@include('layouts.header')

@php
App::setLocale(Auth::user()->lang);
@endphp

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <!-- header info start -->
        <div class="row">
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $totalDevices }}</h3>
                            <span>{{ __('Total devices') }}</span>
                        </div>
                        <div class="avatar bg-light-primary p-50">
                            <span class="avatar-content">
                                <i data-feather="smartphone" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $totalOnline }}</h3>
                            <span>{{ __('Total online') }}</span>
                        </div>
                        <div class="avatar bg-light-success p-50">
                            <span class="avatar-content">
                                <i data-feather="wifi" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $currentSent }}</h3>
                            <span>{{ __('Total sent this month') }}</span>
                        </div>
                        <div class="avatar bg-light-danger p-50">
                            <span class="avatar-content">
                                <i data-feather="send" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $totalSent }}</h3>
                            <span>{{ __('Total sent all time') }}</span>
                        </div>
                        <div class="avatar bg-light-warning p-50">
                            <span class="avatar-content">
                                <i data-feather="send" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- header info end -->
        <div class="content-body">
            <section class="app-device-list">
                <!-- list and filter start -->
                <div class="card">
                    <h5 class="card-header">
                        <div class="input-group input-group-sm position-relative mx-auto">
                            {{ __('Device list') }}<span class="badge badge-light-secondary ms-2">{{ $listAll ? DB::table('devices')->count() : DB::table('devices')->where('user_id',Auth::user()->id)->count() }}</span>
                            <input type="search" class="form-control" id="search" value="{{!empty($_GET['search']) ? $_GET['search'] : ''}}" placeholder="{{__('Search')}}..." />
                            <button type="button" class="btn btn-sm btn-info" id="searchbtn"><i data-feather="search" class="me-0"></i></button>
                            @if(!$listAll)
                            <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#addNew"><i data-feather="plus" class="me-1"></i>{{ strtoupper(__('Add new')) }}</button>
                            @endif
                        </div>
                    </h5>
                    <div class="card-body">
                        <div class="table-responsive table-responsive">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>{{ __('Device name') }}</th>
                                        <th>{{ __('Sender phone') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Api token') }}</th>
                                        @if($listAll)<th>{{ __('Username') }}</th>@endif
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($devices as $device)
                                    @php($openAi=json_decode($device->openai,true))
                                    @php($extWebhook=json_decode($device->ext_webhook,true))
                                    @php($workingHours=json_decode($device?->working_hours,true))
                                    {{--@if(empty($openAi)) @continue @endif--}}
                                    <tr>
                                        <td>
                                        <a data-toggle="tooltip" title="{{ ($openAi['apikey'] ?? null) ? 'OpenAI chatGPT' : 'OpenAI inactive' }}" data-bs-toggle="modal" data-bs-target="#edit-{{$device->id}}">
                                        {{ $device->name }}
                                        @if($openAi['apikey'] ?? null) <img src="{{ url('app-assets/images/icons/brands/openai.png') }}" width="20"> @endif
                                        @if($device->warmingup) <img src="{{ url('app-assets/images/icons/flame.png') }}" width="20"> @endif
                                        </a>
                                        </td>
                                        <td><a data-toggle="tooltip" title="{{__('View')}}" href="{{ route('device.show', ['device_id' => $device->id]) }}" target="_blank">
                                        <span class="badge rounded-pill badge-light-{{$device->status === 'ONLINE'?'success':'danger'}} me-1">{{ $device->sender }}</span></a>
                                        </td>
                                        <td><a data-toggle="tooltip" title="{{__('View')}}" href="{{ route('device.show', ['device_id' => $device->id]) }}" target="_blank">
                                        <span class="badge rounded-pill badge-light-{{$device->status === 'ONLINE'?'success':'danger'}} me-1">{{ $device->status }}</span></a>
                                        </td>
                                        <td>
                                        <span class="badge rounded-pill badge-light-primary" data-toggle="tooltip" title="{{__('Click to copy')}}" data-clipboard-text="{{ $device->token }}">
                                            {{ $device->token }}
                                        </span>
                                        </td>
                                        @if($listAll)
                                        <td><a data-bs-toggle="modal" data-bs-target="#edit-{{$device->id}}" href="javascript:;">
                                        <span class="badge rounded-pill badge-light-{{$device->status === 'ONLINE'?'success':'danger'}} me-1">{{ empty($device->user->name) ? '('.__('Deleted').')' : $device->user->name }}</span></a>
                                        </td>
                                        @endif
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton">
                                                <a class="dropdown-item" href="{{ route('device.show', ['device_id' => $device->id]) }}" target="_blank"><img class="me-0" src="{{ url('/') }}/app-assets/images/icons/qr-scan.png" height="14" width="14" alt="" /> {{__('View Device')}}</a>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit-{{$device->id}}"><i data-feather="edit" class="me-0"></i> {{__('Edit Device')}}</a>
                                                @if($user->role === 'admin' || $user->package->webhook)
                                                <a class="dropdown-item" href="{{ route('webhook.show', ['device_id' => $device->id]) }}"><i data-feather="eye" class="me-0"></i> {{__('Webhook contents')}}</a>
                                                @endif
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-{{$device->id}}"><i data-feather="trash" class="me-0"></i> {{__('Delete')}}</a>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-{{$device->id}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    {{ __('Are you sure you want to delete?') }} <br><br>
                                                    <span class="text text-danger"> <b>{{ $device->name }}</b> </span><br><br>
                                                    {{ __('This process is irreversible') }} <br>
                                                    {{ __('The record(s) will be deleted from the database permanently') }}
                                                </div>
                                                <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="{{ route('device.destroy', ['device_id' => $device->id]) }}">{{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Edit device Modal -->
                                    <div class="modal fade" id="edit-{{$device->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-lg modal-dialog-centered modal-edit-device">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1">{{ __('Edit Device') }} {{ $device->sender }}</h1>
                                                    </div>
                                                    <form action="{{ route('device.update') }}" method="POST" id="editDeviceForm" class="row gy-1 pt-75">
                                                        @csrf
                                                        <div class="row">
                                                            <!--  -->
                                                            <div class="card-header pt-1">
                                                                <ul class="nav nav-tabs nav-fill card-header-tabs" role="tablist">
                                                                    <li class="nav-item">
                                                                        <button type="button" class="nav-link active" role="tab" data-bs-toggle="tab" data-bs-target="#navs-tab-general-{{$device->id}}" aria-controls="navs-tab-general" aria-selected="true">General</button>
                                                                    </li>
                                                                    <li class="nav-item">
                                                                        <button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#navs-tab-whatsapp-{{$device->id}}" aria-controls="navs-tab-whatsapp" aria-selected="false">Whatsapp</button>
                                                                    </li>
                                                                    <li class="nav-item">
                                                                        <button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#navs-tab-openai-{{$device->id}}" aria-controls="navs-tab-openai" aria-selected="false">Open AI</button>
                                                                    </li>
                                                                    <li class="nav-item">
                                                                        <button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#navs-tab-geminiai-{{$device->id}}" aria-controls="navs-tab-geminiai" aria-selected="false">Gemini AI</button>
                                                                    </li>
                                                                    <li class="nav-item">
                                                                        <button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#navs-tab-autoreply-{{$device->id}}" aria-controls="navs-tab-autoreply" aria-selected="false">Autoreply</button>
                                                                    </li>
                                                                    <li class="nav-item" {{$user->role === 'admin' || $user->package->webhook ? '' : 'hidden'}}>
                                                                        <button type="button" class="nav-link" role="tab" data-bs-toggle="tab" data-bs-target="#navs-tab-extwebhook-{{$device->id}}" aria-controls="navs-tab-extwebhook" aria-selected="false">External Webhook</button>
                                                                    </li>
                                                                </ul>
                                                            </div>
                                                            <div class="card-body">
                                                                <div class="tab-content p-0">
                                                                    <div class="tab-pane fade show active" id="navs-tab-general-{{$device->id}}" role="tabpanel">
                                                                        <div class="row">
                                                                            <div class="col-12 col-md-6">
                                                                                <input type="hidden"  name="device_id" value="{{ $device->id }}" />
                                                                                <label class="form-label" for="name">{{ __('Name') }}</label>
                                                                                <input type="text" name="name" class="form-control" value="{{ $device->name }}" />
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="token">{{ __('Token') }}</label>
                                                                                <input type="text" name="token" class="form-control" value="{{ $device->token }}" />
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="working_hours"> {{ __('Working hours') }} ({{ __('EMPTY = All day & night') }})</label>
                                                                                <div class="row">
                                                                                    <div class="col-6">
                                                                                        <div class="row">
                                                                                            <div class="col-12">
                                                                                                <input type="text" name="open" placeholder="{{__('Open')}}" class="form-control" value="{{ $workingHours[0] ?? '' }}" data-toggle="tooltip" title="{{ __('This device will be available starting this time (Ex. 08:00)') }}">
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col-6">
                                                                                        <div class="row">
                                                                                            <div class="col-12">
                                                                                                <input type="text" name="closed" placeholder="{{__('Closed')}}" class="form-control" value="{{ $workingHours[1] ?? '' }}" data-toggle="tooltip" title="{{ __('This device will NOT be available starting this time (Ex. 18:00)') }}">
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="autoswitch">{{ __('Autoswitch') }}</label>
                                                                                <select name="autoswitch" class="form-select" data-toggle="tooltip" title="{{ __('_tipAutoswitch') }}">
                                                                                    <option value="0" {{ !$device->autoswitch ? 'selected' : '' }}>{{ __('NO') }}</option>
                                                                                    <option value="1" {{ $device->autoswitch ? 'selected' : '' }}>{{ __('YES') }}</option>
                                                                                </select>
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="warmingup">{{ __('Warming up Device') }}</label>
                                                                                <select name="warmingup" class="form-select" data-toggle="tooltip" title="{{ __('_tipWarmingupDevice') }}">
                                                                                    <option value="0" {{ !$device->warmingup ? 'selected' : '' }}>{{ __('NO') }}</option>
                                                                                    <option value="1" {{ $device->warmingup ? 'selected' : '' }}>{{ __('YES') }}</option>
                                                                                </select>
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="wu_receiver">{{ __('Warming up Receiver') }} ({{ __('Separated by comma') }})</label>
                                                                                <input type="text" name="wu_receiver" maxlength="255" class="form-control" value="{{ $device->wu_receiver }}" data-toggle="tooltip" title="{{ __('_tipWarmingupReceiver') }}" />
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="subUnsub"> {{ __('Subscribe') }} ({{ __('Keyword') }})</label>
                                                                                <input type="text" name="subscribe_keyword" placeholder="{{__('Subscribe')}}" class="form-control" value="{{ $device->subscribe_keyword }}" data-toggle="tooltip" title="{{ __('Send this message to bot to Subscribe!') }}">
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="subUnsub"> {{ __('Unsubscribe') }} ({{ __('Keyword') }})</label>
                                                                                <input type="text" name="unsubscribe_keyword" placeholder="{{__('Unsubscribe')}}" class="form-control" value="{{ $device->unsubscribe_keyword }}" data-toggle="tooltip" title="{{ __('Send this message to bot to Unsubscribe!') }}">
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="subscribe_message">{{ __('Subscribe Message') }}</label>
                                                                                <textarea name="subscribe_message" class="form-control" rows="3" data-toggle="tooltip" title="{{ __('_MsgSubscribe') }}">{{ $device->subscribe_message }}</textarea>
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="unsubscribe_message">{{ __('Unsubscribe Message') }}</label>
                                                                                <textarea name="unsubscribe_message" class="form-control" rows="3" data-toggle="tooltip" title="{{ __('_MsgUnsubscribe') }}">{{ $device->unsubscribe_message }}</textarea>
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="welcome_msg">{{ __('Welcome Message') }}</label>
                                                                                <textarea name="welcome_msg" class="form-control" rows="3" data-toggle="tooltip" title="{{ __('_tipWelcomeMsg') }}">{{ $device->welcome_msg }}</textarea>
                                                                            </div>
                                                                            <div class="col-12" {{$user->role === 'admin' || $user->package->webhook ? '' : 'hidden'}}>
                                                                                <label class="form-label" for="webhook">{{ __('Webhook url') }}</label>
                                                                                <input type="text" name="webhook" class="form-control" value="{{ $device->webhook === url('/api/webhook') ? '' : $device->webhook }}" placeholder="{{ __('EMPTY = DEFAULT URL') }}" />
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="tab-pane fade" id="navs-tab-whatsapp-{{$device->id}}" role="tabpanel">
                                                                        <div class="row">
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="autoread">{{ __('Autoread') }}</label>
                                                                                <select name="autoread" class="form-select" data-toggle="tooltip" title="{{ __('_tipAutoread') }}">
                                                                                    <option value="0" {{ !$device->autoread ? 'selected' : '' }}>{{ __('NO') }}</option>
                                                                                    <option value="1" {{ $device->autoread ? 'selected' : '' }}>{{ __('YES') }}</option>
                                                                                </select>
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="incall_msg">{{ __('Decline Incoming Call Message') }}</label>
                                                                                <textarea name="incall_msg" class="form-control" rows="3" data-toggle="tooltip" title="{{ __('If this device get incoming call, then it will reply with this message.') }}" placeholder="Sorry... I cannot answer your call. Please whatsapp call 1234567890 to talk to customer support!">{{ $device->incall_msg }}</textarea>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="tab-pane fade" id="navs-tab-openai-{{$device->id}}" role="tabpanel">
                                                                        <div class="row">
                                                                            <div class="col-12">
                                                                                <label class="form-label" for="openai_apikey">{{ __('OpenAI Apikey') }}</label>
                                                                                <input type="text" name="openai_apikey" class="form-control" value="{{ $openAi['apikey'] ?? '' }}" />
                                                                            </div>
                                                                            <div class="col-12 col-md-3">
                                                                                <label class="form-label" for="openai_contain">{{ __('OpenAI Contain') }}</label>
                                                                                <input type="text" name="openai_contain" class="form-control" value="{{ $openAi['contain'] ?? '' }}" data-toggle="tooltip" title="{{ __('_tipOpenAIContain') }}" />
                                                                            </div>
                                                                            <div class="col-12 col-md-3">
                                                                                <label class="form-label" for="openai_model">{{ __('OpenAI Model') }}</label>
                                                                                <select name="openai_model" class="form-select" data-toggle="tooltip" title="{{ __('_tipOpenAIModel') }}">
                                                                                    <option value="gpt-3.5-turbo" {{ ($openAi['model'] ?? 'gpt-3.5-turbo') === 'gpt-3.5-turbo' ? 'selected' : '' }}>gpt-3.5-turbo</option>
                                                                                    <option value="gpt-4" {{ ($openAi['model'] ?? '') === 'gpt-4' ? 'selected' : '' }}>gpt-4</option>
                                                                                </select>
                                                                            </div>
                                                                            <div class="col-12 col-md-3">
                                                                                <label class="form-label" for="openai_image_contain">{{ __('Image Contain') }}</label>
                                                                                <input type="text" name="openai_image_contain" class="form-control" value="{{ $openAi['image_contain'] ?? __('Generate image') }}" data-toggle="tooltip" title="{{ str_ireplace(['{Usage}', '{openAIContain}', '{imageContain}'],[__('Usage'), ($openAi['contain'] ?? ''), ($openAi['image_contain'] ?? __('Generate image'))], __('_tipOpenAIImageContain')) }}" required />
                                                                            </div>
                                                                            <div class="col-12 col-md-3">
                                                                                <label class="form-label" for="openai_image_model">{{ __('Image Model') }}</label>
                                                                                <select name="openai_image_model" class="form-select" data-toggle="tooltip" title="{{ __('_tipOpenAIImageModel') }}">
                                                                                    <option value="dall-e-2" {{ ($openAi['image_model'] ?? 'dall-e-2') === 'dall-e-2' ? 'selected' : '' }}>dall-e-2</option>
                                                                                    <option value="dall-e-3" {{ ($openAi['image_model']  ?? '') === 'dall-e-3' ? 'selected' : '' }}>dall-e-3</option>
                                                                                </select>
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="openai_max_tokens">{{ __('OpenAI max_tokens') }} (1 - 2048)</label>
                                                                                <input type="number" min="20" name="openai_max_tokens" class="form-control" value="{{ $openAi['max_tokens'] ?? 2000 }}" data-toggle="tooltip" title="{{ __('_tipOpenAIMaxToken') }}" required />
                                                                            </div>
                                                                            <div class="col-12 col-md-3">
                                                                                <label class="form-label" for="openai_save_chats">{{ __('OpenAI Save Chats') }}</label>
                                                                                <select name="openai_save_chats" class="form-select" data-toggle="tooltip" title="{{ __('_tipOpenAISaveChat') }}">
                                                                                    <option value="0" {{ ($openAi['save_chats'] ?? 0) == '0' ? 'selected' : '' }}>{{ __('NO') }}</option>
                                                                                    <option value="1" {{ ($openAi['save_chats'] ?? '') =='1' ? 'selected' : '' }}>{{ __('YES') }}</option>
                                                                                </select>
                                                                            </div>
                                                                            <div class="col-12 col-md-3">
                                                                                <label class="form-label" for="oaiDestroyChats">{{ __('OpenAI Chat history') }}</label>
                                                                                <a class="btn btn-sm btn-danger" href="{{ route('device.oaiDestroyChats', ['device_id' => $device->id]) }}" data-toggle="tooltip" title="{{ __('_tipOpenAIChatHistory') }}">{{ __('Delete Chat history') }}</a>
                                                                            </div>
                                                                            <div class="col-12">
                                                                                <label class="form-label" for="openai_persona">{{ __('OpenAI Personality') }}</label>
                                                                                <input type="text" name="openai_persona" class="form-control" value="{{ $openAi['persona'] ?? '' }}" data-toggle="tooltip" title="{{ __('_tipOpenAIPersonality') }}" />
                                                                                <label class="form-label text-warning">{{ __('After change personality, you must delete chat history') }}</label>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="tab-pane fade" id="navs-tab-geminiai-{{$device->id}}" role="tabpanel">
                                                                    <div class="row">
                                                                            <div class="col-12">
                                                                                <label class="form-label" for="geminiai_apikey">{{ __('GeminiAI Apikey') }}</label>
                                                                                <input type="text" name="geminiai_apikey" pattern=".{39}" title="starts with AI- and total 39 characters" class="form-control" value="{{ $openAi['geminiai_apikey'] ?? '' }}" />
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="geminiai_contain">{{ __('GeminiAI Contain') }}</label>
                                                                                <input type="text" name="geminiai_contain" class="form-control" value="{{ $openAi['geminiai_contain'] ?? '' }}" data-toggle="tooltip" title="{{ __('If incoming message contain this words, then geminiAI bot will give response. You can leave this EMPTY if you want the bot answer all incoming messages.') }}" />
                                                                            </div>
                                                                            <div class="col-12 col-md-3" hidden>
                                                                                <label class="form-label" for="geminiai_model">{{ __('GeminiAI Model') }}</label>
                                                                                <select name="geminiai_model" class="form-select" data-toggle="tooltip" title="{{ __('Gemini AI model.') }}">
                                                                                    <option value="gpt-3.5-turbo" {{ ($openAi['geminiai_model'] ?? 'gpt-3.5-turbo') === 'gpt-3.5-turbo' ? 'selected' : '' }}>gpt-3.5-turbo</option>
                                                                                    <option value="gpt-4" {{ ($openAi['geminiai_model'] ?? '') === 'gpt-4' ? 'selected' : '' }}>gpt-4</option>
                                                                                </select>
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="geminiai_image_contain">{{ __('Image Contain') }}</label>
                                                                                <input type="text" name="geminiai_image_contain" class="form-control" value="{{ $openAi['geminiai_image_contain'] ?? __('What is this picture?') }}" data-toggle="tooltip" title="Send the bot an image and include this word" required />
                                                                            </div>
                                                                            <div class="col-12 col-md-3" hidden>
                                                                                <label class="form-label" for="geminiai_image_model">{{ __('Image Model') }}</label>
                                                                                <select name="geminiai_image_model" class="form-select" data-toggle="tooltip" title="{{ __('GeminiAI model for image generation') }}">
                                                                                    <option value="dall-e-2" {{ ($openAi['geminiai_image_model'] ?? 'dall-e-2') === 'dall-e-2' ? 'selected' : '' }}>dall-e-2</option>
                                                                                    <option value="dall-e-3" {{ ($openAi['geminiai_image_model']  ?? '') === 'dall-e-3' ? 'selected' : '' }}>dall-e-3</option>
                                                                                </select>
                                                                            </div>
                                                                            <div class="col-12 col-md-6" hidden>
                                                                                <label class="form-label" for="geminiai_max_tokens">{{ __('GeminiAI max_tokens') }} (20 - 2048)</label>
                                                                                <input type="number" min="20" name="geminiai_max_tokens" class="form-control" value="{{ $openAi['geminiai_max_tokens'] ?? 2000 }}" data-toggle="tooltip" title="{{ __('Maximum tokens for openAI bot to answer.') }}" required />
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="geminiai_save_chats">{{ __('GeminiAI Save Chats') }}</label>
                                                                                <select name="geminiai_save_chats" class="form-select" data-toggle="tooltip" title="{{ __('Save every chat interaction. Need to clear history regularly, because chat history will be included in every chat. The bigger the history, the more you will spend your tokens.') }}">
                                                                                    <option value="0" {{ ($openAi['geminiai_save_chats'] ?? 0) == '0' ? 'selected' : '' }}>{{ __('NO') }}</option>
                                                                                    <option value="1" {{ ($openAi['geminiai_save_chats'] ?? '') =='1' ? 'selected' : '' }}>{{ __('YES') }}</option>
                                                                                </select>
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="gaiDestroyChats">{{ __('GeminiAI Chat history') }}</label><br>
                                                                                <a class="btn btn-danger" href="{{ route('device.gaiDestroyChats', $device->id) }}" data-toggle="tooltip" title="{{ __('Clear ALL chat histories. If you want to clear 1 device chat history, chat with the bot and type reset chat to reset only that bot history.') }}">{{ __('Delete Chat history') }}</a>
                                                                            </div>
                                                                            <div class="col-12">
                                                                                <label class="form-label" for="geminiai_persona">{{ __('GeminiAI Personality') }}</label>
                                                                                <input type="text" name="geminiai_persona" class="form-control" value="{{ $openAi['geminiai_persona'] ?? '' }}" data-toggle="tooltip" title="{{ __('Describe your GeminiAI bot personality. After change personality, you must delete chat history by chatting with the bot and type reset chat.') }}">
                                                                                <label class="form-label text-warning">{{ __('After change personality, you must delete chat history') }}</label>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="tab-pane fade" id="navs-tab-autoreply-{{$device->id}}" role="tabpanel">
                                                                        <div class="row">
                                                                            <div class="col-12 col-md-3">
                                                                                <label class="form-label" for="autoreply_group">{{ __('Autoreply Group') }}</label>
                                                                                <select name="autoreply_group" class="form-select" data-toggle="tooltip" title="{{ __('_tipAutoreplyGroup') }}">
                                                                                    <option value="0" {{ !$device->autoreply_group ? 'selected' : '' }}>{{ __('NO') }}</option>
                                                                                    <option value="1" {{ $device->autoreply_group ? 'selected' : '' }}>{{ __('YES') }}</option>
                                                                                </select>
                                                                            </div>
                                                                            <div class="col-12 col-md-3">
                                                                                <label class="form-label" for="autoreply_pause">{{ __('Autoreply Pause Keyword') }}</label>
                                                                                <input type="text" name="autoreply_pause" class="form-control" value="{{ $device->autoreply_pause }}" data-toggle="tooltip" title="{{ __('_tipAutoreplyPause') }}" />
                                                                            </div>
                                                                            <div class="col-12 col-md-3">
                                                                                <label class="form-label" for="autoreply_resume">{{ __('Autoreply Resume Keyword') }}</label>
                                                                                <input type="text" name="autoreply_resume" class="form-control" value="{{ $device->autoreply_resume }}" data-toggle="tooltip" title="{{ __('_tipAutoreplyResume') }}" />
                                                                            </div>
                                                                            <div class="col-12 col-md-3">
                                                                                <label class="form-label" for="autoreply_reset">{{ __('Autoreply Reset Keyword') }}</label>
                                                                                <input type="text" name="autoreply_reset" class="form-control" value="{{ $device->autoreply_reset }}" data-toggle="tooltip" title="{{ __('_tipAutoreplyReset') }}" />
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="autoreply_pause_msg">{{ __('Autoreply Pause Message') }}</label>
                                                                                <textarea name="autoreply_pause_msg" class="form-control" rows="3" data-toggle="tooltip" title="{{ __('_tipAutoreplyPauseMsg') }}" placeholder="Autoreply is now paused. No more response coming from the bot.">{{ $device->autoreply_pause_msg }}</textarea>
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="autoreply_resume_msg">{{ __('Autoreply Resume Message') }}</label>
                                                                                <textarea name="autoreply_resume_msg" class="form-control" rows="3" data-toggle="tooltip" title="{{ __('_tipAutoreplyResumeMsg') }}" placeholder="Autoreply is now working again. Bot will response to your messages">{{ $device->autoreply_resume_msg }}</textarea>
                                                                            </div>
                                                                            <div class="col-12 col-md-6">
                                                                                <label class="form-label" for="autoreply_reset_msg">{{ __('Autoreply Reset Message') }}</label>
                                                                                <textarea name="autoreply_reset_msg" class="form-control" rows="3" data-toggle="tooltip" title="{{ __('_tipAutoreplyResetMsg') }}" placeholder="Autoreply has been resetted.">{{ $device->autoreply_reset_msg }}</textarea>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="tab-pane fade" id="navs-tab-extwebhook-{{$device->id}}" role="tabpanel" {{$user->role === 'admin' || $user->package->webhook ? '' : 'hidden'}}>
                                                                        <div class="row">
                                                                            <div class="col-12">
                                                                                <label class="form-label" for="extWebhookUrl">{{ __('External Webhook Url') }}</label> <label for="warning" class="text-warning">({{ __('EMPTY = disabled') }})</label>
                                                                                <input type="text" id="extWebhookUrl" name="extWebhookUrl" class="form-control" value="{{ $extWebhook['url'] ?? '' }}" data-toggle="tooltip" title="{{ __('External Webhook Url') }} ({{ __('Example: https://external-domain.com/api/invoice') }})" placeholder="https://external-domain.com/api/invoice" />
                                                                            </div>
                                                                            <div class="col-12">
                                                                                <label class="form-label" for="extWebhookData">{{ __('Webhook Data') }} {{ __('JSON format') }}</label> <label for="warning" class="text-warning">({{ __('EMPTY = default data') }})</label>
                                                                                @php($extWebhookData = $extWebhook['data'] ?? '')
                                                                                <textarea id="extWebhookData" name="extWebhookData" class="form-control" rows="15" data-toggle="tooltip" title="{{ __('Every incoming message, it will send Raw JSON string data to the URL above. If EMPTY default data will be sent.') }}" placeholder="{{ $extWebhookDataPlaceholder }}">{{ empty($extWebhookData) ? '' : (is_array($extWebhookData) ? json_encode($extWebhookData, JSON_PRETTY_PRINT) : json_encode(json_decode($extWebhookData), JSON_PRETTY_PRINT)) }}</textarea>
                                                                                <label for="dataTags">Tags: {sender}, {receiver}, {text}, {token}, {key_id}, {recnumber}, {recname}, {devtype}, {mentioned}, {appurl}, {nodeurl}</label>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                            <!--  -->
                                                        </div>
                                                        <div class="col-12 text-center pt-50">
                                                            <button type="submit" class="btn btn-primary me-1">{{ __('Save') }}</button>
                                                            <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Close') }}</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Edit device Modal -->
                                    @endforeach
                                    {{ $devices->links() }}
                                </tbody>
                            </table>
                        </div>
                        <!-- Modal to add new device starts-->
                        <div class="modal modal-slide-in new-device-modal fade" id="addNew">
                            <div class="modal-dialog">
                                <form action="{{ route('device.store') }}" method="POST" class="add-new-device modal-content pt-0">
                                @csrf
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
                                    <div class="modal-header mb-1">
                                        <h5 class="modal-title" id="exampleModalLabel">{{ __('Add new device') }}</h5>
                                    </div>
                                    <div class="modal-body flex-grow-1">
                                        <div class="mb-1">
                                            <input type="hidden"  name="adminSender" value="{{ $adminSender }}" />
                                            <label class="form-label" for="name">{{ __('Device name') }}</label>
                                            <input type="text" name="name" class="form-control" placeholder="{{ __('Device name') }}" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="sender">{{ __('Sender phone') }}</label>
                                            <input type="text" id="phone" name="sender" class="form-control" placeholder="{{ $user->phone }}" required />
                                        </div>
                                        @if(filter_var(\App\Helpers\Helpers::setting('waVerification'), FILTER_VALIDATE_BOOLEAN) && $user->role !== 'admin' && !empty($adminSender))
                                        <div class="mb-1">
                                            <button type="button" id="otpbutton_add" class="btn btn-sm btn-primary">{{ __('Request OTP code') }}</button>
                                            <input type="text" name="otp" class="form-control" placeholder="{{ __('Enter OTP') }}" required />
                                        </div>
                                        @endif
                                        <button type="submit" class="btn btn-primary me-1 data-submit">{{ __('Submit') }}</button>
                                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- Modal to add new device Ends-->
                    </div>
                </div>
                <!-- list and filter end -->
            </section>
            <!-- devices list ends -->
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
<!-- BEGIN Vendor JS-->

<!-- BEGIN: Page Vendor JS-->
<script src="{{ url('/') }}/app-assets/vendors/js/clipboard/clipboard.min.js"></script>
<!-- END: Page Vendor JS-->

<script>
    var btns = document.querySelectorAll('span')
    var clipboard = new ClipboardJS(btns)

    $(document).ready(function(){
        $('[data-toggle="tooltip"]').tooltip();
    });

    $("#otpbutton_add").click(function(e) {
        e.preventDefault();
        $.ajax({
            type:"get",
            url: '{{route('user.otpSend')}}',
            // Send OTP to the authenticated user's phone for device addition
            data: {adminSender: '{{$adminSender}}', phone: '{{$user->phone}}', name: '{{$user->name}}', msgOtp: '_MsgOtpAdd'},
            success: function(){ $("#otpbutton_add").prop("disabled",true); },
        });
        var text = $("#otpbutton_add").html();
        var count = 60;
        var counter = setInterval(timer, 1000);
        function timer(){
            count -= 1;
            if (count <= 0){
                clearInterval(counter);
                $("#otpbutton_add").html(text);
                $("#otpbutton_add").prop("disabled",false);
                return;
            }
            $("#otpbutton_add").html(text + ' in ' + count + " seconds.");
        }
    });
</script>

<script>
function search() {
    var url = '{{url()->current()}}' + '?search=' + $('#search').val();
    location.href= url;
}
$('#searchbtn').click(function (e) {
    search();
})
$('#search').keydown(function (e) {
    if (e.which == 13) {
        search();
    }
})
</script>

@include('layouts.footer')
