@include('layouts.header')

    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="card-body">
                <a class="btn btn-success float-end" href="{{ route('phonebook.exportGroups', ['sender' => $device->sender]) }}">{{ __('Export groups') }}</a>
                <a class="btn btn-primary float-end" href="{{ route('phonebook.storeGroups', ['sender' => $device->sender]) }}">{{ __('Save groups') }}</a>
            </div>
            <div class="content-header row">
            <h4>{{ $device->sender }} -> {{ __('Group contacts') }}</h4>
            </div>
            <div class="content-body">
                <!-- table show start -->
                <section class="app-device-show">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive pt-0">
                                <table id="tbl-bootstr" class="table table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th>{{ __('Group ID') }}</th>
                                            <th>{{ __('Group name') }}</th>
                                            <th>{{ __('Group owner') }}</th>
                                            <th>{{ __('Participants') }}</th>
                                            <!-- <th>{{ __('Actions') }}</th> -->
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($contactGroups as $group)
                                        <tr>
                                            <td>
                                            {{ $group->groupId }}
                                            </td>
                                            <td>
                                            {{ $group->subject }}
                                            </td>
                                            <td>
                                            {{ preg_replace('/\D/', '', $group->owner) }}
                                            </td>
                                            <td>
                                                <a class="btn btn-primary"  href="{{ route('phonebook.storeParticipants', ['id' => $group->id]) }}">{{ __('Save participants') }}</a>
                                                <a class="btn btn-success"  href="{{ route('phonebook.exportParticipants', ['id' => $group->id, 'subject' => $group->subject]) }}">{{ __('Export participants') }}</a>
                                            </td>
                                            <!-- <td>
                                                <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#destroy{{$device->id}}">
                                                    <i data-feather="trash" class="me-0"></i>
                                                </button>
                                            </td> -->
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- table show ends -->
            </div>
        </div>
    </div>
    <!-- END: Content-->

    <!-- BEGIN: Vendor JS-->
    <script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
    <!-- BEGIN Vendor JS-->

@include('layouts.footer')
