@include('layouts.header')
<link rel="stylesheet" href="https://cdn.ckeditor.com/ckeditor5/43.3.0/ckeditor5.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
  <div class="content-overlay"></div>
  <div class="header-navbar-shadow"></div>
  <div class="content-wrapper">
    <div class="content-body">

      <h4 class="fw-bold mb-4" id="top-of-page">
        <span class="text-muted fw-light">{{__('Documentation')}} /</span> {{ config('app.name') }}
        @if(auth()?->user()?->role === 'admin')
        <button type="button" class="btn btn-sm btn-primary float-end" data-bs-toggle="modal" data-bs-target="#addNew"><i data-feather="plus-square" class="me-0"></i> {{ strtoupper(__('Add new')) }}</button>
        @endif
      </h4>

      <div class="row">
        <!-- Menus -->
        <div class="col-xxl-1 col-xl-2 col-lg-3 col-md-3 mb-lg-0 mb-4">
          <!-- Search Jumbotron -->
          <!-- <div class="card-body search-bg text-center" id="kb-search">
              <form class="kb-search-input">
                  <div class="input-group input-group-merge">
                      <i data-feather="search" class="me-0"></i></span>
                      <input type="text" class="form-control" id="searchbar" placeholder="{{ __('Search') }}..." />
                  </div>
              </form>
          </div>
          <br> -->
          <!--/ Search Jumbotron -->
          @foreach($menus as $menu)
          <span class="fw-bold">{{$menu->topic}}</span>
          <div class="nav-align-left">
            <ul class="nav nav-pills border-0 w-100 gap-1">
              @foreach($documentations as $documentation)
              @if($documentation->topic === $menu->topic)
              <li class="nav-item">
                <a id="menu-{{$documentation->title}}" class="nav-link" href="#{{$documentation->title}}">{{$documentation->title}}
                  @if(!empty($documentation->highlight))
                  <span class="badge badge-light-success">{{$documentation->highlight}}!</span>
                  @endif
                </a>
              </li>
              @endif
              @endforeach
            </ul>
          </div>
          @endforeach
        </div>
        <!-- /Menus -->

        <!-- Body -->
        <div class="col-xl-10 col-lg-9 col-md-9">
          @foreach($documentations as $documentation)
          <div id="{{$documentation->title}}" class="card overflow-hidden mb-3">
            <div class="card-body">
              <h4 class="d-flex align-items-center mt-2 mb-4">
                <span class="badge badge-light-secondary p-2 rounded me-3">
                  <i data-feather="life-buoy" class="me-0"></i>
                </span>
                {{$documentation->title}}
              </h4>
              {!!$documentation->content!!}
              <hr class="container-m-nx my-4">
              <div class="d-flex justify-content-between flex-wrap gap-3 mb-3">
                <div class="article-info">
                  <p class="card-text">{{ __('Updated at') }}: {{Carbon\Carbon::parse($documentation->updated_at)->tz(auth()?->user()?->timezone ?? config('app.timezone'))->format('d M Y')}}</p>
                </div>
                @if(Auth::user() && Auth::user()->role === 'admin')
                <a class="badge badge-light-secondary p-2 rounded me-3" href="{{route('documentation.edit', $documentation->id)}}">{{ __('Edit') }} {{ $documentation->title }} <i data-feather="edit" class="me-0"></i></a>
                @endif
                <a class="badge badge-light-secondary p-2 rounded me-3" href="#top-of-page">{{ __('Go to top') }}<i data-feather="arrow-up" class="me-0"></i></a>
              </div>
            </div>
          </div>
          @endforeach
        </div>
        <!-- /Body -->
      </div>

    </div>
  </div>
</div>
<!-- Add new Modal -->
<div class="modal fade" id="addNew" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-transparent">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body pb-5 px-sm-5 pt-50">
                <div class="text-center mb-2">
                    <h3 class="mb-1">{{ __('Add new') }}</h3>
                </div>
                <form action="{{ route('documentation.store') }}" method="POST" class="row gy-1 pt-75" enctype="multipart/form-data">
                @csrf
                    <div class="row">
                        <div class="col-12 col-md-6 mb-2">
                            <label class="form-label" for="role">{{ __('Role') }}</label>
                            <select class="form-control" name="role">
                                <option value="user">user</option>
                                <option value="admin">admin</option>
                            </select>
                        </div>
                        {{--<div class="col-12 col-md-6 mb-2">
                            <label class="form-label" for="lang">{{ __('Language') }}</label>
                            <input type="text" name="lang" class="form-control" value="en" required />
                        </div>--}}
                        <div class="col-12 col-md-6 mb-2">
                            <label class="form-label" for="highlight">{{ __('Highlight') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                            <input type="text" name="highlight" class="form-control" value="NEW" />
                        </div>
                        <div class="col-12 col-md-6 mb-2">
                            <label class="form-label" for="topic">{{ __('Topic') }}</label>
                            <input type="text" name="topic" class="form-control" value="Features" required />
                        </div>
                        <div class="col-12 col-md-6 mb-2">
                            <label class="form-label" for="title">{{ __('Title') }}</label>
                            <input type="text" name="title" class="form-control" required />
                        </div>
                        <div class="col-12 mb-2">
                            <label class="form-label" for="edit-content">{{ __('Content') }}</label>
                            <textarea class="form-control" row="20" id="content" name="content"></textarea>
                        </div>
                        <div class="col-12 text-center mt-4 pt-50">
                            <button type="submit" class="btn btn-primary me-1">{{ __('Save') }}</button>
                            <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Cancel') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Add new Modal -->

<!-- BEGIN: Vendor JS-->
<script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
<!-- BEGIN Vendor JS-->

<script src="https://cdn.ckeditor.com/ckeditor5/43.3.0/ckeditor5.js"></script>
<!-- <script src="{{ url('/') }}/app-assets/vendors/js/editors/ckeditor5/ckeditor.js"></script> -->
<script>
    ClassicEditor
        .create( document.querySelector( '#content' ) )
        .catch( error => {
            console.error( error );
        } );
</script>

@include('layouts.footer')
