@include('layouts.header')

@php
App::setLocale(Auth::user()->lang);
@endphp

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-body">
            <section class="invoice-preview-wrapper">
                <div class="row invoice-preview">
                    <!-- Invoice -->
                    <div class="col-xl-9 col-md-8 col-12">
                        <div class="card invoice-preview-card">
                            <div class="card-body invoice-padding pb-0">
                                <!-- Header -->
                                <div class="d-flex justify-content-between flex-md-row flex-column invoice-spacing mt-0">
                                    <div>
                                        <div class="logo-wrapper">
                                            <img src="{{ \App\Helpers\Helpers::setting('logoUrl') }}" height="50">
                                            <h3 class="text-primary invoice-logo mt-1">{{ config('app.name') }}</h3>
                                        </div>
                                        <p class="card-text mb-25">{{ \App\Helpers\Helpers::setting('companyAddress') }}</p>
                                        <p class="card-text mb-25">{{ \App\Helpers\Helpers::setting('companyPhone') }}</p>
                                        <p class="card-text mb-0">{{ \App\Helpers\Helpers::setting('companyEmail') }}</p>
                                    </div>
                                    <div class="mt-md-0 mt-2">
                                        <h4 class="invoice-title">
                                            {{ __('Invoice') }}
                                            <span class="invoice-number">#{{ $invoice->invoice_number }}</span>
                                        </h4>
                                        <div class="invoice-date-wrapper">
                                            <p class="invoice-date-title">{{ __('Date Issued') }}:</p>
                                            <p class="invoice-date">{{ $invoice->invoice_date->format('M d, Y') }}</p>
                                        </div>
                                        <div class="invoice-date-wrapper">
                                            <p class="invoice-date-title">{{ __('Due Date') }}:</p>
                                            <p class="invoice-date">{{ $invoice->due_date->format('M d, Y') }}</p>
                                        </div>
                                        @if($invoice->status == 'paid')
                                        <div class="invoice-date-wrapper">
                                            <p class="invoice-date-title">{{ __('Paid On') }}:</p>
                                            <p class="invoice-date">{{ $invoice->paid_at ? $invoice->paid_at->format('M d, Y') : '-' }}</p>
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            </div>

                            <hr class="invoice-spacing" />

                            <!-- Invoice Details -->
                            <div class="card-body invoice-padding pt-0">
                                <div class="row invoice-spacing">
                                    <div class="col-xl-8 p-0">
                                        <h6 class="mb-2">{{ __('Invoice To') }}:</h6>
                                        <h6 class="mb-25">{{ $invoice->customer_name }}</h6>
                                        @if($invoice->customer_email)
                                        <p class="card-text mb-25">{{ $invoice->customer_email }}</p>
                                        @endif
                                        @if($invoice->customer_phone)
                                        <p class="card-text mb-25">{{ $invoice->customer_phone }}</p>
                                        @endif
                                        @if($invoice->customer_address)
                                        <p class="card-text mb-0">{{ $invoice->customer_address }}</p>
                                        @endif
                                    </div>
                                    <div class="col-xl-4 p-0 mt-xl-0 mt-2">
                                        <h6 class="mb-2">{{ __('Payment Details') }}:</h6>
                                        <table>
                                            <tbody>
                                                <tr>
                                                    <td class="pe-1">{{ __('Status') }}:</td>
                                                    <td>
                                                        @if($invoice->status == 'paid')
                                                            <span class="badge badge-light-success">{{ __('Paid') }}</span>
                                                        @elseif($invoice->status == 'unpaid' && $invoice->due_date < now())
                                                            <span class="badge badge-light-danger">{{ __('Overdue') }}</span>
                                                        @else
                                                            <span class="badge badge-light-warning">{{ __('Unpaid') }}</span>
                                                        @endif
                                                    </td>
                                                </tr>
                                                @if($invoice->payment_method)
                                                <tr>
                                                    <td class="pe-1">{{ __('Method') }}:</td>
                                                    <td><strong>{{ $invoice->payment_method }}</strong></td>
                                                </tr>
                                                @endif
                                                @if($invoice->payment_reference)
                                                <tr>
                                                    <td class="pe-1">{{ __('Reference') }}:</td>
                                                    <td>{{ $invoice->payment_reference }}</td>
                                                </tr>
                                                @endif
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>

                            <!-- Invoice Items -->
                            <div class="table-responsive">
                                <table class="table">
                                    <thead>
                                        <tr>
                                            <th class="py-1">{{ __('Description') }}</th>
                                            <th class="py-1">{{ __('Quantity') }}</th>
                                            <th class="py-1">{{ __('Unit Price') }}</th>
                                            <th class="py-1">{{ __('Total') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($invoice->items as $item)
                                        <tr>
                                            <td class="py-1">
                                                <p class="card-text fw-bold mb-25">{{ $item->description }}</p>
                                            </td>
                                            <td class="py-1">
                                                <span class="fw-bold">{{ $item->quantity }}</span>
                                            </td>
                                            <td class="py-1">
                                                <span class="fw-bold">{{ \App\Helpers\Helpers::setting('currencyCode') }} {{ number_format($item->unit_price, 2) }}</span>
                                            </td>
                                            <td class="py-1">
                                                <span class="fw-bold">{{ \App\Helpers\Helpers::setting('currencyCode') }} {{ number_format($item->total_price, 2) }}</span>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>

                            <!-- Invoice Total -->
                            <div class="card-body invoice-padding pb-0">
                                <div class="row invoice-sales-total-wrapper">
                                    <div class="col-md-6 order-md-1 order-2 mt-md-0 mt-3">
                                        @if($invoice->notes)
                                        <p class="card-text mb-0">
                                            <span class="fw-bold">{{ __('Notes') }}:</span><br>
                                            <span>{{ $invoice->notes }}</span>
                                        </p>
                                        @endif
                                    </div>
                                    <div class="col-md-6 d-flex justify-content-end order-md-2 order-1">
                                        <div class="invoice-total-wrapper">
                                            <div class="invoice-total-item">
                                                <p class="invoice-total-title">{{ __('Subtotal') }}:</p>
                                                <p class="invoice-total-amount">{{ \App\Helpers\Helpers::setting('currencyCode') }} {{ number_format($invoice->subtotal_amount, 2) }}</p>
                                            </div>
                                            @if($invoice->tax_amount > 0)
                                            <div class="invoice-total-item">
                                                <p class="invoice-total-title">{{ __('Tax') }} ({{ $invoice->tax_percentage }}%):</p>
                                                <p class="invoice-total-amount">{{ \App\Helpers\Helpers::setting('currencyCode') }} {{ number_format($invoice->tax_amount, 2) }}</p>
                                            </div>
                                            @endif
                                            <hr class="my-50" />
                                            <div class="invoice-total-item">
                                                <p class="invoice-total-title">{{ __('Total') }}:</p>
                                                <p class="invoice-total-amount">{{ \App\Helpers\Helpers::setting('currencyCode') }} {{ number_format($invoice->total_amount, 2) }}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <hr class="invoice-spacing" />

                            <!-- Invoice Footer -->
                            <div class="card-body invoice-padding pt-0">
                                <div class="row">
                                    <div class="col-12">
                                        <span class="fw-bold">{{ __('Note') }}:</span>
                                        <span>{{ __('It was a pleasure working with you. We hope you will keep us in mind for future projects. Thank You!') }}</span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /Invoice -->

                    <!-- Invoice Actions -->
                    <div class="col-xl-3 col-md-4 col-12 invoice-actions mt-md-0 mt-2">
                        <div class="card">
                            <div class="card-body">
                                <a class="btn btn-primary w-100 mb-75" href="{{ route('invoice.pdf', $invoice->id) }}" target="_blank">
                                    <i data-feather="download" class="me-50"></i>{{ __('Download PDF') }}
                                </a>
                                <a class="btn btn-outline-secondary w-100 mb-75" href="{{ route('invoice.print', $invoice->id) }}" target="_blank">
                                    <i data-feather="printer" class="me-50"></i>{{ __('Print') }}
                                </a>
                                @if($invoice->status != 'paid')
                                <button class="btn btn-success w-100 mb-75" onclick="markAsPaid()">
                                    <i data-feather="check" class="me-50"></i>{{ __('Mark as Paid') }}
                                </button>
                                @endif
                                <button class="btn btn-outline-primary w-100" onclick="sendInvoice()">
                                    <i data-feather="send" class="me-50"></i>{{ __('Send Invoice') }}
                                </button>
                            </div>
                        </div>
                        <div class="mt-2">
                            <a href="{{ route('invoice.list') }}" class="btn btn-outline-secondary w-100">
                                <i data-feather="arrow-left" class="me-50"></i>{{ __('Back to List') }}
                            </a>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

@include('layouts.footer')

<script>
function markAsPaid() {
    if (confirm('{{ __("Mark this invoice as paid?") }}')) {
        fetch('/invoice-markpaid', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({ invoice_id: {{ $invoice->id }} })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            } else {
                alert(data.message || '{{ __("An error occurred") }}');
            }
        })
        .catch(error => {
            alert('{{ __("An error occurred") }}');
        });
    }
}

function sendInvoice() {
    if (confirm('{{ __("Send this invoice to the customer?") }}')) {
        fetch('/invoice-send', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            },
            body: JSON.stringify({ invoice_id: {{ $invoice->id }} })
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                alert('{{ __("Invoice sent successfully!") }}');
            } else {
                alert(data.message || '{{ __("An error occurred") }}');
            }
        })
        .catch(error => {
            alert('{{ __("An error occurred") }}');
        });
    }
}
</script>
