<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="utf-8">
  <meta content="width=device-width, initial-scale=1.0" name="viewport">

  <title>{{ config('app.name') }} - Free WhatsApp API and Bulk Sender with AI and ChatGPT</title>
  <meta content="{{ config('app.name') }} provides best WhatsApp API and Bulk Sender, Autobot with AI and ChatGPT, no coding required." name="description">
  <meta content="whatsapp api, free whatsapp api, bulk whatsapp sender, bulk sender, autobot, WhatsApp bot, chatgpt, unofficial whatsapp api" name="keywords">
  
  <!-- Favicons -->
  <link href="/app-assets/images/ico/favicon.ico" rel="icon">

  <!-- Google Fonts -->
  <link href="https://fonts.googleapis.com/css?family=Open+Sans:300,300i,400,400i,600,600i,700,700i|Nunito:300,300i,400,400i,600,600i,700,700i|Poppins:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

  <!-- Vendor CSS Files - Local -->
  <link href="/landing-assets/css/aos.css" rel="stylesheet">
  <link href="/landing-assets/css/bootstrap.min.css" rel="stylesheet">
  <link href="/landing-assets/css/bootstrap-icons.css" rel="stylesheet">

  <!-- Custom CSS -->
  <style>
    :root {
      --primary-color: #fd810e;
      --primary-dark: #e67410;
      --primary-light: #ff9638;
      --primary-lighter: #fff3e6;
      --secondary-color: #2c3e50;
      --success-color: #28c76f;
      --info-color: #00cfe8;
      --warning-color: #ff9f43;
      --danger-color: #ea5455;
      --text-dark: #1a1a1a;
      --text-light: #666666;
    }

    body {
      font-family: 'Nunito', sans-serif;
      color: var(--text-dark);
    }

    a {
      color: var(--primary-color);
      text-decoration: none;
      transition: all 0.3s ease;
    }

    a:hover {
      color: var(--primary-dark);
      text-decoration: none;
    }

    h1, h2, h3, h4, h5, h6 {
      font-family: 'Poppins', sans-serif;
    }

    /* Header */
    .header {
      transition: all 0.5s;
      z-index: 997;
      padding: 20px 0;
      background: #fff;
      box-shadow: 0px 2px 20px rgba(1, 41, 112, 0.1);
    }

    .header.fixed-top {
      padding: 12px 0;
    }

    .logo img {
      max-height: 40px;
      margin-right: 6px;
    }

    .logo span {
      font-size: 24px;
      font-weight: 700;
      color: var(--primary-color);
    }

    .navbar {
      padding: 0;
    }

    .navbar ul {
      margin: 0;
      padding: 0;
      display: flex;
      list-style: none;
      align-items: center;
    }

    .navbar li {
      position: relative;
    }

    .navbar a, .navbar a:focus {
      display: flex;
      align-items: center;
      justify-content: space-between;
      padding: 10px 0 10px 30px;
      font-family: 'Nunito', sans-serif;
      font-size: 16px;
      font-weight: 700;
      color: var(--secondary-color);
      white-space: nowrap;
      transition: 0.3s;
    }

    .navbar a i, .navbar a:focus i {
      font-size: 12px;
      line-height: 0;
      margin-left: 5px;
    }

    .navbar a:hover, .navbar .active, .navbar .active:focus, .navbar li:hover > a {
      color: var(--primary-color);
    }

    .getstarted, .getstarted:focus {
      background: var(--primary-color);
      padding: 10px 20px;
      margin-left: 30px;
      border-radius: 4px;
      color: #fff;
      display: inline-flex;
      align-items: center;
      justify-content: center;
      line-height: 1;
      text-align: center;
    }

    .getstarted:hover, .getstarted:focus:hover {
      color: #fff;
      background: var(--primary-dark);
      transform: translateY(-2px);
      box-shadow: 0 5px 15px rgba(253, 129, 14, 0.3);
    }

    .navbar .dropdown ul {
      display: block;
      position: absolute;
      left: 14px;
      top: calc(100% + 30px);
      margin: 0;
      padding: 10px 0;
      z-index: 99;
      opacity: 0;
      visibility: hidden;
      background: #fff;
      box-shadow: 0px 0px 30px rgba(127, 137, 161, 0.25);
      transition: 0.3s;
      border-radius: 4px;
    }

    .navbar .dropdown ul li {
      min-width: 200px;
    }

    .navbar .dropdown ul a {
      padding: 10px 20px;
      font-size: 15px;
      text-transform: none;
      font-weight: 600;
    }

    .navbar .dropdown:hover > ul {
      opacity: 1;
      top: 100%;
      visibility: visible;
    }

    .mobile-nav-toggle {
      color: #012970;
      font-size: 28px;
      cursor: pointer;
      display: none;
      line-height: 0;
      transition: 0.5s;
    }

    @media (max-width: 991px) {
      .mobile-nav-toggle {
        display: block;
      }

      .navbar ul {
        display: none;
      }
    }

    /* Hero Section */
    .hero {
      width: 100%;
      height: 100vh;
      background: linear-gradient(135deg, #fd810e 0%, #ff9638 50%, #ffa85c 100%);
      position: relative;
      overflow: hidden;
    }

    .hero::before {
      content: '';
      position: absolute;
      top: 0;
      left: 0;
      right: 0;
      bottom: 0;
      background: url('data:image/svg+xml,<svg width="100" height="100" xmlns="http://www.w3.org/2000/svg"><defs><pattern id="grid" width="100" height="100" patternUnits="userSpaceOnUse"><path d="M 100 0 L 0 0 0 100" fill="none" stroke="rgba(255,255,255,0.05)" stroke-width="1"/></pattern></defs><rect width="100%" height="100%" fill="url(%23grid)" /></svg>');
      opacity: 0.3;
    }

    .hero h1 {
      margin: 0;
      font-size: 48px;
      font-weight: 700;
      color: #fff;
      text-shadow: 2px 2px 4px rgba(0,0,0,0.1);
      position: relative;
      z-index: 1;
    }

    .hero h3 {
      color: rgba(255, 255, 255, 0.95);
      margin: 15px 0 0 0;
      font-size: 26px;
      font-weight: 400;
      text-shadow: 1px 1px 2px rgba(0,0,0,0.1);
      position: relative;
      z-index: 1;
    }

    .hero .btn-get-started {
      margin-top: 30px;
      line-height: 0;
      padding: 15px 40px;
      border-radius: 50px;
      transition: 0.5s;
      color: var(--primary-color);
      background: #fff;
      box-shadow: 0px 8px 30px rgba(253, 129, 14, 0.3);
      font-weight: 600;
      position: relative;
      z-index: 1;
    }

    .hero .btn-get-started:hover {
      background: #fff;
      color: var(--primary-dark);
      box-shadow: 0px 12px 40px rgba(253, 129, 14, 0.4);
      transform: translateY(-3px);
    }

    .hero .hero-img {
      text-align: right;
      position: relative;
      z-index: 1;
    }

    @media (max-width: 991px) {
      .hero {
        height: auto;
        padding: 120px 0 60px 0;
      }

      .hero h1 {
        font-size: 28px;
      }

      .hero h3 {
        font-size: 18px;
      }

      .hero .hero-img {
        text-align: center;
        margin-top: 80px;
      }
    }

    /* Sections General */
    section {
      padding: 60px 0;
      overflow: hidden;
    }

    .section-header {
      text-align: center;
      padding-bottom: 40px;
    }

    .section-header h2 {
      font-size: 13px;
      letter-spacing: 1px;
      font-weight: 700;
      margin: 0;
      color: var(--primary-color);
      text-transform: uppercase;
    }

    .section-header p {
      margin: 10px 0 0 0;
      padding: 0;
      font-size: 38px;
      line-height: 42px;
      font-weight: 700;
      color: var(--secondary-color);
    }

    /* About */
    .about .content {
      padding: 20px;
    }

    .about .content:not([style*="background"]) {
      background: transparent;
    }

    .about h3 {
      font-size: 14px;
      font-weight: 700;
      color: var(--primary-color);
      text-transform: uppercase;
      margin-bottom: 10px;
    }

    .about h2 {
      font-size: 32px;
      font-weight: 700;
      color: var(--secondary-color);
      margin-bottom: 20px;
      line-height: 1.3;
    }

    .about p {
      margin: 15px 0;
      line-height: 1.8;
      color: var(--text-dark);
      font-size: 16px;
    }

    .about ul li {
      line-height: 1.8;
      color: var(--text-dark);
      font-size: 16px;
    }

    .about .content[style*="background"] h2,
    .about .content[style*="background"] p,
    .about .content[style*="background"] strong {
      color: white !important;
    }

    /* Values */
    .values .box {
      padding: 30px;
      box-shadow: 0px 0 20px rgba(253, 129, 14, 0.1);
      text-align: center;
      transition: 0.3s;
      height: 100%;
      border-radius: 15px;
      border: 2px solid transparent;
    }

    .values .box img {
      padding: 30px 50px;
      transition: 0.5s;
      transform: scale(1.1);
      border-radius: 10px;
    }

    .values .box h3 {
      font-size: 24px;
      color: var(--secondary-color);
      font-weight: 700;
      margin-bottom: 18px;
    }

    .values .box:hover {
      box-shadow: 0px 0 30px rgba(253, 129, 14, 0.2);
      border-color: var(--primary-light);
      transform: translateY(-5px);
    }

    .values .box:hover img {
      transform: scale(1);
    }

    /* Features */
    .features .feature-box {
      padding: 24px 20px;
      box-shadow: 0px 0 25px rgba(253, 129, 14, 0.08);
      transition: 0.3s;
      height: 100%;
      border-radius: 12px;
      border: 2px solid transparent;
    }

    .features .feature-box h3 {
      font-size: 18px;
      color: var(--secondary-color);
      font-weight: 700;
      margin: 0;
    }

    .features .feature-box i {
      line-height: 0;
      background: var(--primary-color);
      color: #fff;
      padding: 14px;
      border-radius: 8px;
      transition: 0.3s;
      display: flex;
      align-items: center;
      justify-content: center;
      width: 48px;
      height: 48px;
      flex-shrink: 0;
      margin-right: 10px;
      box-shadow: 0 4px 10px rgba(253, 129, 14, 0.3);
    }

    .features .feature-box:hover {
      border-color: var(--primary-light);
      transform: translateY(-3px);
      box-shadow: 0px 5px 35px rgba(253, 129, 14, 0.15);
    }

    .features .feature-box:hover i {
      background: var(--primary-dark);
      transform: scale(1.1);
    }

    .features .feture-tabs {
      margin-top: 120px;
    }

    .features .feture-tabs h3 {
      color: var(--secondary-color);
      font-weight: 700;
      font-size: 32px;
      margin-bottom: 10px;
    }

    .features .feture-tabs .nav-pills {
      border-bottom: 2px solid #eee;
    }

    .features .feture-tabs .nav-link {
      background: none;
      text-transform: uppercase;
      font-size: 15px;
      font-weight: 600;
      color: var(--text-light);
      padding: 12px 0;
      margin-right: 25px;
      margin-bottom: -2px;
      border-radius: 0;
      transition: all 0.3s ease;
    }

    .features .feture-tabs .nav-link.active {
      color: var(--primary-color);
      border-bottom: 3px solid var(--primary-color);
    }

    .features .feture-tabs .tab-content h4 {
      font-size: 18px;
      margin: 0;
      font-weight: 700;
      color: var(--secondary-color);
    }

    .features .feture-tabs .tab-content i {
      font-size: 24px;
      line-height: 0;
      margin-right: 8px;
      color: var(--primary-color);
    }

    .features-icon-box img {
      width: 64px;
      height: 64px;
      filter: drop-shadow(0 4px 8px rgba(253, 129, 14, 0.2));
      transition: all 0.3s ease;
    }

    .features-icon-box:hover img {
      transform: scale(1.1);
    }

    .features-icon-description {
      color: var(--text-light);
    }

    .features-icon-box {
      padding: 30px;
      border-radius: 12px;
      transition: all 0.3s ease;
    }

    .features-icon-box:hover {
      background: var(--primary-lighter);
      transform: translateY(-5px);
    }

    /* Testimonials */
    .testimonials .testimonial-item {
      box-sizing: content-box;
      padding: 30px;
      margin: 40px 30px;
      box-shadow: 0px 0 25px rgba(253, 129, 14, 0.1);
      background: #fff;
      min-height: 320px;
      display: flex;
      flex-direction: column;
      text-align: center;
      transition: 0.3s;
      border-radius: 15px;
      border: 2px solid transparent;
    }

    .testimonials .testimonial-item:hover {
      box-shadow: 0px 5px 35px rgba(253, 129, 14, 0.2);
      border-color: var(--primary-light);
      transform: translateY(-5px);
    }

    .testimonials .testimonial-item .stars {
      margin-bottom: 15px;
    }

    .testimonials .testimonial-item .stars i {
      color: var(--primary-color);
      margin: 0 1px;
    }

    .testimonials .testimonial-item .testimonial-img {
      width: 90px;
      border-radius: 50%;
      margin: 0 auto;
      border: 4px solid var(--primary-lighter);
    }

    .testimonials .testimonial-item h3 {
      font-size: 18px;
      font-weight: bold;
      margin: 10px 0 5px 0;
      color: var(--secondary-color);
    }

    .testimonials .testimonial-item h4 {
      font-size: 14px;
      color: var(--text-light);
      margin: 0;
    }

    .testimonials .testimonial-item p {
      font-style: italic;
      margin: 0 auto 15px auto;
      color: var(--text-light);
    }

    .testimonials .swiper-pagination {
      margin-top: 20px;
      position: relative;
    }

    .testimonials .swiper-pagination .swiper-pagination-bullet {
      width: 12px;
      height: 12px;
      background-color: #fff;
      opacity: 1;
      border: 2px solid var(--primary-color);
    }

    .testimonials .swiper-pagination .swiper-pagination-bullet-active {
      background-color: var(--primary-color);
    }

    /* Footer */
    .footer {
      background: #f6f9ff;
      padding: 0 0 30px 0;
      font-size: 14px;
    }

    .footer .footer-top {
      background: white url(../img/footer-bg.png) no-repeat right top;
      background-size: contain;
      border-top: 1px solid #e1ecff;
      border-bottom: 1px solid #e1ecff;
      padding: 60px 0 30px 0;
    }

    .footer .footer-top .footer-info {
      margin-bottom: 30px;
    }

    .footer .footer-top .footer-info .logo {
      line-height: 0;
      margin-bottom: 15px;
    }

    .footer .footer-top .footer-info .logo img {
      max-height: 40px;
      margin-right: 6px;
    }

    .footer .footer-top .footer-info .logo span {
      font-size: 30px;
      font-weight: 700;
      letter-spacing: 1px;
      color: #012970;
      font-family: "Nunito", sans-serif;
      margin-top: 3px;
    }

    .footer .footer-top .footer-info p {
      font-size: 14px;
      line-height: 24px;
      margin-bottom: 0;
      font-family: "Nunito", sans-serif;
    }

    .footer .footer-top .social-links a {
      font-size: 20px;
      display: inline-block;
      color: rgba(1, 41, 112, 0.5);
      line-height: 0;
      margin-right: 10px;
      transition: 0.3s;
    }

    .footer .footer-top .social-links a:hover {
      color: #012970;
    }

    .footer .footer-top h4 {
      font-size: 16px;
      font-weight: bold;
      color: var(--secondary-color);
      text-transform: uppercase;
      position: relative;
      padding-bottom: 12px;
    }

    .footer .footer-top .footer-links {
      margin-bottom: 30px;
    }

    .footer .footer-top .footer-links ul {
      list-style: none;
      padding: 0;
      margin: 0;
    }

    .footer .footer-top .footer-links ul i {
      padding-right: 2px;
      color: var(--primary-light);
      font-size: 12px;
      line-height: 0;
    }

    .footer .footer-top .footer-links ul li {
      padding: 10px 0;
      display: flex;
      align-items: center;
    }

    .footer .footer-top .footer-links ul li:first-child {
      padding-top: 0;
    }

    .footer .footer-top .footer-links ul a {
      color: var(--text-dark);
      transition: 0.3s;
      display: inline-block;
      line-height: 1;
    }

    .footer .footer-top .footer-links ul a:hover {
      color: var(--primary-color);
    }

    .footer .copyright {
      text-align: center;
      padding-top: 30px;
      color: var(--secondary-color);
    }

    .back-to-top {
      position: fixed;
      visibility: hidden;
      opacity: 0;
      right: 15px;
      bottom: 15px;
      z-index: 99999;
      background: var(--primary-color);
      width: 40px;
      height: 40px;
      border-radius: 50%;
      transition: all 0.4s;
      box-shadow: 0 4px 15px rgba(253, 129, 14, 0.3);
    }

    .back-to-top i {
      font-size: 24px;
      color: #fff;
      line-height: 0;
    }

    .back-to-top:hover {
      background: var(--primary-dark);
      color: #fff;
      transform: translateY(-5px);
      box-shadow: 0 6px 20px rgba(253, 129, 14, 0.4);
    }

    .back-to-top.active {
      visibility: visible;
      opacity: 1;
    }

    .badge {
      padding: 0.35rem 0.65rem;
      font-weight: 600;
    }

    .badge.bg-label-primary {
      background-color: var(--primary-lighter) !important;
      color: var(--primary-color) !important;
    }
  </style>
</head>

<body>

  <!-- ======= Header ======= -->
  <header id="header" class="header fixed-top">
    <div class="container-fluid container-xl d-flex align-items-center justify-content-between">

      <a href="{{ route('landing') }}" class="logo d-flex align-items-center">
        @if(\App\Helpers\Helpers::setting('logoUrl'))
          <img src="{{ str_replace(['https://127.0.0.1:8000', 'http://127.0.0.1:8000', 'https://nearbuymarts.com', 'http://nearbuymarts.com'], '', \App\Helpers\Helpers::setting('logoUrl')) }}" alt="{{ config('app.name') }}">
        @else
          <span>{{ config('app.name') }}</span>
        @endif
      </a>

      <nav id="navbar" class="navbar">
        <ul>
          <li><a class="nav-link scrollto active" href="#hero">Home</a></li>
          <li><a class="nav-link scrollto" href="#about">About</a></li>
          <li><a class="nav-link scrollto" href="#features">Features</a></li>
          <li><a class="nav-link scrollto" href="#testimonials">Testimonials</a></li>
          @guest
          <li><a class="nav-link scrollto" href="{{ route('login') }}">Login</a></li>
          <li><a class="getstarted scrollto" href="{{ route('register') }}">Get Started</a></li>
          @else
          <li><a class="getstarted scrollto" href="{{ route('device.list') }}">My Dashboard</a></li>
          @endguest
        </ul>
        <i class="bi bi-list mobile-nav-toggle"></i>
      </nav><!-- .navbar -->

    </div>
  </header><!-- End Header -->

  <!-- ======= Hero Section ======= -->
  <section id="hero" class="hero d-flex align-items-center">
    <div class="container">
      <div class="row">
        <div class="col-lg-6 d-flex flex-column justify-content-center">
          <h1 data-aos="fade-up">Customer Engagement on WhatsApp Made Simple for Peace of Mind</h1>
          <h3 data-aos="fade-up" data-aos-delay="100">Drive Sales, Support & Marketing Conversations on the World's Most Popular Messaging App</h3>
          <h3 data-aos="fade-up" data-aos-delay="200">Marketing | E-Commerce | Support</h3>
          <div data-aos="fade-up" data-aos-delay="300">
            <div class="text-center text-lg-start">
              <a href="{{ route('register') }}" class="btn-get-started scrollto d-inline-flex align-items-center justify-content-center align-self-center">
                <span>Get Started Free</span>
                <i class="bi bi-arrow-right ms-2"></i>
              </a>
            </div>
          </div>
        </div>
        <div class="col-lg-6 hero-img" data-aos="zoom-out" data-aos-delay="200">
          <img src="/landing-assets/images/hero-illustration.svg" class="img-fluid" alt="WhatsApp Marketing">
        </div>
      </div>
    </div>
  </section><!-- End Hero -->

  <main id="main">

    <!-- ======= About Section ======= -->
    <section id="about" class="about">
      <div class="container" data-aos="fade-up">
        
        <!-- Who We Are -->
        <div class="row gx-0 mb-5">
          <div class="col-lg-6 d-flex flex-column justify-content-center" data-aos="fade-up" data-aos-delay="200">
            <div class="content">
              <h3>About Us</h3>
              <h2>Who We Are</h2>
              <p>
                At <strong>NearBuy Communications Gateway</strong>, we are a team of passionate developers dedicated to transforming how businesses communicate.
              </p>
              <p>
                We design and deliver reliable WhatsApp APIs, bulk messaging platforms, and automation tools that make marketing and customer engagement effortless.
              </p>
              <p>
                Our solutions integrate seamlessly with accounting systems, CRMs, ERPs, and websites, enabling businesses to send messages, share updates, and automate workflows with speed and precision.
              </p>
              <p>
                With NearBuy, connecting with your audience is simpler, smarter, and more powerful than ever.
              </p>
            </div>
          </div>

          <div class="col-lg-6 d-flex align-items-center" data-aos="zoom-out" data-aos-delay="200">
            <img src="/landing-assets/images/team-collaboration.svg" class="img-fluid" alt="NearBuy Team">
          </div>
        </div>

        <!-- What We Do -->
        <div class="row gx-0 mb-5">
          <div class="col-lg-6 d-flex align-items-center order-lg-2" data-aos="zoom-out" data-aos-delay="200">
            <img src="/landing-assets/images/what-we-do-illustration.svg" class="img-fluid" alt="What We Do">
          </div>

          <div class="col-lg-6 d-flex flex-column justify-content-center order-lg-1" data-aos="fade-up" data-aos-delay="200">
            <div class="content">
              <h2>What We Do</h2>
              <p>
                At <strong>NearBuy Communications Gateway</strong>, we simplify digital communication through intelligent automation and seamless integration.
              </p>
              <p>
                We provide businesses and developers with cutting-edge WhatsApp-based solutions that streamline marketing, customer support, and operations.
              </p>
              <p><strong>Our tools are designed to help you:</strong></p>
              <ul style="list-style: none; padding-left: 0;">
                <li style="margin-bottom: 12px;">
                  <i class="bi bi-chat-dots" style="color: #FD810E; font-size: 20px; margin-right: 10px;"></i>
                  <strong>Send personalized messages</strong> to customers in real time.
                </li>
                <li style="margin-bottom: 12px;">
                  <i class="bi bi-gear" style="color: #FD810E; font-size: 20px; margin-right: 10px;"></i>
                  <strong>Automate routine tasks</strong> such as order updates, payment reminders, and notifications.
                </li>
                <li style="margin-bottom: 12px;">
                  <i class="bi bi-diagram-3" style="color: #FD810E; font-size: 20px; margin-right: 10px;"></i>
                  <strong>Integrate easily</strong> with your existing CRM, ERP, or website for smooth data flow.
                </li>
                <li style="margin-bottom: 12px;">
                  <i class="bi bi-rocket-takeoff" style="color: #FD810E; font-size: 20px; margin-right: 10px;"></i>
                  <strong>Enhance engagement</strong> and productivity through smart communication workflows.
                </li>
              </ul>
              <p>
                With NearBuy, you gain the flexibility, scalability, and performance needed to build stronger customer relationships and grow your business efficiently.
              </p>
            </div>
          </div>
        </div>

        <!-- Mission & Vision -->
        <div class="row gx-0">
          <!-- Mission -->
          <div class="col-lg-6 mb-4 mb-lg-0" data-aos="fade-up" data-aos-delay="200">
            <div class="content" style="background: linear-gradient(135deg, #FD810E 0%, #FF9638 100%); padding: 40px; border-radius: 15px; color: white; height: 100%;">
              <div class="text-center mb-4">
                <img src="/landing-assets/images/mission-illustration.svg" style="max-width: 200px; opacity: 0.9;" alt="Our Mission">
              </div>
              <h2 style="color: white;">Our Mission</h2>
              <p>
                Our mission at <strong>NearBuy Communications Gateway</strong> is to empower businesses with smart, reliable, and scalable communication tools that drive growth and efficiency.
              </p>
              <p>
                We aim to make customer engagement simple, automated, and accessible — enabling every business, regardless of size, to connect meaningfully with their audience through WhatsApp and beyond.
              </p>
            </div>
          </div>

          <!-- Vision -->
          <div class="col-lg-6" data-aos="fade-up" data-aos-delay="400">
            <div class="content" style="background: linear-gradient(135deg, #2C3E50 0%, #34495E 100%); padding: 40px; border-radius: 15px; color: white; height: 100%;">
              <div class="text-center mb-4">
                <img src="/landing-assets/images/vision-illustration.svg" style="max-width: 200px; opacity: 0.9;" alt="Our Vision">
              </div>
              <h2 style="color: white;">Our Vision</h2>
              <p>
                Our vision is to become a global leader in business communication technology, redefining how organizations interact with customers in the digital age.
              </p>
              <p>
                We envision a future where every business leverages automation, integration, and intelligent messaging to create seamless, personalized, and impactful customer experiences.
              </p>
            </div>
          </div>
        </div>

      </div>
    </section><!-- End About Section -->

    <!-- ======= Values Section ======= -->
    <section id="values" class="values">
      <div class="container" data-aos="fade-up">

        <header class="section-header">
          <h2>How it works?</h2>
          <p>Quick Onboarding in Less Than 1 Minute</p>
        </header>

        <div class="row">

          <div class="col-lg-4" data-aos="fade-up" data-aos-delay="200">
            <div class="box">
              <img src="/landing-assets/images/create-account.svg" class="img-fluid" alt="Create Account">
              <h3>Create Account</h3>
              <p>Sign up and create instance to get your API Token instantly.</p>
            </div>
          </div>

          <div class="col-lg-4 mt-4 mt-lg-0" data-aos="fade-up" data-aos-delay="400">
            <div class="box">
              <img src="/landing-assets/images/qr-scan.svg" class="img-fluid" alt="Scan QR">
              <h3>Scan QR Code</h3>
              <p>Scan QR to authenticate your instance to send messages via your WhatsApp number.</p>
            </div>
          </div>

          <div class="col-lg-4 mt-4 mt-lg-0" data-aos="fade-up" data-aos-delay="600">
            <div class="box">
              <img src="/landing-assets/images/send-message.svg" class="img-fluid" alt="Send Messages">
              <h3>Start Sending Messages</h3>
              <p>Start sending messages via API or our inbuilt system in your favorite programming language.</p>
            </div>
          </div>

        </div>

      </div>
    </section><!-- End Values Section -->

    <!-- ======= Features Section ======= -->
    <section id="features" class="features">
      <div class="container" data-aos="fade-up">

        <header class="section-header">
          <h2>Basic Features</h2>
          <p>Developer & User-Friendly API for Integration</p>
        </header>

        <div class="row">

          <div class="col-lg-6">
            <img src="/landing-assets/images/features-illustration.svg" class="img-fluid" alt="Features">
          </div>

          <div class="col-lg-6 mt-5 mt-lg-0 d-flex">
            <div class="row align-self-center gy-4">

              <div class="col-md-6" data-aos="zoom-out" data-aos-delay="200">
                <div class="feature-box d-flex align-items-center">
                  <i class="bi bi-robot"></i>
                  <h3>AI Chatbots</h3>
                </div>
              </div>

              <div class="col-md-6" data-aos="zoom-out" data-aos-delay="300">
                <div class="feature-box d-flex align-items-center">
                  <i class="bi bi-file-earmark-richtext"></i>
                  <h3>Multimedia Messages</h3>
                </div>
              </div>

              <div class="col-md-6" data-aos="zoom-out" data-aos-delay="400">
                <div class="feature-box d-flex align-items-center">
                  <i class="bi bi-shield-check"></i>
                  <h3>Verification & OTP</h3>
                </div>
              </div>

              <div class="col-md-6" data-aos="zoom-out" data-aos-delay="500">
                <div class="feature-box d-flex align-items-center">
                  <i class="bi bi-megaphone"></i>
                  <h3>Bulk Broadcasting</h3>
                </div>
              </div>

              <div class="col-md-6" data-aos="zoom-out" data-aos-delay="600">
                <div class="feature-box d-flex align-items-center">
                  <i class="bi bi-bell"></i>
                  <h3>Smart Notifications</h3>
                </div>
              </div>

              <div class="col-md-6" data-aos="zoom-out" data-aos-delay="700">
                <div class="feature-box d-flex align-items-center">
                  <i class="bi bi-people"></i>
                  <h3>Customer Communications</h3>
                </div>
              </div>

              <div class="col-md-6" data-aos="zoom-out" data-aos-delay="800">
                <div class="feature-box d-flex align-items-center">
                  <i class="bi bi-headset"></i>
                  <h3>Customer Support</h3>
                </div>
              </div>

              <div class="col-md-6" data-aos="zoom-out" data-aos-delay="900">
                <div class="feature-box d-flex align-items-center">
                  <i class="bi bi-clock-history"></i>
                  <h3>Smart Reminders</h3>
                </div>
              </div>

            </div>
          </div>

        </div>

      </div>
    </section><!-- End Features Section -->

    <!-- ======= Key Features Section ======= -->
    <section id="key-features" class="features" style="background: #f6f9ff;">
      <div class="container" data-aos="fade-up">
        <div class="text-center mb-3 pb-1">
          <span class="badge bg-label-primary">Useful Features</span>
        </div>

        <header class="section-header">
          <h2>Key Features</h2>
          <p>Everything to Start WhatsApp Automation</p>
        </header>

        <p class="text-center mb-5 pb-3">
          Prepare yourself for the world of WhatsApp automation.
        </p>

        <div class="row g-4">
          
          <div class="col-lg-4 col-sm-6 text-center" data-aos="fade-up" data-aos-delay="100">
            <div class="features-icon-box p-4">
              <div class="mb-3">
                <i class="bi bi-bell text-primary" style="font-size: 48px;"></i>
              </div>
              <h5 class="mb-3">Notifications</h5>
              <p class="features-icon-description">
                Send automated transactional notifications from external apps.
              </p>
            </div>
          </div>

          <div class="col-lg-4 col-sm-6 text-center" data-aos="fade-up" data-aos-delay="200">
            <div class="features-icon-box p-4">
              <div class="mb-3">
                <i class="bi bi-robot text-primary" style="font-size: 48px;"></i>
              </div>
              <h5 class="mb-3">AI Chatbot</h5>
              <p class="features-icon-description">
                Create chatbots to answer your customers' queries automatically with AI.
              </p>
            </div>
          </div>

          <div class="col-lg-4 col-sm-6 text-center" data-aos="fade-up" data-aos-delay="300">
            <div class="features-icon-box p-4">
              <div class="mb-3">
                <i class="bi bi-arrow-repeat text-primary" style="font-size: 48px;"></i>
              </div>
              <h5 class="mb-3">Recurring Messages</h5>
              <p class="features-icon-description">
                Send daily, weekly, monthly messages automatically.
              </p>
            </div>
          </div>

          <div class="col-lg-4 col-sm-6 text-center" data-aos="fade-up" data-aos-delay="400">
            <div class="features-icon-box p-4">
              <div class="mb-3">
                <i class="bi bi-file-earmark-text text-primary" style="font-size: 48px;"></i>
              </div>
              <h5 class="mb-3">Invoice Management</h5>
              <p class="features-icon-description">
                Send company invoices to customers easily with PDF generation.
              </p>
            </div>
          </div>

          <div class="col-lg-4 col-sm-6 text-center" data-aos="fade-up" data-aos-delay="500">
            <div class="features-icon-box p-4">
              <div class="mb-3">
                <i class="bi bi-broadcast text-primary" style="font-size: 48px;"></i>
              </div>
              <h5 class="mb-3">Broadcast</h5>
              <p class="features-icon-description">
                Send messages to multiple receivers at once efficiently.
              </p>
            </div>
          </div>

          <div class="col-lg-4 col-sm-6 text-center" data-aos="fade-up" data-aos-delay="600">
            <div class="features-icon-box p-4">
              <div class="mb-3">
                <i class="bi bi-shield-check text-primary" style="font-size: 48px;"></i>
              </div>
              <h5 class="mb-3">OTP Verification</h5>
              <p class="features-icon-description">
                Send OTP codes for login, registration, and password reset.
              </p>
            </div>
          </div>

          <div class="col-lg-4 col-sm-6 text-center" data-aos="fade-up" data-aos-delay="700">
            <div class="features-icon-box p-4">
              <div class="mb-3">
                <i class="bi bi-lightning text-primary" style="font-size: 48px;"></i>
              </div>
              <h5 class="mb-3">OpenAI ChatGPT</h5>
              <p class="features-icon-description">
                Automated OpenAI ChatGPT chatbot integration.
              </p>
            </div>
          </div>

          <div class="col-lg-4 col-sm-6 text-center" data-aos="fade-up" data-aos-delay="800">
            <div class="features-icon-box p-4">
              <div class="mb-3">
                <i class="bi bi-calendar-check text-primary" style="font-size: 48px;"></i>
              </div>
              <h5 class="mb-3">Schedule Messages</h5>
              <p class="features-icon-description">
                Send scheduled messages at specific dates and times.
              </p>
            </div>
          </div>

          <div class="col-lg-4 col-sm-6 text-center" data-aos="fade-up" data-aos-delay="900">
            <div class="features-icon-box p-4">
              <div class="mb-3">
                <i class="bi bi-code-square text-primary" style="font-size: 48px;"></i>
              </div>
              <h5 class="mb-3">Custom Variables</h5>
              <p class="features-icon-description">
                Personalize messages with custom variables like {name}.
              </p>
            </div>
          </div>

          <div class="col-lg-4 col-sm-6 text-center" data-aos="fade-up" data-aos-delay="1000">
            <div class="features-icon-box p-4">
              <div class="mb-3">
                <i class="bi bi-paperclip text-primary" style="font-size: 48px;"></i>
              </div>
              <h5 class="mb-3">File Attachments</h5>
              <p class="features-icon-description">
                Send messages with multiple file types (images, PDF, Excel, etc.).
              </p>
            </div>
          </div>

          <div class="col-lg-4 col-sm-6 text-center" data-aos="fade-up" data-aos-delay="1100">
            <div class="features-icon-box p-4">
              <div class="mb-3">
                <i class="bi bi-file-earmark-spreadsheet text-primary" style="font-size: 48px;"></i>
              </div>
              <h5 class="mb-3">CSV & Excel Import</h5>
              <p class="features-icon-description">
                Import phonebooks from CSV and Excel files easily.
              </p>
            </div>
          </div>

          <div class="col-lg-4 col-sm-6 text-center" data-aos="fade-up" data-aos-delay="1200">
            <div class="features-icon-box p-4">
              <div class="mb-3">
                <i class="bi bi-check-square text-primary" style="font-size: 48px;"></i>
              </div>
              <h5 class="mb-3">Todo & Reminders</h5>
              <p class="features-icon-description">
                Manage tasks with smart reminders and recurring todos.
              </p>
            </div>
          </div>

        </div>
      </div>
    </section><!-- End Key Features Section -->

    <!-- ======= Testimonials Section ======= -->
    <section id="testimonials" class="testimonials">
      <div class="container" data-aos="fade-up">

        <header class="section-header">
          <h2>Testimonials</h2>
          <p>What They Are Saying About Us</p>
        </header>

        <div class="row gy-4">

          <div class="col-lg-4" data-aos="fade-up" data-aos-delay="100">
            <div class="testimonial-item">
              <div class="stars">
                <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
              </div>
              <p>
                Cost-effective with all major features and a supportive team. The automation chatbot feature is amazing! We recently conducted registrations where ~2000 students registered themselves automatically.
              </p>
              <div class="profile mt-auto">
                <img src="/app-assets/images/portrait/small/avatar-s-1.jpg" class="testimonial-img" alt="">
                <h3>John Smith</h3>
                <h4>CEO & Founder</h4>
              </div>
            </div>
          </div>

          <div class="col-lg-4" data-aos="fade-up" data-aos-delay="200">
            <div class="testimonial-item">
              <div class="stars">
                <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
              </div>
              <p>
                The most advanced yet user-friendly WhatsApp business CRM solution! I really like the broadcasting, flow builder, and mobile app. I can assign multiple agents to manage conversations.
              </p>
              <div class="profile mt-auto">
                <img src="/app-assets/images/portrait/small/avatar-s-2.jpg" class="testimonial-img" alt="">
                <h3>Sarah Wilson</h3>
                <h4>Marketing Director</h4>
              </div>
            </div>
          </div>

          <div class="col-lg-4" data-aos="fade-up" data-aos-delay="300">
            <div class="testimonial-item">
              <div class="stars">
                <i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i><i class="bi bi-star-fill"></i>
              </div>
              <p>
                We're sending automated notifications to customers. With this automation, we don't have to manually send notifications. Super easy to use and integrate with existing workflows!
              </p>
              <div class="profile mt-auto">
                <img src="/app-assets/images/portrait/small/avatar-s-3.jpg" class="testimonial-img" alt="">
                <h3>Michael Brown</h3>
                <h4>E-commerce Owner</h4>
              </div>
            </div>
          </div>

        </div>

      </div>
    </section><!-- End Testimonials Section -->

  </main><!-- End #main -->

  <!-- ======= Footer ======= -->
  <footer id="footer" class="footer">

    <div class="footer-top">
      <div class="container">
        <div class="row gy-4">
          <div class="col-lg-5 col-md-12 footer-info">
            <a href="{{ route('landing') }}" class="logo d-flex align-items-center">
              @if(\App\Helpers\Helpers::setting('logoUrl'))
                <img src="{{ str_replace(['https://127.0.0.1:8000', 'http://127.0.0.1:8000', 'https://nearbuymarts.com', 'http://nearbuymarts.com'], '', \App\Helpers\Helpers::setting('logoUrl')) }}" alt="">
              @else
                <span>{{ config('app.name') }}</span>
              @endif
            </a>
            <p class="mt-3">Drive Sales, Support & Marketing Conversations on the World's most popular messaging App.</p>
            <div class="social-links mt-3">
              <a href="#" class="facebook"><i class="bi bi-facebook"></i></a>
              <a href="#" class="twitter"><i class="bi bi-twitter"></i></a>
              <a href="#" class="youtube"><i class="bi bi-youtube"></i></a>
              <a href="#" class="linkedin"><i class="bi bi-linkedin"></i></a>
            </div>
          </div>

          <div class="col-lg-2 col-6 footer-links">
            <h4>Useful Links</h4>
            <ul>
              <li><i class="bi bi-chevron-right"></i> <a href="#hero">Home</a></li>
              <li><i class="bi bi-chevron-right"></i> <a href="#about">About us</a></li>
              <li><i class="bi bi-chevron-right"></i> <a href="#features">Features</a></li>
              <li><i class="bi bi-chevron-right"></i> <a href="{{ route('login') }}">Login</a></li>
              <li><i class="bi bi-chevron-right"></i> <a href="{{ route('register') }}">Register</a></li>
            </ul>
          </div>

          <div class="col-lg-2 col-6 footer-links">
            <h4>Our Services</h4>
            <ul>
              <li><i class="bi bi-chevron-right"></i> <a href="#features">AI Chatbot</a></li>
              <li><i class="bi bi-chevron-right"></i> <a href="#features">Bulk Sender</a></li>
              <li><i class="bi bi-chevron-right"></i> <a href="#features">API Integration</a></li>
              <li><i class="bi bi-chevron-right"></i> <a href="#features">Marketing</a></li>
              <li><i class="bi bi-chevron-right"></i> <a href="#features">Notifications</a></li>
            </ul>
          </div>

          <div class="col-lg-3 col-md-12 footer-contact text-center text-md-start">
            <h4>Contact Us</h4>
            <p>
              {{ \App\Helpers\Helpers::setting('companyAddress') ?? 'NearBuy Communications Gateway' }}<br>
              <strong>Phone:</strong> {{ \App\Helpers\Helpers::setting('companyPhone') ?? '+234 809 720 1257' }}<br>
              <strong>Email:</strong> {{ \App\Helpers\Helpers::setting('companyEmail') ?? 'info@nearbuymarts.com' }}<br>
            </p>
          </div>

        </div>
      </div>
    </div>

    <div class="container">
      <div class="copyright">
        &copy; Copyright <strong><span>{{ config('app.name') }}</span></strong>. All Rights Reserved
      </div>
    </div>
  </footer><!-- End Footer -->

  <a href="#" class="back-to-top d-flex align-items-center justify-content-center"><i class="bi bi-arrow-up-short"></i></a>

  <!-- WhatsApp Chat Widget -->
  @php
    $whatsappNumber = \App\Helpers\Helpers::setting('supportWhatsApp') ?? '+2348097201257';
    $whatsappNumber = preg_replace('/[^0-9]/', '', $whatsappNumber);
  @endphp
  
  <div id="whatsapp-chat-widget">
    <!-- WhatsApp Button -->
    <div class="whatsapp-button" id="wa-button">
      <i class="bi bi-whatsapp"></i>
      <span class="pulse-ring"></span>
    </div>

    <!-- Chat Box -->
    <div class="whatsapp-chat-box" id="wa-chat-box">
      <div class="chat-header">
        <div class="d-flex align-items-center">
          <div class="avatar">
            @if(\App\Helpers\Helpers::setting('logoUrl'))
              <img src="{{ str_replace(['https://127.0.0.1:8000', 'http://127.0.0.1:8000', 'https://nearbuymarts.com', 'http://nearbuymarts.com'], '', \App\Helpers\Helpers::setting('logoUrl')) }}" alt="Support">
            @else
              <i class="bi bi-person-circle"></i>
            @endif
          </div>
          <div class="ms-3">
            <h6 class="mb-0">{{ config('app.name') }} Support</h6>
            <small>Typically replies instantly</small>
          </div>
        </div>
        <button class="close-chat" id="close-chat">
          <i class="bi bi-x"></i>
        </button>
      </div>
      
      <div class="chat-body">
        <div class="message admin-message">
          <div class="message-content">
            <p>Hi there! 👋</p>
            <p>How can we help you today?</p>
            <small>{{ now()->format('h:i A') }}</small>
          </div>
        </div>
      </div>

      <div class="chat-footer">
        <a href="https://wa.me/{{ $whatsappNumber }}?text=Hi,%20I%20need%20help%20with%20{{ urlencode(config('app.name')) }}" 
           target="_blank" 
           class="btn-start-chat">
          <i class="bi bi-whatsapp me-2"></i>
          Start WhatsApp Chat
        </a>
      </div>
    </div>
  </div>

  <style>
    /* WhatsApp Widget Styles */
    #whatsapp-chat-widget {
      position: fixed;
      bottom: 30px;
      right: 30px;
      z-index: 9999;
    }

    .whatsapp-button {
      width: 60px;
      height: 60px;
      background: linear-gradient(135deg, #25D366 0%, #128C7E 100%);
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      cursor: pointer;
      box-shadow: 0 4px 20px rgba(37, 211, 102, 0.4);
      transition: all 0.3s ease;
      position: relative;
    }

    .whatsapp-button:hover {
      transform: scale(1.1);
      box-shadow: 0 6px 30px rgba(37, 211, 102, 0.6);
    }

    .whatsapp-button i {
      font-size: 32px;
      color: white;
    }

    .pulse-ring {
      position: absolute;
      width: 100%;
      height: 100%;
      border: 3px solid #25D366;
      border-radius: 50%;
      animation: pulse 2s infinite;
      opacity: 0;
    }

    @keyframes pulse {
      0% {
        transform: scale(1);
        opacity: 0.8;
      }
      100% {
        transform: scale(1.5);
        opacity: 0;
      }
    }

    .whatsapp-chat-box {
      position: absolute;
      bottom: 80px;
      right: 0;
      width: 350px;
      max-width: calc(100vw - 60px);
      background: white;
      border-radius: 15px;
      box-shadow: 0 10px 40px rgba(0, 0, 0, 0.2);
      display: none;
      flex-direction: column;
      overflow: hidden;
      animation: slideUp 0.3s ease;
    }

    .whatsapp-chat-box.active {
      display: flex;
    }

    @keyframes slideUp {
      from {
        opacity: 0;
        transform: translateY(20px);
      }
      to {
        opacity: 1;
        transform: translateY(0);
      }
    }

    .chat-header {
      background: linear-gradient(135deg, #25D366 0%, #128C7E 100%);
      color: white;
      padding: 15px;
      display: flex;
      justify-content: space-between;
      align-items: center;
    }

    .chat-header .avatar {
      width: 50px;
      height: 50px;
      background: white;
      border-radius: 50%;
      display: flex;
      align-items: center;
      justify-content: center;
      overflow: hidden;
    }

    .chat-header .avatar img {
      width: 100%;
      height: 100%;
      object-fit: cover;
    }

    .chat-header .avatar i {
      font-size: 35px;
      color: #25D366;
    }

    .chat-header h6 {
      color: white;
      font-weight: 600;
    }

    .chat-header small {
      color: rgba(255, 255, 255, 0.9);
      font-size: 12px;
    }

    .close-chat {
      background: none;
      border: none;
      color: white;
      font-size: 24px;
      cursor: pointer;
      padding: 0;
      width: 30px;
      height: 30px;
      display: flex;
      align-items: center;
      justify-content: center;
      border-radius: 50%;
      transition: background 0.3s;
    }

    .close-chat:hover {
      background: rgba(255, 255, 255, 0.2);
    }

    .chat-body {
      padding: 20px;
      background: #E5DDD5;
      min-height: 200px;
      max-height: 300px;
      overflow-y: auto;
      background-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="100" height="100"><path d="M0 0 L50 50 L0 100 L50 50 L100 100 L100 0 L50 50 L100 0" fill="none" stroke="rgba(0,0,0,0.03)" stroke-width="1"/></svg>');
    }

    .message {
      margin-bottom: 15px;
      display: flex;
    }

    .admin-message {
      justify-content: flex-start;
    }

    .message-content {
      background: white;
      padding: 10px 15px;
      border-radius: 10px;
      max-width: 80%;
      box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
    }

    .message-content p {
      margin: 5px 0;
      color: #2C3E50;
      font-size: 14px;
    }

    .message-content small {
      color: #999;
      font-size: 11px;
    }

    .chat-footer {
      padding: 15px;
      background: white;
      border-top: 1px solid #eee;
    }

    .btn-start-chat {
      width: 100%;
      background: linear-gradient(135deg, #25D366 0%, #128C7E 100%);
      color: white;
      border: none;
      padding: 12px 20px;
      border-radius: 8px;
      font-weight: 600;
      font-size: 15px;
      cursor: pointer;
      transition: all 0.3s ease;
      text-decoration: none;
      display: flex;
      align-items: center;
      justify-content: center;
    }

    .btn-start-chat:hover {
      background: linear-gradient(135deg, #128C7E 0%, #075E54 100%);
      color: white;
      transform: translateY(-2px);
      box-shadow: 0 4px 15px rgba(37, 211, 102, 0.3);
    }

    @media (max-width: 768px) {
      #whatsapp-chat-widget {
        bottom: 20px;
        right: 20px;
      }

      .whatsapp-button {
        width: 55px;
        height: 55px;
      }

      .whatsapp-button i {
        font-size: 28px;
      }

      .whatsapp-chat-box {
        width: calc(100vw - 40px);
        bottom: 75px;
      }
    }
  </style>

  <!-- Vendor JS Files - Local -->
  <script src="/landing-assets/js/aos.js"></script>
  <script src="/landing-assets/js/bootstrap.bundle.min.js"></script>

  <!-- Main JS -->
  <script>
    // AOS Animation
    AOS.init({
      duration: 1000,
      easing: 'ease-in-out',
      once: true,
      mirror: false
    });

    // Back to top button
    let backtotop = document.querySelector('.back-to-top');
    if (backtotop) {
      const toggleBacktotop = () => {
        if (window.scrollY > 100) {
          backtotop.classList.add('active');
        } else {
          backtotop.classList.remove('active');
        }
      }
      window.addEventListener('load', toggleBacktotop);
      window.addEventListener('scroll', toggleBacktotop);
    }

    // Mobile nav toggle
    document.querySelector('.mobile-nav-toggle').addEventListener('click', function() {
      document.querySelector('.navbar ul').classList.toggle('d-block');
    });

    // Smooth scroll for anchor links
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
      anchor.addEventListener('click', function (e) {
        e.preventDefault();
        const target = document.querySelector(this.getAttribute('href'));
        if (target) {
          target.scrollIntoView({
            behavior: 'smooth',
            block: 'start'
          });
        }
      });
    });

    // Header scroll effect
    window.addEventListener('scroll', function() {
      const header = document.querySelector('#header');
      if (window.scrollY > 100) {
        header.classList.add('header-scrolled');
      } else {
        header.classList.remove('header-scrolled');
      }
    });

    // WhatsApp Chat Widget
    const waButton = document.getElementById('wa-button');
    const waChatBox = document.getElementById('wa-chat-box');
    const closeChat = document.getElementById('close-chat');

    waButton.addEventListener('click', function(e) {
      e.preventDefault();
      waChatBox.classList.toggle('active');
    });

    closeChat.addEventListener('click', function(e) {
      e.preventDefault();
      waChatBox.classList.remove('active');
    });

    // Close chat when clicking outside
    document.addEventListener('click', function(e) {
      if (!e.target.closest('#whatsapp-chat-widget')) {
        waChatBox.classList.remove('active');
      }
    });
  </script>

</body>
</html>
