@php
    if (Auth::check() && Auth::user()->lang) {
        App::setLocale(Auth::user()->lang);
    }
@endphp
<div class="sidenav-overlay"></div>
    <div class="drag-target"></div>

    <!-- BEGIN: Footer-->
    <footer class="footer footer-static footer-light">
        @php($domain=explode('/', rtrim(config('app.url'), '/')))
        <p class="clearfix mb-0"><span class="float-md-start d-block d-md-inline-block mt-25">COPYRIGHT &copy; <script>document.write(new Date().getFullYear());</script> {{ config('app.name') }} by <a class="ms-25" href="{{rtrim(config('app.url'), '/')}}" target="_blank">{{$domain[2]}}</a>. <span class="d-none d-sm-inline-block"> All rights Reserved</span></span><span class="float-md-end d-none d-md-block">Laravel v{{ Illuminate\Foundation\Application::VERSION }} || PHP v{{ PHP_VERSION }} <i data-feather="heart"></i></span></p>
    </footer>
    <button class="btn btn-primary btn-icon scroll-top" type="button"><i data-feather="arrow-up"></i></button>
    <!-- END: Footer-->

    <!-- BEGIN: whatsapp support -->
    @if (filter_var(\App\Helpers\Helpers::setting('supportButton'), FILTER_VALIDATE_BOOLEAN))
    <div class="floating_btn">
        <a target="_blank" href="https://wa.me/{{ \App\Helpers\Helpers::setting('supportPhone') }}">
            <div class="contact_icon">
                <i class="fab fa-whatsapp"></i>
            </div>
        </a>
        <p class="text_icon">{{ __('Need help?') }}</p>
    </div>
    <style>a{text-decoration:none}.floating_btn{position:fixed;bottom:30px;right:30px;width:100px;height:100px;display:flex;flex-direction:column;align-items:center;justify-content:center;z-index:1000}@keyframes pulsing{to{box-shadow:0 0 0 30px rgba(232,76,61,0)}}.contact_icon{background-color:#42db87;color:#fff;width:60px;height:60px;font-size:30px;border-radius:50px;text-align:center;box-shadow:2px 2px 3px #999;display:flex;align-items:center;justify-content:center;transform:translatey(0px);animation:pulse 1.5s infinite;box-shadow:0 0 0 0 #42db87;-webkit-animation:pulsing 1.25s infinite cubic-bezier(0.66,0,0,1);-moz-animation:pulsing 1.25s infinite cubic-bezier(0.66,0,0,1);-ms-animation:pulsing 1.25s infinite cubic-bezier(0.66,0,0,1);animation:pulsing 1.25s infinite cubic-bezier(0.66,0,0,1);font-weight:400;font-family:sans-serif;text-decoration:none!important;transition:all 300ms ease-in-out}.text_icon{margin-top:8px;color:#707070;font-size:13px}</style>
    @endif
    <!-- END: whatsapp support -->

    <!-- BEGIN: Vendor JS-->
    <script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
    <script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
    <script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
    <script src="{{ url('/') }}/app-assets/vendors/js/forms/repeater/jquery.repeater.min.js"></script>
    <!-- END: Vendor JS-->

    <!-- BEGIN: Theme JS-->
    <script src="{{ url('/') }}/app-assets/js/core/app-menu.js"></script>
    <script src="{{ url('/') }}/app-assets/js/core/app.js"></script>
    <!-- END: Theme JS-->

    <!-- Bootstrap Dropdown Fix -->
    <script>
        $(document).ready(function() {
            // Initialize all dropdown toggles
            $('[data-bs-toggle="dropdown"]').each(function() {
                var dropdownToggle = this;
                $(dropdownToggle).on('click', function(e) {
                    e.preventDefault();
                    e.stopPropagation();
                    
                    // Close other dropdowns
                    $('.dropdown-menu').removeClass('show');
                    
                    // Toggle this dropdown
                    var dropdownMenu = $(this).next('.dropdown-menu');
                    dropdownMenu.toggleClass('show');
                });
            });
            
            // Close dropdown when clicking outside
            $(document).on('click', function(e) {
                if (!$(e.target).closest('.dropdown').length) {
                    $('.dropdown-menu').removeClass('show');
                }
            });
        });
    </script>

    <!-- BEGIN: Page JS-->
    <script src="{{ url('/') }}/app-assets/js/scripts/components/components-alerts.js"></script>
    <script src="{{ url('/') }}/app-assets/js/scripts/pages/page-knowledge-base.js"></script>
    <!-- END: Page JS-->

    <!-- <script>
        $(document).ready(function () {
            $('#tbl-bootstr').DataTable();
        });        
    </script> -->

    <script>
        $(window).on('load', function() {
            if (feather) {
                feather.replace({
                    width: 14,
                    height: 14
                });
            }
        })

        $("li").click(
            function(event) {
                setCookie('active_menu', this.id, 1)
            }
        );

        function setCookie(name,value,exp_days) {
            var d = new Date();
            d.setTime(d.getTime() + (exp_days*24*60*60*1000));
            var expires = "expires=" + d.toGMTString();
            document.cookie = name + "=" + value + ";" + expires + ";path=/";
        }
    </script>
</body>
<!-- END: Body-->

</html>