<!DOCTYPE html>
@auth
@php
App::setLocale(Auth::user()->lang);
@endphp
<html class="loading {{ Auth::user()->theme }}" lang="{{ Auth::user()->lang }}" data-textdirection="ltr">
@elseguest
<html class="loading light-layout" lang="us" data-textdirection="ltr">
@endauth
<!-- BEGIN: Head-->

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0,user-scalable=0,minimal-ui">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="description" content="NearBuyMarts Whatsapp Gateway simple but powerful, handles complex tasks, clean and easy to read codes.">
    <meta name="keywords" content="NearBuyMarts whatsapp gateway, multi device, baileys, multi sessions, multi users">
    <meta name="author" content="NearBuyMarts">
    <title>{{ config('app.name') }}</title>
    <link rel="apple-touch-icon" href="{{ url('/') }}/app-assets/images/ico/apple-icon-120.png">
    <link rel="shortcut icon" type="image/x-icon" href="{{ url('/') }}/app-assets/images/ico/favicon.ico">
    <link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,300;0,400;0,500;0,600;1,400;1,500;1,600">
    <link rel="stylesheet" href="{{ url('/') }}/app-assets/fonts/font-awesome/css/font-awesome.min.css">

    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/vendors.min.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/forms/select/select2.min.css">
    <!-- <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css"> -->
    <!-- END: Vendor CSS-->

    <!-- BEGIN: Theme CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css{{Auth::user() && Auth::user()->rtl ? '-rtl':''}}/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css{{Auth::user() && Auth::user()->rtl ? '-rtl':''}}/bootstrap-extended.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css{{Auth::user() && Auth::user()->rtl ? '-rtl':''}}/colors.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css{{Auth::user() && Auth::user()->rtl ? '-rtl':''}}/components.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css{{Auth::user() && Auth::user()->rtl ? '-rtl':''}}/themes/dark-layout.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css{{Auth::user() && Auth::user()->rtl ? '-rtl':''}}/themes/bordered-layout.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css{{Auth::user() && Auth::user()->rtl ? '-rtl':''}}/themes/semi-dark-layout.css">

    <!-- BEGIN: Page CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css{{Auth::user() && Auth::user()->rtl ? '-rtl':''}}/core/menu/menu-types/vertical-menu.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css{{Auth::user() && Auth::user()->rtl ? '-rtl':''}}/plugins/forms/form-validation.css">
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/css{{Auth::user() && Auth::user()->rtl ? '-rtl':''}}/plugins/extensions/ext-component-toastr.css">
    <!-- END: Page CSS-->

    <!-- BEGIN: Custom CSS-->
    <link rel="stylesheet" type="text/css" href="{{ url('/') }}/assets/css/style.css">
    <!-- END: Custom CSS-->

    <script async src="https://www.googletagmanager.com/gtag/js?id=G-HTN5RP4CBJ"></script>
    <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());

    gtag('config', 'G-HTN5RP4CBJ');
    </script>
</head>
<!-- END: Head-->

<!-- BEGIN: Body-->

<body class="vertical-layout vertical-menu-modern navbar-floating footer-static" data-open="click" data-menu="vertical-menu-modern" data-col="">
<noscript><iframe src="https://www.googletagmanager.com/ns.html?id=GTM-5KG4ZNG"
height="0" width="0" style="display:none;visibility:hidden"></iframe></noscript>

    <!-- BEGIN: Header-->
    <nav class="header-navbar navbar navbar-expand-lg align-items-center floating-nav navbar-light navbar-shadow">
        <div class="navbar-container d-flex content">
            <ul class="nav navbar-nav d-xl-none">
                <li class="nav-item"><a class="nav-link menu-toggle" href="#"><i class="ficon" data-feather="menu"></i></a></li>
            </ul>
            @auth
            <!-- BEGIN: Alert -->
            @if(Session::has('success_alert'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
                <div class="alert-body">{!! Session::get('success_alert') !!}</div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            @elseif(Session::has('danger_alert'))
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <div class="alert-body">{!! Session::get('danger_alert') !!}</div>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            @endif
            @if($errors->any())
            <div class="alert alert-danger" alert-dismissible fade show role="alert">
                <ul>
                    @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                    @endforeach
                </ul>
                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
            </div>
            @endif
            <!-- END: Alert -->

            <ul class="nav navbar-nav align-items-center ms-auto">
                <li class="nav-item impersonate">
                    @impersonating($guard = null)
                    <a class="btn btn-warning" href="{{ route('user.leaveImpersonate') }}">ADMIN</a>
                    @endImpersonating
                </li>
                @if(\App\Helpers\Helpers::isEx())
                <li>
                    <a href="{{ route('transaction.list') }}">
                        <i class="fas fa-wallet"></i>
                        @if(Auth::user()->transactions()->sum('amount') < 0 )
                        <span class="badge rounded-pill badge-light-danger me-1">
                        @else
                        <span class="badge rounded-pill badge-light-success me-1">
                        @endif
                            {{ \App\Helpers\Helpers::setting('currencyCode') }} {{ number_format(Auth::user()->transactions()->sum('amount'),\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator')) }}
                        </span>
                    </a>
                </li>
                @endif
                <li class="nav-item dropdown dropdown-language"><a class="nav-link dropdown-toggle" id="dropdown-flag" href="#" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="flag-icon flag-icon-{{ Auth::user()->lang }}"></i><span class="selected-language">{{ Auth::user()->lang }}</span></a>
                    <div class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdown-flag">
                        @foreach(glob(base_path() . '/lang/*.json') as $file)
                        @php $locale = pathinfo($file, PATHINFO_FILENAME); @endphp
                        <a class="dropdown-item" href="{{ route('user.locale', ['locale' => $locale]) }}" data-language="{{ $locale }}">
                            <i class="flag-icon flag-icon-{{ $locale }}"></i>
                            {{ $locale }}
                        </a>
                        @endforeach
                    </div>
                </li>
                <li class="nav-item dropdown dropdown-user">
                    <a class="nav-link dropdown-toggle dropdown-user-link" id="dropdown-user" href="#" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                        <div class="user-nav d-sm-flex d-none">
                            <span class="user-name fw-bolder">{{ ucwords(str_replace('_',' ', Auth::user()->name)) }}</span>
                            <span class="user-status">{{ App\Models\Package::where('id', Auth::user()->package_id)->value('name') }}</span>
                        </div>
                        <span class="avatar">
                            <img class="round" src="{{ \App\Helpers\Helpers::avatarUrl() }}" alt="avatar" height="40" width="40">
                            <span class="avatar-status-online"></span>
                        </span>
                    </a>
                    <div class="dropdown-menu dropdown-menu-end" aria-labelledby="dropdown-user">
                        <a class="dropdown-item" href="{{ route('user.show', ['user_id' => Auth::user()->id]) }}">
                            <i class="me-50" data-feather="user"></i> {{ __('My account') }}
                        </a>
                        @if(Auth::check())
                        <a class="dropdown-item" href="{{ route('logout') }}"
                            onclick="event.preventDefault(); document.getElementById('logout-form').submit();">
                            <i class="me-50" data-feather="power"></i> {{ __('Log out') }}
                        </a>
                        <form method="POST" id="logout-form" action="{{ route('logout') }}">
                            @csrf
                        </form>
                        @else
                        <a class="dropdown-item" href="{{ Route::has('login') ? route('login') : 'javascript:void(0)' }}">
                            <i class="me-50" data-feather="log-in"></i> {{ __('Log in') }}
                        </a>
                        @endif
                    </div>
                </li>
            </ul>
            @endauth
        </div>
    </nav>
    
    <!-- END: Header-->

    <!-- BEGIN: Main Menu-->
    <div class="main-menu menu-fixed menu-light menu-accordion menu-shadow" data-scroll-to-active="true">
        <div class="navbar-header">
            <ul class="nav navbar-nav flex-row">
                <li class="nav-item me-auto">
                    <a class="navbar-brand" href="{{ url('/') }}">
                        @if(\App\Helpers\Helpers::setting('logoUrl'))
                        <span class="brand-logo">
                            <img src="{{ \App\Helpers\Helpers::setting('logoUrl') }}" style="max-width: 200px; height: auto; max-height: 40px;">
                        </span>
                        @else
                        <h2 class="brand-text">{{ config('app.name') }}</h2>
                        @endif
                    </a></li>
                <li class="nav-item nav-toggle"><a class="nav-link modern-nav-toggle pe-0" data-bs-toggle="collapse"><i class="d-block d-xl-none text-primary toggle-icon font-medium-4" data-feather="x"></i><i class="d-none d-xl-block collapse-toggle-icon font-medium-4  text-primary" data-feather="disc" data-ticon="disc"></i></a></li>
            </ul>
        </div>
        <div class="shadow-bottom"></div>
        <?php
        $installedVersion = file_get_contents(base_path('storage/installed'));
        $latestVersion = file_exists(base_path('storage/latest')) ? file_get_contents(base_path('storage/latest')) : $installedVersion;
        ?>
        <div class="main-menu-content">
            @auth
            @php($adminSender = \App\Models\Device::where('user_id', 1)->where('status', '=', 'ONLINE')->value('sender'))
            @if(empty(Auth::user()->banned) && (empty($adminSender) || !empty(Auth::user()->email_verified_at) || !filter_var(\App\Helpers\Helpers::setting('waVerification'), FILTER_VALIDATE_BOOLEAN)))
            <ul class="navigation navigation-main" id="main-menu-navigation" data-menu="menu-navigation">
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'user.show' ? 'active' : '' }}" id="user.show"><a class="d-flex align-items-center" href="{{ route('user.show', ['user_id' => Auth::user()->id]) }}"><i data-feather="user"></i><span class="menu-item text-truncate">{{ __('My account') }}</span></a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'device.list' ? 'active' : '' }}" id="device.list"><a class="d-flex align-items-center" href="{{ route('device.list') }}"><i data-feather="smartphone"></i><span class="menu-item text-truncate">{{ __('Devices') }}</span><span class="badge badge-light-primary rounded-pill ms-auto me-1">{{ DB::table('devices')->where('user_id', '=', Auth::user()->id)->count() }}</span></a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'sendmsg.index' ? 'active' : '' }}" id="sendmsg.index"><a class="d-flex align-items-center" href="{{ route('sendmsg.index') }}"><i data-feather="send"></i><span class="menu-item text-truncate">{{ __('Send message') }}</span></a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'autoreply.list' ? 'active' : '' }}" id="autoreply.list"><a class="d-flex align-items-center" href="{{ route('autoreply.list') }}"><i data-feather="repeat"></i><span class="menu-item text-truncate">{{ __('Autoreply') }}</span></a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'outbox.list' ? 'active' : '' }}" id="outbox.list"><a class="d-flex align-items-center" href="{{ route('outbox.list') }}"><i data-feather="external-link"></i><span class="menu-item text-truncate">{{ __('Outbox') }}</span></a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'outbox.listRecurring' ? 'active' : '' }}" id="outbox.listRecurring"><a class="d-flex align-items-center" href="{{ route('outbox.listRecurring') }}"><i data-feather="clock"></i><span class="menu-item text-truncate">{{ __('Recurring') }}</span></a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'phonebook.list' ? 'active' : '' }}" id="phonebook.list"><a class="d-flex align-items-center" href="{{ route('phonebook.list') }}"><i data-feather="book-open"></i><span class="menu-item text-truncate">{{ __('Phonebooks') }}</span></a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'template.list' ? 'active' : '' }}" id="template.list"><a class="d-flex align-items-center" href="{{ route('template.list') }}"><i data-feather="clipboard"></i><span class="menu-item text-truncate">{{ __('Templates') }}</span></a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'capture.list' ? 'active' : '' }}" id="capture.list"><a class="d-flex align-items-center" href="{{ route('capture.list') }}"><i data-feather="save"></i><span class="menu-item text-truncate">{{ __('Captures') }}</span></a></li>
                @if(env('RECORD_MESSAGES'))
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'message.list' ? 'active' : '' }}" id="message.list"><a class="d-flex align-items-center" href="{{ route('message.list') }}"><i data-feather="message-square"></i><span class="menu-item text-truncate">{{ __('Messages') }}</span></a></li>
                @endif
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'subscriber.list' ? 'active' : '' }}" id="subscriber.list"><a class="d-flex align-items-center" href="{{ route('subscriber.list') }}"><i data-feather="user-plus"></i><span class="menu-item text-truncate">{{ __('Subscribers') }}</span></a></li>
                <li class="navigation-header"><span>{{ __('Management') }}</span><i data-feather="more-horizontal"></i></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'todo.list' ? 'active' : '' }}" id="todo.list"><a class="d-flex align-items-center" href="{{ route('todo.list') }}"><i data-feather="check-square"></i><span class="menu-item text-truncate">{{ __('Todos') }}</span><span class="badge badge-light-warning rounded-pill ms-auto me-1">{{ \App\Models\Todo::where('user_id', Auth::user()->id)->pending()->count() }}</span></a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'invoice.list' ? 'active' : '' }}" id="invoice.list"><a class="d-flex align-items-center" href="{{ route('invoice.list') }}"><i data-feather="file-text"></i><span class="menu-item text-truncate">{{ __('Invoices') }}</span></a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'transaction.list' ? 'active' : '' }}" id="transaction.list"><a class="d-flex align-items-center" href="{{ route('transaction.list') }}"><i data-feather="dollar-sign"></i><span class="menu-item text-truncate">{{ __('Transactions') }}</span></a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'chatbot.list' ? 'active' : '' }}" id="chatbot.list"><a class="d-flex align-items-center" href="{{ route('chatbot.list') }}"><i data-feather="message-circle"></i><span class="menu-item text-truncate">{{ __('Chatbot') }}</span></a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'variable.list' ? 'active' : '' }}" id="variable.list"><a class="d-flex align-items-center" href="{{ route('variable.list') }}"><i data-feather="code"></i><span class="menu-item text-truncate">{{ __('Variables') }}</span></a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'notification.index' ? 'active' : '' }}" id="notification.index"><a class="d-flex align-items-center" href="{{ route('notification.index') }}"><i data-feather="bell"></i><span class="menu-item text-truncate">{{ __('Notifications') }}</span>@if(Auth::user()->unreadNotifications->count() > 0)<span class="badge badge-light-danger rounded-pill ms-auto me-1">{{ Auth::user()->unreadNotifications->count() }}</span>@endif</a></li>
                <li class="navigation-header"><span>{{ __('Support') }}</span><i data-feather="more-horizontal"></i></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && str_starts_with($_COOKIE['active_menu'], 'support.tickets') ? 'active' : '' }}" id="support.tickets"><a class="d-flex align-items-center" href="{{ route('support.tickets.index') }}"><i data-feather="inbox"></i><span class="menu-item text-truncate">{{ __('Tickets') }}</span>@php($pendingTickets = \App\Models\SupportTicket::where('device_id', session('device_id'))->whereIn('status', ['new', 'open'])->count())@if($pendingTickets > 0)<span class="badge badge-light-warning rounded-pill ms-auto me-1">{{ $pendingTickets }}</span>@endif</a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && str_starts_with($_COOKIE['active_menu'], 'support.agents') ? 'active' : '' }}" id="support.agents"><a class="d-flex align-items-center" href="{{ route('support.agents.index') }}"><i data-feather="headphones"></i><span class="menu-item text-truncate">{{ __('Agents') }}</span></a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && str_starts_with($_COOKIE['active_menu'], 'staff') ? 'active' : '' }}" id="staff"><a class="d-flex align-items-center" href="{{ route('staff.index') }}"><i data-feather="users"></i><span class="menu-item text-truncate">{{ __('Staff') }}</span></a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && str_starts_with($_COOKIE['active_menu'], 'support.leads') ? 'active' : '' }}" id="support.leads"><a class="d-flex align-items-center" href="{{ route('support.leads.index') }}"><i data-feather="target"></i><span class="menu-item text-truncate">{{ __('Leads') }}</span>@php($newLeads = \App\Models\Lead::where('device_id', session('device_id'))->where('status', 'new')->count())@if($newLeads > 0)<span class="badge badge-light-info rounded-pill ms-auto me-1">{{ $newLeads }}</span>@endif</a></li>
                <li class="navigation-header"><span>{{ __('Integrations') }}</span><i data-feather="more-horizontal"></i></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && str_starts_with($_COOKIE['active_menu'], 'api.') ? 'active' : '' }}" id="api.tokens"><a class="d-flex align-items-center" href="{{ route('api.tokens.index') }}"><i data-feather="key"></i><span class="menu-item text-truncate">{{ __('API Tokens') }}</span></a></li>
                <li class="navigation-header"><span>{{ __('System') }}</span><i data-feather="more-horizontal"></i></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'restapi.index' ? 'active' : '' }}" id="restapi.index"><a class="d-flex align-items-center" href="{{ route('restapi.index') }}"><i data-feather="zap"></i><span class="menu-item text-truncate">{{ __('Rest API') }}</span></a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'documentations' ? 'active' : '' }}" id="documentations"><a class="d-flex align-items-center" href="{{ route('documentations') }}"><i data-feather="life-buoy"></i><span class="menu-item text-truncate">{{ __('Documentations') }}</span></a></li>
                @if(Auth::user()->role === 'admin')
                <li class="navigation-header"><span>Admin Access</span><i data-feather="more-horizontal"></i></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'transaction.listOffline' ? 'active' : '' }}" id="transaction.listOffline"><a class="d-flex align-items-center" href="{{ route('transaction.listOffline') }}"><i data-feather="credit-card"></i><span class="menu-item text-truncate">{{ __('Offline Payments') }}</span>@php($pendingOffline = \App\Models\Transaction::where('payment_gateway', 'offline')->where('gateway_status', 'pending')->count())@if($pendingOffline > 0)<span class="badge badge-light-warning rounded-pill ms-auto me-1">{{ $pendingOffline }}</span>@endif</a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'module.list' ? 'active' : '' }}" id="module.list"><a class="d-flex align-items-center" href="{{ route('module.list') }}"><i data-feather="layers"></i><span class="menu-item text-truncate">{{ __('Modules') }}</span></a></li>
                @if(\App\Helpers\Helpers::isEx())
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'package.list' ? 'active' : '' }}" id="package.list"><a class="d-flex align-items-center" href="{{ route('package.list') }}"><i data-feather="package"></i><span class="menu-item text-truncate">{{ __('Packages') }}</span></a></li>
                @endif
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'setting.list' ? 'active' : '' }}" id="setting.list"><a class="d-flex align-items-center" href="{{ route('setting.list') }}"><i data-feather="settings"></i><span class="menu-item text-truncate">{{ __('Settings') }}</span></a></li>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'device.listAll' ? 'active' : '' }}" id="device.listAll"><a class="d-flex align-items-center" href="{{ route('device.listAll') }}"><i data-feather="smartphone"></i><span class="menu-item text-truncate">{{ __('Devices') }}*</span><span class="badge badge-light-primary rounded-pill ms-auto me-1">{{ DB::table('devices')->count() }}</span></a></li>
                @if(env('RECORD_MESSAGES'))
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'message.listAll' ? 'active' : '' }}" id="message.listAll"><a class="d-flex align-items-center" href="{{ route('message.listAll') }}"><i data-feather="message-square"></i><span class="menu-item text-truncate">{{ __('Messages') }}*</span><span class="badge badge-light-primary rounded-pill ms-auto me-1">{{ DB::table('messages')->count() }}</span></a></li>
                @endif
                {{-- <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'outbox.listAll' ? 'active' : '' }}" id="outbox.listAll"><a class="d-flex align-items-center" href="{{ route('outbox.listAll') }}"><i data-feather="external-link"></i><span class="menu-item text-truncate">{{ __('Outboxes') }}*</span><span class="badge badge-light-primary rounded-pill ms-auto me-1">{{ DB::table('outboxes')->count() }}</span></a></li> --}}
                {{-- <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'phonebook.listAll' ? 'active' : '' }}" id="phonebook.listAll"><a class="d-flex align-items-center" href="{{ route('phonebook.listAll') }}"><i data-feather="book-open"></i><span class="menu-item text-truncate">{{ __('Phonebooks') }}*</span><span class="badge badge-light-primary rounded-pill ms-auto me-1">{{ DB::table('phonebooks')->count() }}</span></a></li> --}}
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'user.list' ? 'active' : '' }}" id="user.list"><a class="d-flex align-items-center" href="{{ route('user.list') }}"><i data-feather="users"></i><span class="menu-item text-truncate">{{ __('Users') }}</span><span class="badge badge-light-primary rounded-pill ms-auto me-1">{{ DB::table('users')->count() }}</span></a></li>
                <li class="navigation-header"><span>v{{ $installedVersion }}{{ (\App\Helpers\Helpers::isEx()) ? '.extended' : '' }}</span><i data-feather="more-horizontal"></i></li>
                @if($installedVersion < $latestVersion)
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'latest.version' ? 'active' : '' }}" id="latest.version"><a class="d-flex align-items-center" href="{{config('app.URL_MY_ACCOUNT')}}" target="_blank"><i data-feather="download-cloud"></i><span class="menu-item text-truncate">{{ __('UPDATE!') }}</span><span class="badge badge-light-primary rounded-pill ms-auto me-1">v{{ $latestVersion }}</span></a></li>
                @endif
                {{--<li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'referral.module' ? 'active' : '' }}" id="referral.module"><a class="d-flex align-items-center" href="https://visimisi.net/product/1715094690" target="_blank"><i data-feather="dollar-sign"></i><span class="menu-item text-truncate">{{ __('Referral Module') }}</span><span class="badge badge-light-primary rounded-pill ms-auto me-1">NEW!!!</span></a></li>--}}
                @endif
            </ul>
            @endif
            @elseguest
            <ul class="navigation navigation-main" id="main-menu-navigation" data-menu="menu-navigation">
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'user.login' ? 'active' : '' }}" id="user.login"><a class="d-flex align-items-center" href="{{ route('login') }}"><i data-feather="log-in"></i><span class="menu-title text-truncate">{{ __('Log in') }}</span></a></li>
                <div class="dropdown-divider"></div>
                <li class="nav-item {{ isset($_COOKIE['active_menu']) && $_COOKIE['active_menu']  === 'user.register' ? 'active' : '' }}" id="user.register"><a class="d-flex align-items-center" href="{{ route('register') }}"><i data-feather="user-plus"></i><span class="menu-item text-truncate">{{ __('Register') }}</span></a></li>
            </ul>
            @endauth
        </div>
    </div>
    <!-- END: Main Menu-->
