@include('layouts.header')

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-body">
            <!-- job list start -->
            <section class="app-job-list">
                <!-- list and filter start -->
                <div class="card">
                    <h5 class="card-header">
                        <div class="input-group input-group-sm position-relative mx-auto">
                            {{ __('Message list') }}<span class="badge badge-light-secondary ms-2">{{ DB::table('messages')->where('user_id',Auth::user()->id)->count() }}</span>
                            <input type="search" class="form-control" id="search" value="{{!empty($_GET['search']) ? $_GET['search'] : ''}}" placeholder="{{__('Search')}}..." />
                            <button type="button" class="btn btn-sm btn-info" id="searchbtn"><i data-feather="search" class="me-0"></i></button>
                            <a class="btn btn-success" href="{{ route('message.export', ['listAll' => $listAll]) }}">
                                <i data-feather="external-link"></i> {{ strtoupper(__('Export')) }}
                            </a>
                            <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#destroyAll">
                                <i data-feather="trash"></i> {{ strtoupper(__('Delete')) }} {{__('ALL')}}
                            </button>
                            
                            <!-- Modal destroyAll-->
                            <div class="modal fade modal-danger text-start" id="destroyAll" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                <div class="modal-dialog modal-dialog-centered">
                                    <div class="modal-content">
                                        <div class="modal-header">
                                            <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                        </div>
                                        <div class="modal-body">
                                            {{ __('Are you sure you want to delete?') }} <br><br>
                                            <span class="text text-danger"> <b>{{__('ALL')}}</b> </span><br><br>
                                            {{ __('This process is irreversible') }} <br>
                                            {{ __('The record(s) will be deleted from the database permanently') }}
                                        </div>
                                        <div class="modal-footer">
                                        <a class="btn btn-sm btn-danger" href="{{ route('message.destroyAll') }}">{{ __('Delete ALL') }}</a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </h5>
                    <div class="card-body">
                        <div class="table-responsive table-responsive">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th hidden></th>
                                        @if($listAll)<th>{{ __('Username') }}</th>@endif
                                        <th> {{ __('Key ID') }} </th>
                                        <th> {{ __('Sender') }} </th>
                                        <th> {{ __('Remote Jid') }} </th>
                                        <th> {{ __('Push Name')}} </th>
                                        <th> {{ __('Message Text') }} </th>
                                        <th> {{ __('From Me') }} </th>
                                        <th> {{ __('Media Url') }} </th>
                                        <th> {{ __('Actions') }} </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($messages as $message)
                                    <tr class="kb-search-content">
                                        <td hidden>{{ $message->id }}</td>
                                        @if($listAll)
                                        <td><a href="javascript:;" data-bs-target="#show-{{$message->id}}" data-bs-toggle="modal">
                                        {{ empty($message->user->name) ? '('.__('Deleted').')' : $message->user->name }}</a>
                                        </td>
                                        @endif
                                        <td><a href="javascript:;" data-bs-target="#show-{{$message->id}}" data-bs-toggle="modal">
                                        {{ $message->key_id }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#show-{{$message->id}}" data-bs-toggle="modal">
                                        {{ $message->sender }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#show-{{$message->id}}" data-bs-toggle="modal">
                                        {{ preg_replace('/\D/', '', $message->key_remoteJid) }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#show-{{$message->id}}" data-bs-toggle="modal">
                                        {{ $message->pushName }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#show-{{$message->id}}" data-bs-toggle="modal">
                                        {{ substr($message->msgtext, 0, 100) . '...' }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#show-{{$message->id}}" data-bs-toggle="modal">
                                        <span class="badge rounded-pill badge-light-{{$message->from_me?'success':'danger'}} me-1">{{ $message->key_fromMe ? __('YES') : __('NO') }}</span></a>
                                        </td>
                                        <td><a href="{{ $message->mediaurl }}" target="_blank">
                                        @php($arrMediaUrl=explode('/',$message->mediaurl))
                                        {{ end($arrMediaUrl) }}</a>
                                        </td>
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton">
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#show-{{$message->id}}"><i data-feather="eye" class="me-0"></i> {{__('Show')}}</a>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-{{$message->id}}"><i data-feather="trash" class="me-0"></i> {{__('Delete')}}</a>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-{{$message->id}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    {{ __('Are you sure you want to delete?') }} <br><br>
                                                    <span class="text text-danger"> <b>{{ $message->name }}</b> </span><br><br>
                                                    {{ __('This process is irreversible') }} <br>
                                                    {{ __('The record(s) will be deleted from the database permanently') }}
                                                </div>
                                                <div class="modal-footer">
                                                <a class="btn btn-sm btn-danger" href="{{ route('message.destroy', ['message_id' => $message->id]) }}">{{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Show Message Modal -->
                                    <div class="modal fade" id="show-{{$message->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-lg modal-dialog-centered modal-show-message">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1">{{ __('Show message') }}</h1>
                                                    </div>
                                                    <div class="row">
                                                        <!-- <div class="col-12 col-md-6"> -->
                                                            <input type="hidden"  name="message_id" value="{{ $message->id }}" />
                                                            <!-- <label class="form-label" for="sender">{{ __('Device') }}</label>
                                                            <input type="text" name="sender" class="form-control" value="{{ $message->sender }}" />
                                                        </div> -->
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="key_id">{{ __('Key ID') }}</label>
                                                            <input type="text" name="key_id" class="form-control" value="{{ $message->key_id }}" readonly />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="sender">{{ __('Sender') }}</label>
                                                            <input type="text" name="sender" class="form-control" value="{{ $message->sender }}" readonly />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="key_remoteJid">{{ __('Remote Jid') }}</label>
                                                            <input type="text" name="remote_jid" class="form-control" value="{{ $message->remote_jid }}" readonly />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="pushName">{{ __('Push Name')}}</label>
                                                            <input type="text" name="pushName" class="form-control" value="{{ $message->pushName }}" readonly />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="msgtext">{{ __('Message Text') }}</label>
                                                            <input type="text" name="msgtext" class="form-control" value="{{ $message->msgtext }}" readonly />
                                                        </div>
                                                        <div class="col-12 col-md-6" disabled>
                                                            <label class="form-label" for="from_me">{{ __('From Me') }}</label>
                                                            <input type="text" name="from_me" class="form-control" value="{{ $message->from_me? __('YES') : __('NO') }}" readonly />
                                                        </div>
                                                        <div class="col-12">
                                                            <label class="form-label" for="mediaurl">{{ __('Media Url') }}</label>
                                                            <input type="text" name="mediaurl" class="form-control" value="{{ $message->mediaurl }}" readonly />
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Show Message Modal -->
                                    @endforeach
                                    {{ $messages->links() }}
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- list and filter end -->
            </section>
            <!-- jobs list ends -->
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
function search() {
    var url = '{{url()->current()}}' + '?search=' + $('#search').val();
    location.href= url;
}
$('#searchbtn').click(function (e) {
    search();
})
$('#search').keydown(function (e) {
    if (e.which == 13) {
        search();
    }
})
</script>

@include('layouts.footer')
