@include('layouts.header')
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/dropzone/dropzone.min.css">
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div id="jGrowl" class="jGrowl alert alert-success alert-dismissible fade show" role="alert">
        <div class="jGrowl-notification"></div>
    </div>
    <div class="content-wrapper">
        <div class="content-header row">
            <h4>{{ __('Modules manager') }}</h4>
        </div>
        <div class="content-body">
            <!-- modules list start -->
            <section class="app-module-list">
                <!-- list and filter start -->
                <div class="card">
                    @if (!$checkZipExtension)
                        <div class="card-body">
                            <p class="text-danger font-weight-bold"><b>Zip PHP Extension</b> {{ __('Disabled') }}.
                            <br>
                            {{ __('Therefore, you will not be able to upload any Premium Modules') }}.
                            <br>
                            <span class="font-weight-normal">{{ __('Kindly contact your hosting provider to enable') }} <b>Zip PHP Extension</b></span>
                            </p>
                        </div>
                    @else
                    <div class="card-body border-bottom">
                        <div class="card-body">
                            <div class="col-md-12" id="moduleUploadBlock" style="display: block;">
                                <div class="card-body">
                                    <form method="POST" action="{{ route('module.store') }}" enctype="multipart/form-data"
                                        class="dropzone" id="module_uploader">
                                        @csrf
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif
                    <div class="card-body">
                        <div class="table-responsive pt-0">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>{{ __('Name') }}</th>
                                        <th>{{ __('Description') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Version') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($modules as $module)
                                    <?php $lower_name = $module->getLowerName(); ?>
                                    <tr>
                                        <td>
                                            {{ $module->getName() }}
                                        </td>
                                        <td>
                                            {!! $module->getDescription() !!}
                                        </td>
                                        <td>
                                            @if ($module->isEnabled())
                                            <span class="badge rounded-pill badge-light-success me-1">{{ __('Enabled') }}</span>
                                            @else
                                            <span class="badge rounded-pill badge-light-danger me-1">{{ __('Disabled') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            {!! config("$lower_name.version") !!}
                                        </td>
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton">
                                            @if ($module->isEnabled())
                                                <a class="dropdown-item" href="{{ route('module.disable', ['module_name' => $module->getName()]) }}"><i data-feather="x-square" class="me-0"></i> {{__('Disable')}}</a>
                                            @else
                                                <a class="dropdown-item" href="{{ route('module.enable', ['module_name' => $module->getName()]) }}"><i data-feather="check-square" class="me-0"></i> {{__('Enable')}}</a>
                                            @endif
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-{{$module->getName()}}"><i data-feather="trash" class="me-0"></i> {{__('Delete')}}</a>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-{{$module->getName()}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    {{ __('Are you sure you want to delete?') }} <br><br>
                                                    <span class="text text-danger"> <b>{{ $module->getName() }}</b> </span><br><br>
                                                    {{ __('This process is irreversible') }} <br>
                                                    {{ __('The record(s) will be deleted from the database permanently') }}
                                                </div>
                                                <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="{{ route('module.destroy', ['module_name' => $module->getName()]) }}">{{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="modal fade" id="AddNew" tabindex="-1" aria-hidden="true">
                        <div class="modal-dialog modal-lg modal-dialog-centered modal-edit-user">
                            <div class="modal-content">
                                <div class="modal-header bg-transparent">
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                </div>
                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                    <div class="text-center mb-2">
                                        <h1 class="mb-1">{{ __('Upload new module') }}</h1>
                                        <div class="col-md-12" id="moduleUploadBlock" style="display: block;">
                                
                                            <div class="card-body">
                                                <form method="POST" action="{{ route('module.store') }}" enctype="multipart/form-data"
                                                    class="dropzone" id="module_uploader">
                                                    @csrf
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- Modal to add new module starts-->
                    <div class="modal modal-slide-in new-module-modal fade" id="addNew">
                        <div class="modal-dialog">
                            <form action="{{ route('module.store') }}" method="POST"  enctype="multipart/form-data" id="module_uploader" class="dropzone add-new-module modal-content pt-0">
                                @csrf
                                <div>
                                    <h3>{{ __('Drag-and-drop awg_ModuleName.zip file in this box') }}</h3>
                                </div>
                            </form>
                        </div>
                    </div>
                    <!-- Modal to add new module Ends-->
                </div>
                <!-- list and filter end -->
            </section>
            <!-- modules list ends -->
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/sweetalert2/sweetalert2.all.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/dropzone/dropzone.min.js"></script>
<script src="{{ url('/') }}/app-assets/js/scripts/components/components-uploader.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
    $(document).ready(function () {
        $('#tbl-bootstr').DataTable();
    });        
</script>

@include('layouts.footer')
