@include('layouts.header')

@php
App::setLocale(Auth::user()->lang);
@endphp

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <!-- header info start -->
        <div class="row">
            <div class="col-lg-4 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $totalNotifications }}</h3>
                            <span>{{ __('Total Notifications') }}</span>
                        </div>
                        <div class="avatar bg-light-primary p-50">
                            <span class="avatar-content">
                                <i data-feather="bell" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $unreadCount }}</h3>
                            <span>{{ __('Unread') }}</span>
                        </div>
                        <div class="avatar bg-light-warning p-50">
                            <span class="avatar-content">
                                <i data-feather="mail" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $readCount }}</h3>
                            <span>{{ __('Read') }}</span>
                        </div>
                        <div class="avatar bg-light-success p-50">
                            <span class="avatar-content">
                                <i data-feather="check-circle" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- header info end -->
        <div class="content-body">
            <section class="app-notification-list">
                <div class="card">
                    <h5 class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <span>{{ __('Notification Center') }}</span>
                            <div class="btn-group" role="group">
                                <a href="{{ route('notification.index') }}" class="btn btn-sm btn-outline-primary {{ request()->get('filter') == 'all' || !request()->has('filter') ? 'active' : '' }}">
                                    {{ __('All') }}
                                </a>
                                <a href="{{ route('notification.index', ['filter' => 'unread']) }}" class="btn btn-sm btn-outline-warning {{ request()->get('filter') == 'unread' ? 'active' : '' }}">
                                    {{ __('Unread') }} <span class="badge badge-light-warning ms-1">{{ $unreadCount }}</span>
                                </a>
                                <a href="{{ route('notification.index', ['filter' => 'read']) }}" class="btn btn-sm btn-outline-success {{ request()->get('filter') == 'read' ? 'active' : '' }}">
                                    {{ __('Read') }}
                                </a>
                            </div>
                        </div>
                    </h5>
                    <div class="card-body">
                        @if($unreadCount > 0)
                        <div class="mb-3">
                            <button type="button" class="btn btn-sm btn-primary" onclick="markAllAsRead()">
                                <i data-feather="check-circle" class="me-50"></i>{{ __('Mark All as Read') }}
                            </button>
                            <button type="button" class="btn btn-sm btn-outline-danger" onclick="clearAll()">
                                <i data-feather="trash-2" class="me-50"></i>{{ __('Clear All') }}
                            </button>
                        </div>
                        @endif
                        
                        <div class="list-group">
                            @forelse ($notifications as $notification)
                            <div class="list-group-item list-group-item-action {{ is_null($notification->read_at) ? 'bg-light-warning' : '' }}">
                                <div class="d-flex w-100 justify-content-between align-items-start">
                                    <div class="flex-grow-1">
                                        <div class="d-flex align-items-center mb-1">
                                            <div class="avatar {{ is_null($notification->read_at) ? 'bg-light-warning' : 'bg-light-secondary' }} me-2">
                                                <span class="avatar-content">
                                                    @php
                                                        $icon = $notification->data['icon'] ?? 'bell';
                                                    @endphp
                                                    <i data-feather="{{ $icon }}" class="font-medium-3"></i>
                                                </span>
                                            </div>
                                            <div>
                                                <h6 class="mb-0">{{ $notification->data['title'] ?? __('Notification') }}</h6>
                                                <small class="text-muted">{{ $notification->created_at->diffForHumans() }}</small>
                                            </div>
                                        </div>
                                        <p class="mb-1">{{ $notification->data['body'] ?? $notification->data['message'] ?? '' }}</p>
                                        
                                        @if(isset($notification->data['url']))
                                        <a href="{{ $notification->data['url'] }}" class="btn btn-sm btn-outline-primary mt-1">
                                            <i data-feather="external-link" class="me-50"></i>{{ $notification->data['action'] ?? __('View Details') }}
                                        </a>
                                        @endif
                                    </div>
                                    <div class="dropdown">
                                        <button type="button" class="btn btn-sm btn-icon dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                            <i data-feather="more-vertical"></i>
                                        </button>
                                        <div class="dropdown-menu dropdown-menu-end">
                                            @if(is_null($notification->read_at))
                                            <a class="dropdown-item" href="#" onclick="markAsRead('{{ $notification->id }}')">
                                                <i data-feather="check" class="me-50"></i>{{ __('Mark as Read') }}
                                            </a>
                                            @else
                                            <a class="dropdown-item" href="#" onclick="markAsUnread('{{ $notification->id }}')">
                                                <i data-feather="mail" class="me-50"></i>{{ __('Mark as Unread') }}
                                            </a>
                                            @endif
                                            <a class="dropdown-item text-danger" href="#" onclick="deleteNotification('{{ $notification->id }}')">
                                                <i data-feather="trash" class="me-50"></i>{{ __('Delete') }}
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @empty
                            <div class="text-center py-5">
                                <div class="avatar bg-light-secondary p-50 mb-3">
                                    <span class="avatar-content">
                                        <i data-feather="inbox" class="font-large-1"></i>
                                    </span>
                                </div>
                                <h5>{{ __('No notifications yet') }}</h5>
                                <p class="text-muted">{{ __('When you receive notifications, they will appear here') }}</p>
                            </div>
                            @endforelse
                        </div>

                        @if($notifications->hasPages())
                        <div class="d-flex justify-content-center mt-3">
                            {{ $notifications->links() }}
                        </div>
                        @endif
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

@include('layouts.footer')

<script>
function markAsRead(id) {
    fetch('/notification-markread', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify({ notification_id: id })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    });
}

function markAsUnread(id) {
    fetch('/notification-markunread', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify({ notification_id: id })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    });
}

function markAllAsRead() {
    fetch('/notification-markallread', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        }
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    });
}

function clearAll() {
    if (confirm('{{ __("Delete all notifications? This cannot be undone.") }}')) {
        fetch('/notification-clearall', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
            }
        })
        .then(response => response.json())
        .then(data => {
            if (data.success) {
                location.reload();
            }
        });
    }
}

function deleteNotification(id) {
    if (confirm('{{ __("Delete this notification?") }}')) {
        window.location.href = `/notification-destroy?notification_id=${id}`;
    }
}

// Reinitialize feather icons
feather.replace();
</script>
