@include('layouts.header')

@php
App::setLocale(Auth::user()->lang);
@endphp

<link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <h4>{{ __('Offline Payments Management') }}<span class="badge rounded-pill badge-light-warning ms-2">{{ $pendingCount }}</span></h4>
        </div>
        <div class="content-body">
            <!-- Statistics Cards -->
            <div class="row">
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h2 class="fw-bolder">{{ $pendingCount }}</h2>
                                    <p class="card-text">{{ __('Pending') }}</p>
                                </div>
                                <div class="avatar bg-light-warning p-50 mb-0">
                                    <div class="avatar-content">
                                        <i data-feather="clock" class="font-medium-5"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h2 class="fw-bolder">{{ $approvedCount }}</h2>
                                    <p class="card-text">{{ __('Approved') }}</p>
                                </div>
                                <div class="avatar bg-light-success p-50 mb-0">
                                    <div class="avatar-content">
                                        <i data-feather="check-circle" class="font-medium-5"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h2 class="fw-bolder">{{ $rejectedCount }}</h2>
                                    <p class="card-text">{{ __('Rejected') }}</p>
                                </div>
                                <div class="avatar bg-light-danger p-50 mb-0">
                                    <div class="avatar-content">
                                        <i data-feather="x-circle" class="font-medium-5"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-3 col-sm-6 col-12 mb-2">
                    <div class="card">
                        <div class="card-body">
                            <div class="d-flex justify-content-between">
                                <div>
                                    <h2 class="fw-bolder">{{ number_format($totalAmount, 2) }}</h2>
                                    <p class="card-text">{{ __('Total Amount') }}</p>
                                </div>
                                <div class="avatar bg-light-primary p-50 mb-0">
                                    <div class="avatar-content">
                                        <i data-feather="dollar-sign" class="font-medium-5"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Offline Payments List -->
            <section class="app-offline-payment-list">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive pt-0">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>{{ __('ID') }}</th>
                                        <th>{{ __('User') }}</th>
                                        <th>{{ __('Amount') }}</th>
                                        <th>{{ __('Reference') }}</th>
                                        <th>{{ __('Proof') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Date') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($payments as $payment)
                                    <tr>
                                        <td>{{ $payment->id }}</td>
                                        <td>
                                            <a href="{{ route('user.show', ['user_id' => $payment->user_id]) }}">
                                                {{ $payment->user->name ?? 'N/A' }}<br>
                                                <small class="text-muted">{{ $payment->user->email ?? '' }}</small>
                                            </a>
                                        </td>
                                        <td>
                                            @php
                                                // Get requested amount from data field for pending payments
                                                $displayAmount = $payment->amount;
                                                if ($payment->gateway_status === 'pending' && $payment->data) {
                                                    $paymentData = is_array($payment->data) ? $payment->data : json_decode($payment->data, true);
                                                    $displayAmount = $paymentData['requested_amount'] ?? $payment->amount;
                                                }
                                            @endphp
                                            <span class="badge badge-light-primary">
                                                {{ number_format($displayAmount, 2) }}
                                            </span>
                                        </td>
                                        <td>
                                            <small>{{ $payment->gateway_reference }}</small>
                                        </td>
                                        <td>
                                            @if($payment->proof_of_payment)
                                                <a href="{{ Storage::url($payment->proof_of_payment) }}" target="_blank" class="btn btn-sm btn-outline-primary">
                                                    <i data-feather="eye" class="me-0"></i> {{ __('View') }}
                                                </a>
                                            @else
                                                <span class="text-muted">{{ __('No proof') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @php
                                                $statusColors = [
                                                    'pending' => 'warning',
                                                    'success' => 'success',
                                                    'approved' => 'success',
                                                    'rejected' => 'danger',
                                                    'failed' => 'danger'
                                                ];
                                                $color = $statusColors[$payment->gateway_status] ?? 'secondary';
                                            @endphp
                                            <span class="badge bg-{{ $color }}">{{ ucfirst($payment->gateway_status) }}</span>
                                        </td>
                                        <td>
                                            <small>{{ $payment->created_at->format('Y-m-d H:i') }}</small>
                                        </td>
                                        <td>
                                            @if($payment->gateway_status === 'pending')
                                                <button class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#approve-{{ $payment->id }}">
                                                    <i data-feather="check" class="me-0"></i> {{ __('Approve') }}
                                                </button>
                                                <button class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#reject-{{ $payment->id }}">
                                                    <i data-feather="x" class="me-0"></i> {{ __('Reject') }}
                                                </button>
                                            @else
                                                <span class="badge bg-secondary">{{ __('Processed') }}</span>
                                            @endif
                                        </td>
                                    </tr>

                                    <!-- Approve Modal -->
                                    <div class="modal fade modal-success text-start" id="approve-{{ $payment->id }}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">{{ __('Approve Payment') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    @php
                                                        // Get requested amount for modal
                                                        $modalAmount = $payment->amount;
                                                        if ($payment->gateway_status === 'pending' && $payment->data) {
                                                            $modalData = is_array($payment->data) ? $payment->data : json_decode($payment->data, true);
                                                            $modalAmount = $modalData['requested_amount'] ?? $payment->amount;
                                                        }
                                                    @endphp
                                                    {{ __('Are you sure you want to approve this payment?') }}<br><br>
                                                    <strong>{{ __('User') }}:</strong> {{ $payment->user->name ?? 'N/A' }}<br>
                                                    <strong>{{ __('Amount') }}:</strong> {{ number_format($modalAmount, 2) }}<br>
                                                    <strong>{{ __('Reference') }}:</strong> {{ $payment->gateway_reference }}<br><br>
                                                    <span class="text-success">{{ __('The amount will be added to the user\'s wallet balance.') }}</span>
                                                </div>
                                                <div class="modal-footer">
                                                    <form action="{{ route('transaction.approveOffline', ['transaction_id' => $payment->id]) }}" method="POST">
                                                        @csrf
                                                        <button type="submit" class="btn btn-success">{{ __('Approve') }}</button>
                                                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- Reject Modal -->
                                    <div class="modal fade modal-danger text-start" id="reject-{{ $payment->id }}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title">{{ __('Reject Payment') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <form action="{{ route('transaction.rejectOffline', ['transaction_id' => $payment->id]) }}" method="POST">
                                                    @csrf
                                                    <div class="modal-body">
                                                        @php
                                                            // Get requested amount for reject modal
                                                            $rejectAmount = $payment->amount;
                                                            if ($payment->gateway_status === 'pending' && $payment->data) {
                                                                $rejectData = is_array($payment->data) ? $payment->data : json_decode($payment->data, true);
                                                                $rejectAmount = $rejectData['requested_amount'] ?? $payment->amount;
                                                            }
                                                        @endphp
                                                        {{ __('Are you sure you want to reject this payment?') }}<br><br>
                                                        <strong>{{ __('User') }}:</strong> {{ $payment->user->name ?? 'N/A' }}<br>
                                                        <strong>{{ __('Amount') }}:</strong> {{ number_format($rejectAmount, 2) }}<br>
                                                        <strong>{{ __('Reference') }}:</strong> {{ $payment->gateway_reference }}<br><br>
                                                        
                                                        <div class="mb-1">
                                                            <label class="form-label" for="reason">{{ __('Reason for Rejection') }}</label>
                                                            <textarea name="reason" class="form-control" rows="3" placeholder="{{ __('Optional: Provide a reason...') }}"></textarea>
                                                        </div>
                                                        
                                                        <span class="text-danger">{{ __('This action cannot be undone.') }}</span>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="submit" class="btn btn-danger">{{ __('Reject') }}</button>
                                                        <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
    $(document).ready(function () {
        $('#tbl-bootstr').DataTable({
            order: [[0, 'desc']]
        });
    });        
</script>

@include('layouts.footer')
