@include('layouts.header')

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <h4>{{ __('Outbox list') }}<span class="badge rounded-pill badge-light-secondary">{{$allCount}}</span></h4>
        </div>
        <div class="content-body">
            <!-- Search Jumbotron -->
            <section id="kb-search">
                <div class="row">
                    <div class="col-12">
                        <div class="card search-bg text-center" style="background-image: url('app-assets/images/banner/banner.png')">
                            <div class="card-body">
                                <form class="kb-search-input">
                                    <div class="input-group input-group-merge">
                                        <span class="input-group-text"><i data-feather="search"></i></span>
                                        <input type="text" class="form-control" id="searchbar" placeholder="{{ __('Name') }}/{{ __('Phone') }}/{{ __('Message') }}" />

                                        @if(!$listAll)
                                        <button type="button" class="btn btn-sm btn-info float-end" data-bs-toggle="modal" data-bs-target="#resendFailed">
                                            <i data-feather="send" class="me-0"></i> {{ strtoupper(__('Resend failed')) }} ({{$failedCount}})
                                        </button>
                                        <!-- Modal resendFailed-->
                                        <div class="modal fade modal-info text-start" id="resendFailed" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="myModalLabel120">{{ __('Resend confirmation') }}</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        {{ __('Are you sure you want to resend?') }} <br>
                                                        {{ __('This will change the FAILED status to PENDING') }} <br>
                                                        {{ __('The outbox will be sent on next crob job schedule') }}
                                                    </div>
                                                    <div class="modal-footer">
                                                    <a class="btn btn-sm btn-info" href="{{ route('outbox.resendFailed', ['user_id' => Auth::user()->id, 'status' => 'PENDING']) }}">{{ __('Resend') }}</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <button type="button" class="btn btn-sm btn-primary float-end dropdown-toggle" id="filterButton" data-bs-toggle="dropdown" aria-expanded="false">
                                            <i data-feather="filter" class="me-0"></i> {{ strtoupper(__('Filter')) }}
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="filterButton">
                                            <a class="dropdown-item" href="{{ route('outbox.filterStatus', ['status' => 'PENDING', 'pendingCount' => $pendingCount, 'sentCount' => $sentCount, 'failedCount' => $failedCount]) }}"><i data-feather="filter" class="me-0"></i> {{__('Filter PENDING')}} ({{$pendingCount}})</a>
                                            <a class="dropdown-item" href="{{ route('outbox.filterStatus', ['status' => 'SENT', 'pendingCount' => $pendingCount, 'sentCount' => $sentCount, 'failedCount' => $failedCount]) }}"><i data-feather="filter" class="me-0"></i> {{__('Filter SENT')}} ({{$sentCount}})</a>
                                            <a class="dropdown-item" href="{{ route('outbox.filterStatus', ['status' => 'FAILED', 'pendingCount' => $pendingCount, 'sentCount' => $sentCount, 'failedCount' => $failedCount]) }}"><i data-feather="filter" class="me-0"></i> {{__('Filter FAILED')}} ({{$failedCount}})</a>
                                        </div>
                                        
                                        <button type="button" class="btn btn-sm btn-success float-end dropdown-toggle" id="exportButton" data-bs-toggle="dropdown" aria-expanded="false">
                                            <i data-feather="filter" class="me-0"></i> {{ strtoupper(__('Export')) }}
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="exportButton">
                                            <a class="dropdown-item" href="{{ route('outbox.export', ['status' => 'PENDING']) }}"><i data-feather="external-link" class="me-0"></i> {{__('Export PENDING')}} ({{$pendingCount}})</a>
                                            <a class="dropdown-item" href="{{ route('outbox.export', ['status' => 'SENT']) }}"><i data-feather="external-link" class="me-0"></i> {{__('Export SENT')}} ({{$sentCount}})</a>
                                            <a class="dropdown-item" href="{{ route('outbox.export', ['status' => 'FAILED']) }}"><i data-feather="external-link" class="me-0"></i> {{__('Export FAILED')}} ({{$failedCount}})</a>
                                            <a class="dropdown-item" href="{{ route('outbox.export') }}"><i data-feather="external-link" class="me-0"></i> {{__('Export ALL')}} ({{$allCount}})</a>
                                        </div>
                                        
                                        <button type="button" class="btn btn-sm btn-danger float-end dropdown-toggle" id="trashButton" data-bs-toggle="dropdown" aria-expanded="false">
                                            <i data-feather="trash" class="me-0"></i> {{ strtoupper(__('Delete')) }} ({{$pendingCount}} / {{$sentCount}} / {{$failedCount}} / {{$allCount}})
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="trashButton">
                                            <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroyStatusPENDING"><i data-feather="trash" class="me-0"></i> {{__('Delete PENDING')}} ({{$pendingCount}})</a>
                                            <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroyStatusSENT"><i data-feather="trash" class="me-0"></i> {{__('Delete SENT')}} ({{$sentCount}})</a>
                                            <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroyStatusFAILED"><i data-feather="trash" class="me-0"></i> {{__('Delete FAILED')}} ({{$failedCount}})</a>
                                            <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroyAll"><i data-feather="trash" class="me-0"></i> {{__('Delete ALL')}}  ({{$allCount}})</a>
                                        </div>
                                        
                                        <!-- Modal destroyAll-->
                                        <div class="modal fade modal-danger text-start" id="destroyAll" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        {{ __('Are you sure you want to delete?') }} <br><br>
                                                        <span class="text text-danger"> <b>{{__('ALL')}}</b> </span><br><br>
                                                        {{ __('This process is irreversible') }} <br>
                                                        {{ __('The record(s) will be deleted from the database permanently') }}
                                                    </div>
                                                    <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="{{ route('outbox.destroyAll', ['user_id' => Auth::user()->id]) }}">{{ __('Delete') }}</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Modal destroyStatusFAILED-->
                                        <div class="modal fade modal-danger text-start" id="destroyStatusFAILED" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        {{ __('Are you sure you want to delete?') }} <br><br>
                                                        <span class="text text-danger"> <b>{{__('ALL')}} ({{__('FAILED')}})</b> </span><br><br>
                                                        {{ __('This process is irreversible') }} <br>
                                                        {{ __('The record(s) will be deleted from the database permanently') }}
                                                    </div>
                                                    <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="{{ route('outbox.destroyStatus', ['user_id' => Auth::user()->id, 'status' => 'FAILED']) }}">{{ __('Delete') }}</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Modal destroyStatusSENT-->
                                        <div class="modal fade modal-danger text-start" id="destroyStatusSENT" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        {{ __('Are you sure you want to delete?') }} <br><br>
                                                        <span class="text text-danger"> <b>{{__('ALL')}} ({{__('SENT')}})</b> </span><br><br>
                                                        {{ __('This process is irreversible') }} <br>
                                                        {{ __('The record(s) will be deleted from the database permanently') }}
                                                    </div>
                                                    <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="{{ route('outbox.destroyStatus', ['user_id' => Auth::user()->id, 'status' => 'SENT']) }}">{{ __('Delete') }}</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Modal destroyStatusPENDING-->
                                        <div class="modal fade modal-danger text-start" id="destroyStatusPENDING" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        {{ __('Are you sure you want to delete?') }} <br><br>
                                                        <span class="text text-danger"> <b>{{__('ALL')}} ({{__('PENDING')}})</b> </span><br><br>
                                                        {{ __('This process is irreversible') }} <br>
                                                        {{ __('The record(s) will be deleted from the database permanently') }}
                                                    </div>
                                                    <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="{{ route('outbox.destroyStatus', ['user_id' => Auth::user()->id, 'status' => 'PENDING']) }}">{{ __('Delete') }}</a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        @endif
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--/ Search Jumbotron -->
            <!-- job list start -->
            <section class="app-job-list">
                <!-- list and filter start -->
                <div class="card">
                    <div class="table-responsive pt-0 kb-search-content-info match-height">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th> {{ __('Job ID') }} </th>
                                    <th> {{ __('Sender') }} </th>
                                    <th> {{ __('Created') }} </th>
                                    <th> {{ __('Status') }} </th>
                                    <th> {{ __('Actions') }} </th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($jobs as $job)
                                <tr class="kb-search-content">
                                    <td hidden>{{ $job->msgtext }}</td>
                                    <td hidden>{{ $job->rec_name }}</td>
                                    <td hidden>{{ $job->receiver }}</td>
                                    <td hidden>{{ $job->sender }}</td>
                                    <td><a href="{{ route('outbox.show', ['job_id' => $job->job_id]) }}">
                                    {{ $job->job_id }}</a>
                                    </td>
                                    <td>{{ $job->sender }}</td>
                                    <td><a href="{{ route('outbox.show', ['job_id' => $job->job_id]) }}">
                                        <span class="badge rounded-pill badge-light-success">{{ Carbon\Carbon::parse((int)$job->job_id)->timezone(config('app.timezone')) }}</span></a>
                                    </td>
                                    <td><a href="{{ route('outbox.show', ['job_id' => $job->job_id]) }}">
                                    @php
                                    $job->pause = $job->where([['job_id', '=', $job->job_id],['status', '=', 'PAUSED']])->count();
                                    $job->pending = $job->where([['job_id', '=', $job->job_id],['status', '=', 'PENDING']])->count();
                                    $job->sending = $job->where([['job_id', '=', $job->job_id],['status', '=', 'SENDING']])->count();
                                    $job->sent = $job->where([['job_id', '=', $job->job_id],['status', '=', 'SENT']])->count();
                                    $job->failed = $job->where([['job_id', '=', $job->job_id],['status', 'like', 'FAILED%']])->count();
                                    @endphp
                                    @if($job->pause > 0)
                                    <span class="badge rounded-pill badge-light-secondary me-1">{{ $job->pause . ' ' . __('PAUSED') }}</span>
                                    @elseif($job->sending > 0)
                                    <span class="badge rounded-pill badge-light-primary me-1">{{ $job->sending . ' ' . __('SENDING') }}</span>
                                    @else
                                    <span class="badge rounded-pill badge-light-warning me-1">{{ $job->pending . ' ' . __('PENDING') }}</span>
                                    @endif
                                    <span class="badge rounded-pill badge-light-success me-1">{{ $job->sent . ' ' . __('SENT') }}</span>
                                    <span class="badge rounded-pill badge-light-danger me-1">{{ $job->failed . ' ' . __('FAILED') }}</span>
                                    <span class="badge rounded-pill badge-light-primary me-1">{{ $job->total . ' ' . __('TOTAL') }}</a>
                                    </td>
                                    <td>
                                        <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton" data-bs-toggle="dropdown" aria-expanded="false">
                                            <i data-feather="command" class="me-0"></i>
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="actionButton">
                                            <a class="dropdown-item" href="{{ route('outbox.show', ['job_id' => $job->job_id]) }}"><i data-feather="eye" class="me-0"></i> {{__('View')}}</a>
                                            @if($job->sending > 0)
                                            <a class="dropdown-item" href="{{ route('outbox.pause', ['job_id' => $job->job_id]) }}"><i data-feather="pause" class="me-0"></i> {{__('Pause')}}</a>
                                            @endif
                                            @if($job->pause > 0 || $job->sending > 0)
                                            <a class="dropdown-item" href="{{ route('outbox.resume', ['job_id' => $job->job_id]) }}"><i data-feather="pause" class="me-0"></i> {{__('Stop')}} <i data-feather="play" class="me-0"></i> {{__('Resume')}}</a>
                                            @endif
                                            @if ($job->failed > 0)
                                            <a class="dropdown-item" href="{{ route('outbox.resendFailed', ['job_id' => $job->job_id]) }}"><i data-feather="send" class="me-0"></i> {{__('Resend failed')}}</a>
                                            @endif
                                            <div class="dropdown-divider"></div>
                                            <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-{{$job->job_id * 1000}}"><i data-feather="trash" class="me-0"></i> {{__('Delete')}}</a>
                                        </div>
                                    </td>
                                </tr>
                                <!-- Delete Modal -->
                                <div class="modal fade modal-danger text-start" id="destroy-{{$job->job_id * 1000}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                {{ __('Are you sure you want to delete?') }} <br><br>
                                                <span class="text text-danger"> <b>{{ $job->job_id }}</b> </span><br><br>
                                                {{ __('This process is irreversible') }} <br>
                                                {{ __('The record(s) will be deleted from the database permanently') }}
                                            </div>
                                            <div class="modal-footer">
                                            <a class="btn btn-sm btn-danger" href="{{ route('outbox.destroyJob', ['job_id' => $job->job_id]) }}">{{ __('Delete') }}</a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- list and filter end -->
            </section>
            <!-- jobs list ends -->
            <div class="row">
                <div class="col-md-12">
                    {{ $jobs->links() }}
                </div>
            </div>
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
<!-- BEGIN Vendor JS-->

@include('layouts.footer')