@include('layouts.header')
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="card-body">
            <button type="button" class="btn btn-sm btn-danger float-end dropdown-toggle" id="trashButton" data-bs-toggle="dropdown" aria-expanded="false">
                <i data-feather="trash" class="me-0"></i> {{ strtoupper(__('Delete')) }} ({{$pendingCount}} / {{$sentCount}} / {{$failedCount}})
            </button>
            <div class="dropdown-menu" aria-labelledby="trashButton">
                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroyStatusPENDING"><i data-feather="trash" class="me-0"></i> {{__('Delete PENDING')}} ({{$pendingCount}})</a>
                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroyStatusSENT"><i data-feather="trash" class="me-0"></i> {{__('Delete SENT')}} ({{$sentCount}})</a>
                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroyStatusFAILED"><i data-feather="trash" class="me-0"></i> {{__('Delete FAILED')}} ({{$failedCount}})</a>
            </div>
            
            <button class="btn btn-sm btn-primary float-end dropdown-toggle" type="button" id="filterButton" data-bs-toggle="dropdown" aria-expanded="false">
                <i data-feather="filter" class="me-0"></i> {{ strtoupper(__('Filter')) }}
            </button>
            <div class="dropdown-menu" aria-labelledby="filterButton">
                <a class="dropdown-item" href="{{ route('outbox.filterStatus', ['job_id' => $job_id, 'status' => 'PENDING', 'pendingCount' => $pendingCount, 'sentCount' => $sentCount, 'failedCount' => $failedCount]) }}"><i data-feather="filter" class="me-0"></i> {{__('Filter PENDING')}}  ({{$pendingCount}})</a>
                <a class="dropdown-item" href="{{ route('outbox.filterStatus', ['job_id' => $job_id, 'status' => 'SENT', 'pendingCount' => $pendingCount, 'sentCount' => $sentCount, 'failedCount' => $failedCount]) }}"><i data-feather="filter" class="me-0"></i> {{__('Filter SENT')}}  ({{$sentCount}})</a>
                <a class="dropdown-item" href="{{ route('outbox.filterStatus', ['job_id' => $job_id, 'status' => 'FAILED', 'pendingCount' => $pendingCount, 'sentCount' => $sentCount, 'failedCount' => $failedCount]) }}"><i data-feather="filter" class="me-0"></i> {{__('Filter FAILED')}}  ({{$failedCount}})</a>
            </div>

            <button class="btn btn-sm btn-success float-end dropdown-toggle" type="button" id="exportButton" data-bs-toggle="dropdown" aria-expanded="false">
                <i data-feather="external-link" class="me-0"></i> {{ strtoupper(__('Export')) }}
            </button>
            <div class="dropdown-menu" aria-labelledby="exportButton">
                <a class="dropdown-item" href="{{ route('outbox.export', ['job_id' => $job_id, 'status' => 'PENDING']) }}"><i data-feather="external-link" class="me-0"></i> {{__('Export PENDING')}}  ({{$pendingCount}})</a>
                <a class="dropdown-item" href="{{ route('outbox.export', ['job_id' => $job_id, 'status' => 'SENT']) }}"><i data-feather="external-link" class="me-0"></i> {{__('Export SENT')}}  ({{$sentCount}})</a>
                <a class="dropdown-item" href="{{ route('outbox.export', ['job_id' => $job_id, 'status' => 'FAILED']) }}"><i data-feather="external-link" class="me-0"></i> {{__('Export FAILED')}}  ({{$failedCount}})</a>
            </div>

            <!-- Modal destroyStatusFAILED-->
            <div class="modal fade modal-danger text-start" id="destroyStatusFAILED" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            {{ __('Are you sure you want to delete?') }} <br>
                            {{ __('This process is irreversible') }} <br>
                            {{ __('The record(s) will be deleted from the database permanently') }}
                        </div>
                        <div class="modal-footer">
                        <a class="btn btn-sm btn-danger" href="{{ route('outbox.destroyFilter', ['user_id' => Auth::user()->id, 'job_id' => $job_id, 'status' => 'FAILED', 'pendingCount' => $pendingCount, 'sentCount' => $sentCount, 'failedCount' => $failedCount]) }}">{{ __('Delete') }}</a>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Modal destroyStatusSENT-->
            <div class="modal fade modal-danger text-start" id="destroyStatusSENT" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            {{ __('Are you sure you want to delete?') }} <br>
                            {{ __('This process is irreversible') }} <br>
                            {{ __('The record(s) will be deleted from the database permanently') }}
                        </div>
                        <div class="modal-footer">
                        <a class="btn btn-sm btn-danger" href="{{ route('outbox.destroyFilter', ['user_id' => Auth::user()->id, 'job_id' => $job_id, 'status' => 'SENT', 'pendingCount' => $pendingCount, 'sentCount' => $sentCount, 'failedCount' => $failedCount]) }}">{{ __('Delete') }}</a>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Modal destroyStatusPENDING-->
            <div class="modal fade modal-danger text-start" id="destroyStatusPENDING" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                <div class="modal-dialog modal-dialog-centered">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                        <div class="modal-body">
                            {{ __('Are you sure you want to delete?') }} <br>
                            {{ __('This process is irreversible') }} <br>
                            {{ __('The record(s) will be deleted from the database permanently') }}
                        </div>
                        <div class="modal-footer">
                        <a class="btn btn-sm btn-danger" href="{{ route('outbox.destroyFilter', ['user_id' => Auth::user()->id, 'job_id' => $job_id, 'status' => 'PENDING', 'pendingCount' => $pendingCount, 'sentCount' => $sentCount, 'failedCount' => $failedCount]) }}">{{ __('Delete') }}</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="content-header row">
            <h4>{{ __('Send message job#') . ' ' . $job_id }}</h4>
        </div>
        <div class="content-body">
            <!-- job list start -->
            <section class="app-job-list">
                <!-- list and filter start -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive table-responsive">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead>
                                    <tr>
                                        <th> {{ __('Sender') }} </th>
                                        <th> {{ __('Receiver') }} </th>
                                        <th> {{ __('Message text') }} </th>
                                        <th> {{ __('Media file') }} </th>
                                        <th> {{ __('Button') }} </th>
                                        <th> {{ __('Schedule') }} </th>
                                        <th> {{ __('Status') }} </th>
                                        <th> {{ __('Actions') }} </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($outboxes as $outbox)
                                    <tr>
                                        <td>
                                        {{ $outbox->sender }}
                                        </td>
                                        <td>
                                        {{ $outbox->receiver }}
                                        </td>
                                        <td>
                                        <span hidden>{{ $outbox->msgtext }}</span>
                                        {{ substr($outbox->msgtext, 0, 100) . '...' }}
                                        </td>
                                        <td>
                                        @php($arrMediaurl=explode('/', $outbox->mediaurl))
                                        {{ end($arrMediaurl) }}</a>
                                        </td>
                                        <td>
                                        {{ (strpos($outbox->data,'"replyButtons":[{"') > -1 || strpos($outbox->data,'"templateButtons":[{"') > -1 || strpos($outbox->data,'"listButtons":[{"') > -1 ? 'YES' : 'NO') }}
                                        </td>
                                        <td>
                                        <span class="badge rounded-pill badge-light-success">{{ Carbon\Carbon::parse($outbox->schedule)->timezone(config('app.timezone')) }}</span>
                                        </td>
                                        <td>
                                        @if ($outbox->status == 'PENDING')
                                            <span class="badge rounded-pill badge-light-warning me-1">{{ $outbox->status }}</span>
                                        @elseif($outbox->status == 'SENT')
                                            <span class="badge rounded-pill badge-light-success me-1">{{ $outbox->status }}</span>
                                        @elseif(str_starts_with($outbox->status, 'FAILED'))
                                            <span class="badge rounded-pill badge-light-danger me-1">{{ $outbox->status }}</span>
                                        @elseif($outbox->status == 'SENDING')
                                            <span class="badge rounded-pill badge-light-primary me-1">{{ $outbox->status }}</span>
                                        @elseif($outbox->status == 'PAUSED')
                                            <span class="badge rounded-pill badge-light-secondary me-1">{{ $outbox->status }}</span>
                                        @endif
                                        </td>
                                        <td>
                                            <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#destroy{{$outbox->id}}">
                                                <i data-feather="trash" class="me-0"></i>
                                            </button>
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy{{$outbox->id}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    {{ __('Are you sure you want to delete?') }} <br>
                                                    {{ __('This process is irreversible') }} <br>
                                                    {{ __('The record(s) will be deleted from the database permanently') }}
                                                </div>
                                                <div class="modal-footer">
                                                <a class="btn btn-sm btn-danger" href="{{ route('outbox.destroyObx', ['outbox_id' => $outbox->id]) }}">{{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- list and filter end -->
            </section>
            <!-- jobs list ends -->
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
    $(document).ready(function () {
        $('#tbl-bootstr').DataTable();
    });        
</script>

@include('layouts.footer') 
