@include('layouts.header')

@php
App::setLocale(Auth::user()->lang);
@endphp

<link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="card-body">
            <button type="button" class="btn btn-primary float-end" data-bs-toggle="modal" data-bs-target="#addNew">{{ __('Add new package') }}</button>
        </div>
        <div class="content-header row">
            <h4>{{ __('Packages list') }}<span class="badge rounded-pill badge-light-secondary">{{DB::table('packages')->count()}}</span></h4>
        </div>
        <div class="content-body">
            <!-- packages list start -->
            <section class="app-package-list">
                <!-- list and filter start -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive pt-0">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>{{ __('Name') }}</th>
                                        <th>{{ __('Description') }}</th>
                                        <th>{{ __('Monthly') }}</th>
                                        <!-- <th>{{ __('Yearly') }}</th> -->
                                        <th>{{ __('Outgoing') }}</th>
                                        <th>{{ __('Devices') }}</th>
                                        <th>{{ __('Autoreply Keyword')}}</th>
                                        <th>{{ __('Phonebooks') }}</th>
                                        <th>{{ __('Global senders') }}</th>
                                        <th>{{ __('Webhook') }}</th>
                                        <th>{{ __('Footer') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($packages as $package)
                                    <tr>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$package->id}}" data-bs-toggle="modal">
                                        <span class="badge rounded-pill badge-light-{{$package->hidden ? 'danger' : 'primary'}} me-1">{{ $package->name }}</span></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$package->id}}" data-bs-toggle="modal">
                                        {{ $package->description }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$package->id}}" data-bs-toggle="modal">
                                        {{ number_format($package->rate_monthly,\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator')) }}</a>
                                        </td>
                                        <!-- <td><a href="javascript:;" data-bs-target="#edit-{{$package->id}}" data-bs-toggle="modal">
                                        {{ $package->rate_yearly }}</a>
                                        </td> -->
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$package->id}}" data-bs-toggle="modal">
                                        {{ $package->max_outgoing < 0 ? __('Unlimited') : number_format($package->max_outgoing,0,\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator')) }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$package->id}}" data-bs-toggle="modal">
                                        {{ $package->max_device < 0 ? __('Unlimited') : $package->max_device }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$package->id}}" data-bs-toggle="modal">
                                        {{ $package->max_autoreply < 0 ? __('Unlimited') : $package->max_autoreply }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$package->id}}" data-bs-toggle="modal">
                                        {{ $package->max_phonebook < 0 ? __('Unlimited') : $package->max_phonebook }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$package->id}}" data-bs-toggle="modal">
                                        <span class="badge rounded-pill badge-light-{{$package->global_senders?'success':'danger'}} me-1">{{ $package->global_senders ? __('YES') : __('NO') }}</span></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$package->id}}" data-bs-toggle="modal">
                                        <span class="badge rounded-pill badge-light-{{$package->webhook?'success':'danger'}} me-1">{{ $package->webhook ? __('YES') : __('NO') }}</span></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$package->id}}" data-bs-toggle="modal">
                                        <span class="badge rounded-pill badge-light-{{$package->footer?'success':'danger'}} me-1">{{ $package->footer ? __('YES') : __('NO') }}</span></a>
                                        </td>
                                        <td>
                                            @if($package->id > 2)
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton-{{$package->id}}" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton-{{$package->id}}">
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit-{{$package->id}}"><i data-feather="edit" class="me-0"></i> {{__('Edit')}}</a>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-{{$package->id}}"><i data-feather="trash" class="me-0"></i> {{__('Delete')}}</a>
                                            </div>
                                            @else
                                            <span class="badge bg-secondary">{{ __('System') }}</span>
                                            @endif
                                        </td>
                                    </tr>
                                    @if($package->id > 2)
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-{{$package->id}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    {{ __('Are you sure you want to delete?') }} <br><br>
                                                    <span class="text text-danger"> <b>{{ $package->name }}</b> </span><br><br>
                                                    {{ __('This process is irreversible') }} <br>
                                                    {{ __('The record(s) will be deleted from the database permanently') }}
                                                </div>
                                                <div class="modal-footer">
                                                <a class="btn btn-sm btn-danger" href="{{ route('package.destroy', ['package_id' => $package->id]) }}">{{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                    <!-- Edit Package Modal -->
                                    <div class="modal fade" id="edit-{{$package->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-package">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1">{{ __('Edit package form') }}</h1>
                                                    </div>
                                                    <form action="{{ route('package.update') }}" method="POST" id="editPackageForm" class="row gy-1 pt-75">
                                                        @csrf
                                                        <div class="row">
                                                        <div class="col-12 col-md-6">
                                                            <input type="hidden"  name="package_id" value="{{ $package->id }}" />
                                                            <label class="form-label" for="name">{{ __('Package name') }}</label>
                                                            <input type="text" name="name" class="form-control" value="{{ $package->name }}" placeholder="{{ __('Package name') }}" required />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="description">{{ __('Description') }}</label>
                                                            <input type="text" name="description" class="form-control" value="{{ $package->description }}" placeholder="{{ __('Description') }}" required />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="rate_monthly">{{ __('Price monthly') }}</label>
                                                            <input type="number" name="rate_monthly" step="0.01" class="form-control" value="{{ $package->rate_monthly }}" placeholder="{{ __('Price monthly') }}" required />
                                                        </div>
                                                        <!-- <div class="col-12 col-md-6">
                                                            <label class="form-label" for="rate_yearly">{{ __('Price yearly') }}</label>
                                                            <input type="number" name="rate_yearly" step="0.01" class="form-control" value="{{ $package->rate_yearly }}" placeholder="{{ __('Price yearly') }}" {{ ($package->name === 'super' ? 'readonly' : '') }} required />
                                                        </div> -->
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="max_outgoing">{{ __('Max Outgoing') }}</label>
                                                            <label class="form-label text-warning">(-1 = {{ __('Unlimited') }})</label>
                                                            <input type="number" name="max_outgoing" class="form-control" value="{{ $package->max_outgoing }}" placeholder="{{ __('Max Outgoing') }}" required />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="max_device">{{ __('Max Device') }}</label>
                                                            <label class="form-label text-warning">(-1 = {{ __('Unlimited') }})</label>
                                                            <input type="number" name="max_device" class="form-control" value="{{ $package->max_device }}" placeholder="{{ __('Max Device') }}" required />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="max_autoreply">{{ __('Max Autoreply Keyword') }}</label>
                                                            <label class="form-label text-warning">(-1 = {{ __('Unlimited') }})</label>
                                                            <input type="number" name="max_autoreply" class="form-control" value="{{ $package->max_autoreply }}" placeholder="{{ __('Max Autoreply Keyword') }}" required />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="max_phonebook">{{ __('Max Phonebook') }}</label>
                                                            <label class="form-label text-warning">(-1 = {{ __('Unlimited') }})</label>
                                                            <input type="number" name="max_phonebook" class="form-control" value="{{ $package->max_phonebook }}" placeholder="{{ __('Max Phonebook') }}" required />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="global_senders">{{ __('Global senders') }}</label>
                                                            <select name="global_senders" class="form-select">
                                                                <option value="0" {{ !$package->global_senders ? 'selected' : '' }}>{{ __('Global senders Disabled') }}</option>
                                                                <option value="1" {{ $package->global_senders ? 'selected' : '' }}>{{ __('Global senders Enabled') }}</option>
                                                            </select>
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="webhook">{{ __('Webhook') }}</label>
                                                            <select name="webhook" class="form-select">
                                                                <option value="0" {{ !$package->webhook ? 'selected' : '' }}>{{ __('Webhook Disabled') }}</option>
                                                                <option value="1" {{ $package->webhook ? 'selected' : '' }}>{{ __('Webhook Enabled') }}</option>
                                                            </select>
                                                            <label class="form-label text-warning">{{ __('_MsgWebhookWarning') }}</label>
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="hidden">{{ __('Hidden') }}</label>
                                                            <select name="hidden" class="form-select">
                                                                <option value="0" {{ !$package->hidden ? 'selected' : '' }}>{{ __('NO') }}</option>
                                                                <option value="1" {{ $package->hidden ? 'selected' : '' }}>{{ __('YES') }}</option>
                                                            </select>
                                                        </div>
                                                        <div class="col-12">
                                                            <label class="form-label" for="footer">{{ __('Footer Message') }}</label>
                                                            <textarea class="form-control" name="footer" rows="5">{{$package->footer}}</textarea>
                                                        </div>
                                                        <div class="col-12 text-center mt-2 pt-50">
                                                            <button type="submit" class="btn btn-primary me-1">{{ __('Submit') }}</button>
                                                            <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Cancel') }}</button>
                                                        </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Edit Package Modal -->
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- Modal to add new package starts-->
                        <div class="modal modal-slide-in new-package-modal fade" id="addNew">
                            <div class="modal-dialog">
                                <form action="{{ route('package.store') }}" method="POST"  class="add-new-package modal-content pt-0">
                                @csrf
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
                                    <div class="modal-header mb-1">
                                        <h5 class="modal-title" id="exampleModalLabel">{{ __('Add new package') }}</h5>
                                    </div>
                                    <div class="modal-body flex-grow-1">
                                        <div class="mb-1">
                                            <label class="form-label" for="name">{{ __('Package name') }}</label>
                                            <input type="text" name="name" class="form-control" placeholder="{{ __('Package name') }}" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="description">{{ __('Description') }}</label>
                                            <input type="text" name="description" class="form-control" placeholder="{{ __('Description') }}" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="rate_monthly">{{ __('Price monthly') }}</label>
                                            <input type="number" name="rate_monthly" step="0.01" class="form-control" placeholder="{{ __('Price monthly') }}" required />
                                        </div>
                                        <!-- <div class="mb-1">
                                            <label class="form-label" for="rate_yearly">{{ __('Price yearly') }}</label>
                                            <input type="number" name="rate_yearly" step="0.01" class="form-control" placeholder="{{ __('Price yearly') }}" required />
                                        </div> -->
                                        <div class="mb-1">
                                            <label class="form-label" for="max_outgoing">{{ __('Max Outgoing') }}</label>
                                            <label class="form-label text-warning">(-1 = {{ __('Unlimited') }})</label>
                                            <input type="number" name="max_outgoing"class="form-control" placeholder="{{ __('Max Outgoing') }}" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="max_device">{{ __('Max Device') }}</label>
                                            <label class="form-label text-warning">(-1 = {{ __('Unlimited') }})</label>
                                            <input type="number" name="max_device" class="form-control" placeholder="{{ __('Max Device') }}" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="max_autoreply">{{ __('Max Autoreply Keyword') }}</label>
                                            <label class="form-label text-warning">(-1 = {{ __('Unlimited') }})</label>
                                            <input type="number" name="max_autoreply" class="form-control" placeholder="{{ __('Max Autoreply Keyword') }}" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="max_phonebook">{{ __('Max Phonebook') }}</label>
                                            <label class="form-label text-warning">(-1 = {{ __('Unlimited') }})</label>
                                            <input type="number" name="max_phonebook" class="form-control" placeholder="{{ __('Max Phonebook') }}" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="global_senders">{{ __('Global senders') }}</label>
                                            <select name="global_senders" class="form-select">
                                                <option value="0" selected>{{ __('Global senders Disabled') }}</option>
                                                <option value="1">{{ __('Global senders Enabled') }}</option>
                                            </select>
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="webhook">{{ __('Webhook') }}</label>
                                            <select name="webhook" class="form-select">
                                                <option value="0" selected>{{ __('Webhook Disabled') }}</option>
                                                <option value="1">{{ __('Webhook Enabled') }}</option>
                                            </select>
                                            <label class="form-label text-warning">{{ __('_MsgWebhookWarning') }}</label>
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="footer">{{ __('Footer Message') }}</label>
                                            <textarea class="form-control" name="footer" rows="5"></textarea>
                                        </div>
                                        <button type="submit" class="btn btn-primary me-1 data-submit">{{ __('Submit') }}</button>
                                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- Modal to add new package Ends-->
                    </div>
                </div>
                <!-- list and filter end -->
            </section>
            <!-- packages list ends -->
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
    $(document).ready(function () {
        $('#tbl-bootstr').DataTable();
    });        
</script>

@include('layouts.footer')
