@include('layouts.header')
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="card-body">
            <button type="button" class="btn btn-sm btn-warning float-end" data-bs-toggle="modal" data-bs-target="#scrapeGoogleMap"><i data-feather="map"></i> {{ strtoupper(__('Scrape G-Maps Business')) }}</button>
            <a class="btn btn-sm btn-success float-end" href="{{ route('phonebook.export', ['listAll' => $listAll]) }}"><i data-feather="external-link"></i> {{ strtoupper(__('Export')) }}</a>
            @if(!$listAll)
            <button type="button" class="btn btn-sm btn-primary float-end" data-bs-toggle="modal" data-bs-target="#addNew"><i data-feather="plus-square"></i> {{ strtoupper(__('Add new')) }}</button>
            @endif
        </div>
        <div class="content-header row">
            <h4>{{ __('Phonebooks list') }}<span class="badge rounded-pill badge-light-secondary">{{DB::table('phonebooks')->where('user_id',Auth::user()->id)->count()}}</span></h4>
        </div>
        <div class="content-body">
            <!-- phonebooks list start -->
            <section class="app-phonebook-list">
                <!-- list and filter start -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive table-responsive">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th hidden></th>
                                        @if($listAll)<th>{{ __('Username') }}</th>@endif
                                        <th>{{ __('Phonebook name') }}</th>
                                        <th>{{ __('Phonebook data') }}</th>
                                        <th>{{ __('Total') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($phonebooks as $phonebook)
                                    <tr>
                                        <td hidden>{{ $phonebook->id }}</td>
                                        @if($listAll)<td>{{ $phonebook->user->name }}</td>@endif
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$phonebook->id}}" data-bs-toggle="modal">
                                        {{ $phonebook->name }}</a>
                                        </td>
                                        <td><a href="{{ route('phonebook.show', ['phonebook_id' => $phonebook->id]) }}">
                                        <span hidden>{{ $phonebook->data }}</span>
                                        {{ str_replace(['"','[',']','id:','name:','phone:'], [''], substr($phonebook->data, 0, 100)) . '...' }}
                                        </a>
                                        </td>
                                        <td>{{ count(json_decode($phonebook->data)) }}</td>
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton">
                                                <a class="dropdown-item" href="{{ route('phonebook.show', ['phonebook_id' => $phonebook->id]) }}"><i data-feather="eye" class="me-0"></i> {{__('View')}}</a>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit-{{$phonebook->id}}"><i data-feather="edit" class="me-0"></i> {{__('Edit')}}</a>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#check-{{$phonebook->id}}"><i data-feather="check-square" class="me-0"></i> {{__('Check')}}</a>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-{{$phonebook->id}}"><i data-feather="trash" class="me-0"></i> {{__('Delete')}}</a>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Check Modal -->
                                    <div class="modal fade modal-primary text-start" id="check-{{$phonebook->id}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120">{{ __('Check confirmation') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    {{ __('Are you sure you want to check?') }} <br><br>
                                                    <span class="text text-primary"> <b>{{ $phonebook->name }}</b> </span><br><br>
                                                    {{ __('This process will check if the contact number is on Whatsapp or not') }} <br>
                                                    {{ __('If contact number is not registered with whatsapp, it will be deleted automatically') }} <br><br>
                                                    {{ __('If you have a lot of contacts in this phonebook') }} <br>
                                                    {{ __('This process will take a long time to complete') }}
                                                </div>
                                                <div class="modal-footer">
                                                    <a href="{{route('phonebook.check', ['phonebook_id' => $phonebook->id, 'user_id' => $phonebook->user_id])}}" onclick="this.disabled=true; this.innerHTML='Please wait... This window will refresh in 20 seconds. It will be running on the background afterward.'; setTimeout(()=>{window.location.reload();}, 20_000)" class="btn btn-sm btn-primary">{{ __('Check') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-{{$phonebook->id}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    {{ __('Are you sure you want to delete?') }} <br><br>
                                                    <span class="text text-danger"> <b>{{ $phonebook->name }}</b> </span><br><br>
                                                    {{ __('This process is irreversible') }} <br>
                                                    {{ __('The record(s) will be deleted from the database permanently') }}
                                                </div>
                                                <div class="modal-footer">
                                                <a class="btn btn-sm btn-danger" href="{{ route('phonebook.destroy', ['phonebook_id' => $phonebook->id]) }}">{{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Edit Phonebook Modal -->
                                    <div class="modal fade" id="edit-{{$phonebook->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-phonebook">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1">{{ __('Edit phonebook') }}</h1>
                                                    </div>
                                                    <form action="{{ route('phonebook.update') }}" method="POST" id="editPhonebookForm" class="row gy-1 pt-75" enctype="multipart/form-data">
                                                        @csrf
                                                        <div class="row">
                                                        <div class="col-12 col-md-6">
                                                            <input type="hidden"  name="phonebook_id" value="{{ $phonebook->id }}" />
                                                            <label class="form-label" for="name">{{ __('Phonebook name') }}</label>
                                                            <input type="text" name="name" class="form-control" value="{{ $phonebook->name }}" placeholder="{{ __('Phonebook name') }}" required />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="filename">{{ __('Phonebook filename') }}</label>
                                                            <a href="{{ url('/') }}/app-assets/data/sample_phonebook.xlsx">download sample XLSX here
                                                                <img src="{{ url('/') }}/app-assets/images/icons/xls.png" alt="png" height="32">
                                                            </a>
                                                            <input type="file" name="filename" class="form-control" placeholder="{{ __('Upload XLSX file') }}" />
                                                        </div>
                                                        <div class="col-12 text-center mt-2 pt-50">
                                                            <button type="submit" class="btn btn-primary me-1">{{ __('Submit') }}</button>
                                                            <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Cancel') }}</button>
                                                        </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Edit Phonebook Modal -->
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- list and filter end -->
            </section>
            <!-- phonebooks list ends -->
        </div>
    </div>
</div>

<!-- Modal to add new phonebook starts-->
<div class="modal modal-slide-in new-phonebook-modal fade" id="addNew">
    <div class="modal-dialog">
        <form action="{{ route('phonebook.store') }}" method="POST" class="add-new-phonebook modal-content pt-0" enctype="multipart/form-data">
        @csrf
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
            <div class="modal-header mb-1">
                <h5 class="modal-title" id="exampleModalLabel">{{ __('Add new phonebook') }}</h5>
            </div>
            <div class="modal-body flex-grow-1">
                <div class="mb-1">
                    <label class="form-label" for="name">{{ __('Phonebook name') }}</label>
                    <input type="text" name="name" class="form-control" placeholder="{{ __('Phonebook name') }}" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="filename">{{ __('Phonebook filename') }}</label>
                    <a href="{{ url('/') }}/app-assets/data/sample_phonebook.xlsx">{{ __('Download sample XLSX here') }}
                        <img src="{{ url('/') }}/app-assets/images/icons/xls.png" alt="png" height="32">
                    </a>
                    <input type="file" name="filename" class="form-control" placeholder="{{ __('Upload XLSX file') }}" required />
                </div>
                <button type="submit" class="btn btn-primary me-1 data-submit">{{ __('Submit') }}</button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
            </div>
        </form>
    </div>
</div>
<!-- Modal to add new phonebook Ends-->

<!-- Modal to scrape Google Maps Business starts-->
<div class="modal modal-slide-in new-phonebook-modal fade" id="scrapeGoogleMap">
    <div class="modal-dialog">
        <form action="{{ route('phonebook.scrapeGMaps') }}" method="POST" class="add-new-phonebook modal-content pt-0">
        @csrf
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
            <div class="modal-header mb-1">
                <h5 class="modal-title" id="exampleModalLabel">{{ __('Scrape Google Maps Business') }}</h5>
            </div>
            <div class="modal-body flex-grow-1">
                <div class="mb-1">
                    <label class="form-label" for="key">{{ __('Google Maps API KEY') }}</label>
                    <input type="text" name="key" class="form-control" placeholder="AIzaSyDu9hoFE6IZ055Blbl927z1Zf2fCKECPP0" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="location">{{ __('Location') }} (Longitude,Latitude)</label>
                    <input type="text" name="location" class="form-control" placeholder="-6.137433,106.788849" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="radius">{{ __('Radius') }} (in meters)</label>
                    <input type="text" name="radius" class="form-control" placeholder="1000" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="keyword">{{ __('Keyword') }} (Separated by comma | Optional)</label>
                    <input type="text" name="keyword" class="form-control" placeholder="{{ __('Insert Keyword ...') }}" />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="maxprice">{{ __('Max Price') }} (Optional)</label>
                    <input type="number" name="maxprice" class="form-control" />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="minprice">{{ __('Min Price') }} (Optional)</label>
                    <input type="number" name="minprice" class="form-control" />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="rankby">{{ __('Rank By') }} (Optional)</label>
                    <select name="rankby" class="form-select">
                        <option value="prominence">prominence</option>
                        <option value="distance">distance</option>
                    </select>
                </div>
                <div class="mb-1">
                    <label class="form-label" for="type">{{ __('Type') }} (hospital, restaurant, pharmacy, doctor, etc (choose only one) | Optional)</label>
                    <input type="text" name="type" class="form-control" />
                </div>
                <button type="submit" class="btn btn-primary me-1 data-submit">{{ __('Submit') }}</button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
            </div>
        </form>
    </div>
</div>
<!-- Modal to scrape Google Maps Business Ends-->
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
    $(document).ready(function () {
        $('#tbl-bootstr').DataTable();
    });        
</script>

@include('layouts.footer')
