@include('layouts.header')
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="card-body">
            <button type="button" class="btn btn-primary float-end" data-bs-toggle="modal" data-bs-target="#addContact">{{ __('Add new contact') }}</button>
        </div>
        <div class="content-header row">
            <h4>{{ $phonebook->name }} {{ __('Phonebook') }}<span class="badge rounded-pill badge-light-secondary">{{$countContacts}}</span></h4>
        </div>
        <div class="content-body">
            <!-- job list start -->
            <section class="app-job-list">
                <!-- list and filter start -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive table-responsive">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>{{ __('Id') }}</th>
                                        <th>{{ __('Name') }}</th>
                                        <th>{{ __('Phone') }}</th>
                                        <th>{{ __('Email') }}</th>
                                        <th>{{ __('Memo') }}</th>
                                        <th>{{ __('Column1') }}</th>
                                    {{--<th>{{ __('Column2') }}</th>
                                        <th>{{ __('Column3') }}</th>
                                        <th>{{ __('Column4') }}</th>
                                        <th>{{ __('Column5') }}</th>--}}
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                @foreach($contacts as $contact)
                                    <tr>
                                        <td><a href="javascript:;" data-bs-target="#editContact-{{$contact->id}}" data-bs-toggle="modal">
                                        {{ $contact->id }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#editContact-{{$contact->id}}" data-bs-toggle="modal">
                                        {{ $contact->name }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#editContact-{{$contact->id}}" data-bs-toggle="modal">
                                        {{ preg_replace('/\D/', '', $contact->phone) }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#editContact-{{$contact->id}}" data-bs-toggle="modal">
                                        {{ !empty($contact->email) ? $contact->email : '' }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#editContact-{{$contact->id}}" data-bs-toggle="modal">
                                        {{ !empty($contact->memo) ? $contact->memo : '' }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#editContact-{{$contact->id}}" data-bs-toggle="modal">
                                        {{ !empty($contact->column1) ? $contact->column1 : '' }}</a>
                                        </td>
                                    {{--<td><a href="javascript:;" data-bs-target="#editContact-{{$contact->id}}" data-bs-toggle="modal">
                                        {{ !empty($contact->column2) ? $contact->column2 : '' }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#editContact-{{$contact->id}}" data-bs-toggle="modal">
                                        {{ !empty($contact->column3) ? $contact->column3 : '' }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#editContact-{{$contact->id}}" data-bs-toggle="modal">
                                        {{ !empty($contact->column4) ? $contact->column4 : '' }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#editContact-{{$contact->id}}" data-bs-toggle="modal">
                                        {{ !empty($contact->column5) ? $contact->column5 : '' }}</a>
                                        </td>--}}
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton">
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#editContact-{{$contact->id}}"><i data-feather="edit" class="me-0"></i> {{__('Edit')}}</a>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-{{$contact->id}}"><i data-feather="trash" class="me-0"></i> {{__('Delete')}}</a>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-{{$contact->id}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    {{ __('Are you sure you want to delete?') }} <br><br>
                                                    <span class="text text-danger"> <b>{{ $contact->name }}</b> </span><br><br>
                                                    {{ __('This process is irreversible') }} <br>
                                                    {{ __('The record(s) will be deleted from the database permanently') }}
                                                </div>
                                                <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="{{ route('phonebook.destroyContact', ['contact_id' => $contact->id, 'phonebook_id' => $phonebook->id]) }}">{{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Edit Contact Modal -->
                                    <div class="modal fade" id="editContact-{{$contact->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-contact">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1">{{ __('Edit contact') }}</h1>
                                                    </div>
                                                    <form action="{{ route('phonebook.editContact') }}" method="GET" id="editContactForm" class="row gy-1 pt-75" enctype="multipart/form-data">
                                                        @csrf
                                                        <div class="row">
                                                        <div class="col-12 col-md-6">
                                                            <input type="hidden" name="contact_id" value="{{ $contact->id }}" />
                                                            <input type="hidden" name="phonebook_id" value="{{ $phonebook->id }}" />
                                                            <label class="form-label" for="contact_name">{{ __('Contact name') }}</label>
                                                            <input type="text" name="contact_name" class="form-control" value="{{ $contact->name }}" placeholder="{{ __('Contact name') }}" required />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="contact_phone">{{ __('Contact phone') }}</label>
                                                            <input type="text" name="contact_phone" class="form-control" value="{{ $contact->phone }}" placeholder="{{ __('Contact phone') }}" required />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="contact_email">{{ __('Contact email') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                                            <input type="text" name="contact_email" class="form-control" value="{{ !empty($contact->email) ? $contact->email : '' }}" />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="contact_memo">{{ __('Contact memo') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                                            <input type="text" name="contact_memo" class="form-control" value="{{ !empty($contact->memo) ? $contact->memo : '' }}" />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="contact_column1">{{ __('Contact column1') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                                            <input type="text" name="contact_column1" class="form-control" value="{{ !empty($contact->column1) ? $contact->column1 : '' }}" />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="contact_column2">{{ __('Contact column2') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                                            <input type="text" name="contact_column2" class="form-control" value="{{ !empty($contact->column2) ? $contact->column2 : '' }}" />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="contact_column3">{{ __('Contact column3') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                                            <input type="text" name="contact_column3" class="form-control" value="{{ !empty($contact->column3) ? $contact->column3 : '' }}" />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="contact_column4">{{ __('Contact column4') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                                            <input type="text" name="contact_column4" class="form-control" value="{{ !empty($contact->column4) ? $contact->column4 : '' }}" />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="contact_column5">{{ __('Contact column5') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                                            <input type="text" name="contact_column5" class="form-control" value="{{ !empty($contact->column5) ? $contact->column5 : '' }}" />
                                                        </div>
                                                        <div class="col-12 text-center mt-2 pt-50">
                                                            <button type="submit" class="btn btn-primary me-1">{{ __('Submit') }}</button>
                                                            <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Cancel') }}</button>
                                                        </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Edit Contact Modal -->
                                @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- Add Contact Modal -->
                        <div class="modal fade" id="addContact" tabindex="-1" aria-hidden="true">
                            <div class="modal-dialog modal-xl modal-dialog-centered modal-add-contact">
                                <div class="modal-content">
                                    <div class="modal-header bg-transparent">
                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                    </div>
                                    <div class="modal-body pb-5 px-sm-5 pt-50">
                                        <div class="text-center mb-2">
                                            <h1 class="mb-1">{{ __('Add new contact') }}</h1>
                                        </div>
                                        <form action="{{ route('phonebook.addContact') }}" method="GET" id="addContactForm" class="row gy-1 pt-75" enctype="multipart/form-data">
                                            @csrf
                                            <div class="row">
                                            <div class="col-12 col-md-6">
                                                <input type="hidden" name="contact_id" value="{{ !empty($contact->id)?$contact->id:null }}" />
                                                <input type="hidden" name="phonebook_id" value="{{ $phonebook->id }}" />
                                                <label class="form-label" for="contact_name">{{ __('Contact name') }}</label>
                                                <input type="text" name="contact_name" class="form-control" value="" placeholder="{{ __('Contact name') }}" required />
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <label class="form-label" for="contact_phone">{{ __('Contact phone') }}</label>
                                                <input type="text" name="contact_phone" class="form-control" value="" placeholder="{{ __('Contact phone') }}" required />
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <label class="form-label" for="contact_email">{{ __('Contact email') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                                <input type="text" name="contact_email" class="form-control" value="" placeholder="{{ __('Contact email') }}" />
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <label class="form-label" for="contact_memo">{{ __('Contact memo') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                                <input type="text" name="contact_memo" class="form-control" value="" placeholder="{{ __('Contact memo') }}" />
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <label class="form-label" for="contact_column1">{{ __('Contact column1') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                                <input type="text" name="contact_column1" class="form-control" value="" placeholder="{{ __('Contact column1') }}" />
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <label class="form-label" for="contact_column2">{{ __('Contact column2') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                                <input type="text" name="contact_column2" class="form-control" value="" placeholder="{{ __('Contact column2') }}" />
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <label class="form-label" for="contact_column3">{{ __('Contact column3') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                                <input type="text" name="contact_column3" class="form-control" value="" placeholder="{{ __('Contact column3') }}" />
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <label class="form-label" for="contact_column4">{{ __('Contact column4') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                                <input type="text" name="contact_column4" class="form-control" value="" placeholder="{{ __('Contact column4') }}" />
                                            </div>
                                            <div class="col-12 col-md-6">
                                                <label class="form-label" for="contact_column5">{{ __('Contact column5') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                                <input type="text" name="contact_column5" class="form-control" value="" placeholder="{{ __('Contact column5') }}" />
                                            </div>
                                            <div class="col-12 text-center mt-2 pt-50">
                                                <button type="submit" class="btn btn-primary me-1">{{ __('Submit') }}</button>
                                                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Cancel') }}</button>
                                            </div>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!--/ Add Contact Modal -->
                    </div>
                </div>
                <!-- list and filter end -->
            </section>
            <!-- jobs list ends -->
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
    $(document).ready(function () {
        $('#tbl-bootstr').DataTable();
    });        
</script>

@include('layouts.footer') 
