@include('layouts.header')

    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <h4>{{ __('Send message') }}</h4>
            </div>
            <div class="content-body">
                <div class="card col-12">
                    <div class="card-body">
                        <form action="{{ route('sendmsg.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                            <div class="row">
                                <input type="hidden" name="user_id" value="{{ Auth::user()->id }}">
                                <input type="hidden" name="job_id" value="{{ \Carbon\Carbon::now()->timestamp }}">
                                <div class="col-12">
                                    <label> {{ __('Device') }} </label> 
                                    <button id="select_all" name="select_all" class="btn btn-sm rounded-pill btn-outline-secondary"> {{__('Select ALL')}} </button>
                                    <select class="form-select" id="sender" name="sender[]" multiple required>
                                        @foreach($devices as $device)
                                        @if($device === $devices[0])
                                        <option value="{{ $device->sender }}" selected>{{ $device->user_id . '-' . $device->name . ' (' . $device->sender . ')' }}</option>
                                        @continue
                                        @endif
                                        <option value="{{ $device->sender }}">{{ $device->user_id . '-' . $device->name . ' (' . $device->sender . ')' }}</option>
                                        @endforeach
                                        @if($globals)
                                        <option disabled>─</option>
                                        @foreach($globals as $global)
                                        <option value="{{ $global['sender'] }}">{{ $global['user_id'] . '-' . $global['name'] . ' (' . $global['sender'] . ')' }}</option>
                                        @endforeach
                                        @endif
                                    </select>
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> {{ __('Single receiver') }} </label> <label class="form-label text-warning"> (Ex. 55918912341234, 5515934563456, 553078907890) </label>
                                    <input type="tel" name="single_receiver" placeholder="{{ __('Phone with country code') }}" class="form-control" value="{{$broadcastPhones}}">
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> {{ __('Multi receivers') }} </label> <label class="form-label text-warning"> ({{ __('Optional') }}) {{ __('Start sending on the next cron job') }}</label>
                                    <select id="phonebook" name="phonebook" class="form-select">
                                        <option value="">{{ __('Select Phonebook') }}</option>
                                        @foreach($phonebooks as $phonebook)
                                        <option value="{{ $phonebook->data }}">{{ $phonebook->name }} ({{ count(json_decode($phonebook->data)) }})</option>
                                        @endforeach
                                        @foreach($subscribers as $subscriber)
                                        @if($subscriber->device()->value('status') !== 'ONLINE') @continue @endif
                                        <option value="{{ __('Subscribers') }}-{{ $subscriber->sender }}">{{ __('Subscribers') }}-{{ $subscriber->sender }}</option>
                                        @endforeach
                                        <option value="{{ __('Subscribers') }}-{{ __('ALL') }}">{{ __('Subscribers') }}-{{ __('ALL') }}</option>
                                    </select>
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> {{ __('Message text') }} </label>
                                    <select onchange="getTemplate()" id="template" name="template" class="form-select">
                                        <option value="">{{ __('Select Template') }}</option>
                                        @foreach($templates as $template)
                                        <option value="{{ $template }}">{{ $template->name }}</option>
                                        @endforeach
                                    </select>
                                    <textarea id="msgtext" name="msgtext" class="form-control" rows="5" placeholder="{{ __('Message text here...') }}"></textarea>
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> {{ __('Emoji') }} ({{ __('Copy and Paste') }})</label>
                                    <textarea name="emoji" class="form-control" rows="7" readonly>{{ file_get_contents(public_path('app-assets/data/emoji.txt')) }}</textarea>
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> {{ __('Media file') }} </label> <label class="form-label text-warning"> JPEG/PNG/GIF/PDF/DOCX/PPTX/XLSX/CSV/MP3/MP4/ZIP </label>
                                    <input type="file" id="mediafile" name="mediafile" class="form-control">
                                    <input type="text" id="mediaurlInput" name="mediaurlInput" value="" class="form-control" style="display: none;">
                                    <!-- <label class="form-label text-warning"> {{ __('Button message samples') }} <a href="{{config('app.URL_DOCS_BUTTONS')}}" target="_blank">{{ __('Click HERE') }}!</a></label> -->
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> {{ __('Button type') }} </label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                    <select onchange="showButtonType()" id="buttontype" name="buttontype" class="form-select">
                                        <option value="none">{{ __('No Buttons') }}</option>
                                        <option value="reply">{{ __('Reply buttons') }}</option>
                                        <option value="template">{{ __('Template buttons (URL/Call)') }}</option>
                                        <option value="list">{{ __('List buttons') }}</option>
                                    </select>
                                    <label id="buttontypeLabel" style="display: none;" class="text-warning"> 
                                        {{ __('Reply buttons = Quick reply options') }}<br>
                                        {{ __('Template buttons = URL/Phone buttons') }}<br>
                                        {{ __('List buttons = Dropdown menu') }}
                                    </label>
                                    <br>
                                </div>
                                <div class="col-12 col-md-6" style="display: none;" id="areaFooterText">
                                    <label> {{ __('Button footer text') }} </label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                    <input type="text" id="footerText" name="footerText" placeholder="{{ __('Text on the footer') }}" value="" class="form-control">
                                    <br>
                                </div>
                                <div class="col-12 col-md-6" style="display: none;" id="areaMainTitle">
                                    <label> {{ __('Main title') }} </label> <label class="form-label text-warning"> ({{ __('Required for List buttons') }}) </label>
                                    <input type="text" id="mainTitle" name="mainTitle" placeholder="{{ __('Main title') }}" value="Main title" class="form-control">
                                    <br>
                                </div>
                                <div class="col-12 col-md-6" style="display: none;" id="areaButtonText">
                                    <label> {{ __('Text on the button') }} </label> <label class="form-label text-warning"> ({{ __('Required for List buttons') }}) </label>
                                    <input type="text" id="buttonText" name="buttonText" placeholder="{{ __('Text on the button') }}" value="Choose an option" class="form-control">
                                    <br>
                                </div>
                                @for ($i=1; $i<=$numOfButtons; $i++)
                                <div class="col-12 col-md-6" style="display: none;" id="areaReply{{ $i }}">
                                    <label> {{ __('Button') . ' ' . $i }} </label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                    <input type="text" id="displayText{{ $i }}" name="displayText{{ $i }}" placeholder="{{ __('Text on the button') }}" value="" class="form-control">
                                    <input type="text" id="responseText{{ $i }}" name="responseText{{ $i }}" placeholder="{{ __('Response ID (or URL like https://... or phone like +234...)') }}" value="" class="form-control">
                                    <br>
                                </div>
                                @endfor
                                @for ($i=1; $i<=$numOfLists; $i++)
                                <div class="col-12 col-md-6" style="display: none;" id="areaList{{ $i }}">
                                    <label> {{ __('Row') . ' ' . $i }} </label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                    <input type="text" id="sectionTitle{{ $i }}" name="sectionTitle{{ $i }}" placeholder="{{ __('Section title') }}" value="" class="form-control">
                                    <input type="text" id="rowTitle{{ $i }}" name="rowTitle{{ $i }}" placeholder="{{ __('Row title') }}" value="" class="form-control">
                                    <input type="text" id="description{{ $i }}" name="description{{ $i }}" placeholder="{{ __('Description') }}" value="" class="form-control">
                                    <input type="text" id="rowId{{ $i }}" name="rowId{{ $i }}" placeholder="{{ __('Response ID/keyword') }}" value="" class="form-control">
                                    <br>
                                </div>
                                @endfor
                                <div class="col-12 col-md-6">
                                    <label> {{ __('Schedule time') }} </label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                    <input type="datetime-local" id="schedule" name="schedule" class="form-control">
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> {{ __('Recurring every') }} </label> <label class="form-label text-warning"> ({{ __('Optional') }}) {{ __('Must input schedule time') }}</label>
                                    <div class="row">
                                        <div class="col-3">
                                            <div class="row">
                                                <div class="col-12">
                                                    <input type="number" min="0" name="years" placeholder="{{__('Years')}}" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-3">
                                            <div class="row">
                                                <div class="col-12">
                                                    <input type="number" min="0" name="months" placeholder="{{__('Months')}}" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-3">
                                            <div class="row">
                                                <div class="col-12">
                                                    <input type="number" min="0" name="weeks" placeholder="{{__('Weeks')}}" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-3">
                                            <div class="row">
                                                <div class="col-12">
                                                    <input type="number" min="0" name="days" placeholder="{{__('Days')}}" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> {{ __('Message delay (seconds)') }} </label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label>
                                    <div class="row">
                                        <div class="col-4">
                                            <div class="row">
                                                <div class="col-4">
                                                    <label> {{ __('Min') }} </label>
                                                </div>
                                                <div class="col-8">
                                                    <input type="number" min="1" max="120" name="min" placeholder="{{ __('Min') }}" value="3" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-4">
                                            <div class="row">
                                                <div class="col-4">
                                                    <label> {{ __('Max') }} </label>
                                                </div>
                                                <div class="col-8">
                                                    <input type="number" min="1" max="120" name="max" placeholder="{{ __('Max') }}" value="8" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> {{ __('Insert random string') }} </label>
                                    <select name="randomString" class="form-select">
                                        <option value="NO">{{ __('NO') }}</option>
                                        <option value="uuid">{{ __('Random code') }}</option>
                                        <option value="inspiring">{{ __('Inspiring quote') }}</option>
                                    </select>
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> {{ __('Insert Footer Text') }} </label>
                                        <input type="text" id="footer" name="footer" placeholder="{{ __('Text on the footer') }}" class="form-control">
                                    <br>
                                </div>
                                <div>
                                    <button class="btn btn-primary" type="submit" id="sendmsg" onclick="sendMsg(this, '{{$alertMsg}}')" name="send">{{ __('Send') }}</button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

				<!-- BEGIN: Button message sending mechanism -->
                {{--<div class="card col-12">
                    <div class="card-body">
                        <div class="card-header"><h4>{{ __('Button message sending mechanism') }}</h4></div>
                        <div class="card-body">
                            <div class="areapb" id="areapb"></div><br>
                            <table class="table table-striped table-bordered datatable">
                        <thead>
                        <tr style="height: 58px;">
                        <th style="height: 58px;">{{ __('Message Type') }}</th>
                        <th style="height: 58px;">{{ __('Sender') }}</th>
                        <th style="height: 58px;">{{ __('From') }} =&gt; {{ __('To') }}</th>
                        <th style="height: 58px;">{{ __('Receiver') }}</th>
                        <th style="height: 58px;">{{ __('Android') }}</th>
                        <th style="height: 37px;">{{ __('iOS') }}</th>
                        <th style="height: 37px;">{{ __('Web') }}</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr style="height: 58px;">
                        <td style="height: 58px;">{{ __('Button Message') }} (*1)</td>
                        <td style="height: 58px;">{{ __('Personal') }} </td>
                        <td style="height: 58px;">=&gt;</td>
                        <td style="height: 58px;">{{ __('Personal') }}</td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i></td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i> (*0)</td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i></td>
                        </tr>
                        <tr style="height: 58px;">
                        <td style="height: 58px;">{{ __('Button Message') }} (*1)</td>
                        <td style="height: 58px;">{{ __('Personal') }}</td>
                        <td style="height: 58px;">=&gt;</td>
                        <td style="height: 58px;">{{ __('Business') }}</td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i></td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i> (*0)</td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i></td>
                        </tr>
                        <tr style="height: 58px;">
                        <td style="height: 58px;">{{ __('Button Message') }}</td>
                        <td style="height: 58px;">{{ __('Business') }}</td>
                        <td style="height: 58px;">=&gt;</td>
                        <td style="height: 58px;">{{ __('Personal') }}</td>
                        <td style="height: 58px;"><i stroke="red" data-feather="x-circle" style="width:28px;height:28px;"></i></td>
                        <td style="height: 58px;"><i stroke="red" data-feather="x-circle" style="width:28px;height:28px;"></i></td>
                        <td style="height: 58px;"><i stroke="red" data-feather="x-circle" style="width:28px;height:28px;"></i></td>
                        </tr>
                        <tr style="height: 58px;">
                        <td style="height: 58px;">{{ __('Button Message') }}</td>
                        <td style="height: 58px;">{{ __('Business') }}</td>
                        <td style="height: 58px;">=&gt;</td>
                        <td style="height: 58px;">{{ __('Business') }}</td>
                        <td style="height: 58px;"><i stroke="red" data-feather="x-circle" style="width:28px;height:28px;"></i></td>
                        <td style="height: 58px;"><i stroke="red" data-feather="x-circle" style="width:28px;height:28px;"></i></td>
                        <td style="height: 58px;"><i stroke="red" data-feather="x-circle" style="width:28px;height:28px;"></i></td>
                        </tr>
                        <tr style="height: 58px;">
                        <td style="height: 58px;">{{ __('List Message') }}</td>
                        <td style="height: 58px;">{{ __('Personal') }}</td>
                        <td style="height: 58px;">=&gt;</td>
                        <td style="height: 58px;">{{ __('Personal') }}</td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i></td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i></td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i></td>
                        </tr>
                        <tr style="height: 58px;">
                        <td style="height: 58px;">{{ __('List Message') }}</td>
                        <td style="height: 58px;">{{ __('Personal') }}</td>
                        <td style="height: 58px;">=&gt;</td>
                        <td style="height: 58px;">{{ __('Business') }}</td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i></td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i></td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i></td>
                        </tr>
                        <tr style="height: 58px;">
                        <td style="height: 58px;">{{ __('List Message') }}</td>
                        <td style="height: 58px;">{{ __('Business') }}</td>
                        <td style="height: 58px;">=&gt;</td>
                        <td style="height: 58px;">{{ __('Personal') }}</td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i></td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i></td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i></td>
                        </tr>
                        <tr style="height: 58px;">
                        <td style="height: 58px;">{{ __('List Message') }}</td>
                        <td style="height: 58px;">{{ __('Business') }}</td>
                        <td style="height: 58px;">=&gt;</td>
                        <td style="height: 58px;">{{ __('Business') }}</td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i></td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i></td>
                        <td style="height: 58px;"><i stroke="green" data-feather="check-circle" style="width:28px;height:28px;"></i></td>
                        </tr>
						<tr style="height: 58px;">
                        <td style="height: 58px;">{{ __('Interactive Message') }}</td>
                        <td style="height: 58px;">{{ __('Not tested') }}</td>
                        <td style="height: 58px;">=&gt;</td>
                        <td style="height: 58px;">{{ __('Not tested') }}</td>
                        <td style="height: 58px;">{{ __('Not tested') }}</td>
                        <td style="height: 58px;">{{ __('Not tested') }}</td>
                        <td style="height: 58px;">{{ __('Not tested') }}</td>
                        </tr>
						<tr style="height: 58px;">
                        <td style="height: 58px;">{{ __('Template Message') }}</td>
                        <td style="height: 58px;">{{ __('TBA') }}</td>
                        <td style="height: 58px;">=&gt;</td>
                        <td style="height: 58px;">{{ __('TBA') }}</td>
                        <td style="height: 58px;">{{ __('TBA') }}</td>
                        <td style="height: 58px;">{{ __('TBA') }}</td>
                        <td style="height: 58px;">{{ __('TBA') }}</td>
                        </tr>
                        </tbody>
                        </table>
                        </div>
						<label class="form-label text-warning">(*0) {{ __('When online') }}</label><br>
                        <label class="form-label text-warning">(*1) {{ __('Works for image, video, document & live location') }}</label><br>
                        <label class="form-label text-warning">(TBA) {{ __('To Be Annouced') }}</label>
                    </div>
                </div>--}}
                <!-- END: Button message sending mechanism -->

                <div class="card col-12">
                    <div class="card-body">
                        <div class="card-header"><a href="{{ route('phonebook.list') }}"><h4>{{ __('Phonebook') }}</h4></a></div>
                        <div class="card-body">
                            <div class="areapb" id="areapb"></div><br>
                            <table class="table table-striped table-bordered datatable">
                                <thead>
                                    <tr>
                                        <th> {{ __('Phonebook') }} </th>
                                        <th> {{ __('Name & Receiver number') }} </th>
                                        <th> {{ __('Total') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($phonebooks as $phonebook)
                                    <tr>
                                        <td>
                                        {{ $phonebook['name'] }}
                                        </td>
                                        <td>
                                        {{ str_replace(['"','[',']','name:','receiver:'], [''], substr($phonebook->data, 0, 100)) . '...' }}
                                        </td>
                                        <td>{{ count(json_decode($phonebook->data)) }}</td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- END: Content-->

    <!-- BEGIN: Vendor JS-->
    <script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
    <!-- BEGIN Vendor JS-->

<script>
    function showButtonType() {
        var buttonType = document.getElementById("buttontype").value;
        
        // Hide all areas first
        document.getElementById("buttontypeLabel").style.display = 'none';
        document.getElementById("areaFooterText").style.display = 'none';
        document.getElementById("areaMainTitle").style.display = 'none';
        document.getElementById("areaButtonText").style.display = 'none';
        
        for (i=1; i<={{$numOfButtons}}; i++) {
            document.getElementById("areaReply" + i).style.display = 'none';
        }
        for (i=1; i<={{$numOfLists}}; i++) {
            document.getElementById("areaList" + i).style.display = 'none';
        }
        
        // Show relevant areas based on button type
        if (buttonType === 'reply' || buttonType === 'template') {
            document.getElementById("buttontypeLabel").innerHTML = "{{ __('Reply buttons = Quick reply options') }}<br>{{ __('Template buttons = URL/Phone buttons') }}";
            document.getElementById("buttontypeLabel").style.display = 'block';
            document.getElementById("areaFooterText").style.display = 'block';
            
            for (i=1; i<={{$numOfButtons}}; i++) {
                document.getElementById("areaReply" + i).style.display = 'block';
            }
        } else if (buttonType === 'list') {
            document.getElementById("buttontypeLabel").innerHTML = "{{ __('List buttons = Dropdown menu with sections') }}";
            document.getElementById("buttontypeLabel").style.display = 'block';
            document.getElementById("areaFooterText").style.display = 'block';
            document.getElementById("areaMainTitle").style.display = 'block';
            document.getElementById("areaButtonText").style.display = 'block';
            
            for (i=1; i<={{$numOfLists}}; i++) {
                document.getElementById("areaList" + i).style.display = 'block';
            }
        }
    }

    function clearTemplate() {
        document.getElementById("msgtext").innerHTML = '';
        document.getElementById("mediaurlInput").value = '';
        document.getElementById("mediaurlInput").style.display = 'none';
        document.getElementById("mediafile").style.display = 'block';

        // document.getElementById("buttontype").value = 'none';
        // document.getElementById("buttontype").style.display = 'block';
        // document.getElementById("buttontypeLabel").innerHTML = '';
        // document.getElementById("buttontypeLabel").style.display = 'none';
        // document.getElementById("areaFooterText").style.display = 'none';
        // document.getElementById("areaMainTitle").style.display = 'none';
        // document.getElementById("areaButtonText").style.display = 'none';
        // for (i=1; i<={{$numOfButtons}}; i++) {
        //     document.getElementById("areaReply" + i).style.display = 'none';
        // }
        // for (i=1; i<={{$numOfLists}}; i++) {
        //     document.getElementById("areaList" + i).style.display = 'none';
        // }
    }

    function getTemplate() {
        if (document.getElementById("template").value) {
            clearTemplate();
            var template = JSON.parse(document.getElementById("template").value);
            // var buttons = JSON.parse(template.data);
            document.getElementById("msgtext").innerHTML = template.msgtext;
            document.getElementById("mediaurlInput").value = template.mediaurl;
            if (document.getElementById("mediaurlInput").value) {
                document.getElementById("mediaurlInput").style.display = 'block';
                document.getElementById("mediafile").style.display = 'none';
            } else {
                document.getElementById("mediaurlInput").style.display = 'none';
                document.getElementById("mediafile").style.display = 'block';
            }

            // if (buttons && buttons.listButtons) {
            //     document.getElementById("buttontype").value = 'list';
            //     document.getElementById("buttontype").style.display = 'none';
            //     document.getElementById("buttontypeLabel").innerHTML = "{{ __('List buttons') }}";
            //     document.getElementById("buttontypeLabel").style.display = 'block';
            //     document.getElementById("footerText").value = buttons.footerText
            //     document.getElementById("areaFooterText").style.display = 'block';
            //     document.getElementById("mainTitle").value = buttons.mainTitle
            //     document.getElementById("areaMainTitle").style.display = 'block';
            //     document.getElementById("buttonText").value = buttons.buttonText
            //     document.getElementById("areaButtonText").style.display = 'block';

            //     const btns = buttons.listButtons;
            //     var i = 1;
            //     btns.forEach((btn) => {
            //         const rows = btn.rows;
            //         rows.forEach((row) => {
            //             document.getElementById("areaReply" + i).style.display = 'none';
            //             document.getElementById("sectionTitle" + i).value = btn.title;
            //             document.getElementById("rowTitle" + i).value = row.title;
            //             document.getElementById("description" + i).value = row.description;
            //             document.getElementById("rowId" + i).value = row.rowId;
            //             document.getElementById("areaList" + i).style.display = 'block';
            //             i++;
            //         })
            //     })
            // }
            // if (buttons && buttons.replyButtons) {
            //     const btn = buttons.replyButtons;
            //     document.getElementById("buttontype").value = 'reply';
            //     document.getElementById("buttontype").style.display = 'none';
            //     document.getElementById("buttontypeLabel").innerHTML = "{{ __('Reply buttons = NO URL/phone link') }}";
            //     document.getElementById("buttontypeLabel").style.display = 'block';
            //     document.getElementById("footerText").value = buttons.footerText
            //     document.getElementById("areaFooterText").style.display = 'block';
            //     document.getElementById("areaMainTitle").style.display = 'none';
            //     document.getElementById("areaButtonText").style.display = 'none';
            //     for (i=1; i<=btn.length; i++) {
            //         document.getElementById("displayText" + i).value = btn[i-1].buttonText.displayText;
            //         document.getElementById("responseText" + i).value = btn[i-1].buttonId;
            //         document.getElementById("areaReply" + i).style.display = 'block';
            //         document.getElementById("areaList" + i).style.display = 'none';
            //     }
            // } else if (buttons && buttons.templateButtons) {
            //     const btn = buttons.templateButtons;
            //     document.getElementById("buttontype").value = 'template';
            //     document.getElementById("buttontype").style.display = 'none';
            //     document.getElementById("buttontypeLabel").innerHTML = "{{ __('Template buttons = YES URL/phone link') }}";
            //     document.getElementById("buttontypeLabel").style.display = 'block';
            //     document.getElementById("footerText").value = buttons.footerText
            //     document.getElementById("areaFooterText").style.display = 'block';
            //     document.getElementById("areaMainTitle").style.display = 'none';
            //     document.getElementById("areaButtonText").style.display = 'none';
            //     for (i=1; i<=btn.length; i++) {
            //         document.getElementById("displayText" + i).value = btn[i-1].quickReplyButton ? btn[i-1].quickReplyButton.displayText : btn[i-1].callButton ? btn[i-1].callButton.displayText : btn[i-1].urlButton ? btn[i-1].urlButton.displayText : '';
            //         document.getElementById("responseText" + i).value = btn[i-1].quickReplyButton ? btn[i-1].quickReplyButton.id : btn[i-1].callButton ? btn[i-1].callButton.phoneNumber : btn[i-1].urlButton ? btn[i-1].urlButton.url : '';
            //         document.getElementById("areaReply" + i).style.display = 'block';
            //         document.getElementById("areaList" + i).style.display = 'none';
            //     }
            // } else if (buttons && buttons.listButtons) {
            //     document.getElementById("buttontype").value = 'list';
            //     document.getElementById("buttontype").style.display = 'none';
            //     document.getElementById("buttontypeLabel").innerHTML = "{{ __('List buttons') }}";
            //     document.getElementById("buttontypeLabel").style.display = 'block';
            //     document.getElementById("footerText").value = buttons.footerText
            //     document.getElementById("areaFooterText").style.display = 'block';
            //     document.getElementById("mainTitle").value = buttons.mainTitle
            //     document.getElementById("areaMainTitle").style.display = 'block';
            //     document.getElementById("buttonText").value = buttons.buttonText
            //     document.getElementById("areaButtonText").style.display = 'block';

            //     const btns = buttons.listButtons;
            //     var i = 1;
            //     btns.forEach((btn) => {
            //         const rows = btn.rows;
            //         rows.forEach((row) => {
            //             document.getElementById("areaReply" + i).style.display = 'none';
            //             document.getElementById("sectionTitle" + i).value = btn.title;
            //             document.getElementById("rowTitle" + i).value = row.title;
            //             document.getElementById("description" + i).value = row.description;
            //             document.getElementById("rowId" + i).value = row.rowId;
            //             document.getElementById("areaList" + i).style.display = 'block';
            //             i++;
            //         })
            //     })
            // } else if (buttons) {
            //     document.getElementById("buttontype").value = 'none';
            //     document.getElementById("buttontype").style.display = 'block';
            //     document.getElementById("buttontypeLabel").innerHTML = '';
            //     document.getElementById("buttontypeLabel").style.display = 'none';
            //     document.getElementById("areaFooterText").style.display = 'none';
            //     document.getElementById("areaMainTitle").style.display = 'none';
            //     document.getElementById("areaButtonText").style.display = 'none';
            //     for (i=1; i<={{$numOfButtons}}; i++) {
            //         document.getElementById("areaReply" + i).style.display = 'none';
            //     }
            //     for (i=1; i<={{$numOfLists}}; i++) {
            //         document.getElementById("areaList" + i).style.display = 'none';
            //     }
            // }
        } else {
            clearTemplate();
        }
    }

    $('#select_all').click(function(e) {
        e.preventDefault();
        $('#sender option').prop('selected', true);
    });

    $('#phonebook').change(function() {
        var pbdatas = $("#phonebook").val().replace(/"|:|\[|\]|name|receiver/g, "");
        $("#areapb").html(pbdatas);
    });

    var select = document.getElementById('sender');
    select.size = select.length > 20 ? 20 : select.length;

    function sendMsg(sendButton, alertMsg) {
        sendButton.disabled=true;
        sendButton.innerHTML = "{{ __('DO NOT CLOSE / BACK / REFRESH !!!') }}";
        sendButton.form.submit();
        setTimeout(function () {
            window.location.reload();
            alert(alertMsg);
        }, 30_000);
    }
</script>

@include('layouts.footer')
