@include('layouts.header')
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <h4>{{ __('Settings') }}</h4>
        </div>
        <div class="content-body">
            <!-- License activation UI removed -->
        </div>

        <div class="card-body">
            <button type="button" class="btn btn-sm btn-primary float-end" data-bs-toggle="modal" data-bs-target="#addNew">{{ __('Add new setting') }}</button>
            <a href="{{ route('setting.clearCache') }}" class="btn btn-sm btn-danger float-end" >{{ __('Clear app cache') }}</a>
        </div>

        <div class="content-header row">
            <h4>{{ __('Settings list') }}<span class="badge rounded-pill badge-light-secondary">{{DB::table('settings')->count()}}</span></h4>
        </div>
        <div class="content-body">
            <!-- settings list start -->
            <section class="app-setting-list">
                <!-- list and filter start -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive table-responsive">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>{{ __('Setting key') }}</th>
                                        <th>{{ __('Setting value') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($settings as $setting)
                                    <tr>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$setting->id}}" data-bs-toggle="modal">
                                        {{ $setting->key }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$setting->id}}" data-bs-toggle="modal">
                                        {{ $setting->value }}</a>
                                        </td>
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton-{{$setting->id}}" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton-{{$setting->id}}">
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit-{{$setting->id}}"><i data-feather="edit" class="me-0"></i> {{__('Edit')}}</a>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-{{$setting->id}}"><i data-feather="trash" class="me-0"></i> {{__('Delete')}}</a>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-{{$setting->id}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    {{ __('Are you sure you want to delete?') }} <br><br>
                                                    <span class="text text-danger"> <b>{{ $setting->key }}</b> </span><br><br>
                                                    {{ __('This process is irreversible') }} <br>
                                                    {{ __('The record(s) will be deleted from the database permanently') }}
                                                </div>
                                                <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="{{ route('setting.destroy', ['setting_id' => $setting->id]) }}">{{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Edit Setting Modal -->
                                    <div class="modal fade" id="edit-{{$setting->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-setting">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1">{{ __('Edit setting') }}</h1>
                                                    </div>
                                                    <form action="{{ route('setting.update') }}" method="POST" class="row gy-1 pt-75">
                                                        @csrf
                                                        <div class="row">
                                                        <div class="col-12 col-md-6">
                                                            <input type="hidden"  name="setting_id" value="{{ $setting->id }}" />
                                                            <label class="form-label" for="key">{{ __('Setting key') }}</label>
                                                            <input type="text" name="key" class="form-control" value="{{ $setting->key }}" />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="value">{{ __('Setting value') }}</label>
                                                            <input type="text" name="value" class="form-control" value="{{ $setting->value }}" />
                                                        </div>
                                                        <div class="col-12 text-center mt-2 pt-50">
                                                            <button type="submit" class="btn btn-primary me-1">{{ __('Submit') }}</button>
                                                            <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Cancel') }}</button>
                                                        </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Edit Setting Modal -->
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Modal to add new setting starts-->
                    <div class="modal modal-slide-in new-setting-modal fade" id="addNew">
                        <div class="modal-dialog">
                            <form action="{{ route('setting.store') }}" method="POST" class="add-new-setting modal-content pt-0">
                            @csrf
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
                                <div class="modal-header mb-1">
                                    <h5 class="modal-title" id="exampleModalLabel">{{ __('Add new setting') }}</h5>
                                </div>
                                <div class="modal-body flex-grow-1">
                                    <div class="mb-1">
                                        <label class="form-label" for="key">{{ __('Setting key') }}</label>
                                        <input type="text" name="key" class="form-control" required />
                                    </div>
                                    <div class="mb-1">
                                        <label class="form-label" for="value">{{ __('Setting value') }}</label>
                                        <input type="text" name="value" class="form-control" required />
                                    </div>
                                    <button type="submit" class="btn btn-primary me-1 data-submit">{{ __('Submit') }}</button>
                                    <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <!-- Modal to add new setting Ends-->
                </div>
                <!-- list and filter end -->
            </section>
            <!-- settings list ends -->
            <!-- <div class="row">
                <div class="col-md-12">
                    {{--{{ $settings->links() }}--}}
                </div>
            </div> -->
        </div>

        <div class="content-header row">
            <h4>{{ __('Payment Gateway Configurations') }}</h4>
        </div>
        <div class="content-body">
            <section class="app-gateway-list">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                                                <thead class="table-light">
                                    <tr>
                                        <th>{{ __('Gateway Name') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Configuration') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($gateways as $gateway)
                                    <tr>
                                        <td>
                                            <strong>{{ $gateway->display_name }}</strong><br>
                                            <small class="text-muted">{{ $gateway->name }}</small>
                                        </td>
                                        <td>
                                            @if($gateway->is_active)
                                                <span class="badge bg-success">{{ __('Active') }}</span>
                                            @else
                                                <span class="badge bg-danger">{{ __('Inactive') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($gateway->name === 'offline')
                                                @php $settings = $gateway->settings ?? []; @endphp
                                                <small>
                                                    <strong>Bank:</strong> {{ $settings['bank_name'] ?? 'Not set' }}<br>
                                                    <strong>Account:</strong> {{ $settings['account_number'] ?? 'Not set' }}
                                                </small>
                                            @else
                                                <small>
                                                    <strong>Public Key:</strong> {{ $gateway->public_key ? substr($gateway->public_key, 0, 20) . '...' : 'Not set' }}<br>
                                                    <strong>Secret Key:</strong> {{ $gateway->secret_key ? '********' : 'Not set' }}
                                                </small>
                                            @endif
                                        </td>
                                        <td>
                                            <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editGateway-{{$gateway->id}}">{{ __('Edit') }}</button>
                                        </td>
                                    </tr>
                                    <!-- Edit Gateway Modal -->
                                    <div class="modal fade" id="editGateway-{{$gateway->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1">{{ __('Edit Payment Gateway') }}: {{ $gateway->display_name }}</h1>
                                                    </div>
                                                    <form action="{{ route('gateway.update', ['gateway_id' => $gateway->id]) }}" method="POST" class="row gy-1 pt-75">
                                                        @csrf
                                                        <div class="row">
                                                            @if($gateway->name === 'offline')
                                                                <!-- Offline Payment Specific Fields -->
                                                                <div class="col-12">
                                                                    <div class="alert alert-info">
                                                                        <strong>{{ __('Offline Payment Configuration') }}</strong>
                                                                        <p class="mb-0">{{ __('Configure bank details that will be shown to users during payment.') }}</p>
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="bank_name">{{ __('Bank Name') }}</label>
                                                                    <input type="text" name="bank_name" class="form-control" value="{{ $gateway->settings['bank_name'] ?? '' }}" placeholder="e.g., Bank Central Asia" />
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="account_number">{{ __('Account Number') }}</label>
                                                                    <input type="text" name="account_number" class="form-control" value="{{ $gateway->settings['account_number'] ?? '' }}" placeholder="e.g., 1234567890" />
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="account_name">{{ __('Account Name') }}</label>
                                                                    <input type="text" name="account_name" class="form-control" value="{{ $gateway->settings['account_name'] ?? '' }}" placeholder="e.g., Company Name" />
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="require_proof">{{ __('Require Proof of Payment') }}</label>
                                                                    <select name="require_proof" class="form-control">
                                                                        <option value="1" @if(($gateway->settings['require_proof'] ?? 1) == 1) selected @endif>{{ __('Yes') }}</option>
                                                                        <option value="0" @if(($gateway->settings['require_proof'] ?? 1) == 0) selected @endif>{{ __('No') }}</option>
                                                                    </select>
                                                                </div>
                                                                <div class="col-12">
                                                                    <label class="form-label" for="instructions">{{ __('Payment Instructions') }}</label>
                                                                    <textarea name="instructions" class="form-control" rows="3" placeholder="{{ __('Instructions shown to users...') }}">{{ $gateway->settings['instructions'] ?? '' }}</textarea>
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="is_active">{{ __('Status') }}</label>
                                                                    <select name="is_active" class="form-control">
                                                                        <option value="1" @if($gateway->is_active) selected @endif>{{ __('Active') }}</option>
                                                                        <option value="0" @if(!$gateway->is_active) selected @endif>{{ __('Inactive') }}</option>
                                                                    </select>
                                                                </div>
                                                            @elseif($gateway->name === 'paypal')
                                                                <!-- PayPal Specific Fields -->
                                                                <div class="col-12">
                                                                    <div class="alert alert-info">
                                                                        <strong>{{ __('PayPal Configuration') }}</strong>
                                                                        <p class="mb-0">{{ __('Get your credentials from') }} <a href="https://developer.paypal.com/dashboard/" target="_blank">PayPal Developer Dashboard</a></p>
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="mode">{{ __('Mode') }}</label>
                                                                    <select name="mode" class="form-control">
                                                                        <option value="sandbox" @if(($gateway->settings['mode'] ?? 'sandbox') === 'sandbox') selected @endif>{{ __('Sandbox (Testing)') }}</option>
                                                                        <option value="live" @if(($gateway->settings['mode'] ?? 'sandbox') === 'live') selected @endif>{{ __('Live (Production)') }}</option>
                                                                    </select>
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="client_id">{{ __('Client ID') }}</label>
                                                                    <input type="text" name="client_id" class="form-control" value="{{ $gateway->settings['client_id'] ?? '' }}" placeholder="PayPal Client ID" />
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="client_secret">{{ __('Client Secret') }}</label>
                                                                    <input type="password" name="client_secret" class="form-control" value="{{ $gateway->settings['client_secret'] ?? '' }}" placeholder="PayPal Client Secret" />
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="webhook_url">{{ __('Webhook URL') }}</label>
                                                                    <input type="text" name="webhook_url" class="form-control" value="{{ $gateway->webhook_url }}" readonly />
                                                                    <small class="text-muted">{{ __('Copy this URL to your PayPal webhook settings') }}</small>
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="is_active">{{ __('Status') }}</label>
                                                                    <select name="is_active" class="form-control">
                                                                        <option value="1" @if($gateway->is_active) selected @endif>{{ __('Active') }}</option>
                                                                        <option value="0" @if(!$gateway->is_active) selected @endif>{{ __('Inactive') }}</option>
                                                                    </select>
                                                                </div>
                                                            @elseif($gateway->name === 'stripe')
                                                                <!-- Stripe Specific Fields -->
                                                                <div class="col-12">
                                                                    <div class="alert alert-info">
                                                                        <strong>{{ __('Stripe Configuration') }}</strong>
                                                                        <p class="mb-0">{{ __('Get your credentials from') }} <a href="https://dashboard.stripe.com/apikeys" target="_blank">Stripe Dashboard</a></p>
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="test_mode">{{ __('Test Mode') }}</label>
                                                                    <select name="test_mode" class="form-control">
                                                                        <option value="1" @if(($gateway->settings['test_mode'] ?? 1) == 1) selected @endif>{{ __('Enabled (Testing)') }}</option>
                                                                        <option value="0" @if(($gateway->settings['test_mode'] ?? 1) == 0) selected @endif>{{ __('Disabled (Production)') }}</option>
                                                                    </select>
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="publishable_key">{{ __('Publishable Key') }}</label>
                                                                    <input type="text" name="publishable_key" class="form-control" value="{{ $gateway->settings['publishable_key'] ?? '' }}" placeholder="pk_test_... or pk_live_..." />
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="stripe_secret_key">{{ __('Secret Key') }}</label>
                                                                    <input type="password" name="stripe_secret_key" class="form-control" value="{{ $gateway->settings['secret_key'] ?? '' }}" placeholder="sk_test_... or sk_live_..." />
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="webhook_secret">{{ __('Webhook Signing Secret') }}</label>
                                                                    <input type="password" name="webhook_secret" class="form-control" value="{{ $gateway->settings['webhook_secret'] ?? '' }}" placeholder="whsec_..." />
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="webhook_url">{{ __('Webhook URL') }}</label>
                                                                    <input type="text" name="webhook_url" class="form-control" value="{{ $gateway->webhook_url }}" readonly />
                                                                    <small class="text-muted">{{ __('Copy this URL to your Stripe webhook settings') }}</small>
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="is_active">{{ __('Status') }}</label>
                                                                    <select name="is_active" class="form-control">
                                                                        <option value="1" @if($gateway->is_active) selected @endif>{{ __('Active') }}</option>
                                                                        <option value="0" @if(!$gateway->is_active) selected @endif>{{ __('Inactive') }}</option>
                                                                    </select>
                                                                </div>
                                                            @else
                                                                <!-- Standard Gateway Fields (Paystack, Flutterwave, etc.) -->
                                                                <div class="col-12 col-md-4">
                                                                    <label class="form-label" for="public_key">{{ __('Public Key') }}</label>
                                                                    <input type="text" name="public_key" class="form-control" value="{{ $gateway->public_key }}" />
                                                                </div>
                                                                <div class="col-12 col-md-4">
                                                                    <label class="form-label" for="secret_key">{{ __('Secret Key') }}</label>
                                                                    <input type="password" name="secret_key" class="form-control" value="{{ $gateway->secret_key }}" />
                                                                </div>
                                                                <div class="col-12 col-md-4">
                                                                    <label class="form-label" for="webhook_url">{{ __('Webhook URL') }}</label>
                                                                    <input type="text" name="webhook_url" class="form-control" value="{{ $gateway->webhook_url }}" />
                                                                </div>
                                                                <div class="col-12 col-md-4">
                                                                    <label class="form-label" for="is_active">{{ __('Status') }}</label>
                                                                    <select name="is_active" class="form-control">
                                                                        <option value="1" @if($gateway->is_active) selected @endif>{{ __('Active') }}</option>
                                                                        <option value="0" @if(!$gateway->is_active) selected @endif>{{ __('Inactive') }}</option>
                                                                    </select>
                                                                </div>
                                                            @endif
                                                        </div>
                                                        <div class="col-12 text-center mt-2 pt-50">
                                                            <button type="submit" class="btn btn-primary me-1">{{ __('Save') }}</button>
                                                            <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Cancel') }}</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Edit Gateway Modal -->
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
    $(document).ready(function () {
        $('#tbl-bootstr').DataTable();
    });        
</script>

@include('layouts.footer')
