@include('layouts.header')

@php
App::setLocale(Auth::user()->lang);
@endphp

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <!-- Header Stats -->
        <div class="row">
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $totalStaff }}</h3>
                            <span>{{ __('Total Staff') }}</span>
                        </div>
                        <div class="avatar bg-light-primary p-50">
                            <span class="avatar-content">
                                <i data-feather="users" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $activeStaff }}</h3>
                            <span>{{ __('Active Staff') }}</span>
                        </div>
                        <div class="avatar bg-light-success p-50">
                            <span class="avatar-content">
                                <i data-feather="user-check" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $inactiveStaff }}</h3>
                            <span>{{ __('Inactive Staff') }}</span>
                        </div>
                        <div class="avatar bg-light-warning p-50">
                            <span class="avatar-content">
                                <i data-feather="user-x" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $managers }}</h3>
                            <span>{{ __('Managers') }}</span>
                        </div>
                        <div class="avatar bg-light-info p-50">
                            <span class="avatar-content">
                                <i data-feather="award" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-body">
            <!-- Staff List Card -->
            <div class="card">
                <div class="card-header border-bottom">
                    <h4 class="card-title">{{ __('Staff Management') }}</h4>
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addStaffModal">
                        <i data-feather="plus" class="me-50"></i> {{ __('Add Staff') }}
                    </button>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>{{ __('Name') }}</th>
                                    <th>{{ __('Email') }}</th>
                                    <th>{{ __('Phone') }}</th>
                                    <th>{{ __('Device') }}</th>
                                    <th>{{ __('Role') }}</th>
                                    <th>{{ __('Status') }}</th>
                                    <th>{{ __('Last Login') }}</th>
                                    <th>{{ __('Actions') }}</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($staff as $member)
                                <tr>
                                    <td>
                                        <div class="d-flex align-items-center">
                                            <div class="avatar bg-light-primary me-1">
                                                <span class="avatar-content">{{ strtoupper(substr($member->staff_name, 0, 2)) }}</span>
                                            </div>
                                            <strong>{{ $member->staff_name }}</strong>
                                        </div>
                                    </td>
                                    <td>{{ $member->staff_email }}</td>
                                    <td>{{ $member->staff_phone ?? 'N/A' }}</td>
                                    <td>
                                        <span class="badge badge-light-info">
                                            {{ $member->device->sender ?? 'N/A' }}
                                        </span>
                                    </td>
                                    <td>
                                        @if($member->role === 'manager')
                                            <span class="badge badge-light-primary">{{ __('Manager') }}</span>
                                        @elseif($member->role === 'operator')
                                            <span class="badge badge-light-success">{{ __('Operator') }}</span>
                                        @else
                                            <span class="badge badge-light-secondary">{{ __('Viewer') }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($member->status === 'active')
                                            <span class="badge badge-light-success">{{ __('Active') }}</span>
                                        @elseif($member->status === 'suspended')
                                            <span class="badge badge-light-danger">{{ __('Suspended') }}</span>
                                        @else
                                            <span class="badge badge-light-warning">{{ __('Inactive') }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($member->last_login_at)
                                            {{ $member->last_login_at->diffForHumans() }}
                                        @else
                                            <span class="text-muted">{{ __('Never') }}</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="dropdown">
                                            <button type="button" class="btn btn-sm btn-icon dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                <i data-feather="more-vertical"></i>
                                            </button>
                                            <div class="dropdown-menu">
                                                <a class="dropdown-item" href="#" onclick="editStaff({{ $member->id }}, '{{ $member->staff_name }}', '{{ $member->staff_email }}', '{{ $member->staff_phone }}', {{ $member->device_id }}, '{{ $member->role }}', '{{ $member->status }}', {{ json_encode($member->permissions ?? []) }})">
                                                    <i data-feather="edit" class="me-50"></i>{{ __('Edit') }}
                                                </a>
                                                <a class="dropdown-item" href="{{ route('staff.toggle', $member->id) }}">
                                                    <i data-feather="power" class="me-50"></i>{{ $member->status === 'active' ? __('Deactivate') : __('Activate') }}
                                                </a>
                                                <a class="dropdown-item" href="#" onclick="event.preventDefault(); if(confirm('{{ __('Are you sure?') }}')) document.getElementById('delete-staff-{{ $member->id }}').submit();">
                                                    <i data-feather="trash" class="me-50"></i>{{ __('Delete') }}
                                                </a>
                                                <form id="delete-staff-{{ $member->id }}" action="{{ route('staff.destroy') }}" method="POST" style="display: none;">
                                                    @csrf
                                                    <input type="hidden" name="id" value="{{ $member->id }}">
                                                </form>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="8" class="text-center text-muted py-4">
                                        {{ __('No staff members found. Add your first staff member using the "Add Staff" button above.') }}
                                    </td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <!-- Pagination -->
                    <div class="d-flex justify-content-center mt-3">
                        {{ $staff->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add Staff Modal -->
<div class="modal fade" id="addStaffModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Add New Staff Member') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="{{ route('staff.store') }}">
                @csrf
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('Full Name') }}*</label>
                            <input type="text" name="staff_name" class="form-control" required placeholder="{{ __('Enter staff name') }}">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('Email Address') }}*</label>
                            <input type="email" name="staff_email" class="form-control" required placeholder="{{ __('staff@example.com') }}">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('Phone Number') }}</label>
                            <input type="text" name="staff_phone" class="form-control" placeholder="+1234567890">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('WhatsApp Device') }}*</label>
                            <select name="device_id" class="form-select" required>
                                <option value="">{{ __('Select Device') }}</option>
                                @foreach($devices as $device)
                                    <option value="{{ $device->id }}" {{ $device->id == $device_id ? 'selected' : '' }}>
                                        {{ $device->sender }} - {{ $device->phone_number }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('Role') }}*</label>
                            <select name="role" class="form-select" id="staffRole" onchange="updatePermissions()" required>
                                <option value="viewer">{{ __('Viewer') }} - {{ __('Can only view tickets') }}</option>
                                <option value="operator" selected>{{ __('Operator') }} - {{ __('Can view and reply to tickets') }}</option>
                                <option value="manager">{{ __('Manager') }} - {{ __('Full access') }}</option>
                            </select>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('Status') }}</label>
                            <select name="status" class="form-select">
                                <option value="active" selected>{{ __('Active') }}</option>
                                <option value="inactive">{{ __('Inactive') }}</option>
                            </select>
                        </div>
                    </div>
                    <div class="mb-3" id="permissionsSection">
                        <label class="form-label">{{ __('Permissions') }}</label>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="view_tickets" id="perm_view" checked>
                                    <label class="form-check-label" for="perm_view">{{ __('View Tickets') }}</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="reply_tickets" id="perm_reply" checked>
                                    <label class="form-check-label" for="perm_reply">{{ __('Reply to Tickets') }}</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="close_tickets" id="perm_close">
                                    <label class="form-check-label" for="perm_close">{{ __('Close Tickets') }}</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="manage_contacts" id="perm_contacts">
                                    <label class="form-check-label" for="perm_contacts">{{ __('Manage Contacts') }}</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="view_analytics" id="perm_analytics">
                                    <label class="form-check-label" for="perm_analytics">{{ __('View Analytics') }}</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="send_messages" id="perm_send">
                                    <label class="form-check-label" for="perm_send">{{ __('Send Messages') }}</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('Add Staff Member') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Staff Modal -->
<div class="modal fade" id="editStaffModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Edit Staff Member') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="{{ route('staff.update') }}">
                @csrf
                <input type="hidden" name="id" id="edit_staff_id">
                <div class="modal-body">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('Full Name') }}*</label>
                            <input type="text" name="staff_name" id="edit_staff_name" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('Email Address') }}*</label>
                            <input type="email" name="staff_email" id="edit_staff_email" class="form-control" required>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('Phone Number') }}</label>
                            <input type="text" name="staff_phone" id="edit_staff_phone" class="form-control">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('Role') }}*</label>
                            <select name="role" id="edit_staff_role" class="form-select" onchange="updateEditPermissions()" required>
                                <option value="viewer">{{ __('Viewer') }}</option>
                                <option value="operator">{{ __('Operator') }}</option>
                                <option value="manager">{{ __('Manager') }}</option>
                            </select>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('Status') }}</label>
                            <select name="status" id="edit_staff_status" class="form-select">
                                <option value="active">{{ __('Active') }}</option>
                                <option value="inactive">{{ __('Inactive') }}</option>
                                <option value="suspended">{{ __('Suspended') }}</option>
                            </select>
                        </div>
                    </div>
                    <div class="mb-3" id="editPermissionsSection">
                        <label class="form-label">{{ __('Permissions') }}</label>
                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="view_tickets" id="edit_perm_view">
                                    <label class="form-check-label" for="edit_perm_view">{{ __('View Tickets') }}</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="reply_tickets" id="edit_perm_reply">
                                    <label class="form-check-label" for="edit_perm_reply">{{ __('Reply to Tickets') }}</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="close_tickets" id="edit_perm_close">
                                    <label class="form-check-label" for="edit_perm_close">{{ __('Close Tickets') }}</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="manage_contacts" id="edit_perm_contacts">
                                    <label class="form-check-label" for="edit_perm_contacts">{{ __('Manage Contacts') }}</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="view_analytics" id="edit_perm_analytics">
                                    <label class="form-check-label" for="edit_perm_analytics">{{ __('View Analytics') }}</label>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="permissions[]" value="send_messages" id="edit_perm_send">
                                    <label class="form-check-label" for="edit_perm_send">{{ __('Send Messages') }}</label>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('Update Staff Member') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>

<script>
function updatePermissions() {
    const role = document.getElementById('staffRole').value;
    const permSection = document.getElementById('permissionsSection');
    
    if (role === 'manager') {
        permSection.style.display = 'none';
    } else {
        permSection.style.display = 'block';
        
        if (role === 'viewer') {
            document.getElementById('perm_view').checked = true;
            document.getElementById('perm_reply').checked = false;
            document.getElementById('perm_close').checked = false;
        } else if (role === 'operator') {
            document.getElementById('perm_view').checked = true;
            document.getElementById('perm_reply').checked = true;
        }
    }
}

function updateEditPermissions() {
    const role = document.getElementById('edit_staff_role').value;
    const permSection = document.getElementById('editPermissionsSection');
    
    if (role === 'manager') {
        permSection.style.display = 'none';
    } else {
        permSection.style.display = 'block';
    }
}

function editStaff(id, name, email, phone, deviceId, role, status, permissions) {
    document.getElementById('edit_staff_id').value = id;
    document.getElementById('edit_staff_name').value = name;
    document.getElementById('edit_staff_email').value = email;
    document.getElementById('edit_staff_phone').value = phone || '';
    document.getElementById('edit_staff_role').value = role;
    document.getElementById('edit_staff_status').value = status;
    
    // Clear all checkboxes
    document.querySelectorAll('#editPermissionsSection input[type="checkbox"]').forEach(cb => cb.checked = false);
    
    // Check permissions
    if (permissions && Array.isArray(permissions)) {
        permissions.forEach(perm => {
            const checkbox = document.querySelector(`#editPermissionsSection input[value="${perm}"]`);
            if (checkbox) checkbox.checked = true;
        });
    }
    
    updateEditPermissions();
    
    const modal = new bootstrap.Modal(document.getElementById('editStaffModal'));
    modal.show();
}
</script>

@include('layouts.footer')
