@include('layouts.header')

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-body">
            <!-- job list start -->
            <section class="app-job-list">
                <!-- list and filter start -->
                <div class="card">
                    <h5 class="card-header">
                        <div class="input-group input-group-sm position-relative mx-auto">
                            {{ __('Subscriber list') }}<span class="badge badge-light-secondary ms-2">{{DB::table('subscribers')->where('user_id',Auth::user()->id)->count()}}</span>
                            <input type="search" class="form-control" id="search" value="{{!empty($_GET['search']) ? $_GET['search'] : ''}}" placeholder="{{__('Search')}}..." />
                            <button type="button" class="btn btn-sm btn-primary" id="searchbtn"><i data-feather="search" class="me-0"></i></button>
                            <a class="btn btn-sm btn-success" href="{{ route('subscriber.export') }}"><i data-feather="external-link" class="me-0"></i> {{ strtoupper(__('Export')) }}</a>
                        </div>
                    </h5>
                    <div class="card-body">
                        <div class="table-responsive table-responsive">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <!-- <th> {{ __('Device') }} </th> -->
                                        <th> {{ __('Name') }} </th>
                                        <th> {{ __('Phone') }} </th>
                                        <th> {{ __('Subscribe') }} </th>
                                        <th> {{ __('Updated at') }} </th>
                                        <th> {{ __('Actions') }} </th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($subscribers as $subscriber)
                                    <tr>
                                        <!-- <td><a href="javascript:;" data-bs-target="#edit-{{$subscriber->id}}" data-bs-toggle="modal">
                                        {{ $subscriber->sender }}</a>
                                        </td> -->
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$subscriber->id}}" data-bs-toggle="modal">
                                        {{ $subscriber->name }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$subscriber->id}}" data-bs-toggle="modal">
                                        {{ $subscriber->phone }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$subscriber->id}}" data-bs-toggle="modal">
                                        <span class="badge rounded-pill badge-light-{{$subscriber->status?'success':'danger'}} me-1">{{ $subscriber->status ? __('YES') : __('NO') }}</span></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$subscriber->id}}" data-bs-toggle="modal">
                                        {{ $subscriber->updated_at }}</a>
                                        </td>
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton">
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit-{{$subscriber->id}}"><i data-feather="edit" class="me-0"></i> {{__('Edit')}}</a>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-{{$subscriber->id}}"><i data-feather="trash" class="me-0"></i> {{__('Delete')}}</a>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-{{$subscriber->id}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    {{ __('Are you sure you want to delete?') }} <br><br>
                                                    <span class="text text-danger"> <b>{{ $subscriber->name }}</b> </span><br><br>
                                                    {{ __('This process is irreversible') }} <br>
                                                    {{ __('The record(s) will be deleted from the database permanently') }}
                                                </div>
                                                <div class="modal-footer">
                                                <a class="btn btn-sm btn-danger" href="{{ route('subscriber.destroy', ['subscriber_id' => $subscriber->id]) }}">{{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Edit Subscriber Modal -->
                                    <div class="modal fade" id="edit-{{$subscriber->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-subscriber">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1">{{ __('Edit subscriber') }}</h1>
                                                    </div>
                                                    <form action="{{ route('subscriber.update') }}" method="POST" id="editSubscriberForm" class="row gy-1 pt-75" enctype="multipart/form-data">
                                                        @csrf
                                                        <div class="row">
                                                            <!-- <div class="col-12 col-md-6"> -->
                                                                <input type="hidden"  name="subscriber_id" value="{{ $subscriber->id }}" />
                                                                <!-- <label class="form-label" for="sender">{{ __('Device') }}</label>
                                                                <input type="text" name="sender" class="form-control" value="{{ $subscriber->sender }}" />
                                                            </div> -->
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="name">{{ __('Name') }}</label>
                                                                <input type="text" name="name" class="form-control" value="{{ $subscriber->name }}" />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="phone">{{ __('Phone') }}</label>
                                                                <input type="text" name="phone" class="form-control" value="{{ $subscriber->phone }}" />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="status">{{ __('Status') }}</label>
                                                                <select name="status" class="form-select">
                                                                    <option value="1" {{ $subscriber->status ? 'selected' : '' }}>{{ __('YES') }}</option>
                                                                    <option value="0" {{ !$subscriber->status ? 'selected' : '' }}>{{ __('NO') }}</option>
                                                                </select>
                                                            </div>
                                                            <div class="col-12 text-center mt-2 pt-50">
                                                                <button type="submit" class="btn btn-primary me-1">{{ __('Save') }}</button>
                                                                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Cancel') }}</button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Edit Subscriber Modal -->
                                    @endforeach
                                    {{ $subscribers->links() }}
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- list and filter end -->
            </section>
            <!-- jobs list ends -->
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
function search() {
    var url = '{{url()->current()}}' + '?search=' + $('#search').val();
    location.href= url;
}
$('#searchbtn').click(function (e) {
    search();
})
$('#search').keydown(function (e) {
    if (e.which == 13) {
        search();
    }
})
</script>

@include('layouts.footer')
