@include('layouts.header')

@php
App::setLocale(Auth::user()->lang);
@endphp

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-body">
            <section class="app-agent-create">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ __('Create Agent') }}</h4>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('support.agents.store') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-md-6 mb-2">
                                    <label class="form-label" for="user_id">{{ __('User') }} *</label>
                                    <select name="user_id" id="user_id" class="form-select" required>
                                        <option value="">{{ __('Select User') }}</option>
                                        @if($availableUsers->count() > 0)
                                            <optgroup label="{{ __('System Users') }}">
                                                @foreach($availableUsers as $user)
                                                <option value="{{ $user->id }}">{{ $user->name }} ({{ $user->email }})</option>
                                                @endforeach
                                            </optgroup>
                                        @endif
                                        @if(isset($staffMembers) && $staffMembers->count() > 0)
                                            <optgroup label="{{ __('Staff Members') }}">
                                                @foreach($staffMembers as $staff)
                                                <option value="staff_{{ $staff->id }}" data-staff-id="{{ $staff->id }}" data-staff-name="{{ $staff->staff_name }}" data-staff-email="{{ $staff->staff_email }}">
                                                    {{ $staff->staff_name }} ({{ $staff->staff_email }}) - {{ ucfirst($staff->role) }}
                                                </option>
                                                @endforeach
                                            </optgroup>
                                        @endif
                                    </select>
                                    @if($availableUsers->count() === 0 && (!isset($staffMembers) || $staffMembers->count() === 0))
                                        <small class="text-muted">{{ __('No users or staff available. All have been assigned as agents.') }}</small>
                                    @endif
                                </div>
                                <div class="col-md-6 mb-2">
                                    <label class="form-label" for="role">{{ __('Role') }} *</label>
                                    <select name="role" id="role" class="form-select" required>
                                        <option value="agent">{{ __('Agent') }}</option>
                                        <option value="supervisor">{{ __('Supervisor') }}</option>
                                        <option value="admin">{{ __('Admin') }}</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-2">
                                    <label class="form-label" for="max_tickets">{{ __('Max Tickets') }} *</label>
                                    <input type="number" name="max_tickets" id="max_tickets" class="form-control" value="10" min="1" max="50" required>
                                    <small class="text-muted">{{ __('Maximum concurrent tickets (recommended: 5-15)') }}</small>
                                </div>
                                <div class="col-md-6 mb-2">
                                    <label class="form-label">{{ __('Settings') }}</label>
                                    <div class="form-check">
                                        <input type="hidden" name="auto_assign" value="0">
                                        <input type="checkbox" name="auto_assign" value="1" class="form-check-input" id="auto_assign" checked>
                                        <label class="form-check-label" for="auto_assign">{{ __('Enable Auto Assignment') }}</label>
                                    </div>
                                </div>
                                <div class="col-12 mb-2">
                                    <label class="form-label">{{ __('Permissions (Optional)') }}</label>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-check">
                                                <input type="checkbox" name="permissions[]" value="technical_support" class="form-check-input" id="perm_tech">
                                                <label class="form-check-label" for="perm_tech">{{ __('Technical Support') }}</label>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-check">
                                                <input type="checkbox" name="permissions[]" value="billing" class="form-check-input" id="perm_billing">
                                                <label class="form-check-label" for="perm_billing">{{ __('Billing') }}</label>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-check">
                                                <input type="checkbox" name="permissions[]" value="sales" class="form-check-input" id="perm_sales">
                                                <label class="form-check-label" for="perm_sales">{{ __('Sales') }}</label>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-check">
                                                <input type="checkbox" name="permissions[]" value="customer_service" class="form-check-input" id="perm_cs">
                                                <label class="form-check-label" for="perm_cs">{{ __('Customer Service') }}</label>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="form-check">
                                                <input type="checkbox" name="permissions[]" value="escalations" class="form-check-input" id="perm_esc">
                                                <label class="form-check-label" for="perm_esc">{{ __('Escalations') }}</label>
                                            </div>
                                        </div>
                                    </div>
                                    <small class="text-muted">{{ __('Select expertise areas for smart ticket routing') }}</small>
                                </div>
                            </div>
                            <div class="mt-3">
                                <button type="submit" class="btn btn-primary">
                                    <i data-feather="save"></i> {{ __('Create Agent') }}
                                </button>
                                <a href="{{ route('support.agents.index') }}" class="btn btn-outline-secondary">
                                    {{ __('Cancel') }}
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

@include('layouts.footer')
