@include('layouts.header')

@php
App::setLocale(Auth::user()->lang);
@endphp

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <!-- Statistics -->
        <div class="row">
            <div class="col-lg-4 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $statistics['total'] }}</h3>
                            <span>{{ __('Total Agents') }}</span>
                        </div>
                        <div class="avatar bg-light-primary p-50">
                            <span class="avatar-content">
                                <i data-feather="users" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $statistics['online'] }}</h3>
                            <span>{{ __('Online Now') }}</span>
                        </div>
                        <div class="avatar bg-light-success p-50">
                            <span class="avatar-content">
                                <i data-feather="user-check" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $statistics['available'] }}</h3>
                            <span>{{ __('Available') }}</span>
                        </div>
                        <div class="avatar bg-light-info p-50">
                            <span class="avatar-content">
                                <i data-feather="headphones" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-body">
            <section class="app-agent-list">
                <div class="card">
                    <div class="card-header border-bottom">
                        <h4 class="card-title">{{ __('Support Agents') }}</h4>
                        <a href="{{ route('support.agents.create') }}" class="btn btn-primary">
                            <i data-feather="plus" class="me-25"></i>
                            <span>{{ __('Add Agent') }}</span>
                        </a>
                    </div>
                    <div class="card-body">
                        <!-- Filters -->
                        <form method="GET" action="{{ route('support.agents.index') }}" class="mb-2">
                            <div class="row">
                                <div class="col-md-4 mb-1">
                                    <select name="status" class="form-select" onchange="this.form.submit()">
                                        <option value="all">{{ __('All Status') }}</option>
                                        <option value="online" {{ request('status') == 'online' ? 'selected' : '' }}>{{ __('Online') }}</option>
                                        <option value="offline" {{ request('status') == 'offline' ? 'selected' : '' }}>{{ __('Offline') }}</option>
                                        <option value="busy" {{ request('status') == 'busy' ? 'selected' : '' }}>{{ __('Busy') }}</option>
                                        <option value="away" {{ request('status') == 'away' ? 'selected' : '' }}>{{ __('Away') }}</option>
                                    </select>
                                </div>
                                <div class="col-md-4 mb-1">
                                    <select name="role" class="form-select" onchange="this.form.submit()">
                                        <option value="all">{{ __('All Roles') }}</option>
                                        <option value="agent" {{ request('role') == 'agent' ? 'selected' : '' }}>{{ __('Agent') }}</option>
                                        <option value="supervisor" {{ request('role') == 'supervisor' ? 'selected' : '' }}>{{ __('Supervisor') }}</option>
                                        <option value="admin" {{ request('role') == 'admin' ? 'selected' : '' }}>{{ __('Admin') }}</option>
                                    </select>
                                </div>
                            </div>
                        </form>

                        <!-- Agents Table -->
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>{{ __('Agent') }}</th>
                                        <th>{{ __('Role') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Active Tickets') }}</th>
                                        <th>{{ __('Max Tickets') }}</th>
                                        <th>{{ __('Auto Assign') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($agents as $agent)
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar me-1 {{ $agent->status == 'online' ? 'bg-light-success' : 'bg-light-secondary' }}">
                                                    <span class="avatar-content">{{ substr($agent->user->name, 0, 2) }}</span>
                                                </div>
                                                <div>
                                                    <div class="fw-bold">{{ $agent->user->name }}</div>
                                                    <small class="text-muted">{{ $agent->user->email }}</small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            @php
                                                $roleColors = [
                                                    'agent' => 'info',
                                                    'supervisor' => 'warning',
                                                    'admin' => 'danger'
                                                ];
                                            @endphp
                                            <span class="badge bg-{{ $roleColors[$agent->role] ?? 'secondary' }}">{{ ucfirst($agent->role) }}</span>
                                        </td>
                                        <td>
                                            @php
                                                $statusColors = [
                                                    'online' => 'success',
                                                    'offline' => 'secondary',
                                                    'busy' => 'danger',
                                                    'away' => 'warning'
                                                ];
                                            @endphp
                                            <span class="badge bg-{{ $statusColors[$agent->status] ?? 'secondary' }}">{{ ucfirst($agent->status) }}</span>
                                        </td>
                                        <td>
                                            <span class="badge bg-primary">{{ $agent->current_tickets }}</span>
                                        </td>
                                        <td>{{ $agent->max_tickets }}</td>
                                        <td>
                                            @if($agent->auto_assign)
                                                <i data-feather="check-circle" class="text-success"></i>
                                            @else
                                                <i data-feather="x-circle" class="text-muted"></i>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="dropdown">
                                                <button type="button" class="btn btn-sm btn-icon" data-bs-toggle="dropdown">
                                                    <i data-feather="more-vertical"></i>
                                                </button>
                                                <div class="dropdown-menu">
                                                    <a class="dropdown-item" href="{{ route('support.agents.show', $agent->id) }}">
                                                        <i data-feather="eye" class="me-50"></i>
                                                        <span>{{ __('View') }}</span>
                                                    </a>
                                                    <a class="dropdown-item" href="{{ route('support.agents.edit', $agent->id) }}">
                                                        <i data-feather="edit" class="me-50"></i>
                                                        <span>{{ __('Edit') }}</span>
                                                    </a>
                                                    <div class="dropdown-divider"></div>
                                                    <form action="{{ route('support.agents.updateStatus', $agent->id) }}" method="POST">
                                                        @csrf
                                                        <input type="hidden" name="status" value="{{ $agent->status == 'online' ? 'offline' : 'online' }}">
                                                        <button type="submit" class="dropdown-item">
                                                            <i data-feather="power" class="me-50"></i>
                                                            <span>{{ $agent->status == 'online' ? __('Go Offline') : __('Go Online') }}</span>
                                                        </button>
                                                    </form>
                                                    <div class="dropdown-divider"></div>
                                                    <a class="dropdown-item text-danger" href="{{ route('support.agents.destroy', $agent->id) }}" 
                                                       onclick="return confirm('{{ __('Are you sure?') }}')">
                                                        <i data-feather="trash" class="me-50"></i>
                                                        <span>{{ __('Delete') }}</span>
                                                    </a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="7" class="text-center py-3">
                                            <p class="mb-0">{{ __('No agents found') }}</p>
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center">
                            {{ $agents->links() }}
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

@include('layouts.footer')
