@include('layouts.header')

@php
App::setLocale(Auth::user()->lang);
@endphp

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-body">
            <section class="app-lead-create">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ __('Create Lead') }}</h4>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('support.leads.store') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-md-6 mb-2">
                                    <label class="form-label" for="customer_phone">{{ __('Phone Number') }} *</label>
                                    <input type="text" name="customer_phone" id="customer_phone" class="form-control" required>
                                </div>
                                <div class="col-md-6 mb-2">
                                    <label class="form-label" for="customer_name">{{ __('Customer Name') }}</label>
                                    <input type="text" name="customer_name" id="customer_name" class="form-control">
                                </div>
                                <div class="col-md-6 mb-2">
                                    <label class="form-label" for="customer_email">{{ __('Email') }}</label>
                                    <input type="email" name="customer_email" id="customer_email" class="form-control">
                                </div>
                                <div class="col-md-6 mb-2">
                                    <label class="form-label" for="source">{{ __('Source') }} *</label>
                                    <select name="source" id="source" class="form-select" required>
                                        <option value="whatsapp">WhatsApp</option>
                                        <option value="manual">Manual</option>
                                        <option value="website">Website</option>
                                        <option value="referral">Referral</option>
                                        <option value="other">Other</option>
                                    </select>
                                </div>
                                <div class="col-md-6 mb-2">
                                    <label class="form-label" for="lead_score">{{ __('Lead Score') }}</label>
                                    <input type="number" name="lead_score" id="lead_score" class="form-control" value="50" min="0" max="100">
                                    <small class="text-muted">{{ __('0-100, default: 50') }}</small>
                                </div>
                                <div class="col-12 mb-2">
                                    <label class="form-label" for="notes">{{ __('Initial Notes') }}</label>
                                    <textarea name="notes" id="notes" class="form-control" rows="3"></textarea>
                                </div>
                            </div>
                            <div class="mt-3">
                                <button type="submit" class="btn btn-primary">
                                    <i data-feather="save"></i> {{ __('Create Lead') }}
                                </button>
                                <a href="{{ route('support.leads.index') }}" class="btn btn-outline-secondary">
                                    {{ __('Cancel') }}
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

@include('layouts.footer')
