@include('layouts.header')

@php
App::setLocale(Auth::user()->lang);
@endphp

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <!-- Statistics -->
        <div class="row">
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $statistics['total'] }}</h3>
                            <span>{{ __('Total Leads') }}</span>
                        </div>
                        <div class="avatar bg-light-primary p-50">
                            <span class="avatar-content">
                                <i data-feather="target" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $statistics['new'] }}</h3>
                            <span>{{ __('New Leads') }}</span>
                        </div>
                        <div class="avatar bg-light-info p-50">
                            <span class="avatar-content">
                                <i data-feather="user-plus" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $statistics['qualified'] }}</h3>
                            <span>{{ __('Qualified') }}</span>
                        </div>
                        <div class="avatar bg-light-warning p-50">
                            <span class="avatar-content">
                                <i data-feather="award" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $statistics['converted'] }}</h3>
                            <span>{{ __('Converted') }}</span>
                        </div>
                        <div class="avatar bg-light-success p-50">
                            <span class="avatar-content">
                                <i data-feather="check-circle" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-body">
            <section class="app-lead-list">
                <div class="card">
                    <div class="card-header border-bottom">
                        <h4 class="card-title">{{ __('Leads') }}</h4>
                        <a href="{{ route('support.leads.create') }}" class="btn btn-primary">
                            <i data-feather="plus" class="me-25"></i>
                            <span>{{ __('Add Lead') }}</span>
                        </a>
                    </div>
                    <div class="card-body">
                        <!-- Filters -->
                        <form method="GET" action="{{ route('support.leads.index') }}" class="mb-2">
                            <div class="row">
                                <div class="col-md-3 mb-1">
                                    <select name="status" class="form-select" onchange="this.form.submit()">
                                        <option value="all">{{ __('All Status') }}</option>
                                        <option value="new" {{ request('status') == 'new' ? 'selected' : '' }}>{{ __('New') }}</option>
                                        <option value="contacted" {{ request('status') == 'contacted' ? 'selected' : '' }}>{{ __('Contacted') }}</option>
                                        <option value="qualified" {{ request('status') == 'qualified' ? 'selected' : '' }}>{{ __('Qualified') }}</option>
                                        <option value="proposal" {{ request('status') == 'proposal' ? 'selected' : '' }}>{{ __('Proposal') }}</option>
                                        <option value="negotiation" {{ request('status') == 'negotiation' ? 'selected' : '' }}>{{ __('Negotiation') }}</option>
                                        <option value="converted" {{ request('status') == 'converted' ? 'selected' : '' }}>{{ __('Converted') }}</option>
                                        <option value="lost" {{ request('status') == 'lost' ? 'selected' : '' }}>{{ __('Lost') }}</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mb-1">
                                    <select name="assigned_to" class="form-select" onchange="this.form.submit()">
                                        <option value="all">{{ __('All Leads') }}</option>
                                        <option value="unassigned" {{ request('assigned_to') == 'unassigned' ? 'selected' : '' }}>{{ __('Unassigned') }}</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mb-1">
                                    <select name="min_score" class="form-select" onchange="this.form.submit()">
                                        <option value="">{{ __('All Scores') }}</option>
                                        <option value="70" {{ request('min_score') == '70' ? 'selected' : '' }}>{{ __('High Score (70+)') }}</option>
                                        <option value="50" {{ request('min_score') == '50' ? 'selected' : '' }}>{{ __('Medium Score (50+)') }}</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mb-1">
                                    <input type="text" name="search" class="form-control" placeholder="{{ __('Search...') }}" value="{{ request('search') }}">
                                </div>
                            </div>
                        </form>

                        <!-- Leads Table -->
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>{{ __('Customer') }}</th>
                                        <th>{{ __('Source') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Score') }}</th>
                                        <th>{{ __('Assigned To') }}</th>
                                        <th>{{ __('Last Contact') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($leads as $lead)
                                    <tr>
                                        <td>
                                            <div>{{ $lead->customer_name ?? __('Unknown') }}</div>
                                            <small class="text-muted">{{ $lead->customer_phone }}</small>
                                        </td>
                                        <td>{{ ucfirst($lead->source) }}</td>
                                        <td>
                                            @php
                                                $statusColors = [
                                                    'new' => 'info',
                                                    'contacted' => 'primary',
                                                    'qualified' => 'warning',
                                                    'proposal' => 'secondary',
                                                    'negotiation' => 'dark',
                                                    'converted' => 'success',
                                                    'lost' => 'danger'
                                                ];
                                            @endphp
                                            <span class="badge bg-{{ $statusColors[$lead->status] ?? 'secondary' }}">{{ ucfirst($lead->status) }}</span>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="progress flex-grow-1 me-1" style="height: 6px; width: 50px;">
                                                    @php
                                                        $scoreColor = $lead->lead_score >= 70 ? 'success' : ($lead->lead_score >= 50 ? 'warning' : 'danger');
                                                    @endphp
                                                    <div class="progress-bar bg-{{ $scoreColor }}" style="width: {{ $lead->lead_score }}%"></div>
                                                </div>
                                                <span class="text-muted">{{ $lead->lead_score }}</span>
                                            </div>
                                        </td>
                                        <td>
                                            @if($lead->assignedAgent)
                                                {{ $lead->assignedAgent->name }}
                                            @else
                                                <span class="text-muted">{{ __('Unassigned') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($lead->last_contact_at)
                                                <small>{{ $lead->last_contact_at->diffForHumans() }}</small>
                                            @else
                                                <span class="text-muted">{{ __('Never') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="dropdown">
                                                <button type="button" class="btn btn-sm btn-icon" data-bs-toggle="dropdown">
                                                    <i data-feather="more-vertical"></i>
                                                </button>
                                                <div class="dropdown-menu">
                                                    <a class="dropdown-item" href="{{ route('support.leads.show', $lead->id) }}">
                                                        <i data-feather="eye" class="me-50"></i>
                                                        <span>{{ __('View') }}</span>
                                                    </a>
                                                    @if($lead->status == 'new')
                                                    <form action="{{ route('support.leads.qualify', $lead->id) }}" method="POST">
                                                        @csrf
                                                        <button type="submit" class="dropdown-item">
                                                            <i data-feather="check" class="me-50"></i>
                                                            <span>{{ __('Qualify') }}</span>
                                                        </button>
                                                    </form>
                                                    @endif
                                                    @if($lead->isActive())
                                                    <form action="{{ route('support.leads.convert', $lead->id) }}" method="POST">
                                                        @csrf
                                                        <button type="submit" class="dropdown-item text-success">
                                                            <i data-feather="check-circle" class="me-50"></i>
                                                            <span>{{ __('Convert') }}</span>
                                                        </button>
                                                    </form>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="7" class="text-center py-3">
                                            <p class="mb-0">{{ __('No leads found') }}</p>
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center">
                            {{ $leads->links() }}
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

@include('layouts.footer')
