@include('layouts.header')

@php
App::setLocale(Auth::user()->lang);
@endphp

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-body">
            <section class="app-lead-view">
                <div class="card">
                    <div class="card-header border-bottom">
                        <div class="d-flex justify-content-between align-items-center w-100">
                            <h4 class="card-title mb-0">{{ __('Lead Details') }}</h4>
                            <div class="d-flex gap-1">
                                @php
                                    $statusColors = [
                                        'new' => 'info',
                                        'contacted' => 'primary',
                                        'qualified' => 'warning',
                                        'proposal' => 'secondary',
                                        'negotiation' => 'dark',
                                        'converted' => 'success',
                                        'lost' => 'danger'
                                    ];
                                @endphp
                                <span class="badge bg-{{ $statusColors[$lead->status] ?? 'secondary' }}">{{ ucfirst($lead->status) }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8">
                                <!-- Customer Information -->
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="mb-0">{{ __('Customer Information') }}</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <p><strong>{{ __('Name') }}:</strong> {{ $lead->customer_name ?? __('Not provided') }}</p>
                                                <p><strong>{{ __('Phone') }}:</strong> {{ $lead->customer_phone }}</p>
                                                <p><strong>{{ __('Email') }}:</strong> {{ $lead->customer_email ?? __('Not provided') }}</p>
                                            </div>
                                            <div class="col-md-6">
                                                <p><strong>{{ __('Source') }}:</strong> {{ ucfirst($lead->source) }}</p>
                                                <p><strong>{{ __('Lead Score') }}:</strong>
                                                    <div class="progress" style="height: 20px;">
                                                        @php
                                                            $scoreColor = $lead->lead_score >= 70 ? 'success' : ($lead->lead_score >= 50 ? 'warning' : 'danger');
                                                        @endphp
                                                        <div class="progress-bar bg-{{ $scoreColor }}" style="width: {{ $lead->lead_score }}%">
                                                            {{ $lead->lead_score }}/100
                                                        </div>
                                                    </div>
                                                </p>
                                                <p><strong>{{ __('Created') }}:</strong> {{ $lead->created_at->format('M d, Y H:i') }}</p>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Notes -->
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="mb-0">{{ __('Notes & Activity') }}</h5>
                                    </div>
                                    <div class="card-body">
                                        @if($lead->notes && count($lead->notes) > 0)
                                            <div class="timeline">
                                                @foreach($lead->notes as $note)
                                                <div class="timeline-item mb-3">
                                                    <div class="d-flex">
                                                        <div class="avatar bg-light-primary me-2">
                                                            <i data-feather="message-square"></i>
                                                        </div>
                                                        <div class="flex-grow-1">
                                                            <p class="mb-1">{{ $note['note'] }}</p>
                                                            <small class="text-muted">{{ $note['timestamp'] }}</small>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endforeach
                                            </div>
                                        @else
                                            <p class="text-muted">{{ __('No notes yet') }}</p>
                                        @endif

                                        <!-- Add Note Form -->
                                        <form action="{{ route('support.leads.note', $lead->id) }}" method="POST" class="mt-3">
                                            @csrf
                                            <div class="mb-2">
                                                <textarea name="note" class="form-control" rows="3" placeholder="{{ __('Add a note...') }}" required></textarea>
                                            </div>
                                            <button type="submit" class="btn btn-sm btn-primary">
                                                <i data-feather="plus"></i> {{ __('Add Note') }}
                                            </button>
                                        </form>
                                    </div>
                                </div>

                                <!-- Custom Fields -->
                                @if($lead->custom_fields && count($lead->custom_fields) > 0)
                                <div class="card">
                                    <div class="card-header">
                                        <h5 class="mb-0">{{ __('Custom Fields') }}</h5>
                                    </div>
                                    <div class="card-body">
                                        @foreach($lead->custom_fields as $key => $value)
                                        <p><strong>{{ ucfirst(str_replace('_', ' ', $key)) }}:</strong> {{ $value }}</p>
                                        @endforeach
                                    </div>
                                </div>
                                @endif
                            </div>

                            <div class="col-md-4">
                                <!-- Actions -->
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="mb-0">{{ __('Actions') }}</h6>
                                    </div>
                                    <div class="card-body">
                                        @if($lead->status == 'new')
                                        <form action="{{ route('support.leads.qualify', $lead->id) }}" method="POST" class="mb-2">
                                            @csrf
                                            <button type="submit" class="btn btn-warning w-100">
                                                <i data-feather="check"></i> {{ __('Qualify Lead') }}
                                            </button>
                                        </form>
                                        @endif

                                        @if($lead->isActive())
                                        <form action="{{ route('support.leads.convert', $lead->id) }}" method="POST" class="mb-2">
                                            @csrf
                                            <div class="mb-2">
                                                <textarea name="conversion_note" class="form-control" rows="2" placeholder="{{ __('Conversion note (optional)') }}"></textarea>
                                            </div>
                                            <button type="submit" class="btn btn-success w-100">
                                                <i data-feather="check-circle"></i> {{ __('Convert Lead') }}
                                            </button>
                                        </form>

                                        <form action="{{ route('support.leads.lost', $lead->id) }}" method="POST" class="mb-2">
                                            @csrf
                                            <div class="mb-2">
                                                <input type="text" name="reason" class="form-control" placeholder="{{ __('Reason (optional)') }}">
                                            </div>
                                            <button type="submit" class="btn btn-danger w-100">
                                                <i data-feather="x-circle"></i> {{ __('Mark as Lost') }}
                                            </button>
                                        </form>
                                        @endif

                                        <a href="{{ route('support.leads.edit', $lead->id) }}" class="btn btn-outline-primary w-100 mb-2">
                                            <i data-feather="edit"></i> {{ __('Edit Lead') }}
                                        </a>
                                    </div>
                                </div>

                                <!-- Assignment -->
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="mb-0">{{ __('Assignment') }}</h6>
                                    </div>
                                    <div class="card-body">
                                        @if($lead->assignedAgent)
                                        <p><strong>{{ __('Assigned To') }}:</strong><br>{{ $lead->assignedAgent->name }}</p>
                                        @endif
                                        
                                        <form action="{{ route('support.leads.assign', $lead->id) }}" method="POST">
                                            @csrf
                                            <div class="mb-2">
                                                <select name="agent_id" class="form-select" required>
                                                    <option value="">{{ __('Select Agent') }}</option>
                                                    @foreach($availableAgents as $agent)
                                                    <option value="{{ $agent->user_id }}" {{ $lead->assigned_to == $agent->user_id ? 'selected' : '' }}>
                                                        {{ $agent->user->name }}
                                                    </option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <button type="submit" class="btn btn-sm btn-primary w-100">{{ __('Assign') }}</button>
                                        </form>
                                    </div>
                                </div>

                                <!-- Lead Score Adjustment -->
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="mb-0">{{ __('Adjust Score') }}</h6>
                                    </div>
                                    <div class="card-body">
                                        <form action="{{ route('support.leads.score', $lead->id) }}" method="POST">
                                            @csrf
                                            <div class="mb-2">
                                                <label class="form-label">{{ __('Score Change') }}</label>
                                                <select name="score_change" class="form-select" required>
                                                    <option value="10">+10</option>
                                                    <option value="5">+5</option>
                                                    <option value="-5">-5</option>
                                                    <option value="-10">-10</option>
                                                </select>
                                            </div>
                                            <button type="submit" class="btn btn-sm btn-primary w-100">{{ __('Update Score') }}</button>
                                        </form>
                                    </div>
                                </div>

                                <!-- Associated Ticket -->
                                @if($lead->ticket)
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="mb-0">{{ __('Associated Ticket') }}</h6>
                                    </div>
                                    <div class="card-body">
                                        <p><strong>{{ __('Ticket') }}:</strong> {{ $lead->ticket->ticket_number }}</p>
                                        <p><strong>{{ __('Status') }}:</strong> {{ ucfirst($lead->ticket->status) }}</p>
                                        <a href="{{ route('support.tickets.show', $lead->ticket->id) }}" class="btn btn-sm btn-outline-primary w-100">
                                            {{ __('View Ticket') }}
                                        </a>
                                    </div>
                                </div>
                                @endif

                                <!-- Timeline -->
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="mb-0">{{ __('Important Dates') }}</h6>
                                    </div>
                                    <div class="card-body">
                                        <p class="mb-1"><strong>{{ __('Created') }}:</strong><br>
                                            <small>{{ $lead->created_at->format('M d, Y H:i') }}</small>
                                        </p>
                                        @if($lead->last_contact_at)
                                        <p class="mb-1"><strong>{{ __('Last Contact') }}:</strong><br>
                                            <small>{{ $lead->last_contact_at->format('M d, Y H:i') }}</small>
                                        </p>
                                        @endif
                                        @if($lead->converted_at)
                                        <p class="mb-0"><strong>{{ __('Converted') }}:</strong><br>
                                            <small>{{ $lead->converted_at->format('M d, Y H:i') }}</small>
                                        </p>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

@include('layouts.footer')
