@include('layouts.header')

@php
App::setLocale(Auth::user()->lang);
@endphp

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-body">
            <section class="app-ticket-create">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">{{ __('Create Ticket') }}</h4>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('support.tickets.store') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-md-6 mb-2">
                                    <label class="form-label" for="customer_phone">{{ __('Customer Phone') }} *</label>
                                    <input type="text" name="customer_phone" id="customer_phone" class="form-control" required>
                                </div>
                                <div class="col-md-6 mb-2">
                                    <label class="form-label" for="customer_name">{{ __('Customer Name') }}</label>
                                    <input type="text" name="customer_name" id="customer_name" class="form-control">
                                </div>
                                <div class="col-md-6 mb-2">
                                    <label class="form-label" for="customer_email">{{ __('Customer Email') }}</label>
                                    <input type="email" name="customer_email" id="customer_email" class="form-control">
                                </div>
                                <div class="col-md-6 mb-2">
                                    <label class="form-label" for="priority">{{ __('Priority') }} *</label>
                                    <select name="priority" id="priority" class="form-select" required>
                                        <option value="low">{{ __('Low') }}</option>
                                        <option value="medium" selected>{{ __('Medium') }}</option>
                                        <option value="high">{{ __('High') }}</option>
                                        <option value="urgent">{{ __('Urgent') }}</option>
                                    </select>
                                </div>
                                <div class="col-12 mb-2">
                                    <label class="form-label" for="subject">{{ __('Subject') }} *</label>
                                    <input type="text" name="subject" id="subject" class="form-control" required>
                                </div>
                                <div class="col-md-6 mb-2">
                                    <label class="form-label" for="category">{{ __('Category') }}</label>
                                    <input type="text" name="category" id="category" class="form-control" placeholder="{{ __('e.g., technical, billing, general') }}">
                                </div>
                                <div class="col-12 mb-2">
                                    <label class="form-label" for="description">{{ __('Description') }} *</label>
                                    <textarea name="description" id="description" class="form-control" rows="5" required></textarea>
                                </div>
                            </div>
                            <div class="mt-3">
                                <button type="submit" class="btn btn-primary">
                                    <i data-feather="save"></i> {{ __('Create Ticket') }}
                                </button>
                                <a href="{{ route('support.tickets.index') }}" class="btn btn-outline-secondary">
                                    {{ __('Cancel') }}
                                </a>
                            </div>
                        </form>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

@include('layouts.footer')
