@include('layouts.header')

@php
App::setLocale(Auth::user()->lang);
@endphp

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <!-- Statistics Cards -->
        <div class="row">
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $statistics['total'] }}</h3>
                            <span>{{ __('Total Tickets') }}</span>
                        </div>
                        <div class="avatar bg-light-primary p-50">
                            <span class="avatar-content">
                                <i data-feather="inbox" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $statistics['new'] }}</h3>
                            <span>{{ __('New Tickets') }}</span>
                        </div>
                        <div class="avatar bg-light-info p-50">
                            <span class="avatar-content">
                                <i data-feather="alert-circle" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $statistics['open'] }}</h3>
                            <span>{{ __('Open Tickets') }}</span>
                        </div>
                        <div class="avatar bg-light-warning p-50">
                            <span class="avatar-content">
                                <i data-feather="clock" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $statistics['unassigned'] }}</h3>
                            <span>{{ __('Unassigned') }}</span>
                        </div>
                        <div class="avatar bg-light-danger p-50">
                            <span class="avatar-content">
                                <i data-feather="user-x" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="content-body">
            <section class="app-ticket-list">
                <!-- Filters and Action Bar -->
                <div class="card">
                    <div class="card-header border-bottom">
                        <h4 class="card-title">{{ __('Support Tickets') }}</h4>
                        <a href="{{ route('support.tickets.create') }}" class="btn btn-primary">
                            <i data-feather="plus" class="me-25"></i>
                            <span>{{ __('Create Ticket') }}</span>
                        </a>
                    </div>
                    <div class="card-body">
                        <!-- Filters -->
                        <form method="GET" action="{{ route('support.tickets.index') }}" class="mb-2">
                            <div class="row">
                                <div class="col-md-3 mb-1">
                                    <label class="form-label">{{ __('Status') }}</label>
                                    <select name="status" class="form-select" onchange="this.form.submit()">
                                        <option value="all" {{ request('status') == 'all' ? 'selected' : '' }}>{{ __('All Status') }}</option>
                                        <option value="new" {{ request('status') == 'new' ? 'selected' : '' }}>{{ __('New') }}</option>
                                        <option value="open" {{ request('status') == 'open' ? 'selected' : '' }}>{{ __('Open') }}</option>
                                        <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>{{ __('Pending') }}</option>
                                        <option value="resolved" {{ request('status') == 'resolved' ? 'selected' : '' }}>{{ __('Resolved') }}</option>
                                        <option value="closed" {{ request('status') == 'closed' ? 'selected' : '' }}>{{ __('Closed') }}</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mb-1">
                                    <label class="form-label">{{ __('Priority') }}</label>
                                    <select name="priority" class="form-select" onchange="this.form.submit()">
                                        <option value="all" {{ request('priority') == 'all' ? 'selected' : '' }}>{{ __('All Priorities') }}</option>
                                        <option value="low" {{ request('priority') == 'low' ? 'selected' : '' }}>{{ __('Low') }}</option>
                                        <option value="medium" {{ request('priority') == 'medium' ? 'selected' : '' }}>{{ __('Medium') }}</option>
                                        <option value="high" {{ request('priority') == 'high' ? 'selected' : '' }}>{{ __('High') }}</option>
                                        <option value="urgent" {{ request('priority') == 'urgent' ? 'selected' : '' }}>{{ __('Urgent') }}</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mb-1">
                                    <label class="form-label">{{ __('Assignment') }}</label>
                                    <select name="assigned_to" class="form-select" onchange="this.form.submit()">
                                        <option value="all">{{ __('All Tickets') }}</option>
                                        <option value="unassigned" {{ request('assigned_to') == 'unassigned' ? 'selected' : '' }}>{{ __('Unassigned') }}</option>
                                        <option value="{{ Auth::id() }}" {{ request('assigned_to') == Auth::id() ? 'selected' : '' }}>{{ __('My Tickets') }}</option>
                                    </select>
                                </div>
                                <div class="col-md-3 mb-1">
                                    <label class="form-label">{{ __('Search') }}</label>
                                    <input type="text" name="search" class="form-control" placeholder="{{ __('Ticket #, Phone, Name...') }}" value="{{ request('search') }}">
                                </div>
                            </div>
                        </form>

                        <!-- Tickets Table -->
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th>{{ __('Ticket #') }}</th>
                                        <th>{{ __('Customer') }}</th>
                                        <th>{{ __('Subject') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Priority') }}</th>
                                        <th>{{ __('Assigned To') }}</th>
                                        <th>{{ __('Created') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($tickets as $ticket)
                                    <tr>
                                        <td>
                                            <a href="{{ route('support.tickets.show', $ticket->id) }}" class="fw-bold">
                                                {{ $ticket->ticket_number }}
                                            </a>
                                        </td>
                                        <td>
                                            <div>{{ $ticket->customer_name ?? __('Unknown') }}</div>
                                            <small class="text-muted">{{ $ticket->customer_phone }}</small>
                                        </td>
                                        <td>{{ Str::limit($ticket->subject, 40) }}</td>
                                        <td>
                                            @php
                                                $statusColors = [
                                                    'new' => 'info',
                                                    'open' => 'primary',
                                                    'pending' => 'warning',
                                                    'resolved' => 'success',
                                                    'closed' => 'secondary',
                                                    'on_hold' => 'dark'
                                                ];
                                                $color = $statusColors[$ticket->status] ?? 'secondary';
                                            @endphp
                                            <span class="badge bg-{{ $color }}">{{ ucfirst($ticket->status) }}</span>
                                        </td>
                                        <td>
                                            @php
                                                $priorityColors = [
                                                    'low' => 'success',
                                                    'medium' => 'info',
                                                    'high' => 'warning',
                                                    'urgent' => 'danger'
                                                ];
                                                $pColor = $priorityColors[$ticket->priority] ?? 'secondary';
                                            @endphp
                                            <span class="badge bg-{{ $pColor }}">{{ ucfirst($ticket->priority) }}</span>
                                        </td>
                                        <td>
                                            @if($ticket->assignedAgent)
                                                <span class="badge bg-primary">Agent</span>
                                                {{ $ticket->assignedAgent->name }}
                                            @elseif($ticket->assignedStaff)
                                                <span class="badge bg-info">Staff</span>
                                                {{ $ticket->assignedStaff->staff_name }}
                                            @else
                                                <span class="text-muted">{{ __('Unassigned') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <small>{{ $ticket->created_at->diffForHumans() }}</small>
                                        </td>
                                        <td>
                                            <div class="dropdown">
                                                <button type="button" class="btn btn-sm btn-icon" data-bs-toggle="dropdown">
                                                    <i data-feather="more-vertical"></i>
                                                </button>
                                                <div class="dropdown-menu">
                                                    <a class="dropdown-item" href="{{ route('support.tickets.show', $ticket->id) }}">
                                                        <i data-feather="eye" class="me-50"></i>
                                                        <span>{{ __('View') }}</span>
                                                    </a>
                                                    @if(!$ticket->assigned_to)
                                                    <form action="{{ route('support.tickets.accept', $ticket->id) }}" method="POST">
                                                        @csrf
                                                        <button type="submit" class="dropdown-item">
                                                            <i data-feather="user-check" class="me-50"></i>
                                                            <span>{{ __('Accept') }}</span>
                                                        </button>
                                                    </form>
                                                    @endif
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="8" class="text-center py-3">
                                            <p class="mb-0">{{ __('No tickets found') }}</p>
                                        </td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center">
                            {{ $tickets->links() }}
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

@include('layouts.footer')
