@include('layouts.header')

@php
App::setLocale(Auth::user()->lang);
@endphp

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-body">
            <section class="app-ticket-view">
                <!-- Ticket Header -->
                <div class="card">
                    <div class="card-header border-bottom">
                        <div class="d-flex justify-content-between align-items-center w-100">
                            <div>
                                <h4 class="card-title mb-0">{{ $ticket->ticket_number }}</h4>
                                <small class="text-muted">{{ __('Created') }}: {{ $ticket->created_at->format('M d, Y H:i') }}</small>
                            </div>
                            <div class="d-flex gap-1">
                                @php
                                    $statusColors = [
                                        'new' => 'info',
                                        'open' => 'primary',
                                        'pending' => 'warning',
                                        'resolved' => 'success',
                                        'closed' => 'secondary',
                                        'on_hold' => 'dark'
                                    ];
                                    $priorityColors = [
                                        'low' => 'success',
                                        'medium' => 'info',
                                        'high' => 'warning',
                                        'urgent' => 'danger'
                                    ];
                                @endphp
                                <span class="badge bg-{{ $statusColors[$ticket->status] ?? 'secondary' }}">{{ ucfirst($ticket->status) }}</span>
                                <span class="badge bg-{{ $priorityColors[$ticket->priority] ?? 'secondary' }}">{{ ucfirst($ticket->priority) }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-8">
                                <!-- Ticket Subject -->
                                <h5>{{ $ticket->subject }}</h5>
                                <hr>
                                
                                <!-- Customer Info -->
                                <div class="mb-3">
                                    <h6>{{ __('Customer Information') }}</h6>
                                    <p class="mb-0"><strong>{{ __('Name') }}:</strong> {{ $ticket->customer_name ?? __('Unknown') }}</p>
                                    <p class="mb-0"><strong>{{ __('Phone') }}:</strong> {{ $ticket->customer_phone }}</p>
                                    @if($ticket->customer_email)
                                    <p class="mb-0"><strong>{{ __('Email') }}:</strong> {{ $ticket->customer_email }}</p>
                                    @endif
                                </div>

                                <!-- Messages -->
                                <h6 class="mt-3">{{ __('Conversation') }}</h6>
                                <div class="card bg-light">
                                    <div class="card-body" style="max-height: 500px; overflow-y: auto;" id="messages-container">
                                        @foreach($ticket->messages as $message)
                                        <div class="mb-3 {{ $message->isFromAgent() ? 'text-end' : '' }}">
                                            <div class="d-inline-block" style="max-width: 70%;">
                                                <div class="card mb-0 {{ $message->isFromAgent() ? 'bg-primary text-white' : 'bg-white' }}">
                                                    <div class="card-body p-2">
                                                        @if($message->isFromSystem())
                                                            <em class="text-muted small">{{ $message->message }}</em>
                                                        @else
                                                            <p class="mb-0">{{ $message->message }}</p>
                                                            @if($message->hasAttachments())
                                                                <div class="mt-2">
                                                                    @foreach($message->attachments as $attachment)
                                                                    <a href="{{ Storage::url($attachment['path']) }}" target="_blank" class="btn btn-sm btn-outline-secondary">
                                                                        <i data-feather="paperclip"></i> {{ $attachment['filename'] }}
                                                                    </a>
                                                                    @endforeach
                                                                </div>
                                                            @endif
                                                        @endif
                                                        <small class="d-block mt-1 {{ $message->isFromAgent() ? 'text-white-50' : 'text-muted' }}">
                                                            {{ $message->sender_name }} • {{ $message->created_at->format('H:i') }}
                                                        </small>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>

                                <!-- Reply Form -->
                                @if(!in_array($ticket->status, ['closed']))
                                <div class="mt-3">
                                    <form action="{{ route('support.tickets.addMessage', $ticket->id) }}" method="POST" enctype="multipart/form-data">
                                        @csrf
                                        <div class="mb-2">
                                            <label class="form-label">{{ __('Your Reply') }}</label>
                                            <textarea name="message" class="form-control" rows="4" required></textarea>
                                        </div>
                                        <div class="mb-2">
                                            <label class="form-label">{{ __('Attachments') }}</label>
                                            <input type="file" name="attachments[]" class="form-control" multiple>
                                        </div>
                                        <div class="form-check mb-2">
                                            <input type="checkbox" name="is_internal_note" class="form-check-input" id="internalNote">
                                            <label class="form-check-label" for="internalNote">{{ __('Internal Note (not visible to customer)') }}</label>
                                        </div>
                                        <button type="submit" class="btn btn-primary">
                                            <i data-feather="send"></i> {{ __('Send Reply') }}
                                        </button>
                                    </form>
                                </div>
                                @endif
                            </div>

                            <div class="col-md-4">
                                <!-- Ticket Actions -->
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="mb-0">{{ __('Actions') }}</h6>
                                    </div>
                                    <div class="card-body">
                                        @if(!$ticket->assigned_to)
                                        <form action="{{ route('support.tickets.accept', $ticket->id) }}" method="POST" class="mb-2">
                                            @csrf
                                            <button type="submit" class="btn btn-success w-100">
                                                <i data-feather="user-check"></i> {{ __('Accept Ticket') }}
                                            </button>
                                        </form>
                                        @endif

                                        @if($ticket->isOpen())
                                        <form action="{{ route('support.tickets.resolve', $ticket->id) }}" method="POST" class="mb-2">
                                            @csrf
                                            <button type="submit" class="btn btn-primary w-100">
                                                <i data-feather="check-circle"></i> {{ __('Mark as Resolved') }}
                                            </button>
                                        </form>
                                        @endif

                                        @if($ticket->status == 'resolved')
                                        <form action="{{ route('support.tickets.close', $ticket->id) }}" method="POST" class="mb-2">
                                            @csrf
                                            <button type="submit" class="btn btn-secondary w-100">
                                                <i data-feather="x-circle"></i> {{ __('Close Ticket') }}
                                            </button>
                                        </form>
                                        <form action="{{ route('support.tickets.reopen', $ticket->id) }}" method="POST" class="mb-2">
                                            @csrf
                                            <button type="submit" class="btn btn-warning w-100">
                                                <i data-feather="rotate-ccw"></i> {{ __('Reopen Ticket') }}
                                            </button>
                                        </form>
                                        @endif
                                    </div>
                                </div>

                                <!-- Assignment -->
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="mb-0">{{ __('Assignment') }}</h6>
                                    </div>
                                    <div class="card-body">
                                        @if($ticket->assignedAgent)
                                            <p><strong>{{ __('Assigned To') }}:</strong><br>
                                                <span class="badge badge-light-primary">{{ __('Agent') }}</span> {{ $ticket->assignedAgent->name }}
                                            </p>
                                        @elseif($ticket->assignedStaff)
                                            <p><strong>{{ __('Assigned To') }}:</strong><br>
                                                <span class="badge badge-light-info">{{ __('Staff') }}</span> {{ $ticket->assignedStaff->staff_name }}
                                            </p>
                                        @else
                                            <p class="text-muted">{{ __('Not assigned yet') }}</p>
                                        @endif
                                        
                                        <form action="{{ route('support.tickets.assign', $ticket->id) }}" method="POST">
                                            @csrf
                                            <div class="mb-2">
                                                <select name="agent_id" class="form-select" required>
                                                    <option value="">{{ __('Select Assignee') }}</option>
                                                    @if($availableAgents->count() > 0)
                                                        <optgroup label="{{ __('Agents') }}">
                                                            @foreach($availableAgents as $agent)
                                                            <option value="{{ $agent->user_id }}" {{ $ticket->assigned_to == $agent->user_id ? 'selected' : '' }}>
                                                                {{ $agent->user->name }} ({{ $agent->current_tickets }}/{{ $agent->max_tickets }})
                                                            </option>
                                                            @endforeach
                                                        </optgroup>
                                                    @endif
                                                    @if(isset($availableStaff) && $availableStaff->count() > 0)
                                                        <optgroup label="{{ __('Staff Members') }}">
                                                            @foreach($availableStaff as $staff)
                                                            <option value="staff_{{ $staff->id }}" {{ $ticket->assigned_staff_id == $staff->id ? 'selected' : '' }}>
                                                                {{ $staff->staff_name }} ({{ ucfirst($staff->role) }})
                                                            </option>
                                                            @endforeach
                                                        </optgroup>
                                                    @endif
                                                </select>
                                            </div>
                                            <button type="submit" class="btn btn-sm btn-primary w-100">
                                                <i data-feather="user-check"></i> {{ __('Assign Ticket') }}
                                            </button>
                                        </form>
                                    </div>
                                </div>

                                <!-- Ticket Details -->
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="mb-0">{{ __('Details') }}</h6>
                                    </div>
                                    <div class="card-body">
                                        <p class="mb-1"><strong>{{ __('Category') }}:</strong> {{ $ticket->category ?? __('N/A') }}</p>
                                        <p class="mb-1"><strong>{{ __('Created By') }}:</strong> {{ $ticket->creator->name ?? __('System') }}</p>
                                        <p class="mb-1"><strong>{{ __('Lead Score') }}:</strong> {{ $ticket->lead_score ?? 0 }}/100</p>
                                        @if($ticket->first_response_at)
                                        <p class="mb-1"><strong>{{ __('First Response') }}:</strong> {{ $ticket->calculateResponseTime() }} min</p>
                                        @endif
                                        @if($ticket->resolved_at)
                                        <p class="mb-1"><strong>{{ __('Resolution Time') }}:</strong> {{ $ticket->calculateResolutionTime() }} min</p>
                                        @endif
                                        <p class="mb-0"><strong>{{ __('Last Activity') }}:</strong> {{ $ticket->last_activity_at->diffForHumans() }}</p>
                                    </div>
                                </div>

                                <!-- Associated Lead -->
                                @if($ticket->lead)
                                <div class="card">
                                    <div class="card-header">
                                        <h6 class="mb-0">{{ __('Associated Lead') }}</h6>
                                    </div>
                                    <div class="card-body">
                                        <p class="mb-1"><strong>{{ __('Status') }}:</strong> {{ ucfirst($ticket->lead->status) }}</p>
                                        <p class="mb-0"><strong>{{ __('Score') }}:</strong> {{ $ticket->lead->lead_score }}/100</p>
                                        <a href="{{ route('support.leads.show', $ticket->lead->id) }}" class="btn btn-sm btn-outline-primary w-100 mt-2">
                                            {{ __('View Lead') }}
                                        </a>
                                    </div>
                                </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

<script>
// Auto-scroll to bottom of messages
document.addEventListener('DOMContentLoaded', function() {
    const container = document.getElementById('messages-container');
    if(container) {
        container.scrollTop = container.scrollHeight;
    }
});
</script>

@include('layouts.footer')
