@include('layouts.header')
<link rel="stylesheet" type="text/css" href="{{ url('/') }}/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="card-body">
            <button type="button" class="btn btn-sm btn-primary float-end" data-bs-toggle="modal" data-bs-target="#addNew">{{ __('Add new template') }}</button>
            {{--<a class="btn btn-sm btn-success float-end" href="{{ route('template.export') }}"><i data-feather="external-link" class="me-0"></i> {{ strtoupper(__('Export')) }}</a>--}}
        </div>
        <div class="content-header row">
            <h4>{{ __('Templates list') }}<span class="badge rounded-pill badge-light-secondary">{{DB::table('templates')->where('user_id',Auth::user()->id)->count()}}</span></h4>
        </div>
        <div class="content-body">
            <!-- templates list start -->
            <section class="app-template-list">
                <!-- list and filter start -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive table-responsive">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>{{ __('Template name') }}</th>
                                        <th>{{ __('Message text') }}</th>
                                        <th>{{ __('Media') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($templates as $template)
                                    <tr>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$template->id}}" data-bs-toggle="modal">
                                        {{ $template->name }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$template->id}}" data-bs-toggle="modal">
                                        {{ substr($template->msgtext, 0, 100) . '...' }}</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-{{$template->id}}" data-bs-toggle="modal">
                                        @php($arrMediaurl=explode('/', $template->mediaurl))
                                        {{ end($arrMediaurl) }}</a>
                                        </td>
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton">
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit-{{$template->id}}"><i data-feather="edit" class="me-0"></i> {{__('Edit')}}</a>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-{{$template->id}}"><i data-feather="trash" class="me-0"></i> {{__('Delete')}}</a>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-{{$template->id}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    {{ __('Are you sure you want to delete?') }} <br><br>
                                                    <span class="text text-danger"> <b>{{ $template->name }}</b> </span><br><br>
                                                    {{ __('This process is irreversible') }} <br>
                                                    {{ __('The record(s) will be deleted from the database permanently') }}
                                                </div>
                                                <div class="modal-footer">
                                                <a class="btn btn-sm btn-danger" href="{{ route('template.destroy', ['template_id' => $template->id]) }}">{{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Edit Template Modal -->
                                    <div class="modal fade" id="edit-{{$template->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-template">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1">{{ __('Edit template') }}</h1>
                                                    </div>
                                                    <form action="{{ route('template.update') }}" method="POST" id="editTemplateForm" class="row gy-1 pt-75" enctype="multipart/form-data">
                                                        @csrf
                                                        <div class="row">
                                                            <div class="col-12 col-md-6">
                                                                <input type="hidden"  name="template_id" value="{{ $template->id }}" />
                                                                <input type="hidden" name="prev_mediafile" value="{{ end($arrMediaurl) }}" />
                                                                <input type="hidden" name="prev_mediaurl" value="{{ $template->mediaurl }}" />
                                                                <label class="form-label" for="name">{{ __('Template name') }}</label>
                                                                <input type="text" name="name" class="form-control" value="{{ $template->name }}" required />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="mediafile">{{ __('Template mediafile') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label> <label class="form-label text-warning"> JPEG/PNG/GIF/PDF/DOCX/PPTX/XLSX/CSV/MP3 </label>
                                                                <input type="file" name="mediafile" class="form-control" />{{ end($arrMediaurl) }}
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="msgtext">{{ __('Message text') }}</label>
                                                                <textarea name="msgtext" class="form-control" rows="7" required>{{ $template->msgtext }}</textarea>
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label> {{ __('Emoji') }} ({{ __('Copy and Paste') }})</label>
                                                                <textarea name="emoji" class="form-control" rows="7" readonly>{{ file_get_contents(public_path('app-assets/data/emoji.txt')) }}</textarea><br>
                                                            </div>
                                                            <div class="col-12 text-center mt-2 pt-50">
                                                                <button type="submit" class="btn btn-primary me-1">{{ __('Submit') }}</button>
                                                                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Cancel') }}</button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Edit Template Modal -->
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <!-- Modal to add new template starts-->
                        <div class="modal modal-slide-in new-template-modal fade" id="addNew">
                            <div class="modal-dialog">
                                <form action="{{ route('template.store') }}" method="POST" class="add-new-template modal-content pt-0" enctype="multipart/form-data">
                                @csrf
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
                                    <div class="modal-header mb-1">
                                        <h5 class="modal-title" id="exampleModalLabel">{{ __('Add new template') }}</h5>
                                    </div>
                                    <div class="modal-body flex-grow-1">
                                        <div class="mb-1">
                                            <label class="form-label" for="name">{{ __('Template name') }}</label>
                                            <input type="text" name="name" class="form-control" placeholder="{{ __('Template name') }}" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="msgtext">{{ __('Message text') }}</label>
                                            <textarea name="msgtext" class="form-control" rows="6" required></textarea>
                                        </div>
                                        <div class="mb-1">
                                            <label> {{ __('Emoji') }} ({{ __('Copy and Paste') }})</label>
                                            <textarea name="emoji" class="form-control" rows="7" readonly>{{ file_get_contents(public_path('app-assets/data/emoji.txt')) }}</textarea><br>
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="mediafile">{{ __('Template mediafile') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }}) </label> <label class="form-label text-warning"> JPEG/PNG/GIF/PDF/DOCX/PPTX/XLSX/CSV/MP3 </label>
                                            <input type="file" name="mediafile" class="form-control" />
                                        </div>
                                        <button type="submit" class="btn btn-primary me-1 data-submit">{{ __('Submit') }}</button>
                                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- Modal to add new template Ends-->
                    </div>
                </div>
                <!-- list and filter end -->
            </section>
            <!-- templates list ends -->
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
<script src="{{ url('/') }}/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
    $(document).ready(function () {
        $('#tbl-bootstr').DataTable();
    });        
</script>

@include('layouts.footer')
