@include('layouts.header')

@php
App::setLocale(Auth::user()->lang);
@endphp

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <!-- header info start -->
        <div class="row">
            <div class="col-lg-2 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $stats['total'] }}</h3>
                            <span>{{ __('Total Todos') }}</span>
                        </div>
                        <div class="avatar bg-light-primary p-50">
                            <span class="avatar-content">
                                <i data-feather="list" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $stats['pending'] }}</h3>
                            <span>{{ __('Pending') }}</span>
                        </div>
                        <div class="avatar bg-light-warning p-50">
                            <span class="avatar-content">
                                <i data-feather="clock" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $stats['completed'] }}</h3>
                            <span>{{ __('Completed') }}</span>
                        </div>
                        <div class="avatar bg-light-success p-50">
                            <span class="avatar-content">
                                <i data-feather="check-circle" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75 text-danger">{{ $stats['overdue'] }}</h3>
                            <span>{{ __('Overdue') }}</span>
                        </div>
                        <div class="avatar bg-light-danger p-50">
                            <span class="avatar-content">
                                <i data-feather="alert-circle" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $stats['upcoming'] }}</h3>
                            <span>{{ __('Upcoming') }}</span>
                        </div>
                        <div class="avatar bg-light-info p-50">
                            <span class="avatar-content">
                                <i data-feather="calendar" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-2 col-sm-6">
                <div class="card cursor-pointer" onclick="window.location.href='{{ route('todo.calendar') }}'">
                    <div class="card-body d-flex align-items-center justify-content-center flex-column">
                        <div class="avatar bg-light-secondary p-50 mb-1">
                            <span class="avatar-content">
                                <i data-feather="calendar" class="font-medium-4"></i>
                            </span>
                        </div>
                        <span class="fw-bold">{{ __('Calendar View') }}</span>
                    </div>
                </div>
            </div>
        </div>
        <!-- header info end -->
        <div class="content-body">
            <section class="app-todo-list">
                <div class="card">
                    <h5 class="card-header">
                        <div class="input-group input-group-sm position-relative mx-auto">
                            {{ __('Todo List') }}<span class="badge badge-light-secondary ms-2">{{ $todos->total() }}</span>
                            <input type="search" class="form-control" id="search" value="{{!empty($_GET['search']) ? $_GET['search'] : ''}}" placeholder="{{__('Search')}}..." />
                            <button type="button" class="btn btn-sm btn-info" id="searchbtn"><i data-feather="search" class="me-0"></i></button>
                            
                            <!-- Filter Dropdown -->
                            <div class="dropdown ms-2">
                                <button class="btn btn-sm btn-outline-primary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                                    <i data-feather="filter" class="me-1"></i>{{ __('Filter') }}
                                </button>
                                <div class="dropdown-menu">
                                    <a class="dropdown-item" href="{{ route('todo.list') }}">{{ __('All') }}</a>
                                    <a class="dropdown-item" href="{{ route('todo.list', ['filter' => 'pending']) }}">{{ __('Pending') }}</a>
                                    <a class="dropdown-item" href="{{ route('todo.list', ['filter' => 'completed']) }}">{{ __('Completed') }}</a>
                                    <a class="dropdown-item" href="{{ route('todo.list', ['filter' => 'overdue']) }}">{{ __('Overdue') }}</a>
                                    <a class="dropdown-item" href="{{ route('todo.list', ['filter' => 'upcoming']) }}">{{ __('Upcoming 24hrs') }}</a>
                                    <div class="dropdown-divider"></div>
                                    <h6 class="dropdown-header">{{ __('Priority') }}</h6>
                                    <a class="dropdown-item" href="{{ route('todo.list', ['priority' => 'high']) }}">{{ __('High Priority') }}</a>
                                    <a class="dropdown-item" href="{{ route('todo.list', ['priority' => 'medium']) }}">{{ __('Medium Priority') }}</a>
                                    <a class="dropdown-item" href="{{ route('todo.list', ['priority' => 'low']) }}">{{ __('Low Priority') }}</a>
                                </div>
                            </div>
                            
                            <button type="button" class="btn btn-sm btn-primary ms-2" data-bs-toggle="modal" data-bs-target="#addNew">
                                <i data-feather="plus" class="me-1"></i>{{ strtoupper(__('Add Todo')) }}
                            </button>
                        </div>
                    </h5>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th style="width: 30px;"></th>
                                        <th>{{ __('Title') }}</th>
                                        <th>{{ __('Todo Time') }}</th>
                                        <th>{{ __('Reminder') }}</th>
                                        <th>{{ __('Priority') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($todos as $todo)
                                    <tr class="{{ $todo->is_completed ? 'table-secondary' : '' }}">
                                        <td>
                                            <div class="form-check">
                                                <input class="form-check-input" type="checkbox" {{ $todo->is_completed ? 'checked' : '' }} onchange="toggleStatus({{ $todo->id }})">
                                            </div>
                                        </td>
                                        <td>
                                            <div>
                                                <strong class="{{ $todo->is_completed ? 'text-decoration-line-through' : '' }}">{{ $todo->title }}</strong>
                                                @if($todo->description)
                                                <br><small class="text-muted">{{ \Str::limit($todo->description, 60) }}</small>
                                                @endif
                                            </div>
                                        </td>
                                        <td>
                                            <span class="{{ $todo->todo_time < now() && !$todo->is_completed ? 'text-danger fw-bold' : '' }}">
                                                {{ $todo->todo_time->format('M d, Y h:i A') }}
                                            </span>
                                            <br><small class="text-muted">{{ $todo->todo_time->diffForHumans() }}</small>
                                        </td>
                                        <td>
                                            <span class="badge badge-light-info">{{ $todo->reminder_label }}</span>
                                            @if($todo->reminder_sent)
                                                <br><small class="text-success">✓ {{ __('Sent') }}</small>
                                            @endif
                                        </td>
                                        <td>
                                            @if($todo->priority == 'high')
                                                <span class="badge badge-light-danger">{{ __('High') }}</span>
                                            @elseif($todo->priority == 'medium')
                                                <span class="badge badge-light-warning">{{ __('Medium') }}</span>
                                            @else
                                                <span class="badge badge-light-info">{{ __('Low') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($todo->is_completed)
                                                <span class="badge badge-light-success">{{ __('Completed') }}</span>
                                            @elseif($todo->todo_time < now())
                                                <span class="badge badge-light-danger">{{ __('Overdue') }}</span>
                                            @else
                                                <span class="badge badge-light-warning">{{ __('Pending') }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="dropdown">
                                                <button type="button" class="btn btn-sm btn-icon dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                    <i data-feather="more-vertical"></i>
                                                </button>
                                                <div class="dropdown-menu">
                                                    <a class="dropdown-item" href="{{ route('todo.show', $todo->id) }}">
                                                        <i data-feather="eye" class="me-50"></i>{{ __('View') }}
                                                    </a>
                                                    @if(!$todo->is_completed)
                                                    <a class="dropdown-item" href="#" onclick="markCompleted({{ $todo->id }})">
                                                        <i data-feather="check" class="me-50"></i>{{ __('Mark Complete') }}
                                                    </a>
                                                    @endif
                                                    <a class="dropdown-item" href="#" onclick="editTodo({{ $todo->id }})">
                                                        <i data-feather="edit" class="me-50"></i>{{ __('Edit') }}
                                                    </a>
                                                    <a class="dropdown-item text-danger" href="#" onclick="deleteTodo({{ $todo->id }})">
                                                        <i data-feather="trash" class="me-50"></i>{{ __('Delete') }}
                                                    </a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="d-flex justify-content-center mt-3">
                            {{ $todos->links() }}
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- Modal Add Todo -->
<div class="modal fade" id="addNew" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Create New Todo') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="{{ route('todo.store') }}">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('Title') }}*</label>
                        <input type="text" name="title" class="form-control" required placeholder="{{ __('Meeting with client') }}">
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('Description') }}</label>
                        <textarea name="description" class="form-control" rows="3" placeholder="{{ __('Discuss project details...') }}"></textarea>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('Todo Date & Time') }}*</label>
                            <input type="datetime-local" name="todo_time" class="form-control" required>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-label">{{ __('Remind me') }}*</label>
                            <select name="reminder_before" class="form-select" required>
                                <option value="60">{{ __('1 hour before') }}</option>
                                <option value="120">{{ __('2 hours before') }}</option>
                                <option value="300">{{ __('5 hours before') }}</option>
                            </select>
                        </div>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('Priority') }}</label>
                        <select name="priority" class="form-select">
                            <option value="low">{{ __('Low') }}</option>
                            <option value="medium" selected>{{ __('Medium') }}</option>
                            <option value="high">{{ __('High') }}</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('Create Todo') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>

@include('layouts.footer')

<script>
function toggleStatus(id) {
    fetch('/todo-togglestatus', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify({ todo_id: id })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    });
}

function markCompleted(id) {
    fetch('/todo-markcompleted', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').content
        },
        body: JSON.stringify({ todo_id: id })
    })
    .then(response => response.json())
    .then(data => {
        if (data.success) {
            location.reload();
        }
    });
}

function deleteTodo(id) {
    if (confirm('{{ __("Delete this todo?") }}')) {
        window.location.href = `/todo-destroy?todo_id=${id}`;
    }
}

document.getElementById('searchbtn').addEventListener('click', function() {
    const search = document.getElementById('search').value;
    window.location.href = `{{ route('todo.list') }}?search=${search}`;
});

document.getElementById('search').addEventListener('keypress', function(e) {
    if (e.key === 'Enter') {
        document.getElementById('searchbtn').click();
    }
});
</script>
