@include('layouts.header')
@php
App::setLocale(Auth::user()->lang);
@endphp
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <!-- header info start -->
        <div class="row">
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $totalUsers }}</h3>
                            <span>{{ __('Users') }} </span>[ <span class="text-success" data-toggle="tooltip" title="{{__('Verified')}}">{{$verifiedUsers}}</span> | <span class="text-danger" data-toggle="tooltip" title="{{__('Unverified')}}">{{$unverifiedUsers}}</span> ]
                        </div>
                        <div class="avatar bg-light-warning p-50">
                            <span class="avatar-content">
                                <i data-feather="users" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $totalDevices }}</h3>
                            <span>{{ __('Devices') }} </span>[ <span class="text-success" data-toggle="tooltip" title="{{__('ONLINE')}}">{{$onlineDevices}}</span> | <span class="text-danger" data-toggle="tooltip" title="{{__('OFFLINE')}}">{{$offlineDevices}}</span> ]
                        </div>
                        <div class="avatar bg-light-primary p-50">
                            <span class="avatar-content">
                                <i data-feather="smartphone" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $totalSubscribers }}</h3>
                            <span>{{ __('Subs') }} </span>[ <span class="text-success" data-toggle="tooltip" title="{{__('Subscribed')}}">{{$subSubscribers}}</span> | <span class="text-danger" data-toggle="tooltip" title="{{__('Unsubscribed')}}">{{$unsubSubscribers}}</span> ]
                        </div>
                        <div class="avatar bg-light-success p-50">
                            <span class="avatar-content">
                                <i data-feather="user-plus" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75">{{ $totalSent }}</h3>
                            <span>{{ __('Sent') }} </span>[ <span class="text-success" data-toggle="tooltip" title="{{__('This month')}}">{{$currentSent}}</span> | <span class="text-danger" data-toggle="tooltip" title="{{__('All time')}}">{{$totalSent}}</span> ]
                        </div>
                        <div class="avatar bg-light-danger p-50">
                            <span class="avatar-content">
                                <i data-feather="send" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- header info end -->
        <div class="content-body">
            <!-- users list start -->
            <section class="app-user-list">
                <!-- list and filter start -->
                <div class="card">
                    <h5 class="card-header">
                        <div class="input-group input-group-sm position-relative mx-auto">
                            {{ __('User list') }}<span class="badge badge-light-secondary ms-2">{{ DB::table('users')->count() }}</span>
                            <input type="search" class="form-control" id="search" value="{{!empty($_GET['search']) ? $_GET['search'] : ''}}" placeholder="{{__('Search')}}..." />
                            <button type="button" class="btn btn-sm btn-info" id="searchbtn"><i data-feather="search" class="me-0"></i></button>
                            <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#addNew"><i data-feather="plus" class="me-1"></i>{{ strtoupper(__('Add new')) }}</button>
                            <button type="button" class="btn btn-sm btn-warning dropdown-toggle" id="broadcastButton" data-bs-toggle="dropdown" aria-expanded="false"><i data-feather="git-branch" class="me-1"></i> {{ __('Broadcast') }}</button>
                            <div class="dropdown-menu" aria-labelledby="broadcastButton">
                                <a class="dropdown-item" href="{{route('sendmsg.index', ['role' => 'user'])}}">All users</a>
                                <a class="dropdown-item" href="{{route('sendmsg.index', ['role' => 'admin'])}}">All admins</a>
                            </div>
                        </div>
                    </h5>
                    <div class="card-body">
                        <div class="table-responsive table-responsive">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th hidden></th>
                                        <th>{{ __('Username') }}</th>
                                        <th>{{ __('Role') }}</th>
                                        <th>{{ __('Current sent') }}</th>
                                        <th>{{ __('Total sent') }}</th>
                                        @if (\App\Helpers\Helpers::isEx())
                                        <th>{{ __('Package name') }}</th>
                                        <th>{{ __('Wallet') }}
                                        <th>{{ __('Expiry date') }}</th>
                                        @endif
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($users as $user)
                                    <tr>
                                        <td hidden>{{ $user->created_at }}</td>
                                        <td><a href="{{ route('user.show', ['user_id' => $user->id]) }}">
                                        {{ $user->name }}<span class="badge rounded-pill badge-light-danger me-1">{{ $user->banned ? '(banned)' : ''}}</span></a>
                                        </td>
                                        <td><a href="{{ route('user.show', ['user_id' => $user->id]) }}">
                                        <span class="badge rounded-pill badge-light-warning me-1">{{ $user->role }}</span></a>
                                        </td>
                                        <td><a href="{{ route('user.show', ['user_id' => $user->id]) }}">
                                        {{ $user->current_sent }}</a>
                                        </td>
                                        <td><a href="{{ route('user.show', ['user_id' => $user->id]) }}">
                                        {{ $user->total_sent }}</a>
                                        </td>
                                        @if (\App\Helpers\Helpers::isEx())
                                        <td><a href="{{ route('user.show', ['user_id' => $user->id]) }}">
                                        <span class="badge rounded-pill badge-light-{{empty($user->email_verified_at) ? 'danger' : 'success'}} me-1">{{ $user->package?->name }}</span></a>
                                        </td>
                                        <td><a href="{{ route('user.show', ['user_id' => $user->id]) }}">
                                        @php $walletBalance = $user->transactions()->sum('amount') @endphp
                                        <span class="badge rounded-pill badge-light-{{$walletBalance < 0 ? 'danger' : 'success'}} me-1">{{ number_format($walletBalance,\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator')) }}</span></a>
                                        </td>
                                        <td><a href="{{ route('user.show', ['user_id' => $user->id]) }}">
                                        <span class="badge rounded-pill badge-light-{{$user->billing_end < date('Y-m-d H:i:s') ? 'danger' : 'success'}} me-1">{{ $user->billing_end }}</span></a>
                                        </td>
                                        @endif
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton">
                                                @canBeImpersonated($user, $guard = null)
                                                <a class="dropdown-item" href="{{ route('user.impersonate', $user->id) }}" {{ (Auth::user()->id != 1 &&  $user->id <= 2) ? 'hidden' : '' }}><i data-feather="log-in" class="me-0"></i> {{__('Log in')}}</a>
                                                @endCanBeImpersonated
                                                @if ($user->id !== Auth::user()->id && $user->id > 2)
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit-{{$user->id}}"><i data-feather="edit" class="me-0"></i> {{ __('Edit') }}</a>
                                                <a class="dropdown-item" href="{{ route('user.banUnban', ['user_id' => $user->id]) }}"><i data-feather="{{ $user->banned ? 'thumbs-up' : 'thumbs-down' }}" class="me-0"></i> {{ $user->banned ?  __('Unban') : __('Ban') }}</a>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-{{$user->id}}"><i data-feather="trash" class="me-0"></i> {{__('Delete')}}</a>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-{{$user->id}}" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    {{ __('Are you sure you want to delete?') }} <br><br>
                                                    <span class="text text-danger"> <b>{{ $user->name }}</b> </span><br><br>
                                                    {{ __('This process is irreversible') }} <br>
                                                    {{ __('The record(s) will be deleted from the database permanently') }}
                                                </div>
                                                <div class="modal-footer">
                                                <a class="btn btn-sm btn-danger" href="{{ route('user.destroy', ['user_id' => $user->id]) }}">{{ __('Delete') }}</a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Edit User Modal -->
                                    <div class="modal fade" id="edit-{{$user->id}}" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-user">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1">{{ __('Edit user form') }}</h1>
                                                    </div>
                                                    <form action="{{ route('user.update') }}" method="POST" id="editUserForm" class="row gy-1 pt-75">
                                                        @csrf
                                                        <div class="row">
                                                            <div class="col-12 col-md-6">
                                                                <input type="hidden"  name="user_id" value="{{ $user->id }}" />
                                                                <label class="form-label" for="name">{{ __('Username') }}</label>
                                                                <input type="text" name="name" class="form-control" value="{{ $user->name }}" required />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="password">{{ __('Password minimum 6 characters') }}</label>
                                                                <input type="text" name="password" class="form-control" placeholder="{{ __('EMPTY = NO CHANGE') }}" />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="email">{{ __('Email') }}</label>
                                                                <input type="text" name="email" class="form-control" value="{{ $user->email }}" placeholder="example@domain.com" required />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="phone">{{ __('Phone') }}</label>
                                                                <input type="text" name="phone" class="form-control" value="{{ $user->phone }}" placeholder="6281212341234" required />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="theme">{{ __('Panel theme') }}</label>
                                                                <select id="theme" name="theme" class="form-select">
                                                                    <option value="light-layout" {{ ( $user->theme == 'light-layout' ) ? 'selected' : '' }}>Light theme</option>
                                                                    <option value="dark-layout" {{ ( $user->theme == 'dark-layout' ) ? 'selected' : '' }}>Dark theme</option>
                                                                </select>
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="rtl">{{ __('Text direction') }}</label>
                                                                <select name="rtl" class="form-select">
                                                                    <option value="0" {{ !$user->rtl ? 'selected' : '' }}>Left to Right (LTR)</option>
                                                                    <option value="1" {{ $user->rtl ? 'selected' : '' }}>Right to Left (RTL)</option>
                                                                </select>
                                                            </div>
                                                            @if(Auth::user()->role === 'admin' && $user->id > 2)
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="role">{{ __('User role') }}</label>
                                                                <select id="role" name="role" class="form-select">
                                                                    <option value="admin" {{ ( $user->role === 'admin' ) ? 'selected' : '' }}>Admin</option>
                                                                    <option value="user" {{ ( $user->role === 'user' ) ? 'selected' : '' }}>User</option>
                                                                </select>
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="banned">{{ __('Ban') }}/{{ __('Unban User Account') }}</label>
                                                                <select name="banned" class="form-select">
                                                                    <option value="0" {{ !$user->banned ? 'selected' : '' }}>{{ __('User Unbanned') }}</option>
                                                                    <option value="1" {{ $user->banned ? 'selected' : '' }}>{{ __('User Banned') }}</option>
                                                                </select>
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="billing_end">{{ __('Billing end') }}</label>
                                                                <input type="datetime-local" name="billing_end" class="form-control" value="{{ $user->billing_end }}">
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="verified_at">{{ __('Verified at') }}</label>
                                                                <input type="datetime-local" name="verified_at" class="form-control" value="{{ $user->email_verified_at }}">
                                                            </div>
                                                            <div class="col-12 col-md-6" id="package" {{\App\Helpers\Helpers::isEx()?'':'hidden'}}>
                                                                <label class="form-label" for="package_name">{{ __('Package name') }}</label>
                                                                <select name="package_id" class="form-select">
                                                                    <option value="{{ $user->package?->id }}" selected>{{ $user->package?->name . '-' . $user->package?->rate_monthly . '/' . __('Month') }}</option>
                                                                    @foreach($packages as $package)
                                                                    <option value="{{ $package->id }}">{{ $package->name . '-' . $package->rate_monthly . '/' . __('Month') }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>
                                                            @endif
                                                        </div>
                                                        <div class="col-12 text-center mt-2 pt-50">
                                                            <button type="submit" class="btn btn-primary me-1">{{ __('Submit') }}</button>
                                                            <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Cancel') }}</button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    @endforeach
                                    {{ $users->links() }}
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Modal to add new user starts-->
                    <div class="modal modal-slide-in new-user-modal fade" id="addNew">
                        <div class="modal-dialog">
                            <form action="{{ route('user.store') }}" method="POST" class="add-new-user modal-content pt-0">
                            @csrf
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
                                <div class="modal-header mb-1">
                                    <h5 class="modal-title" id="exampleModalLabel">{{ __('Add new user') }}</h5>
                                </div>
                                <div class="modal-body flex-grow-1">
                                    <div class="mb-1">
                                        <label class="form-label" for="name">{{ __('Username') }}</label>
                                        <input type="text" name="name" class="form-control" placeholder="{{ __('Username') }}" required />
                                    </div>
                                    <div class="mb-1">
                                        <label class="form-label" for="password">{{ __('Password') }}</label>
                                        <input type="password" name="password" class="form-control" placeholder="{{ __('Password') }}" required />
                                    </div>
                                    <div class="mb-1">
                                        <label class="form-label" for="password_confirmation">{{ __('Confirm Password') }}</label>
                                        <input type="password" name="password_confirmation" class="form-control" placeholder="{{ __('Confirm Password') }}" required />
                                    </div>
                                    <div class="mb-1">
                                        <label class="form-label" for="email">{{ __('Email') }}</label>
                                        <input type="email" name="email" class="form-control" placeholder="{{ __('Email') }}" required />
                                    </div>
                                    <div class="mb-1">
                                        <label class="form-label" for="phone">{{ __('Phone') }}</label>
                                        <input type="tel" name="phone" class="form-control" placeholder="14083243658" required />
                                    </div>
                                    <div class="mb-1">
                                        <label class="form-label" for="role">{{ __('Role') }}</label>
                                        <select class="form-select" id="role" name="role">
                                            <option value="admin">Admin</option>
                                            <option value="user" selected>User</option>
                                        </select>
                                    </div>
                                    @if (\App\Helpers\Helpers::isEx())
                                    <div class="mb-1">
                                        <label class="form-label" for="package_id">{{ __('Package') }}</label>
                                        <select class="form-select" id="package_id" name="package_id">
                                            @foreach($packages as $package)
                                            <option value="{{ $package->id }}" {{ ( $package->id === 2 ) ? 'selected' : '' }}>{{ $package->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="mb-1">
                                        <label class="form-label" for="billing_interval">{{ __('Interval') }}</label>
                                        <select name="billing_interval" class="form-select">
                                            @foreach($intervals as $interval)
                                            <option value="{{ $interval }}">{{ $interval }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @else
                                        <input type="hidden"  name="package_id" value="2" />
                                        <input type="hidden"  name="billing_interval" value="monthly" />
                                    @endif
                                    <button type="submit" class="btn btn-primary me-1 data-submit">{{ __('Submit') }}</button>
                                    <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <!-- Modal to add new user Ends-->
                </div>
                <!-- list and filter end -->
            </section>
            <!-- users list ends -->
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
function search() {
    var url = '{{url()->current()}}' + '?search=' + $('#search').val();
    location.href= url;
}
$('#searchbtn').click(function (e) {
    search();
})
$('#search').keydown(function (e) {
    if (e.which == 13) {
        search();
    }
})
</script>

@include('layouts.footer')
