@include('layouts.header')
@php
App::setLocale(Auth::user()->lang);
@endphp
    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
            </div>
            <div class="content-body">
                <section class="app-user-view-security">
                    <div class="row">
                        <!-- User Sidebar -->
                        <div class="col-xl-8 col-lg-7 col-md-7 order-1 order-md-0">
                            <!-- User Card -->
                            <div class="card border-primary">
                            <div class="row">
                                <div class="card-body col-xl-3 col-lg-4 col-md-4">
                                    <a href="javascript:;" class="user-avatar-section" data-bs-target="#updateAvatar" data-bs-toggle="modal">
                                        <div class="d-flex align-items-center flex-column">
                                            <img class="img-fluid rounded mt-3 mb-2" src="{{ \App\Helpers\Helpers::avatarUrl() }}" height="110" width="110" alt="User avatar" />
                                            <div class="user-info text-center">
                                                <h4>{{ $user->name }}</h4>
                                                <span class="badge bg-light-secondary">{{ $user->package->name }}</span>
                                            </div>
                                        </div>
                                    </a>
                                    <div class="d-flex justify-content-around my-2 pt-75">
                                        <div class="d-flex align-items-start me-2">
                                            <span class="badge bg-light-primary p-75 rounded">
                                                <i data-feather="check" class="font-medium-2"></i>
                                            </span>
                                            <div class="ms-75">
                                                <h4 class="mb-0">{{ $user->current_sent }}</h4>
                                                <small>{{ __('Current sent') }}</small>
                                            </div>
                                        </div>
                                        <div class="d-flex align-items-start">
                                            <span class="badge bg-light-primary p-75 rounded">
                                                <i data-feather="briefcase" class="font-medium-2"></i>
                                            </span>
                                            <div class="ms-75">
                                                <h4 class="mb-0">{{ $user->total_sent }}</h4>
                                                <small>{{ __('Total sent') }}</small>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="card-body col-xl-3 col-lg-4 col-md-4">
                                    <h4 class="fw-bolder border-bottom pb-50 mb-1">{{ __('Details') }}</h4>
                                    <div class="info-container">
                                        <ul class="list-unstyled">
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25">{{ __('Username') }}:</span>
                                                <span>{{ $user->name }}</span>
                                            </li>
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25">{{ __('Email') }}:</span>
                                                <span>{{ $user->email }}</span>
                                            </li>
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25">{{ __('Phone') }}:</span>
                                                <span>{{ $user->phone }}</span>
                                            </li>
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25">{{ __('Status') }}:</span>
                                                <span class="badge bg-light-{{ ($status == 'ACTIVE') ? 'success' : 'danger' }}">{{ $status }}</span>
                                            </li>
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25">{{ __('Role') }}:</span>
                                                <span>{{ $user->role }}</span>
                                            </li>
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25">{{ __('Language') }}:</span>
                                                <span>{{ $user->lang }}</span>
                                            </li>
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25">{{ __('Panel theme') }}:</span>
                                                <span>{{ $user->theme }}</span>
                                            </li>
                                            @if (\App\Helpers\Helpers::isEx())
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25">{{ __('Package') }}:</span>
                                                <span>{{ $user->package->description }}</span>
                                            </li>
                                            <li class="mb-75">
                                                <span class="fw-bolder me-25">{{ __('Wallet') }}:</span>
                                                @if ($walletBalance < 0)
                                                <span class="badge rounded-pill badge-light-danger me-1">
                                                @else
                                                <span class="badge rounded-pill badge-light-success me-1">
                                                @endif
                                                {{number_format($walletBalance,\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator'))}}
                                                </span>
                                            </li>
                                            <li class="mb-75">
                                                @if(Auth::user()->id == $user->id)
                                                <a class="btn-sm btn-primary" href="{{ route('transaction.list') }}">{{ __('Transactions') }}</a>
                                                <a class="btn btn-sm btn-warning me-1" data-bs-target="#transferUser" data-bs-toggle="modal" href="javascript:;">{{ __('Transfer') }}</a>
                                                @if($user->role !== 'admin')
                                                <a class="btn btn-sm btn-success me-1" data-bs-target="#topupUser" data-bs-toggle="modal" href="javascript:;" id="topupbutton">{{ __('Top up') }}</a>
                                                @endif
                                                @endif
                                            </li>
                                            @endif
                                            <li class="mb-75">
                                                <a class="btn btn-sm btn-primary me-1" data-bs-target="#editUser" data-bs-toggle="modal" href="javascript:;"><i data-feather="edit" class="me-0"></i> {{ __('Edit') }}</a>
                                                @if($user->id > 4 && filter_var(\App\Helpers\Helpers::setting('allowUserDeleteAccount'), FILTER_VALIDATE_BOOLEAN))
                                                <a class="btn btn-sm btn-danger me-1" data-bs-target="#destroyUser" data-bs-toggle="modal" href="javascript:;"><i data-feather="trash" class="me-0"></i> {{ __('Delete Account') }}</a>
                                                @endif
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            </div>
                            <!-- /User Card -->
                        </div>
                        <!--/ User Sidebar -->

                        <!-- User Content -->
                        @if (\App\Helpers\Helpers::isEx() && $user->package->name !== 'super' && $user->role !== 'admin')
                        <div class="col-xl-4 col-lg-5 col-md-5 order-0 order-md-1">
                            <!-- Plan Card -->
                            <div class="card border-primary">
                                <div class="card-body">
                                    <span class="badge bg-light-primary">{{ $user->package->name }}</span>
                                    <div class="d-flex justify-content-between align-items-start">
                                        <div class="d-flex justify-content-center">
                                            <sup class="h5 pricing-currency text-primary mt-1 mb-0">{{ $currencyCode }}</sup>
                                            <span class="fw-bolder display-6 mb-0 text-primary">{{ number_format($user->package->rate_monthly,\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator')) }}</span>
                                            <sub class="pricing-duration font-small-4 ms-25 mt-auto mb-2">/{{ __('Month') }}</sub>
                                        </div>
                                    </div>
                                    <!-- <div class="d-flex justify-content-between align-items-start">
                                        <div class="d-flex justify-content-center">
                                            <sup class="h5 pricing-currency text-primary mt-1 mb-0">{{ $currencyCode }}</sup>
                                            <span class="fw-bolder display-6 mb-0 text-primary">{{ $user->package->rate_yearly }}</span>
                                            <sub class="pricing-duration font-small-4 ms-25 mt-auto mb-2">/{{ __('Year') }}</sub>
                                        </div>
                                    </div> -->
                                    <ul class="ps-1 mb-2">
                                        <li class="mb-50">{{ __('Outgoing') }}: {{ $user->package->max_outgoing < 0 ? __('Unlimited') : number_format($user->package->max_outgoing,0,\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator')) }}</li>
                                        <li class="mb-50">{{ __('Device') }}: {{ $user->package->max_device < 0 ? __('Unlimited') : $user->package->max_device }}</li>
                                        <li class="mb-50">{{ __('Autoreply Keyword') }}: {{ $user->package->max_autoreply < 0 ? __('Unlimited') : $user->package->max_autoreply }}</li>
                                        <li class="mb-50">{{ __('Phonebook') }}: {{ $user->package->max_phonebook < 0 ? __('Unlimited') : $user->package->max_phonebook }}</li>
                                        <li class="mb-50">{{ __('Webhook') }}: {{ $user->package->webhook == 0 ? __('NO') : __('YES') }}</li>
                                        <li class="mb-50">{{ __('Basic support') }}</li>
                                    </ul>
                                    @if ($daysRemaining <=3 && $walletBalance < $user->package->rate_monthly)
                                    <p class="text-danger"><strong>{{ __('Please top up wallet!') }}</strong></p>
                                    @endif
                                    @if (round($daysUsed, 2) >= round($daysTotal, 2) || round($daysUsed, 2) < 0)
                                    <div class="d-flex justify-content-between align-items-center fw-bolder mb-50">
                                        <span>{{ __('Days') }}</span>
                                        <span>{{ round($daysTotal, 2) . ' of ' . round($daysTotal, 2) . ' ' . __('Days') }}</span>
                                    </div>
                                    @else
                                    <div class="d-flex justify-content-between align-items-center fw-bolder mb-50">
                                        <span>{{ __('Days') }}</span>
                                        <span>{{ round($daysUsed, 2) . ' of ' . round($daysTotal, 2) . ' ' . __('Days') }}</span>
                                    </div>
                                    @endif
                                    @if ($percentUsed < 0 || $percentUsed > 100)
                                    <div class="progress mb-50" style="height: 16px">
                                        <div class="progress-bar" role="progressbar" style="width: 100%" aria-valuenow="65" aria-valuemax="100" aria-valuemin="80">100%</div>
                                    </div>
                                    @else
                                    <div class="progress mb-50" style="height: 16px">
                                        <div class="progress-bar" role="progressbar" style="width: {{ $percentUsed }}%" aria-valuenow="65" aria-valuemax="100" aria-valuemin="80">{{ $percentUsed }}%</div>
                                    </div>
                                    @endif
                                    @if (round($daysRemaining, 2) < 0)
                                    <span>{{ '0 ' . __('days remaining') }}</span>
                                    @else
                                    <span>{{ round($daysRemaining, 2) . ' ' . __('days remaining') }}</span>
                                    @endif
                                    @if (Auth::user()->role !== 'admin')
                                    <div class="d-grid w-100 mt-2">
                                        <a class="btn btn-primary me-1" data-bs-target="#upgradeUser" data-bs-toggle="modal" href="javascript:;">
                                            {{ __('Upgrade') }} / {{ __('Downgrade') }}
                                        </a>
                                    </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                        @endif
                        <!--/ User Content -->
                    </div>
                </section>
                <!-- Update Avatar Modal starts-->
                <div class="modal fade" id="updateAvatar" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-update-avatar">
                        <div class="modal-content">
                            <div class="modal-header bg-transparent">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body pb-5 px-sm-5 pt-50">
                                <div class="text-center mb-2">
                                    <h1 class="mb-1">{{ __('Update avatar') }}</h1>
                                </div>
                                <form action="{{ route('user.updateAvatar') }}" method="POST" class="row gy-1 pt-75" enctype="multipart/form-data">
                                    @csrf
                                    <div class="col-12">
                                        <label class="form-label" for="avatarPicture">{{ __('Avatar picture') }}</label> <label class="form-label text-warning"> (JPG/JPEG/PNG | {{ __('Max') }} 2 MB | Ratio 1:1) </label>
                                        <input type="file" name="avatarPicture" class="form-control" />
                                        <input type="hidden"  name="user_id" value="{{ $user->id }}" />
                                    </div>
                                    <div class="col-12 text-center mt-2 pt-50">
                                        <button type="submit" class="btn btn-primary me-1">{{ __('Submit') }}</button>
                                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Cancel') }}</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Update Avatar Modal Ends-->
                <!-- Edit User Modal -->
                <div class="modal fade" id="editUser" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-user">
                        <div class="modal-content">
                            <div class="modal-header bg-transparent">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body pb-5 px-sm-5 pt-50">
                                <div class="text-center mb-2">
                                    <h1 class="mb-1">{{ __('Edit user form') }}</h1>
                                </div>
                                <form action="{{ route('user.update') }}" method="POST" id="editUserForm" class="row gy-1 pt-75">
                                    @csrf
                                    <div class="col-12 col-md-6">
                                        <input type="hidden"  name="user_id" value="{{ $user->id }}" />
                                        <input type="hidden"  name="adminSender" value="{{ $adminSender }}" />
                                        <label class="form-label" for="name">{{ __('Username') }}</label>
                                        <input type="text" name="name" class="form-control" value="{{ $user->name }}" required />
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="password">{{ __('Password minimum 6 characters') }}</label>
                                        <input type="text" name="password" class="form-control" placeholder="{{ __('EMPTY = NO CHANGE') }}" />
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="email">{{ __('Email') }}</label>
                                        <input type="text" name="email" class="form-control" value="{{ $user->email }}" placeholder="example@domain.com" required />
                                    </div>
                                    @if($daysRemaining > 0 || $user->role === 'admin' || !\App\Helpers\Helpers::isEx())
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="phone">{{ __('Phone') }}</label>
                                        <input type="text" id="phone" name="phone" class="form-control" value="{{ $user->phone }}" placeholder="6281212341234" required />
                                    </div>
                                    @if(filter_var(\App\Helpers\Helpers::setting('waVerification'), FILTER_VALIDATE_BOOLEAN) && Auth::user()->role !== 'admin' && !empty($adminSender))
                                    <div class="col-12 col-md-6">
                                        <button type="button" id="otpbutton_edit" class="btn btn-sm btn-primary">{{ __('Request OTP code') }}</button>
                                        <input type="text" name="otp" class="form-control" placeholder="{{ __('Enter OTP') }}" required />
                                    </div>
                                    @endif
                                    @endif
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="theme">{{ __('Panel theme') }}</label>
                                        <select id="theme" name="theme" class="form-select">
                                            <option value="light-layout" {{ ( $user->theme == 'light-layout' ) ? 'selected' : '' }}>Light theme</option>
                                            <option value="dark-layout" {{ ( $user->theme == 'dark-layout' ) ? 'selected' : '' }}>Dark theme</option>
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="rtl">{{ __('Text direction') }}</label>
                                        <select name="rtl" class="form-select">
                                            <option value="0" {{ !$user->rtl ? 'selected' : '' }}>Left to Right (LTR)</option>
                                            <option value="1" {{ $user->rtl ? 'selected' : '' }}>Right to Left (RTL)</option>
                                        </select>
                                    </div>
                                    @if(Auth::user()->role === 'admin' && $user->id > 3)
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="role">{{ __('User role') }}</label>
                                        <select id="role" name="role" class="form-select">
                                            <option value="admin" {{ ( $user->role === 'admin' ) ? 'selected' : '' }}>Admin</option>
                                            <option value="user" {{ ( $user->role === 'user' ) ? 'selected' : '' }}>User</option>
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="banned">{{ __('Ban') }}/{{ __('Unban User Account') }}</label>
                                        <select name="banned" class="form-select">
                                            <option value="0" {{ !$user->banned ? 'selected' : '' }}>{{ __('User Unbanned') }}</option>
                                            <option value="1" {{ $user->banned ? 'selected' : '' }}>{{ __('User Banned') }}</option>
                                        </select>
                                    </div>
                                    <div class="col-12 col-md-6" id="package" {{\App\Helpers\Helpers::isEx()?'':'hidden'}}>
                                        <label class="form-label" for="package_name">{{ __('Package name') }}</label>
                                        <select name="package_id" class="form-select">
                                            <option value="{{ $user->package->id }}" selected>{{ $user->package->name . '-' . $user->package->rate_monthly . '/' . __('Month') }}</option>
                                            @foreach($packages as $package)
                                            <option value="{{ $package->id }}">{{ $package->name . '-' . $package->rate_monthly . '/' . __('Month') }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    @endif
                                    <div class="col-12 text-center mt-2 pt-50">
                                        <button type="submit" class="btn btn-primary me-1">{{ __('Submit') }}</button>
                                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Cancel') }}</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Delete Modal -->
                <div class="modal fade modal-danger text-start" id="destroyUser" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="myModalLabel120">{{ __('Delete confirmation') }}</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                {{ __('Are you sure you want to delete?') }} <br><br>
                                <span class="text text-danger"> <b>{{ $user->name }}</b> </span><br><br>
                                {{ __('This process is irreversible') }} <br>
                                {{ __('The record(s) will be deleted from the database permanently') }}
                            </div>
                            <div class="modal-footer">
                                @if (\App\Helpers\Helpers::isEx())
                                {{ __('WARNING! Wallet balance will be deleted after you click delete button') }}
                                @endif
                                <a class="btn btn-sm btn-danger" href="{{ route('user.destroySoft', ['user_id' => $user->id]) }}">{{ __('Delete') }}</a>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Transfer Modal -->
                <div class="modal fade" id="transferUser" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-lg modal-dialog-centered modal-edit-user">
                        <div class="modal-content">
                            <div class="modal-header bg-transparent">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body pb-5 px-sm-5 pt-50">
                                <div class="text-center mb-2">
                                    <h1 class="mb-1">{{ __('Transfer form') }}</h1>
                                </div>
                                <form action="{{ route('transaction.transfer') }}" method="POST" id="transferUserForm" class="row gy-1 pt-75">
                                    @csrf
                                    <div class="col-12 col-md-6">
                                        <input type="hidden"  name="adminSender" value="{{ $adminSender }}" />
                                        <label class="form-label" for="from_name">{{ __('From') }}</label>
                                        <input type="text" name="from_name" class="form-control" value="{{ $user->name }}" placeholder="{{ __('Username') }}" required readonly />
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="to_name">{{ __('To') }}</label>
                                        @if (Auth::user()->role === 'admin')
                                        <select class="select2 form-select" id="select2-basic" name="to_name">
                                            <optgroup label="Admins">
                                            @foreach($adminUsers as $adminUser)
                                            @if($adminUser->id === $user->id || $adminUser->id == 2) @continue @endif
                                                <option value="{{$adminUser->name}}">{{$adminUser->name}}</option>
                                            @endforeach
                                            </optgroup>
                                            <optgroup label="Users">
                                            @foreach($userUsers as $userUser)
                                            @if($userUser->id === $user->id) @continue @endif
                                                <option value="{{$userUser->name}}">{{$userUser->name}}</option>
                                            @endforeach
                                            </optgroup>
                                        </select>
                                        @else
                                        <input type="text" name="to_name" class="form-control" placeholder="{{ __('Enter recipient username') }}" required />
                                        @endif
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="amount">{{ __('Amount') }}</label>
                                        <input type="number" name="amount" min="0.01" max="{{ $user->role !== 'admin' ? $walletBalance : '' }}" step="0.01" class="form-control" required />
                                    </div>
                                    <div class="col-12 col-md-6">
                                        <label class="form-label" for="memo">{{ __('Memo') }}</label> <label class="form-label text-warning"> ({{ __('Optional') }})</label>
                                        <input type="text" name="memo" class="form-control" placeholder="{{ __('Enter a memo for this transfer') }}" />
                                    </div>
                                    @if(filter_var(\App\Helpers\Helpers::setting('waVerification'), FILTER_VALIDATE_BOOLEAN) && $user->role !== 'admin' && !empty($adminSender))
                                    <div class="col-12 col-md-6">
                                        <button type="button" id="otpbutton_transfer" class="btn btn-sm btn-primary">{{ __('Request OTP code') }}</button>
                                        <input type="text" name="otp" class="form-control" placeholder="{{ __('Enter OTP') }}" required />
                                    </div>
                                    @endif
                                    <div class="col-12 text-center mt-2 pt-50">
                                        <button type="submit" class="btn btn-primary me-1">{{ __('Submit') }}</button>
                                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close">{{ __('Cancel') }}</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Top up Modal -->
                <div class="modal fade" id="topupUser" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-topup-user">
                        <div class="modal-content">
                            <div class="modal-header bg-transparent">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body pb-5 px-sm-5 pt-50">
                                <div class="text-center mb-2">
                                    <h1 class="mb-1">{{ __('Top up form') }}</h1>
                                </div>
                                <section class="app-user-view-security">
                                    <div class="card-body">
                                        <div class="card border-primary">
                                            <div class="card-body">
                                                <span class="badge bg-light-primary">{{ __('Top up value') }}</span>
                                            </div>
                                            <form id="topupForm" action="{{ route('transaction.topup') }}" method="POST" enctype="multipart/form-data">
                                            @csrf
                                                <input type="hidden" name="user_id" value="{{ $user->id }}" />
                                                <input type="hidden" name="user_name" value="{{ $user->name }}" />
                                                <input type="hidden" name="currencyCode" value="{{ $currencyCode }}" />
                                                <div class="card-body">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="topupValue">{{ __('Top up value') }}</label>
                                                        <div class="position-relative">
                                                            @if (\App\Helpers\Helpers::setting('topupValues'))
                                                            <select name="topupValue" id="topupValue" class="form-select">
                                                                @foreach($topupValues as $topupValue)
                                                                <option value="{{ $topupValue }}">{{ $currencyCode }} {{ number_format($topupValue,\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator')) }}</option>
                                                                @endforeach
                                                            </select>
                                                            @else
                                                            <input type="number" name="topupValue" id="topupValue" step="0.01" class="form-control" required />
                                                            @endif
                                                        </div>
                                                    </div>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="gateway">{{ __('Pay with') }}</label>
                                                        <div class="position-relative">
                                                            <select name="gateway" id="gateway" class="form-select">
                                                            <?php 
                                                            $firstOption = true;
                                                            
                                                            // Show module-based gateways first
                                                            foreach ($modules as $module) {
                                                              $name = $module->getLowerName();
                                                              if (config("$name.pg")) {
                                                                echo '<option value="' . $module->getName() . '">' . $module->getName() . '</option>';
                                                                $firstOption = false;
                                                              }
                                                            }
                                                            
                                                            // Show payment gateway table gateways
                                                            $offlineIsFirstOption = false;
                                                            foreach ($paymentGateways as $gateway) {
                                                                // Skip if already added from modules
                                                                $alreadyAdded = false;
                                                                foreach ($modules as $module) {
                                                                    if (strtolower($module->getName()) === strtolower($gateway->name)) {
                                                                        $alreadyAdded = true;
                                                                        break;
                                                                    }
                                                                }
                                                                if (!$alreadyAdded) {
                                                                    if ($gateway->name === 'offline') {
                                                                        // Make offline payment selected by default if it's the first option
                                                                        $selected = $firstOption ? ' selected' : '';
                                                                        if ($firstOption) $offlineIsFirstOption = true;
                                                                        echo '<option value="OfflinePayment"' . $selected . '>' . $gateway->display_name . '</option>';
                                                                    } else {
                                                                        echo '<option value="' . $gateway->name . '">' . $gateway->display_name . '</option>';
                                                                    }
                                                                    $firstOption = false;
                                                                }
                                                            }
                                                            ?>
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="mb-1" id="gopayId" style="display: none;">
                                                        <label class="form-label" for="userGopayId">Gopay ID anda (contoh: 081212341234)</label>
                                                        <div class="position-relative">
                                                            <input type="text" name="userGopayId" class="form-control" />
                                                        </div>
                                                    </div>
                                                    
                                                    <!-- Offline Payment Details -->
                                                    <div id="offlinePaymentDetails" style="display: <?php echo $offlineIsFirstOption ? 'block' : 'none'; ?>;">
                                                        @php
                                                            $offlineGateway = \App\Models\PaymentGateway::where('name', 'offline')->first();
                                                            $offlineSettings = $offlineGateway->settings ?? [];
                                                        @endphp
                                                        <div class="alert alert-info">
                                                            <h5 class="alert-heading"><i data-feather="info"></i> {{ __('Payment Instructions') }}</h5>
                                                            <p class="mb-1"><strong>{{ __('Bank Name') }}:</strong> {{ $offlineSettings['bank_name'] ?? 'Not configured' }}</p>
                                                            <p class="mb-1"><strong>{{ __('Account Number') }}:</strong> <span class="badge bg-primary">{{ $offlineSettings['account_number'] ?? 'Not configured' }}</span></p>
                                                            <p class="mb-1"><strong>{{ __('Account Name') }}:</strong> {{ $offlineSettings['account_name'] ?? 'Not configured' }}</p>
                                                            <p class="mb-1"><strong>{{ __('Amount to Pay') }}:</strong> <span id="displayAmount" class="text-primary fw-bold">{{ $currencyCode }} 0.00</span></p>
                                                            <hr>
                                                            <p class="mb-0"><small>{{ $offlineSettings['instructions'] ?? 'Please make payment to the above account and upload proof of payment. Your wallet will be credited after admin approval.' }}</small></p>
                                                        </div>
                                                        
                                                        @if (($offlineSettings['require_proof'] ?? 1))
                                                        <div class="mb-1">
                                                            <label class="form-label" for="proof_of_payment">
                                                                <i data-feather="upload"></i> {{ __('Proof of Payment') }} <span class="text-danger">*</span>
                                                            </label>
                                                            <input type="file" name="proof_of_payment" id="proof_of_payment" class="form-control" accept="image/jpeg,image/jpg,image/png,image/gif,application/pdf" />
                                                            <small class="text-muted">
                                                                <i data-feather="alert-circle" class="text-warning" style="width: 14px; height: 14px;"></i>
                                                                {{ __('Upload screenshot or PDF of payment receipt (Max: 5MB)') }}
                                                            </small>
                                                            <div id="file-preview" class="mt-1" style="display: none;">
                                                                <span class="badge bg-success"><i data-feather="check"></i> <span id="file-name"></span></span>
                                                            </div>
                                                        </div>
                                                        @endif
                                                        
                                                        <div class="mb-1">
                                                            <label class="form-label" for="reference">
                                                                <i data-feather="file-text"></i> {{ __('Reference/Notes') }}
                                                            </label>
                                                            <textarea name="reference" id="reference" class="form-control" rows="2" placeholder="{{ __('Optional: Add transaction reference or notes (e.g., bank transfer reference number)') }}"></textarea>
                                                            <small class="text-muted">{{ __('This helps admin verify your payment faster') }}</small>
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="mb-1">
                                                        <button class="btn btn-primary btn-page-block-custom waves-effect" type="submit">
                                                            {{ __('Top up') }}
                                                        </button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </section>
                            </div>
                        </div>
                    </div>
                </div>
                
                <script>
                $(document).ready(function() {
                    function handleGatewayChange() {
                        var selectedGateway = $('#gateway').val();
                        console.log('Selected gateway:', selectedGateway); // Debug log
                        
                        if (selectedGateway === 'OfflinePayment') {
                            $('#offlinePaymentDetails').show();
                            $('#gopayId').hide();
                            $('#proof_of_payment').prop('required', true);
                            $('#proof_of_payment').prop('disabled', false);
                            updateDisplayAmount();
                        } else {
                            $('#offlinePaymentDetails').hide();
                            $('#gopayId').toggle(selectedGateway === 'Gopay');
                            $('#proof_of_payment').prop('required', false);
                            $('#proof_of_payment').prop('disabled', true);
                            $('#proof_of_payment').val(''); // Clear any selected file
                            $('#reference').val(''); // Clear reference field
                        }
                    }
                    
                    // Handle gateway selection
                    $('#gateway').on('change', handleGatewayChange);
                    
                    // Handle amount changes (both change and input events for real-time update)
                    $('#topupValue').on('change input', function() {
                        updateDisplayAmount();
                    });
                    
                    // Handle file selection - show file name and validate
                    $('#proof_of_payment').on('change', function() {
                        var fileName = $(this).val().split('\\').pop();
                        var fileSize = this.files[0]?.size || 0;
                        var maxSize = 5 * 1024 * 1024; // 5MB
                        
                        if (fileSize > maxSize) {
                            alert('{{ __("File size must be less than 5MB") }}');
                            $(this).val('');
                            $('#file-preview').hide();
                            return;
                        }
                        
                        if (fileName) {
                            console.log('Proof file selected:', fileName);
                            $('#file-name').text(fileName);
                            $('#file-preview').show();
                            feather.replace(); // Re-initialize feather icons
                        } else {
                            $('#file-preview').hide();
                        }
                    });
                    
                    // Form submission validation
                    $('#topupForm').on('submit', function(e) {
                        var selectedGateway = $('#gateway').val();
                        
                        if (selectedGateway === 'OfflinePayment') {
                            var proofFile = $('#proof_of_payment')[0].files[0];
                            
                            if (!proofFile) {
                                e.preventDefault();
                                alert('{{ __("Please upload proof of payment") }}');
                                $('#proof_of_payment').focus();
                                return false;
                            }
                            
                            // Validate file type
                            var allowedTypes = ['image/jpeg', 'image/jpg', 'image/png', 'image/gif', 'application/pdf'];
                            if (!allowedTypes.includes(proofFile.type)) {
                                e.preventDefault();
                                alert('{{ __("Please upload a valid image (JPEG, PNG, GIF) or PDF file") }}');
                                $('#proof_of_payment').focus();
                                return false;
                            }
                        }
                        
                        // Show loading state
                        $(this).find('button[type="submit"]').prop('disabled', true).html('<span class="spinner-border spinner-border-sm me-1" role="status" aria-hidden="true"></span>{{ __("Processing...") }}');
                    });
                    
                    function updateDisplayAmount() {
                        var amount = $('#topupValue').val();
                        if (amount) {
                            var currencyCode = '{{ $currencyCode }}';
                            var decimals = {{ \App\Helpers\Helpers::setting('nfDecimals') ?? 2 }};
                            var decimalPoint = '{{ \App\Helpers\Helpers::setting('nfDecimalpoint') ?? '.' }}';
                            var separator = '{{ \App\Helpers\Helpers::setting('nfSeparator') ?? ',' }}';
                            
                            var formattedAmount = parseFloat(amount).toFixed(decimals);
                            formattedAmount = formattedAmount.replace('.', decimalPoint);
                            
                            $('#displayAmount').text(currencyCode + ' ' + formattedAmount);
                        }
                    }
                    
                    // Trigger initial state on page load
                    handleGatewayChange();
                    
                    // Initialize display amount on page load
                    updateDisplayAmount();
                    
                    // Initialize feather icons if present
                    if (typeof feather !== 'undefined') {
                        feather.replace();
                    }
                    
                    // Debug: Log initial state
                    console.log('Offline section visible:', $('#offlinePaymentDetails').is(':visible'));
                    console.log('Proof field enabled:', !$('#proof_of_payment').prop('disabled'));
                });
                </script>

                <!-- upgrade your plan Modal -->
                <div class="modal fade" id="upgradeUser" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-lg modal-dialog-centered modal-upgrade-user">
                        <div class="modal-content">
                            <div class="modal-header bg-transparent">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body pb-5 px-sm-5 pt-50">
                                <div class="text-center mb-2">
                                    <h1 class="mb-1">{{ __('Upgrade form') }}</h1>
                                </div>
                                <section class="app-user-view-security">
                                    <div class="card-body">
                                        <div class="card border-primary">
                                            <div class="card-body">
                                                <div class="row">
                                                @foreach($packages as $package)
                                                <div class="col-4">
                                                    <span class="badge bg-light-primary"><strong>{{$package->name}}</strong></span>
                                                    <ul class="ps-1 mb-2">
                                                        <li class="mb-50">{{ __('Outgoing') }}: {{ $package->max_outgoing < 0 ? __('Unlimited') : number_format($package->max_outgoing,0,\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator')) }}</li>
                                                        <li class="mb-50">{{ __('Device') }}: {{ $package->max_device < 0 ? __('Unlimited') : $package->max_device }}</li>
                                                        <li class="mb-50">{{ __('Autoreply Keyword') }}: {{ $package->max_autoreply < 0 ? __('Unlimited') : $package->max_autoreply }}</li>
                                                        <li class="mb-50">{{ __('Phonebook') }}: {{ $package->max_phonebook < 0 ? __('Unlimited') : $package->max_phonebook }}</li>
                                                        <li class="mb-50">{{ __('Webhook') }}: {{ $package->webhook == 0 ? __('NO') : __('YES') }}</li>
                                                        <li class="mb-50"><b>{{ __('Monthly') }}: {{ number_format($package->rate_monthly,\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator')) }}</b></li>
                                                        <!-- <li class="mb-50">{{ __('Yearly') }}: {{ $currencyCode }} {{ $package->rate_yearly }}</li> -->
                                                    </ul>
                                                </div>
                                                @endforeach
                                                </div>
                                            </div>
                                            <form action="{{ route('transaction.upgrade') }}" method="POST">
                                            @csrf
                                                <input type="hidden" name="user_id" value="{{ $user->id }}" />
                                                <input type="hidden" name="user_name" value="{{ $user->name }}" />
                                                <input type="hidden" name="currencyCode" value="{{ $currencyCode }}" />
                                                <input type="hidden" name="walletBalance" value="{{ $walletBalance }}" />
                                                <div class="card-body">
                                                    <div class="mb-1">
                                                        <label class="form-label" for="choosePackage">{{ __('Choose package') }}</label>
                                                        <div class="position-relative">
                                                            <select name="package_id" class="form-select">
                                                                @foreach($packages as $package)
                                                                <option value="{{ $package->id }}">{{ $package->name }}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="mb-1" hidden>
                                                        <label class="form-label" for="chooseInterval">{{ __('Choose interval') }}</label>
                                                        <div class="position-relative">
                                                            <select name="billing_interval" class="form-select">
                                                                @foreach($intervals as $interval)
                                                                <option value="{{ $interval }}">{{ $interval }}</option>
                                                                @endforeach
                                                            </select>
                                                        </div>
                                                    </div>
                                                    <div class="mb-1">
                                                        <label class="form-label" for="balance">{{ __('Wallet balance') }}: </label>
                                                        @if ($walletBalance < 0)
                                                        <span class="badge rounded-pill badge-light-danger me-1">
                                                        @else
                                                        <span class="badge rounded-pill badge-light-success me-1">
                                                        @endif
                                                        {{number_format($walletBalance,\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator'))}}
                                                        </span>
                                                    </div>
                                                    <div class="mb-1">
                                                        <span class="badge bg-light-warning"><strong>{{ __('Upgrade will be charged at a pro-rated amount from today until the end of month') }}</strong></span>
                                                        <span class="badge bg-light-warning"><strong>{{ __('Downgrade will be free. New rate will affect at the beginning of next month') }}</strong></span>
                                                    </div>
                                                    <div class="mb-1">
                                                        <button class="btn btn-primary btn-page-block-custom waves-effect" type="submit">
                                                            {{ __('Upgrade / Downgrade') }}
                                                        </button>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </section>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>
    <!-- END: Content-->

    <!-- BEGIN: Vendor JS-->
    <script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
    <!-- BEGIN Vendor JS-->

    <!-- BEGIN: Page Vendor JS-->
    <script src="{{ url('/') }}/app-assets/vendors/js/forms/select/select2.full.min.js"></script>
    <!-- END: Page Vendor JS-->

    <!-- BEGIN: Page JS-->
    <script src="{{ url('/') }}/app-assets/js/scripts/forms/form-select2.js"></script>
    <!-- END: Page JS-->

    <script>
    $(document).ready(function(){
        if ($('#gateway').val() === 'Gopay') {
            $('#gopayId').show();
        } else {
            $('#gopayId').hide();
        }
        if ($('#role').val() === 'admin') {
            $("#package").hide();
        }
    });

    $('#role').change(function() {
        $("#package").toggle(this.value !== 'admin');
    })

    $('#gateway').change(function(e) {
        e.preventDefault();
        $("#gopayId").toggle(this.value === 'Gopay');
    });

    $("#otpbutton_edit").click(function(e) {
        e.preventDefault();
        $.ajax({
            type:"get",
            url: '{{route('user.otpSend')}}',
            data: {adminSender: '{{$adminSender}}', phone: $("#phone").val(), name: '{{$user->name}}', msgOtp: '_MsgOtpEdit'},
            success: $("#otpbutton_edit").prop("disabled",true),
        });
        var text = $("#otpbutton_edit").html();
        var count = 60;
        var counter = setInterval(timer, 1000);
        function timer(){
            count -= 1;
            if (count <= 0){
                clearInterval(counter);
                $("#otpbutton_edit").html(text);
                $("#otpbutton_edit").prop("disabled",false);
                return;
            }
            $("#otpbutton_edit").html(text + ' in ' + count + " seconds.");
        }
    });

    $("#otpbutton_transfer").click(function(e) {
        e.preventDefault();
        $.ajax({
            type:"get",
            url: '{{route('user.otpSend')}}',
            data: {adminSender: '{{$adminSender}}', phone: '{{$user->phone}}', name: '{{$user->name}}', msgOtp: '_MsgOtpTransfer'},
            success: $("#otpbutton_transfer").prop("disabled",true),
        });
        var text = $("#otpbutton_transfer").html();
        var count = 60;
        var counter = setInterval(timer, 1000);
        function timer(){
            count -= 1;
            if (count <= 0){
                clearInterval(counter);
                $("#otpbutton_transfer").html(text);
                $("#otpbutton_transfer").prop("disabled",false);
                return;
            }
            $("#otpbutton_transfer").html(text + ' in ' + count + " seconds.");
        }
    });
    </script>

@include('layouts.footer')
