@include('layouts.header')
@php
App::setLocale(Auth::user()->lang);
@endphp
    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">

            <div class="card-body">
                <a class="btn btn-success float-end" href="{{ route('user.exportTransaction') }}"><i data-feather="external-link" class="me-0"></i> {{ __('Export') }}</a>
            </div>

            <div class="content-header row">
                <h4>{{ __('Wallet balance') }}: 
                    @if ($walletBalance < 0)
                    <span class="badge rounded-pill badge-light-danger me-1">
                    @else
                    <span class="badge rounded-pill badge-light-success me-1">
                    @endif
                    {{number_format($walletBalance,\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator'))}}
                    </span>
                </h4>
            </div>
            <div class="content-body">
                <section class="app-user-wallet-list">
                    <div class="card">
                        <div class="card-body">
                            <div class="table-responsive table-responsive">
                                <table id="tbl-bootstr" class="table table-hover">
                                    <thead class="table-light">
                                        <tr>
                                            <th>{{ __('ID') }}</th>
                                            <th>{{ __('Me') }}</th>
                                            <th>{{ __('Other') }}</th>
                                            <th>{{ __('Type') }}</th>
                                            <th>{{ __('Amount') }}</th>
                                            <th>{{ __('Data') }}</th>
                                            <th>{{ __('Date') }}</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($transactions as $transaction)
                                        <tr>
                                            <td>
                                                {{$transaction->id}}
                                            </td>
                                            <td>
                                                {{$transaction->user->name}}
                                            </td>
                                            <td>
                                                @php($user2=\App\Helpers\Helpers::db('users', 'id', $transaction->user2_id, 'name'))
                                                {{ empty($user2) ? '('.__('Deleted').')' : $user2 }}
                                            </td>
                                            <td>
                                                {{$transaction->type}}
                                            </td>
                                            <td>@if ($transaction->amount < 0 )
                                                <span class="badge rounded-pill badge-light-danger me-1">
                                                @else
                                                <span class="badge rounded-pill badge-light-success me-1">
                                                @endif
                                                {{number_format($transaction->amount,\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator'))}}
                                                </span>
                                            </td>
                                            <td>
                                                {{$transaction->data}}
                                            </td>
                                            <td>
                                                {{$transaction->updated_at}}
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </section>
            </div>
        </div>
    </div>
    <!-- END: Content-->

    <!-- BEGIN: Vendor JS-->
    <script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
    <!-- BEGIN Vendor JS-->

@include('layouts.footer')

<!-- Offline Payment Submission Modal -->
<div class="modal fade" id="offlinePaymentModal" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Submit Offline Payment') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form action="{{ route('transaction.offlinePayment') }}" method="POST" enctype="multipart/form-data">
                @csrf
                <div class="modal-body">
                    <div class="mb-1">
                        <label class="form-label" for="amount">{{ __('Amount') }}</label>
                        <input type="number" name="amount" class="form-control" required />
                    </div>
                    <div class="mb-1">
                        <label class="form-label" for="reference">{{ __('Reference') }}</label>
                        <input type="text" name="reference" class="form-control" />
                    </div>
                    <div class="mb-1">
                        <label class="form-label" for="proof_of_payment">{{ __('Proof of Payment (Upload)') }}</label>
                        <input type="file" name="proof_of_payment" class="form-control" accept="image/*,application/pdf" required />
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="submit" class="btn btn-primary">{{ __('Submit Payment') }}</button>
                    <button type="button" class="btn btn-outline-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
<!--/ Offline Payment Submission Modal -->
