@include('layouts.header')

    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
            </div>
            <div class="content-body">
                <!-- Not authorized-->
                <div class="misc-wrapper">
                    <div class="misc-inner p-2 p-sm-3">
                        <div class="w-100 text-center">
                            <h2 class="mb-1">{{__('You are almost there!')}} 🔐</h2>
                            <p class="mb-2">{{__('Please enter the code that was sent to your phone!')}}</p>
                            <form action="{{ route('user.verifyOtp') }}" method="POST">
                            @csrf
                                <div class="form-group">
                                    <input type="hidden" name="user_id" value="{{$user->id}}">
                                    <input type="hidden" name="email_verified_at" value="{{$user->email_verified_at}}">
                                    <input type="number" name="otp" class="form-control text-center" required>
                                </div>
                                <br>
                                <button type="submit" onclick="this.disabled=true;this.form.submit();" class="btn btn-primary mb-1 btn-sm-block">{{__('Verify NOW')}}</button><br>
                            </form>
                        </div>
                    </div>
                </div>
                <!-- / Not authorized-->
                <!-- Change phone number-->
                <div class="misc-wrapper">
                    <div class="misc-inner p-2 p-sm-3">
                        <div class="w-100 text-center">
                            <h2 class="mb-1">{{__('Change phone number!')}}<i data-feather="phone" class="font-medium-4"></i></h2>
                            <p class="mb-2">{{__('If you believe you put the wrong phone number when register')}}</p>
                            <p class="mb-2">{{__('Please enter it again below! Make sure you put the country code. Example: 5511912341234')}}</p>
                            <p class="mb-2">{{__('If you receive [Waiting for this message...] error on your phone, please reply with [Hi]')}}</p>
                            <p class="mb-2">{{__('Please wait 30 seconds, then click (Re-send new OTP) again.')}}</p>
                            <div class="form-group">
                                <input type="tel" id="phone" name="phone" class="form-control text-center" value="{{$user->phone}}" required>
                                <br>
                                <button type="button" id="otpbutton" class="btn btn-primary mb-1 btn-sm-block">{{ __('Request OTP code') }}</button>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- / Change phone number-->
            </div>
        </div>
    </div>

    <!-- BEGIN: Vendor JS-->
    <script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
    <!-- BEGIN Vendor JS-->

    <script>
    $('#otpbutton').click(function(e) {
        e.preventDefault();
        console.log('otpbutton:', $('#phone').val());
        $.ajax({
            type:"get",
            url: '{{route('user.otpRegister')}}',
            data: {adminSender: '{{$adminSender}}', phone: $('#phone').val(), name: '{{$user?->name}}'},
            success: this.disabled = true,
        });
        var text = this.innerHTML;
        var count = 60;
        var counter = setInterval(timer, 1000);
        function timer(){
            count -= 1;
            if (count <= 0){
                clearInterval(counter);
                document.getElementById("otpbutton").innerHTML = text;
                document.getElementById("otpbutton").disabled = false;
                return;
            }
            document.getElementById("otpbutton").innerHTML = text + ' in ' + count + " seconds.";
        }
    });
    </script>

@include('layouts.footer')
