@include('layouts.header')

@php
App::setLocale(Auth::user()->lang);
@endphp

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-body">
            <section class="app-variable-list">
                <div class="card">
                    <h5 class="card-header">
                        <div class="input-group input-group-sm position-relative mx-auto">
                            {{ __('Custom Variables') }}<span class="badge badge-light-secondary ms-2">{{ $variables->total() }}</span>
                            <input type="search" class="form-control" id="search" value="{{!empty($_GET['search']) ? $_GET['search'] : ''}}" placeholder="{{__('Search')}}..." />
                            <button type="button" class="btn btn-sm btn-info" id="searchbtn"><i data-feather="search" class="me-0"></i></button>
                            <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#addNew">
                                <i data-feather="plus" class="me-1"></i>{{ strtoupper(__('Add Variable')) }}
                            </button>
                        </div>
                    </h5>
                    <div class="card-body">
                        <div class="alert alert-info" role="alert">
                            <div class="alert-body">
                                <i data-feather="info" class="me-50"></i>
                                <strong>{{ __('How to use') }}:</strong> {{ __('Use variables in your messages like this') }}: <code>{variable_name}</code>
                                <br>{{ __('Example') }}: <code>Hello {customer_name}, your order {order_id} is ready!</code>
                            </div>
                        </div>
                        <div class="table-responsive">
                            <table class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th>{{ __('Variable Name') }}</th>
                                        <th>{{ __('Variable Value') }}</th>
                                        <th>{{ __('Description') }}</th>
                                        <th>{{ __('Usage Count') }}</th>
                                        <th>{{ __('Created') }}</th>
                                        <th>{{ __('Actions') }}</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($variables as $variable)
                                    <tr>
                                        <td>
                                            <code class="text-primary">{<strong>{{ $variable->variable_name }}</strong>}</code>
                                        </td>
                                        <td>{{ \Str::limit($variable->variable_value, 40) }}</td>
                                        <td><small class="text-muted">{{ $variable->description }}</small></td>
                                        <td><span class="badge badge-light-info">{{ $variable->usage_count ?? 0 }}</span></td>
                                        <td>{{ $variable->created_at->format('M d, Y') }}</td>
                                        <td>
                                            <div class="dropdown">
                                                <button type="button" class="btn btn-sm btn-icon dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
                                                    <i data-feather="more-vertical"></i>
                                                </button>
                                                <div class="dropdown-menu">
                                                    <a class="dropdown-item" href="#" onclick="copyVariable('{{ $variable->variable_name }}')">
                                                        <i data-feather="copy" class="me-50"></i>{{ __('Copy') }}
                                                    </a>
                                                    <a class="dropdown-item" href="#" onclick="editVariable({{ $variable->id }})">
                                                        <i data-feather="edit" class="me-50"></i>{{ __('Edit') }}
                                                    </a>
                                                    <a class="dropdown-item text-danger" href="#" onclick="deleteVariable({{ $variable->id }})">
                                                        <i data-feather="trash" class="me-50"></i>{{ __('Delete') }}
                                                    </a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="d-flex justify-content-center mt-3">
                            {{ $variables->links() }}
                        </div>
                    </div>
                </div>

                <!-- Predefined Variables Card -->
                <div class="card">
                    <h5 class="card-header">{{ __('System Variables') }}</h5>
                    <div class="card-body">
                        <p class="card-text">{{ __('These variables are automatically available in all messages') }}:</p>
                        <div class="row">
                            <div class="col-md-6">
                                <ul class="list-group">
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <code>{sender_name}</code>
                                        <span class="badge badge-light-primary">{{ __('Sender name') }}</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <code>{sender_phone}</code>
                                        <span class="badge badge-light-primary">{{ __('Sender phone') }}</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <code>{date}</code>
                                        <span class="badge badge-light-primary">{{ __('Current date') }}</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <code>{time}</code>
                                        <span class="badge badge-light-primary">{{ __('Current time') }}</span>
                                    </li>
                                </ul>
                            </div>
                            <div class="col-md-6">
                                <ul class="list-group">
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <code>{company_name}</code>
                                        <span class="badge badge-light-primary">{{ __('Your company') }}</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <code>{company_phone}</code>
                                        <span class="badge badge-light-primary">{{ __('Company phone') }}</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <code>{company_email}</code>
                                        <span class="badge badge-light-primary">{{ __('Company email') }}</span>
                                    </li>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <code>{random_number}</code>
                                        <span class="badge badge-light-primary">{{ __('Random number') }}</span>
                                    </li>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- Modal Add Variable -->
<div class="modal fade" id="addNew" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ __('Create New Variable') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="{{ route('variable.store') }}">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">{{ __('Variable Name') }}*</label>
                        <div class="input-group">
                            <span class="input-group-text">{</span>
                            <input type="text" name="variable_name" class="form-control" placeholder="customer_name" required pattern="[a-z_]+">
                            <span class="input-group-text">}</span>
                        </div>
                        <small class="text-muted">{{ __('Use lowercase letters and underscores only') }}</small>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('Variable Value') }}*</label>
                        <textarea name="variable_value" class="form-control" rows="3" required placeholder="{{ __('Enter the value for this variable') }}"></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">{{ __('Description') }}</label>
                        <input type="text" name="description" class="form-control" placeholder="{{ __('Brief description of this variable') }}">
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ __('Cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ __('Create Variable') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>

@include('layouts.footer')

<script>
function copyVariable(name) {
    const text = `{${name}}`;
    navigator.clipboard.writeText(text).then(() => {
        alert('{{ __("Variable copied to clipboard!") }}');
    });
}

function deleteVariable(id) {
    if (confirm('{{ __("Delete this variable?") }}')) {
        window.location.href = `/variable-destroy?variable_id=${id}`;
    }
}

document.getElementById('searchbtn').addEventListener('click', function() {
    const search = document.getElementById('search').value;
    window.location.href = `{{ route('variable.list') }}?search=${search}`;
});

document.getElementById('search').addEventListener('keypress', function(e) {
    if (e.key === 'Enter') {
        document.getElementById('searchbtn').click();
    }
});
</script>
