@include('layouts.header')
@php
    if (Auth::check() && Auth::user()->lang) {
        App::setLocale(Auth::user()->lang);
    }
@endphp
    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
            </div>
            <div class="content-body">
                <!-- Coming soon page-->
                <div class="misc-wrapper">
                    <a class="brand-logo" href="#">
                        <img src="{{ \App\Helpers\Helpers::setting('logoUrl') }}" alt="nearbuy-logo"   height="36">
                        <!-- <img src="{{ url('app-assets/images/logo/logo.png') }}" alt="nearbuy-logo"   height="36"> -->
                        <h2 class="brand-text text-primary ms-1">{{config('app.name')}}</h2>
                    </a>
                    <div class="misc-inner text-center p-2 p-sm-3">
                        @if(config('app.DEMO'))
                        <h1>THIS IS A DEMO WEBSITE!</h1>
                        <h2>PLEASE READ BELOW ON WHAT TO DO AFTER DONE TESTING!</h2>
                        <span class="mb-2 pb-75">=> PLEASE DO THESE AFTER YOU ARE DONE TESTING: <span class="mb-2 pb-75 text-warning"></span></span><br>
                        <span class="mb-2 pb-75">=> 1. Menu Devices: logout WA and delete devices <span class="mb-2 pb-75 text-warning"></span></span><br>
                        <span class="mb-2 pb-75">=> 2. Menu Outbox: delete all outboxes</span><br>
                        <span class="mb-2 pb-75">=> 3. Menu My-Account: If you create new Account -> Delete account</span><br><br>
                        @endif
                        <div class="w-100">
                            <h2 class="mb-1">Welcome! 👋</h2>
                            <p class="mb-3">We're creating something awesome. Please register and test it out yourself!</p>
                            <img class="img-fluid" src="{{ url('/') }}/app-assets/images/pages/coming-soon.svg" alt="Coming soon page" />
                        </div>
                    </div>
                </div>
                <!-- / Coming soon page-->
                <!-- START DELETE THIS PART -->
                <div class="misc-wrapper">
                    <div class="misc-inner p-2 p-sm-3">
                        <div class="w-100 text-center">
                            <h2 class="mb-1">NearBuyMarts - WHATSAPP GATEWAY 🤖</h2>
                            <span class="mb-2 pb-75">=> login as admin: admin <span class="mb-2 pb-75 text-warning"></span></span><br>
                            <span class="mb-2 pb-75">=> pass as admin : password <span class="mb-2 pb-75 text-warning"></span></span><br>
                            <span class="mb-2 pb-75">=> login as bank: bank <span class="mb-2 pb-75 text-warning"></span></span><br>
                            <span class="mb-2 pb-75">=> pass as bank : password <span class="mb-2 pb-75 text-warning"></span></span><br>
                            <span class="mb-2 pb-75">=> login as user: demo</span><br>
                            <span class="mb-2 pb-75">=> pass as user : password</span><br><br>
                            <span class="mb-2 pb-75 text-warning">***************************************************************************************</span><br><br>
                            <span class="mb-2 pb-75 text-warning">This welcome page location: /resources/views/welcome.blade.php</span><br>
                            <span class="mb-2 pb-75 text-warning">You can edit this file to get the welcome page as you like.</span><br><br>
                            @if(!empty($packages))
                            <span class="mb-2 pb-75 text-warning">By default I already pass the "Packages" to this page, to pull the data out is very simple!</span><br><br>
                            <span class="mb-2 pb-75 text-warning">***************************************************************************************</span><br><br>
                            <div class="card">
                                <div class="table-responsive pt-0">
                                    <table class="table table-hover">
                                        <thead class="table-light">
                                            <tr>
                                                <th>{{ __('Name') }}</th>
                                                <th>{{ __('Description') }}</th>
                                                <th>{{ __('Monthly') }}</th>
                                                <th>{{ __('Outgoing') }}</th>
                                                <th>{{ __('Devices') }}</th>
                                                <th>{{ __('Autoreply Keyword') }}</th>
                                                <th>{{ __('Phonebooks') }}</th>
                                                <th>{{ __('Webhook') }}</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($packages as $package)
                                            <tr>
                                                <td>
                                                <span class="badge rounded-pill badge-light-primary me-1">{{ $package->name }}</span>
                                                </td>
                                                <td>
                                                {{ $package->description }}
                                                </td>
                                                <td>
                                                {{ $package->rate_monthly }}
                                                </td>
                                                <td>
                                                {{ $package->max_outgoing < 0 ? __('Unlimited') : $package->max_outgoing }}
                                                </td>
                                                <td>
                                                {{ $package->max_device < 0 ? __('Unlimited') : $package->max_device }}
                                                </td>
                                                <td>
                                                {{ $package->max_autoreply < 0 ? __('Unlimited') : $package->max_autoreply }}
                                                </td>
                                                <td>
                                                {{ $package->max_phonebook < 0 ? __('Unlimited') : $package->max_phonebook }}
                                                </td>
                                                <td>
                                                {{ $package->webhook ? __('YES') : __('NO') }}
                                                </td>
                                            </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                            <span class="mb-2 pb-75 text-warning">***************************************************************************************</span><br><br>
                            @endif
                            <span class="mb-2 pb-75 text-warning">to enable Whatsapp notification for registration and password reset</span><br><br>
                            <span class="mb-2 pb-75 text-warning"><a href="{{config('app.URL_DOCS_VERIFY_WHATSAPP')}}">{{config('app.URL_DOCS_VERIFY_WHATSAPP')}}</a></span><br><br>
                            <span class="mb-2 pb-75 text-warning">***************************************************************************************</span><br><br>
                            <span class="mb-2 pb-75">=> Menu Device: add sender phone number</span><br>
                            <span class="mb-2 pb-75">click your number in the list and scan with Whatsapp Multi-Device app from your phone</span><br>
                            <span class="mb-2 pb-75">you can use other phone to test for autoreply</span><br>
                            <span class="mb-2 pb-75">keywords: "info"</span><br><br>
                            <span class="mb-2 pb-75">=> Menu Send message: Please choose your phone number in the sender dropdown menu</span><br>
                            <span class="mb-2 pb-75">input the receiver phone number, you can input it in single or multi receiver or both of them (you must add phonebook to send multi receiver)</span><br>
                            <span class="mb-2 pb-75">pick a media file from your local pc (if you want to send media message)</span><br>
                            <span class="mb-2 pb-75">input your text message or you can choose template from dropdown menu (you must add template from Autoreply menu)</span><br><br>
                            <span class="mb-2 pb-75">=> Menu Outbox: this is where all your outgoing messages history will be with it status SENT/FAILED</span><br>
                            <span class="mb-2 pb-75">you can click on each job to get detail messages report</span><br><br>
                        </div>
                    </div>
                </div>
                <!-- / END DELETE THIS PART -->
            </div>
        </div>
    </div>
    <!-- END: Content-->

    <!-- BEGIN: Vendor JS-->
    <script src="{{ url('/') }}/app-assets/vendors/js/vendors.min.js"></script>
    <!-- BEGIN Vendor JS-->

@include('layouts.footer')
