<?php

use App\Http\Controllers\PhonebookController;
use App\Http\Controllers\SendmsgController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\WebhookController;
use App\Http\Controllers\Api\WaTicketApiController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
  return $request->user();
});

Route::get('/phonebook-check', [PhonebookController::class, 'check'])->name('phonebook.check');

Route::post('/autoRenew', [TransactionController::class, 'autoRenew']);
Route::post('/scheduledMsg', [SendmsgController::class, 'scheduledMsg']);
Route::post('/webhook', [WebhookController::class, 'index']);
Route::post('/payment-response', [TransactionController::class, 'paymentResponse']);

Route::post('/send', [SendmsgController::class, 'apiSend']);

// WaTicket API Routes - Protected by Sanctum
Route::middleware('auth:sanctum')->prefix('waticket')->group(function () {
    // Create ticket
    Route::post('/tickets', [WaTicketApiController::class, 'createTicket']);
    
    // List tickets
    Route::get('/tickets', [WaTicketApiController::class, 'listTickets']);
    
    // Get ticket details
    Route::get('/tickets/{ticketNumber}', [WaTicketApiController::class, 'getTicket']);
    
    // Add message to ticket
    Route::post('/tickets/{ticketNumber}/messages', [WaTicketApiController::class, 'addMessage']);
    
    // Update ticket status
    Route::patch('/tickets/{ticketNumber}/status', [WaTicketApiController::class, 'updateStatus']);
    
    // Get statistics
    Route::get('/statistics', [WaTicketApiController::class, 'getStatistics']);
});

// Add New User: https://mydomain.com/public/api/addUser?email=example@gmail.com&phone=112233445566&password=12345678
// Route::get('/addUser', [UserController::class, 'store']);
