<?php

use App\Http\Controllers\AutoreplyController;
use App\Http\Controllers\CaptureController;
use App\Http\Controllers\ChatbotController;
use App\Http\Controllers\CustomVariableController;
use App\Http\Controllers\DeviceController;
use App\Http\Controllers\DocumentationController;
use App\Http\Controllers\InvoiceController;
use App\Http\Controllers\MessageController;
use App\Http\Controllers\ModuleController;
use App\Http\Controllers\NotificationController;
use App\Http\Controllers\OutboxController;
use App\Http\Controllers\PackageController;
use App\Http\Controllers\PhonebookController;
use App\Http\Controllers\RestApiController;
use App\Http\Controllers\SendmsgController;
use App\Http\Controllers\SettingController;
use App\Http\Controllers\SubscriberController;
use App\Http\Controllers\TemplateController;
use App\Http\Controllers\TodoController;
use App\Http\Controllers\TransactionController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\WebhookController;
use App\Http\Controllers\WelcomeController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/', function () {
    return view('landing');
})->middleware('installed')->name('landing');
Route::get('/welcome', [WelcomeController::class, 'index'])->middleware('installed')->name('welcome');
Route::get('/user-banned', [UserController::class, 'banned'])->name('user.banned');
Route::get('/user-deleted', [UserController::class, 'deleted'])->name('user.deleted');
Route::get('/user-otpregister', [UserController::class, 'otpRegister'])->name('user.otpRegister');
Route::get('/user-verify', [UserController::class, 'verify'])->name('user.verify');
Route::post('/user-verifyotp', [UserController::class, 'verifyOtp'])->name('user.verifyOtp');
Route::post('/user-reset', [UserController::class, 'reset'])->name('user.reset');
Route::get('/user-resetnow/{id}/{code}', [UserController::class, 'resetNow'])->name('user.resetNow');
Route::get('/docs', [DocumentationController::class, 'index'])->name('documentations');

Route::group(['middleware' => ['auth', 'banned', 'verified', 'wa.verified']], function () {
  Route::group(['middleware' => ['admin']], function () {
    Route::group(['middleware' => ['demo']], function () {
      Route::get('/module-destroy', [ModuleController::class, 'destroy'])->name('module.destroy');
      Route::get('/module-disable', [ModuleController::class, 'disable'])->name('module.disable');
      Route::get('/module-enable', [ModuleController::class, 'enable'])->name('module.enable');
      Route::post('/module-store', [ModuleController::class, 'store'])->name('module.store');

      Route::get('/package-destroy', [PackageController::class, 'destroy'])->name('package.destroy');
      Route::post('/package-store', [PackageController::class, 'store'])->name('package.store');
      Route::post('/package-update', [PackageController::class, 'update'])->name('package.update');

      Route::get('/setting-clearcache', [SettingController::class, 'clearCache'])->name('setting.clearCache');
      Route::get('/setting-deletekey', [SettingController::class, 'deleteKey'])->name('setting.deleteKey');
      Route::get('/setting-destroy', [SettingController::class, 'destroy'])->name('setting.destroy');
      Route::post('/setting-store', [SettingController::class, 'store'])->name('setting.store');
      Route::post('/setting-update', [SettingController::class, 'update'])->name('setting.update');
      Route::get('/setting-list', [SettingController::class, 'list'])->name('setting.list');
      Route::post('/gateway-update/{gateway_id}', [SettingController::class, 'updateGateway'])->name('gateway.update');

      Route::get('/user-banunban', [UserController::class, 'banUnban'])->name('user.banUnban');
      Route::post('/user-store', [UserController::class, 'store'])->name('user.store');
    });
    Route::get('/documentation/{documentation}', [DocumentationController::class, 'edit'])->name('documentation.edit');
    Route::post('/documentation', [DocumentationController::class, 'store'])->name('documentation.store');
    Route::patch('/documentation/{documentation}', [DocumentationController::class, 'update'])->name('documentation.update');

    Route::get('/device-listall', [DeviceController::class, 'listAll'])->name('device.listAll');
    Route::get('/message-listall', [MessageController::class, 'listAll'])->name('message.listAll');
    Route::get('/module-list', [ModuleController::class, 'list'])->name('module.list');
    Route::get('/outbox-listall', [OutboxController::class, 'listAll'])->name('outbox.listAll');
    Route::get('/package-list', [PackageController::class, 'list'])->name('package.list');
    Route::get('/phonebook-listall', [PhonebookController::class, 'listAll'])->name('phonebook.listAll');
    Route::get('/{user}/impersonate', [UserController::class, 'impersonate'])->name('user.impersonate');
    Route::get('/user-destroy', [UserController::class, 'destroy'])->name('user.destroy');
    Route::get('/user-list', [UserController::class, 'list'])->name('user.list');
  });

  Route::post('/transaction-topup', [TransactionController::class, 'topup'])->name('transaction.topup');
  Route::post('/topupsuccess', [TransactionController::class, 'topupSuccess'])->name('transaction.topupSuccess');
  Route::get('/mpsuccess', [TransactionController::class, 'mpSuccess'])->name('transaction.mpSuccess');
  Route::get('/stripesuccess', [TransactionController::class, 'stripeSuccess'])->name('transaction.stripeSuccess');
  Route::get('/transaction-list', [TransactionController::class, 'list'])->name('transaction.list');
  Route::post('/transaction-transfer', [TransactionController::class, 'transfer'])->name('transaction.transfer');
  Route::post('/transaction-upgrade', [TransactionController::class, 'upgrade'])->name('transaction.upgrade');
  Route::post('/transaction-offline-payment', [TransactionController::class, 'offlinePayment'])->name('transaction.offlinePayment');
  
  // Admin offline payment management
  Route::get('/offline-payments', [TransactionController::class, 'listOfflinePayments'])->name('transaction.listOffline');
  Route::post('/offline-payments/{transaction_id}/approve', [TransactionController::class, 'approveOfflinePayment'])->name('transaction.approveOffline');
  Route::post('/offline-payments/{transaction_id}/reject', [TransactionController::class, 'rejectOfflinePayment'])->name('transaction.rejectOffline');

  Route::get('/user-expired', [UserController::class, 'expired'])->name('user.expired');
  Route::get('/user-show', [UserController::class, 'show'])->name('user.show');
  Route::get('/user-destroysoft', [UserController::class, 'destroySoft'])->name('user.destroySoft');
});

Route::group(['middleware' => ['active', 'auth', 'banned', 'verified', 'wa.verified']], function () {
  Route::get('/autoreply-copy', [AutoreplyController::class, 'copy'])->name('autoreply.copy');
  Route::get('/autoreply-destroy', [AutoreplyController::class, 'destroy'])->name('autoreply.destroy');
  Route::get('/autoreply-samples/{user_id}', [AutoreplyController::class, 'samples'])->name('autoreply.samples');
  Route::get('/autoreply-list', [AutoreplyController::class, 'list'])->name('autoreply.list');
  Route::get('/autoreply-remove', [AutoreplyController::class, 'remove'])->name('autoreply.remove');
  Route::post('/autoreply-store', [AutoreplyController::class, 'store'])->name('autoreply.store');
  Route::post('/autoreply-update', [AutoreplyController::class, 'update'])->name('autoreply.update');

  Route::get('/capture-resetsubjects', [CaptureController::class, 'resetSubjects'])->name('capture.resetSubjects');
  Route::get('/capture-destroy', [CaptureController::class, 'destroy'])->name('capture.destroy');
  Route::get('/capture-destroysubject', [CaptureController::class, 'destroySubject'])->name('capture.destroySubject');
  Route::get('/capture-exportitem', [CaptureController::class, 'exportItem'])->name('capture.exportItem');
  Route::get('/capture-exportsubject', [CaptureController::class, 'exportSubject'])->name('capture.exportSubject');
  Route::get('/capture-list', [CaptureController::class, 'list'])->name('capture.list');
  Route::get('/capture-savesubjects', [CaptureController::class, 'saveSubjects'])->name('capture.saveSubjects');
  Route::get('/capture-show', [CaptureController::class, 'show'])->name('capture.show');
  Route::post('/capture-update', [CaptureController::class, 'update'])->name('capture.update');

  Route::get('/dashboard', function () {
    return redirect()->route('device.list');
  })->name('dashboard');

  Route::get('/device-destroy', [DeviceController::class, 'destroy'])->name('device.destroy');
  Route::get('/device-list', [DeviceController::class, 'list'])->name('device.list');
  Route::get('/device-oaidestroychats', [DeviceController::class, 'oaiDestroyChats'])->name('device.oaiDestroyChats');
  Route::get('/device-gaidestroychats', [DeviceController::class, 'gaiDestroyChats'])->name('device.gaiDestroyChats');
  Route::get('/device-show', [DeviceController::class, 'show'])->name('device.show');
  Route::get('/device-showcontacts', [DeviceController::class, 'showContacts'])->name('device.showContacts');
  Route::post('/device-store', [DeviceController::class, 'store'])->name('device.store');
  Route::post('/device-update', [DeviceController::class, 'update'])->name('device.update');
  Route::post('/device-updateprofile', [DeviceController::class, 'updateProfile'])->name('device.updateProfile');

  Route::get('/message-destroy', [MessageController::class, 'destroy'])->name('message.destroy');
  Route::get('/message-destroyall', [MessageController::class, 'destroyAll'])->name('message.destroyAll');
  Route::get('/message-export', [MessageController::class, 'export'])->name('message.export');
  Route::get('/message-list', [MessageController::class, 'list'])->name('message.list');
  Route::post('/message-update', [MessageController::class, 'update'])->name('message.update');

  Route::get('/outbox-destroyfilter', [OutboxController::class, 'destroyFilter'])->name('outbox.destroyFilter');
  Route::get('/outbox-destroyjob', [OutboxController::class, 'destroyJob'])->name('outbox.destroyJob');
  Route::get('/outbox-destroyobx', [OutboxController::class, 'destroyObx'])->name('outbox.destroyObx');
  Route::get('/outbox-destroyall', [OutboxController::class, 'destroyAll'])->name('outbox.destroyAll');
  Route::get('/outbox-destroystatus', [OutboxController::class, 'destroyStatus'])->name('outbox.destroyStatus');
  Route::get('/outbox-export', [OutboxController::class, 'export'])->name('outbox.export');
  Route::get('/outbox-filterstatus', [OutboxController::class, 'filterStatus'])->name('outbox.filterStatus');
  Route::get('/outbox-list', [OutboxController::class, 'list'])->name('outbox.list');
  Route::get('/outbox-pause', [OutboxController::class, 'pause'])->name('outbox.pause');
  Route::get('/outbox-resume', [OutboxController::class, 'resume'])->name('outbox.resume');
  Route::get('/outbox-resendfailed', [OutboxController::class, 'resendFailed'])->name('outbox.resendFailed');
  Route::get('/outbox-show', [OutboxController::class, 'show'])->name('outbox.show');
  Route::get('/outbox-filterstatusrecurring', [OutboxController::class, 'filterStatusRecurring'])->name('outbox.filterStatusRecurring');
  Route::get('/outbox-listrecurring', [OutboxController::class, 'listRecurring'])->name('outbox.listRecurring');
  Route::get('/outbox-showrecurring', [OutboxController::class, 'showRecurring'])->name('outbox.showRecurring');

  Route::get('/phonebook-addcontact', [PhonebookController::class, 'addContact'])->name('phonebook.addContact');
  Route::get('/phonebook-destroy', [PhonebookController::class, 'destroy'])->name('phonebook.destroy');
  Route::get('/phonebook-destroycontact', [PhonebookController::class, 'destroyContact'])->name('phonebook.destroyContact');
  Route::get('/phonebook-editcontact', [PhonebookController::class, 'editContact'])->name('phonebook.editContact');
  Route::get('/phonebook-export', [PhonebookController::class, 'export'])->name('phonebook.export');
  Route::get('/phonebook-exportgroups', [PhonebookController::class, 'exportGroups'])->name('phonebook.exportGroups');
  Route::get('/phonebook-exportparticipants', [PhonebookController::class, 'exportParticipants'])->name('phonebook.exportParticipants');
  Route::get('/phonebook-list', [PhonebookController::class, 'list'])->name('phonebook.list');
  Route::get('/phonebook-show', [PhonebookController::class, 'show'])->name('phonebook.show');
  Route::post('/phonebook-store', [PhonebookController::class, 'store'])->name('phonebook.store');
  Route::post('/phonebook-scrape', [PhonebookController::class, 'scrapeGMaps'])->name('phonebook.scrapeGMaps');
  Route::get('/phonebook-storeparticipants', [PhonebookController::class, 'storeParticipants'])->name('phonebook.storeParticipants');
  Route::get('/phonebook-storegroups', [PhonebookController::class, 'storeGroups'])->name('phonebook.storeGroups');
  Route::post('/phonebook-update', [PhonebookController::class, 'update'])->name('phonebook.update');

  Route::get('/restapi', [RestApiController::class, 'index'])->name('restapi.index');

  Route::get('/template-destroy', [TemplateController::class, 'destroy'])->name('template.destroy');
  Route::get('/template-list', [TemplateController::class, 'list'])->name('template.list');
  Route::post('/template-store', [TemplateController::class, 'store'])->name('template.store');
  Route::post('/template-update', [TemplateController::class, 'update'])->name('template.update');

  Route::get('/sendmsg', [SendmsgController::class, 'index'])->name('sendmsg.index');
  Route::post('/sendmsg-store', [SendmsgController::class, 'store'])->name('sendmsg.store');

  Route::get('/subscriber-destroy', [SubscriberController::class, 'destroy'])->name('subscriber.destroy');
  Route::get('/subscriber-export', [SubscriberController::class, 'export'])->name('subscriber.export');
  Route::get('/subscriber-list', [SubscriberController::class, 'list'])->name('subscriber.list');
  Route::post('/subscriber-update', [SubscriberController::class, 'update'])->name('subscriber.update');

  Route::get('/leave-impersonate', [UserController::class, 'leaveImpersonate'])->name('user.leaveImpersonate');
  Route::get('/user-exporttransaction', [UserController::class, 'exportTransaction'])->name('user.exportTransaction');
  Route::get('/user-locale', [UserController::class, 'locale'])->name('user.locale');
  Route::get('/user-otpsend', [UserController::class, 'otpSend'])->name('user.otpSend');
  Route::post('/user-update', [UserController::class, 'update'])->name('user.update');
  Route::post('/user-updateAvatar', [UserController::class, 'updateAvatar'])->name('user.updateAvatar');

  Route::get('/webhook-show', [WebhookController::class, 'show'])->name('webhook.show');
  Route::get('/webhook-reset', [WebhookController::class, 'reset'])->name('webhook.reset');
  Route::post('/webhook-save', [WebhookController::class, 'save'])->name('webhook.save');

  // Invoice routes
  Route::get('/invoice-list', [InvoiceController::class, 'list'])->name('invoice.list');
  Route::get('/invoice-show/{id}', [InvoiceController::class, 'show'])->name('invoice.show');
  Route::get('/invoice-create', [InvoiceController::class, 'create'])->name('invoice.create');
  Route::post('/invoice-store', [InvoiceController::class, 'store'])->name('invoice.store');
  Route::get('/invoice-generate/{transaction_id}', [InvoiceController::class, 'generateFromTransaction'])->name('invoice.generate');
  Route::get('/invoice-download/{id}', [InvoiceController::class, 'download'])->name('invoice.download');
  Route::get('/invoice-pdf/{id}', [InvoiceController::class, 'download'])->name('invoice.pdf');
  Route::get('/invoice-print/{id}', [InvoiceController::class, 'download'])->name('invoice.print');
  Route::post('/invoice-markpaid/{id}', [InvoiceController::class, 'markAsPaid'])->name('invoice.markAsPaid');
  Route::get('/invoice-destroy/{id}', [InvoiceController::class, 'destroy'])->name('invoice.destroy');

  // Chatbot routes
  Route::get('/chatbot-list', [ChatbotController::class, 'list'])->name('chatbot.list');
  Route::get('/chatbot-show/{id}', [ChatbotController::class, 'show'])->name('chatbot.show');
  Route::get('/chatbot-create', [ChatbotController::class, 'create'])->name('chatbot.create');
  Route::post('/chatbot-store', [ChatbotController::class, 'store'])->name('chatbot.store');
  Route::post('/chatbot-update', [ChatbotController::class, 'update'])->name('chatbot.update');
  Route::get('/chatbot-destroy', [ChatbotController::class, 'destroy'])->name('chatbot.destroy');
  Route::get('/chatbot-toggle/{id}', [ChatbotController::class, 'toggleStatus'])->name('chatbot.toggle');
  Route::get('/chatbot-sessions/{id}', [ChatbotController::class, 'sessions'])->name('chatbot.sessions');
  Route::get('/chatbot-clearsessions/{id}', [ChatbotController::class, 'clearSessions'])->name('chatbot.clearSessions');
  Route::post('/chatbot-intent-store', [ChatbotController::class, 'storeIntent'])->name('chatbot.intent.store');

  // Custom Variable routes
  Route::get('/variable-list', [CustomVariableController::class, 'list'])->name('variable.list');
  Route::post('/variable-store', [CustomVariableController::class, 'store'])->name('variable.store');
  Route::post('/variable-update', [CustomVariableController::class, 'update'])->name('variable.update');
  Route::get('/variable-destroy', [CustomVariableController::class, 'destroy'])->name('variable.destroy');
  Route::post('/variable-bulkimport', [CustomVariableController::class, 'bulkImport'])->name('variable.bulkImport');

  // Notification routes
  Route::get('/notifications', [NotificationController::class, 'index'])->name('notification.index');
  Route::get('/notification-markread/{id}', [NotificationController::class, 'markAsRead'])->name('notification.markAsRead');
  Route::get('/notification-markallread', [NotificationController::class, 'markAllAsRead'])->name('notification.markAllAsRead');
  Route::get('/notification-destroy/{id}', [NotificationController::class, 'destroy'])->name('notification.destroy');
  Route::get('/notification-destroyall', [NotificationController::class, 'destroyAll'])->name('notification.destroyAll');
  Route::get('/api/notifications/unread-count', [NotificationController::class, 'unreadCount'])->name('notification.unreadCount');

  // Todo routes
  Route::get('/todo-list', [TodoController::class, 'list'])->name('todo.list');
  Route::get('/todo-show/{id}', [TodoController::class, 'show'])->name('todo.show');
  Route::get('/todo-create', [TodoController::class, 'create'])->name('todo.create');
  Route::post('/todo-store', [TodoController::class, 'store'])->name('todo.store');
  Route::post('/todo-update', [TodoController::class, 'update'])->name('todo.update');
  Route::post('/todo-markcompleted', [TodoController::class, 'markCompleted'])->name('todo.markCompleted');
  Route::post('/todo-togglestatus', [TodoController::class, 'toggleStatus'])->name('todo.toggleStatus');
  Route::get('/todo-destroy', [TodoController::class, 'destroy'])->name('todo.destroy');
  Route::get('/todo-calendar', [TodoController::class, 'calendar'])->name('todo.calendar');
  Route::get('/api/todo-upcoming', [TodoController::class, 'upcoming'])->name('todo.upcoming');

  // Support Ticket routes
  Route::get('/support/tickets', [App\Http\Controllers\SupportTicketController::class, 'index'])->name('support.tickets.index');
  Route::get('/support/tickets/create', [App\Http\Controllers\SupportTicketController::class, 'create'])->name('support.tickets.create');
  Route::get('/support/tickets/statistics', [App\Http\Controllers\SupportTicketController::class, 'getStatistics'])->name('support.tickets.statistics');
  Route::post('/support/tickets', [App\Http\Controllers\SupportTicketController::class, 'store'])->name('support.tickets.store');
  Route::get('/support/tickets/{id}', [App\Http\Controllers\SupportTicketController::class, 'show'])->name('support.tickets.show');
  Route::post('/support/tickets/{id}/assign', [App\Http\Controllers\SupportTicketController::class, 'assign'])->name('support.tickets.assign');
  Route::post('/support/tickets/{id}/accept', [App\Http\Controllers\SupportTicketController::class, 'accept'])->name('support.tickets.accept');
  Route::post('/support/tickets/{id}/resolve', [App\Http\Controllers\SupportTicketController::class, 'resolve'])->name('support.tickets.resolve');
  Route::post('/support/tickets/{id}/reopen', [App\Http\Controllers\SupportTicketController::class, 'reopen'])->name('support.tickets.reopen');
  Route::post('/support/tickets/{id}/close', [App\Http\Controllers\SupportTicketController::class, 'close'])->name('support.tickets.close');
  Route::post('/support/tickets/{id}/message', [App\Http\Controllers\SupportTicketController::class, 'addMessage'])->name('support.tickets.addMessage');
  Route::post('/support/tickets/{id}/upload', [App\Http\Controllers\SupportTicketController::class, 'uploadAttachment'])->name('support.tickets.upload');

  // Support Agent routes
  Route::get('/support/agents', [App\Http\Controllers\TicketAgentController::class, 'index'])->name('support.agents.index');
  Route::get('/support/agents/create', [App\Http\Controllers\TicketAgentController::class, 'create'])->name('support.agents.create');
  Route::post('/support/agents', [App\Http\Controllers\TicketAgentController::class, 'store'])->name('support.agents.store');
  Route::get('/support/agents/{id}', [App\Http\Controllers\TicketAgentController::class, 'show'])->name('support.agents.show');
  Route::get('/support/agents/{id}/edit', [App\Http\Controllers\TicketAgentController::class, 'edit'])->name('support.agents.edit');
  Route::post('/support/agents/{id}', [App\Http\Controllers\TicketAgentController::class, 'update'])->name('support.agents.update');
  Route::get('/support/agents/{id}/delete', [App\Http\Controllers\TicketAgentController::class, 'destroy'])->name('support.agents.destroy');
  Route::post('/support/agents/{id}/status', [App\Http\Controllers\TicketAgentController::class, 'updateStatus'])->name('support.agents.updateStatus');
  Route::get('/support/agents/available', [App\Http\Controllers\TicketAgentController::class, 'getAvailableAgents'])->name('support.agents.available');
  Route::get('/support/agents/performance', [App\Http\Controllers\TicketAgentController::class, 'getPerformanceReport'])->name('support.agents.performance');

  // Lead routes
  Route::get('/support/leads', [App\Http\Controllers\LeadController::class, 'index'])->name('support.leads.index');
  Route::get('/support/leads/create', [App\Http\Controllers\LeadController::class, 'create'])->name('support.leads.create');
  Route::post('/support/leads', [App\Http\Controllers\LeadController::class, 'store'])->name('support.leads.store');
  Route::get('/support/leads/{id}', [App\Http\Controllers\LeadController::class, 'show'])->name('support.leads.show');
  Route::get('/support/leads/{id}/edit', [App\Http\Controllers\LeadController::class, 'edit'])->name('support.leads.edit');
  Route::post('/support/leads/{id}', [App\Http\Controllers\LeadController::class, 'update'])->name('support.leads.update');
  Route::get('/support/leads/{id}/delete', [App\Http\Controllers\LeadController::class, 'destroy'])->name('support.leads.destroy');
  Route::post('/support/leads/{id}/qualify', [App\Http\Controllers\LeadController::class, 'qualify'])->name('support.leads.qualify');
  Route::post('/support/leads/{id}/convert', [App\Http\Controllers\LeadController::class, 'convert'])->name('support.leads.convert');
  Route::post('/support/leads/{id}/lost', [App\Http\Controllers\LeadController::class, 'markAsLost'])->name('support.leads.lost');
  Route::post('/support/leads/{id}/assign', [App\Http\Controllers\LeadController::class, 'assignToAgent'])->name('support.leads.assign');
  Route::post('/support/leads/{id}/score', [App\Http\Controllers\LeadController::class, 'updateScore'])->name('support.leads.score');
  Route::post('/support/leads/{id}/note', [App\Http\Controllers\LeadController::class, 'addNote'])->name('support.leads.note');

  // Staff Management routes
  Route::get('/staff', [App\Http\Controllers\StaffController::class, 'index'])->name('staff.index');
  Route::post('/staff/store', [App\Http\Controllers\StaffController::class, 'store'])->name('staff.store');
  Route::post('/staff/update', [App\Http\Controllers\StaffController::class, 'update'])->name('staff.update');
  Route::post('/staff/destroy', [App\Http\Controllers\StaffController::class, 'destroy'])->name('staff.destroy');
  Route::get('/staff/toggle/{id}', [App\Http\Controllers\StaffController::class, 'toggleStatus'])->name('staff.toggle');

  // API Token Management routes
  Route::get('/api-tokens', [App\Http\Controllers\ApiTokenController::class, 'index'])->name('api.tokens.index');
  Route::post('/api-tokens', [App\Http\Controllers\ApiTokenController::class, 'store'])->name('api.tokens.store');
  Route::get('/api-tokens/{id}', [App\Http\Controllers\ApiTokenController::class, 'show'])->name('api.tokens.show');
  Route::delete('/api-tokens/{id}', [App\Http\Controllers\ApiTokenController::class, 'destroy'])->name('api.tokens.destroy');
  Route::post('/api-tokens/test', [App\Http\Controllers\ApiTokenController::class, 'test'])->name('api.tokens.test');
  Route::get('/api-documentation', [App\Http\Controllers\ApiTokenController::class, 'documentation'])->name('api.documentation');
});

require __DIR__ . '/auth.php';
