<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <h4><?php echo e(__('Outbox list')); ?><span class="badge rounded-pill badge-light-secondary"><?php echo e($allCount); ?></span></h4>
        </div>
        <div class="content-body">
            <!-- Search Jumbotron -->
            <section id="kb-search">
                <div class="row">
                    <div class="col-12">
                        <div class="card search-bg text-center" style="background-image: url('app-assets/images/banner/banner.png')">
                            <div class="card-body">
                                <form class="kb-search-input">
                                    <div class="input-group input-group-merge">
                                        <span class="input-group-text"><i data-feather="search"></i></span>
                                        <input type="text" class="form-control" id="searchbar" placeholder="<?php echo e(__('Name')); ?>/<?php echo e(__('Phone')); ?>/<?php echo e(__('Message')); ?>" />

                                        <?php if(!$listAll): ?>
                                        <button type="button" class="btn btn-sm btn-info float-end" data-bs-toggle="modal" data-bs-target="#resendFailed">
                                            <i data-feather="send" class="me-0"></i> <?php echo e(strtoupper(__('Resend failed'))); ?> (<?php echo e($failedCount); ?>)
                                        </button>
                                        <!-- Modal resendFailed-->
                                        <div class="modal fade modal-info text-start" id="resendFailed" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Resend confirmation')); ?></h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <?php echo e(__('Are you sure you want to resend?')); ?> <br>
                                                        <?php echo e(__('This will change the FAILED status to PENDING')); ?> <br>
                                                        <?php echo e(__('The outbox will be sent on next crob job schedule')); ?>

                                                    </div>
                                                    <div class="modal-footer">
                                                    <a class="btn btn-sm btn-info" href="<?php echo e(route('outbox.resendFailed', ['user_id' => Auth::user()->id, 'status' => 'PENDING'])); ?>"><?php echo e(__('Resend')); ?></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <button type="button" class="btn btn-sm btn-primary float-end dropdown-toggle" id="filterButton" data-bs-toggle="dropdown" aria-expanded="false">
                                            <i data-feather="filter" class="me-0"></i> <?php echo e(strtoupper(__('Filter'))); ?>

                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="filterButton">
                                            <a class="dropdown-item" href="<?php echo e(route('outbox.filterStatus', ['status' => 'PENDING', 'pendingCount' => $pendingCount, 'sentCount' => $sentCount, 'failedCount' => $failedCount])); ?>"><i data-feather="filter" class="me-0"></i> <?php echo e(__('Filter PENDING')); ?> (<?php echo e($pendingCount); ?>)</a>
                                            <a class="dropdown-item" href="<?php echo e(route('outbox.filterStatus', ['status' => 'SENT', 'pendingCount' => $pendingCount, 'sentCount' => $sentCount, 'failedCount' => $failedCount])); ?>"><i data-feather="filter" class="me-0"></i> <?php echo e(__('Filter SENT')); ?> (<?php echo e($sentCount); ?>)</a>
                                            <a class="dropdown-item" href="<?php echo e(route('outbox.filterStatus', ['status' => 'FAILED', 'pendingCount' => $pendingCount, 'sentCount' => $sentCount, 'failedCount' => $failedCount])); ?>"><i data-feather="filter" class="me-0"></i> <?php echo e(__('Filter FAILED')); ?> (<?php echo e($failedCount); ?>)</a>
                                        </div>
                                        
                                        <button type="button" class="btn btn-sm btn-success float-end dropdown-toggle" id="exportButton" data-bs-toggle="dropdown" aria-expanded="false">
                                            <i data-feather="filter" class="me-0"></i> <?php echo e(strtoupper(__('Export'))); ?>

                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="exportButton">
                                            <a class="dropdown-item" href="<?php echo e(route('outbox.export', ['status' => 'PENDING'])); ?>"><i data-feather="external-link" class="me-0"></i> <?php echo e(__('Export PENDING')); ?> (<?php echo e($pendingCount); ?>)</a>
                                            <a class="dropdown-item" href="<?php echo e(route('outbox.export', ['status' => 'SENT'])); ?>"><i data-feather="external-link" class="me-0"></i> <?php echo e(__('Export SENT')); ?> (<?php echo e($sentCount); ?>)</a>
                                            <a class="dropdown-item" href="<?php echo e(route('outbox.export', ['status' => 'FAILED'])); ?>"><i data-feather="external-link" class="me-0"></i> <?php echo e(__('Export FAILED')); ?> (<?php echo e($failedCount); ?>)</a>
                                            <a class="dropdown-item" href="<?php echo e(route('outbox.export')); ?>"><i data-feather="external-link" class="me-0"></i> <?php echo e(__('Export ALL')); ?> (<?php echo e($allCount); ?>)</a>
                                        </div>
                                        
                                        <button type="button" class="btn btn-sm btn-danger float-end dropdown-toggle" id="trashButton" data-bs-toggle="dropdown" aria-expanded="false">
                                            <i data-feather="trash" class="me-0"></i> <?php echo e(strtoupper(__('Delete'))); ?> (<?php echo e($pendingCount); ?> / <?php echo e($sentCount); ?> / <?php echo e($failedCount); ?> / <?php echo e($allCount); ?>)
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="trashButton">
                                            <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroyStatusPENDING"><i data-feather="trash" class="me-0"></i> <?php echo e(__('Delete PENDING')); ?> (<?php echo e($pendingCount); ?>)</a>
                                            <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroyStatusSENT"><i data-feather="trash" class="me-0"></i> <?php echo e(__('Delete SENT')); ?> (<?php echo e($sentCount); ?>)</a>
                                            <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroyStatusFAILED"><i data-feather="trash" class="me-0"></i> <?php echo e(__('Delete FAILED')); ?> (<?php echo e($failedCount); ?>)</a>
                                            <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroyAll"><i data-feather="trash" class="me-0"></i> <?php echo e(__('Delete ALL')); ?>  (<?php echo e($allCount); ?>)</a>
                                        </div>
                                        
                                        <!-- Modal destroyAll-->
                                        <div class="modal fade modal-danger text-start" id="destroyAll" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Delete confirmation')); ?></h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <?php echo e(__('Are you sure you want to delete?')); ?> <br><br>
                                                        <span class="text text-danger"> <b><?php echo e(__('ALL')); ?></b> </span><br><br>
                                                        <?php echo e(__('This process is irreversible')); ?> <br>
                                                        <?php echo e(__('The record(s) will be deleted from the database permanently')); ?>

                                                    </div>
                                                    <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="<?php echo e(route('outbox.destroyAll', ['user_id' => Auth::user()->id])); ?>"><?php echo e(__('Delete')); ?></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <!-- Modal destroyStatusFAILED-->
                                        <div class="modal fade modal-danger text-start" id="destroyStatusFAILED" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Delete confirmation')); ?></h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <?php echo e(__('Are you sure you want to delete?')); ?> <br><br>
                                                        <span class="text text-danger"> <b><?php echo e(__('ALL')); ?> (<?php echo e(__('FAILED')); ?>)</b> </span><br><br>
                                                        <?php echo e(__('This process is irreversible')); ?> <br>
                                                        <?php echo e(__('The record(s) will be deleted from the database permanently')); ?>

                                                    </div>
                                                    <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="<?php echo e(route('outbox.destroyStatus', ['user_id' => Auth::user()->id, 'status' => 'FAILED'])); ?>"><?php echo e(__('Delete')); ?></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Modal destroyStatusSENT-->
                                        <div class="modal fade modal-danger text-start" id="destroyStatusSENT" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Delete confirmation')); ?></h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <?php echo e(__('Are you sure you want to delete?')); ?> <br><br>
                                                        <span class="text text-danger"> <b><?php echo e(__('ALL')); ?> (<?php echo e(__('SENT')); ?>)</b> </span><br><br>
                                                        <?php echo e(__('This process is irreversible')); ?> <br>
                                                        <?php echo e(__('The record(s) will be deleted from the database permanently')); ?>

                                                    </div>
                                                    <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="<?php echo e(route('outbox.destroyStatus', ['user_id' => Auth::user()->id, 'status' => 'SENT'])); ?>"><?php echo e(__('Delete')); ?></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <!-- Modal destroyStatusPENDING-->
                                        <div class="modal fade modal-danger text-start" id="destroyStatusPENDING" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                            <div class="modal-dialog modal-dialog-centered">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Delete confirmation')); ?></h5>
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                    </div>
                                                    <div class="modal-body">
                                                        <?php echo e(__('Are you sure you want to delete?')); ?> <br><br>
                                                        <span class="text text-danger"> <b><?php echo e(__('ALL')); ?> (<?php echo e(__('PENDING')); ?>)</b> </span><br><br>
                                                        <?php echo e(__('This process is irreversible')); ?> <br>
                                                        <?php echo e(__('The record(s) will be deleted from the database permanently')); ?>

                                                    </div>
                                                    <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="<?php echo e(route('outbox.destroyStatus', ['user_id' => Auth::user()->id, 'status' => 'PENDING'])); ?>"><?php echo e(__('Delete')); ?></a>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <?php endif; ?>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--/ Search Jumbotron -->
            <!-- job list start -->
            <section class="app-job-list">
                <!-- list and filter start -->
                <div class="card">
                    <div class="table-responsive pt-0 kb-search-content-info match-height">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th> <?php echo e(__('Job ID')); ?> </th>
                                    <th> <?php echo e(__('Sender')); ?> </th>
                                    <th> <?php echo e(__('Created')); ?> </th>
                                    <th> <?php echo e(__('Status')); ?> </th>
                                    <th> <?php echo e(__('Actions')); ?> </th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $jobs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $job): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr class="kb-search-content">
                                    <td hidden><?php echo e($job->msgtext); ?></td>
                                    <td hidden><?php echo e($job->rec_name); ?></td>
                                    <td hidden><?php echo e($job->receiver); ?></td>
                                    <td hidden><?php echo e($job->sender); ?></td>
                                    <td><a href="<?php echo e(route('outbox.show', ['job_id' => $job->job_id])); ?>">
                                    <?php echo e($job->job_id); ?></a>
                                    </td>
                                    <td><?php echo e($job->sender); ?></td>
                                    <td><a href="<?php echo e(route('outbox.show', ['job_id' => $job->job_id])); ?>">
                                        <span class="badge rounded-pill badge-light-success"><?php echo e(Carbon\Carbon::parse((int)$job->job_id)->timezone(config('app.timezone'))); ?></span></a>
                                    </td>
                                    <td><a href="<?php echo e(route('outbox.show', ['job_id' => $job->job_id])); ?>">
                                    <?php
                                    $job->pause = $job->where([['job_id', '=', $job->job_id],['status', '=', 'PAUSED']])->count();
                                    $job->pending = $job->where([['job_id', '=', $job->job_id],['status', '=', 'PENDING']])->count();
                                    $job->sending = $job->where([['job_id', '=', $job->job_id],['status', '=', 'SENDING']])->count();
                                    $job->sent = $job->where([['job_id', '=', $job->job_id],['status', '=', 'SENT']])->count();
                                    $job->failed = $job->where([['job_id', '=', $job->job_id],['status', 'like', 'FAILED%']])->count();
                                    ?>
                                    <?php if($job->pause > 0): ?>
                                    <span class="badge rounded-pill badge-light-secondary me-1"><?php echo e($job->pause . ' ' . __('PAUSED')); ?></span>
                                    <?php elseif($job->sending > 0): ?>
                                    <span class="badge rounded-pill badge-light-primary me-1"><?php echo e($job->sending . ' ' . __('SENDING')); ?></span>
                                    <?php else: ?>
                                    <span class="badge rounded-pill badge-light-warning me-1"><?php echo e($job->pending . ' ' . __('PENDING')); ?></span>
                                    <?php endif; ?>
                                    <span class="badge rounded-pill badge-light-success me-1"><?php echo e($job->sent . ' ' . __('SENT')); ?></span>
                                    <span class="badge rounded-pill badge-light-danger me-1"><?php echo e($job->failed . ' ' . __('FAILED')); ?></span>
                                    <span class="badge rounded-pill badge-light-primary me-1"><?php echo e($job->total . ' ' . __('TOTAL')); ?></a>
                                    </td>
                                    <td>
                                        <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton" data-bs-toggle="dropdown" aria-expanded="false">
                                            <i data-feather="command" class="me-0"></i>
                                        </button>
                                        <div class="dropdown-menu" aria-labelledby="actionButton">
                                            <a class="dropdown-item" href="<?php echo e(route('outbox.show', ['job_id' => $job->job_id])); ?>"><i data-feather="eye" class="me-0"></i> <?php echo e(__('View')); ?></a>
                                            <?php if($job->sending > 0): ?>
                                            <a class="dropdown-item" href="<?php echo e(route('outbox.pause', ['job_id' => $job->job_id])); ?>"><i data-feather="pause" class="me-0"></i> <?php echo e(__('Pause')); ?></a>
                                            <?php endif; ?>
                                            <?php if($job->pause > 0 || $job->sending > 0): ?>
                                            <a class="dropdown-item" href="<?php echo e(route('outbox.resume', ['job_id' => $job->job_id])); ?>"><i data-feather="pause" class="me-0"></i> <?php echo e(__('Stop')); ?> <i data-feather="play" class="me-0"></i> <?php echo e(__('Resume')); ?></a>
                                            <?php endif; ?>
                                            <?php if($job->failed > 0): ?>
                                            <a class="dropdown-item" href="<?php echo e(route('outbox.resendFailed', ['job_id' => $job->job_id])); ?>"><i data-feather="send" class="me-0"></i> <?php echo e(__('Resend failed')); ?></a>
                                            <?php endif; ?>
                                            <div class="dropdown-divider"></div>
                                            <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-<?php echo e($job->job_id * 1000); ?>"><i data-feather="trash" class="me-0"></i> <?php echo e(__('Delete')); ?></a>
                                        </div>
                                    </td>
                                </tr>
                                <!-- Delete Modal -->
                                <div class="modal fade modal-danger text-start" id="destroy-<?php echo e($job->job_id * 1000); ?>" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                    <div class="modal-dialog modal-dialog-centered">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Delete confirmation')); ?></h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <div class="modal-body">
                                                <?php echo e(__('Are you sure you want to delete?')); ?> <br><br>
                                                <span class="text text-danger"> <b><?php echo e($job->job_id); ?></b> </span><br><br>
                                                <?php echo e(__('This process is irreversible')); ?> <br>
                                                <?php echo e(__('The record(s) will be deleted from the database permanently')); ?>

                                            </div>
                                            <div class="modal-footer">
                                            <a class="btn btn-sm btn-danger" href="<?php echo e(route('outbox.destroyJob', ['job_id' => $job->job_id])); ?>"><?php echo e(__('Delete')); ?></a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
                <!-- list and filter end -->
            </section>
            <!-- jobs list ends -->
            <div class="row">
                <div class="col-md-12">
                    <?php echo e($jobs->links()); ?>

                </div>
            </div>
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/vendors.min.js"></script>
<!-- BEGIN Vendor JS-->

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views//outbox-list.blade.php ENDPATH**/ ?>