<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php
App::setLocale(Auth::user()->lang);
?>

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <!-- Statistics Cards -->
        <div class="row">
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($statistics['total']); ?></h3>
                            <span><?php echo e(__('Total Tickets')); ?></span>
                        </div>
                        <div class="avatar bg-light-primary p-50">
                            <span class="avatar-content">
                                <i data-feather="inbox" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($statistics['new']); ?></h3>
                            <span><?php echo e(__('New Tickets')); ?></span>
                        </div>
                        <div class="avatar bg-light-info p-50">
                            <span class="avatar-content">
                                <i data-feather="alert-circle" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($statistics['open']); ?></h3>
                            <span><?php echo e(__('Open Tickets')); ?></span>
                        </div>
                        <div class="avatar bg-light-warning p-50">
                            <span class="avatar-content">
                                <i data-feather="clock" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($statistics['unassigned']); ?></h3>
                            <span><?php echo e(__('Unassigned')); ?></span>
                        </div>
                        <div class="avatar bg-light-danger p-50">
                            <span class="avatar-content">
                                <i data-feather="user-x" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="content-body">
            <section class="app-ticket-list">
                <!-- Filters and Action Bar -->
                <div class="card">
                    <div class="card-header border-bottom">
                        <h4 class="card-title"><?php echo e(__('Support Tickets')); ?></h4>
                        <a href="<?php echo e(route('support.tickets.create')); ?>" class="btn btn-primary">
                            <i data-feather="plus" class="me-25"></i>
                            <span><?php echo e(__('Create Ticket')); ?></span>
                        </a>
                    </div>
                    <div class="card-body">
                        <!-- Filters -->
                        <form method="GET" action="<?php echo e(route('support.tickets.index')); ?>" class="mb-2">
                            <div class="row">
                                <div class="col-md-3 mb-1">
                                    <label class="form-label"><?php echo e(__('Status')); ?></label>
                                    <select name="status" class="form-select" onchange="this.form.submit()">
                                        <option value="all" <?php echo e(request('status') == 'all' ? 'selected' : ''); ?>><?php echo e(__('All Status')); ?></option>
                                        <option value="new" <?php echo e(request('status') == 'new' ? 'selected' : ''); ?>><?php echo e(__('New')); ?></option>
                                        <option value="open" <?php echo e(request('status') == 'open' ? 'selected' : ''); ?>><?php echo e(__('Open')); ?></option>
                                        <option value="pending" <?php echo e(request('status') == 'pending' ? 'selected' : ''); ?>><?php echo e(__('Pending')); ?></option>
                                        <option value="resolved" <?php echo e(request('status') == 'resolved' ? 'selected' : ''); ?>><?php echo e(__('Resolved')); ?></option>
                                        <option value="closed" <?php echo e(request('status') == 'closed' ? 'selected' : ''); ?>><?php echo e(__('Closed')); ?></option>
                                    </select>
                                </div>
                                <div class="col-md-3 mb-1">
                                    <label class="form-label"><?php echo e(__('Priority')); ?></label>
                                    <select name="priority" class="form-select" onchange="this.form.submit()">
                                        <option value="all" <?php echo e(request('priority') == 'all' ? 'selected' : ''); ?>><?php echo e(__('All Priorities')); ?></option>
                                        <option value="low" <?php echo e(request('priority') == 'low' ? 'selected' : ''); ?>><?php echo e(__('Low')); ?></option>
                                        <option value="medium" <?php echo e(request('priority') == 'medium' ? 'selected' : ''); ?>><?php echo e(__('Medium')); ?></option>
                                        <option value="high" <?php echo e(request('priority') == 'high' ? 'selected' : ''); ?>><?php echo e(__('High')); ?></option>
                                        <option value="urgent" <?php echo e(request('priority') == 'urgent' ? 'selected' : ''); ?>><?php echo e(__('Urgent')); ?></option>
                                    </select>
                                </div>
                                <div class="col-md-3 mb-1">
                                    <label class="form-label"><?php echo e(__('Assignment')); ?></label>
                                    <select name="assigned_to" class="form-select" onchange="this.form.submit()">
                                        <option value="all"><?php echo e(__('All Tickets')); ?></option>
                                        <option value="unassigned" <?php echo e(request('assigned_to') == 'unassigned' ? 'selected' : ''); ?>><?php echo e(__('Unassigned')); ?></option>
                                        <option value="<?php echo e(Auth::id()); ?>" <?php echo e(request('assigned_to') == Auth::id() ? 'selected' : ''); ?>><?php echo e(__('My Tickets')); ?></option>
                                    </select>
                                </div>
                                <div class="col-md-3 mb-1">
                                    <label class="form-label"><?php echo e(__('Search')); ?></label>
                                    <input type="text" name="search" class="form-control" placeholder="<?php echo e(__('Ticket #, Phone, Name...')); ?>" value="<?php echo e(request('search')); ?>">
                                </div>
                            </div>
                        </form>

                        <!-- Tickets Table -->
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Ticket #')); ?></th>
                                        <th><?php echo e(__('Customer')); ?></th>
                                        <th><?php echo e(__('Subject')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th><?php echo e(__('Priority')); ?></th>
                                        <th><?php echo e(__('Assigned To')); ?></th>
                                        <th><?php echo e(__('Created')); ?></th>
                                        <th><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $tickets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ticket): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <a href="<?php echo e(route('support.tickets.show', $ticket->id)); ?>" class="fw-bold">
                                                <?php echo e($ticket->ticket_number); ?>

                                            </a>
                                        </td>
                                        <td>
                                            <div><?php echo e($ticket->customer_name ?? __('Unknown')); ?></div>
                                            <small class="text-muted"><?php echo e($ticket->customer_phone); ?></small>
                                        </td>
                                        <td><?php echo e(Str::limit($ticket->subject, 40)); ?></td>
                                        <td>
                                            <?php
                                                $statusColors = [
                                                    'new' => 'info',
                                                    'open' => 'primary',
                                                    'pending' => 'warning',
                                                    'resolved' => 'success',
                                                    'closed' => 'secondary',
                                                    'on_hold' => 'dark'
                                                ];
                                                $color = $statusColors[$ticket->status] ?? 'secondary';
                                            ?>
                                            <span class="badge bg-<?php echo e($color); ?>"><?php echo e(ucfirst($ticket->status)); ?></span>
                                        </td>
                                        <td>
                                            <?php
                                                $priorityColors = [
                                                    'low' => 'success',
                                                    'medium' => 'info',
                                                    'high' => 'warning',
                                                    'urgent' => 'danger'
                                                ];
                                                $pColor = $priorityColors[$ticket->priority] ?? 'secondary';
                                            ?>
                                            <span class="badge bg-<?php echo e($pColor); ?>"><?php echo e(ucfirst($ticket->priority)); ?></span>
                                        </td>
                                        <td>
                                            <?php if($ticket->assignedAgent): ?>
                                                <span class="badge bg-primary">Agent</span>
                                                <?php echo e($ticket->assignedAgent->name); ?>

                                            <?php elseif($ticket->assignedStaff): ?>
                                                <span class="badge bg-info">Staff</span>
                                                <?php echo e($ticket->assignedStaff->staff_name); ?>

                                            <?php else: ?>
                                                <span class="text-muted"><?php echo e(__('Unassigned')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <small><?php echo e($ticket->created_at->diffForHumans()); ?></small>
                                        </td>
                                        <td>
                                            <div class="dropdown">
                                                <button type="button" class="btn btn-sm btn-icon" data-bs-toggle="dropdown">
                                                    <i data-feather="more-vertical"></i>
                                                </button>
                                                <div class="dropdown-menu">
                                                    <a class="dropdown-item" href="<?php echo e(route('support.tickets.show', $ticket->id)); ?>">
                                                        <i data-feather="eye" class="me-50"></i>
                                                        <span><?php echo e(__('View')); ?></span>
                                                    </a>
                                                    <?php if(!$ticket->assigned_to): ?>
                                                    <form action="<?php echo e(route('support.tickets.accept', $ticket->id)); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <button type="submit" class="dropdown-item">
                                                            <i data-feather="user-check" class="me-50"></i>
                                                            <span><?php echo e(__('Accept')); ?></span>
                                                        </button>
                                                    </form>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="8" class="text-center py-3">
                                            <p class="mb-0"><?php echo e(__('No tickets found')); ?></p>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center">
                            <?php echo e($tickets->links()); ?>

                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views/support/tickets/index.blade.php ENDPATH**/ ?>