<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
            <h4><?php echo e($device->sender); ?> -> Server: <?php echo e(rtrim(config('app.node_url'), '/')); ?></h4>
            </div>
            <div class="content-body">
                <!-- devices show start -->
                <section class="app-device-show">
                    <div class="row">
                        <div class="col-xl-4 col-lg-5 col-md-5 order-1 order-md-0">
                            <div class="card border-primary align-items-center">
                                <div class="device-avatar-section" id="cardimg-<?php echo e($device->sender); ?>"style="text-align: center"><a href="javascript:;"><img class="img-fluid rounded mt-3 mb-2" src="<?php echo e(url('/')); ?>/app-assets/images/app/refresh.png" height="250" width="250" alt="Refresh" /></a><p class="mb-50">Name : <?php echo e(config('app.name')); ?></p><p class="mb-50">WA ID : 123456789012</p></div>
                            </div>
                            <div class="card-body">
                                <button type="button" class="btn btn-sm btn-primary" data-toggle="tooltip" title="<?php echo e(__('Refresh')); ?>" onclick="window.location.reload();"><i data-feather="refresh-cw" class="me-0"></i></button>
                                <button type="button" class="btn btn-sm btn-danger" data-toggle="tooltip" title="<?php echo e(__('Log out')); ?>" onclick="walogout('<?php echo e($device->sender); ?>')"><i data-feather="log-out" class="me-0"></i></button>
                                <button type="button" class="btn btn-sm btn-success" data-toggle="tooltip" title="<?php echo e(__('Device contacts')); ?>" onclick="fetchgroups('<?php echo e($device->sender); ?>')"><?php echo e(__('Contacts')); ?></button>
                            </div>
                        </div>
                        <div id="cardlog-<?php echo e($device->sender); ?>" class="col-xl-8 col-lg-7 col-md-7 order-0 order-md-1">
                            <div class="card border-primary">
                                <textarea class="form-control" id="cardcons-<?php echo e($device->sender); ?>" rows="18" style="background-color: #000;color: #00ff00;border: 1px solid #000;padding: 8px;font-family: courier new;" readonly></textarea>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- devices show ends -->
                <!-- Modal to update profile starts-->
                <div class="modal fade" id="updateProfile" tabindex="-1" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-centered modal-update-profile">
                        <div class="modal-content">
                            <div class="modal-header bg-transparent">
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <div class="modal-body pb-5 px-sm-5 pt-50">
                                <div class="text-center mb-2">
                                    <h1 class="mb-1"><?php echo e(__('Update profile')); ?></h1>
                                </div>
                                <form enctype="multipart/form-data" onsubmit="return false;">
                                    <div class="col-12">
                                        <label class="form-label" for="profilePicture"><?php echo e(__('Profile picture')); ?></label> <label class="form-label text-warning"> (<?php echo e(__('Max')); ?> 800K | Ratio 1:1) </label>
                                        <input type="file" id="profilePicture" name="profilePicture" class="form-control" />
                                    </div>
                                    <div class="col-12" hidden>
                                        <label class="form-label" for="profileName"><?php echo e(__('Profile name')); ?></label>
                                        <input type="text" id="profileName" name="profileName" class="form-control" />
                                    </div>
                                    <div class="col-12" hidden>
                                        <label class="form-label" for="profileStatus"><?php echo e(__('Profile status')); ?></label>
                                        <input type="text" id="profileStatus" name="profileStatus" class="form-control" />
                                    </div>
                                    <div class="col-12 text-center mt-2 pt-50">
                                        <button class="btn btn-primary me-1" id="updateButton" onclick="updateProfile('<?php echo e($device->sender); ?>',<?php echo e($device->user_id); ?>)"><?php echo e(__('Submit')); ?></button>
                                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close"><?php echo e(__('Cancel')); ?></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- Modal to update profile Ends-->
            </div>
        </div>
    </div>
    <!-- END: Content-->

    <!-- BEGIN: Vendor JS-->
    <script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/vendors.min.js"></script>
    <!-- BEGIN Vendor JS-->

    <!-- BEGIN: Page Vendor JS-->
    <script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/socket.io/socket.io.js"></script>
    <!-- END: Page Vendor JS-->

    <script>
        $(document).ready(function(){
            $('[data-toggle="tooltip"]').tooltip();
        });
    </script>

    <script>
    const socket = io(`<?php echo e(rtrim(config('app.node_url'), '/')); ?>`);
    
    $(`#cardimg-<?php echo e($device->sender); ?>`).html(`<img class="img-fluid rounded mt-3 mb-2" src="<?php echo e(url('/')); ?>/app-assets/images/app/loading.gif" height="250" width="250" alt="Loading..." /><br><p> <?php echo e(__('Connecting...')); ?> </p>`);
    socket.emit('socksession', { sender: '<?php echo e($device->sender); ?>' });

    function walogout(sender) {
        socket.emit('walogout', { sender: sender });
    }

    function fetchgroups(sender) {
        socket.emit('fetchgroups', { sender: sender });
    }

    function updateProfile(sender, user_id) {
        $(`#cardimg-${sender}`).html(`<img class="img-fluid rounded mt-3 mb-2" src="<?php echo e(url('/')); ?>/app-assets/images/app/loading.gif" height="250" width="250" alt="Loading..." /><br><p> <?php echo e(__('Connecting...')); ?> </p>`);
        socket.emit('updateProfile', { sender: sender, user_id: user_id, profilePicture:$('#profilePicture')[0].files[0], profileName:$(`#profileName`).val(), profileStatus:$(`#profileStatus`).val() });
        $(`#updateProfile`).modal('hide');
    }

    socket.on('refreshCard', (data) => {
        var waid, imgurl, footer1, footer2, footer3;
        if (data.status == 'open') {
            waid = data.waid.split('@').shift().split(':').shift();
            imgurl = data.imgurl ? data.imgurl : 'app-assets/images/app/noimage.png';
            if (waid !== data.sender) imgurl = 'app-assets/images/app/error.png';
            footer1 = `Name : ${data.waname}`;
            footer2 = `WA ID : ${waid}`;
            footer3 = waid != data.sender ? 'SENDER & WA ID ARE NOT MATCHED!<br>DELETE & ADD NEW DEVICE!' : '';
        } else if (data.status == 'close') {
            imgurl = 'app-assets/images/app/refresh.png';
            footer1 = 'Whatsapp logged out';
            footer2 = 'Please refresh!';
            footer3 = '';
        } else if (data.status == 'qrReceived') {
            imgurl = data.imgurl;
            footer1 = 'Open mobile Whatsapp';
            footer2 = 'Scan QR code to connect!';
            footer3 = '';
        }
        $(`#cardimg-${data.sender}`).html(`
            <a data-bs-toggle="modal" data-bs-target="#updateProfile"><img class="img-fluid rounded mt-3 mb-2" src="${imgurl}" height="250" width="250" alt="Device avatar" /></a>
            <p class="mb-50">${footer1}</p>
            <p class="mb-50">${footer2}</p>
            <p class="mb-50" style="color: red;">${footer3}</p>
        `);
    });

    // Listen on new_message
    socket.on("showLog", (data) => {
        let tnow = new Date();
        $(`#cardcons-${data.sender}`).append("\n" + tnow + "\n" + data.text + "\n");
        var pscons = $(`#cardcons-${data.sender}`);
        if(pscons.length)
        pscons.scrollTop(pscons[0].scrollHeight - pscons.height());
    })

    // Listen on fetcgroups
    socket.on("fetchGroups", (data) => {
        window.open('<?php echo e(url("/device-showcontacts?sender=")); ?>' + data.sender, '_blank');
    });

    </script>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views//device-show.blade.php ENDPATH**/ ?>