<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php
App::setLocale(Auth::user()->lang);
?>
<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <!-- header info start -->
        <div class="row">
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($totalUsers); ?></h3>
                            <span><?php echo e(__('Users')); ?> </span>[ <span class="text-success" data-toggle="tooltip" title="<?php echo e(__('Verified')); ?>"><?php echo e($verifiedUsers); ?></span> | <span class="text-danger" data-toggle="tooltip" title="<?php echo e(__('Unverified')); ?>"><?php echo e($unverifiedUsers); ?></span> ]
                        </div>
                        <div class="avatar bg-light-warning p-50">
                            <span class="avatar-content">
                                <i data-feather="users" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($totalDevices); ?></h3>
                            <span><?php echo e(__('Devices')); ?> </span>[ <span class="text-success" data-toggle="tooltip" title="<?php echo e(__('ONLINE')); ?>"><?php echo e($onlineDevices); ?></span> | <span class="text-danger" data-toggle="tooltip" title="<?php echo e(__('OFFLINE')); ?>"><?php echo e($offlineDevices); ?></span> ]
                        </div>
                        <div class="avatar bg-light-primary p-50">
                            <span class="avatar-content">
                                <i data-feather="smartphone" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($totalSubscribers); ?></h3>
                            <span><?php echo e(__('Subs')); ?> </span>[ <span class="text-success" data-toggle="tooltip" title="<?php echo e(__('Subscribed')); ?>"><?php echo e($subSubscribers); ?></span> | <span class="text-danger" data-toggle="tooltip" title="<?php echo e(__('Unsubscribed')); ?>"><?php echo e($unsubSubscribers); ?></span> ]
                        </div>
                        <div class="avatar bg-light-success p-50">
                            <span class="avatar-content">
                                <i data-feather="user-plus" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($totalSent); ?></h3>
                            <span><?php echo e(__('Sent')); ?> </span>[ <span class="text-success" data-toggle="tooltip" title="<?php echo e(__('This month')); ?>"><?php echo e($currentSent); ?></span> | <span class="text-danger" data-toggle="tooltip" title="<?php echo e(__('All time')); ?>"><?php echo e($totalSent); ?></span> ]
                        </div>
                        <div class="avatar bg-light-danger p-50">
                            <span class="avatar-content">
                                <i data-feather="send" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- header info end -->
        <div class="content-body">
            <!-- users list start -->
            <section class="app-user-list">
                <!-- list and filter start -->
                <div class="card">
                    <h5 class="card-header">
                        <div class="input-group input-group-sm position-relative mx-auto">
                            <?php echo e(__('User list')); ?><span class="badge badge-light-secondary ms-2"><?php echo e(DB::table('users')->count()); ?></span>
                            <input type="search" class="form-control" id="search" value="<?php echo e(!empty($_GET['search']) ? $_GET['search'] : ''); ?>" placeholder="<?php echo e(__('Search')); ?>..." />
                            <button type="button" class="btn btn-sm btn-info" id="searchbtn"><i data-feather="search" class="me-0"></i></button>
                            <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#addNew"><i data-feather="plus" class="me-1"></i><?php echo e(strtoupper(__('Add new'))); ?></button>
                            <button type="button" class="btn btn-sm btn-warning dropdown-toggle" id="broadcastButton" data-bs-toggle="dropdown" aria-expanded="false"><i data-feather="git-branch" class="me-1"></i> <?php echo e(__('Broadcast')); ?></button>
                            <div class="dropdown-menu" aria-labelledby="broadcastButton">
                                <a class="dropdown-item" href="<?php echo e(route('sendmsg.index', ['role' => 'user'])); ?>">All users</a>
                                <a class="dropdown-item" href="<?php echo e(route('sendmsg.index', ['role' => 'admin'])); ?>">All admins</a>
                            </div>
                        </div>
                    </h5>
                    <div class="card-body">
                        <div class="table-responsive table-responsive">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th hidden></th>
                                        <th><?php echo e(__('Username')); ?></th>
                                        <th><?php echo e(__('Role')); ?></th>
                                        <th><?php echo e(__('Current sent')); ?></th>
                                        <th><?php echo e(__('Total sent')); ?></th>
                                        <?php if(\App\Helpers\Helpers::isEx()): ?>
                                        <th><?php echo e(__('Package name')); ?></th>
                                        <th><?php echo e(__('Wallet')); ?>

                                        <th><?php echo e(__('Expiry date')); ?></th>
                                        <?php endif; ?>
                                        <th><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td hidden><?php echo e($user->created_at); ?></td>
                                        <td><a href="<?php echo e(route('user.show', ['user_id' => $user->id])); ?>">
                                        <?php echo e($user->name); ?><span class="badge rounded-pill badge-light-danger me-1"><?php echo e($user->banned ? '(banned)' : ''); ?></span></a>
                                        </td>
                                        <td><a href="<?php echo e(route('user.show', ['user_id' => $user->id])); ?>">
                                        <span class="badge rounded-pill badge-light-warning me-1"><?php echo e($user->role); ?></span></a>
                                        </td>
                                        <td><a href="<?php echo e(route('user.show', ['user_id' => $user->id])); ?>">
                                        <?php echo e($user->current_sent); ?></a>
                                        </td>
                                        <td><a href="<?php echo e(route('user.show', ['user_id' => $user->id])); ?>">
                                        <?php echo e($user->total_sent); ?></a>
                                        </td>
                                        <?php if(\App\Helpers\Helpers::isEx()): ?>
                                        <td><a href="<?php echo e(route('user.show', ['user_id' => $user->id])); ?>">
                                        <span class="badge rounded-pill badge-light-<?php echo e(empty($user->email_verified_at) ? 'danger' : 'success'); ?> me-1"><?php echo e($user->package?->name); ?></span></a>
                                        </td>
                                        <td><a href="<?php echo e(route('user.show', ['user_id' => $user->id])); ?>">
                                        <?php $walletBalance = $user->transactions()->sum('amount') ?>
                                        <span class="badge rounded-pill badge-light-<?php echo e($walletBalance < 0 ? 'danger' : 'success'); ?> me-1"><?php echo e(number_format($walletBalance,\App\Helpers\Helpers::setting('nfDecimals'),\App\Helpers\Helpers::setting('nfDecimalpoint'),\App\Helpers\Helpers::setting('nfSeparator'))); ?></span></a>
                                        </td>
                                        <td><a href="<?php echo e(route('user.show', ['user_id' => $user->id])); ?>">
                                        <span class="badge rounded-pill badge-light-<?php echo e($user->billing_end < date('Y-m-d H:i:s') ? 'danger' : 'success'); ?> me-1"><?php echo e($user->billing_end); ?></span></a>
                                        </td>
                                        <?php endif; ?>
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton">
                                                <?php if (can_be_impersonated($user, $guard = null)) : ?>
                                                <a class="dropdown-item" href="<?php echo e(route('user.impersonate', $user->id)); ?>" <?php echo e((Auth::user()->id != 1 &&  $user->id <= 2) ? 'hidden' : ''); ?>><i data-feather="log-in" class="me-0"></i> <?php echo e(__('Log in')); ?></a>
                                                <?php endif; ?>
                                                <?php if($user->id !== Auth::user()->id && $user->id > 2): ?>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit-<?php echo e($user->id); ?>"><i data-feather="edit" class="me-0"></i> <?php echo e(__('Edit')); ?></a>
                                                <a class="dropdown-item" href="<?php echo e(route('user.banUnban', ['user_id' => $user->id])); ?>"><i data-feather="<?php echo e($user->banned ? 'thumbs-up' : 'thumbs-down'); ?>" class="me-0"></i> <?php echo e($user->banned ?  __('Unban') : __('Ban')); ?></a>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-<?php echo e($user->id); ?>"><i data-feather="trash" class="me-0"></i> <?php echo e(__('Delete')); ?></a>
                                                <?php endif; ?>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-<?php echo e($user->id); ?>" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Delete confirmation')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <?php echo e(__('Are you sure you want to delete?')); ?> <br><br>
                                                    <span class="text text-danger"> <b><?php echo e($user->name); ?></b> </span><br><br>
                                                    <?php echo e(__('This process is irreversible')); ?> <br>
                                                    <?php echo e(__('The record(s) will be deleted from the database permanently')); ?>

                                                </div>
                                                <div class="modal-footer">
                                                <a class="btn btn-sm btn-danger" href="<?php echo e(route('user.destroy', ['user_id' => $user->id])); ?>"><?php echo e(__('Delete')); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Edit User Modal -->
                                    <div class="modal fade" id="edit-<?php echo e($user->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-user">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1"><?php echo e(__('Edit user form')); ?></h1>
                                                    </div>
                                                    <form action="<?php echo e(route('user.update')); ?>" method="POST" id="editUserForm" class="row gy-1 pt-75">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="row">
                                                            <div class="col-12 col-md-6">
                                                                <input type="hidden"  name="user_id" value="<?php echo e($user->id); ?>" />
                                                                <label class="form-label" for="name"><?php echo e(__('Username')); ?></label>
                                                                <input type="text" name="name" class="form-control" value="<?php echo e($user->name); ?>" required />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="password"><?php echo e(__('Password minimum 6 characters')); ?></label>
                                                                <input type="text" name="password" class="form-control" placeholder="<?php echo e(__('EMPTY = NO CHANGE')); ?>" />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="email"><?php echo e(__('Email')); ?></label>
                                                                <input type="text" name="email" class="form-control" value="<?php echo e($user->email); ?>" placeholder="example@domain.com" required />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="phone"><?php echo e(__('Phone')); ?></label>
                                                                <input type="text" name="phone" class="form-control" value="<?php echo e($user->phone); ?>" placeholder="6281212341234" required />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="theme"><?php echo e(__('Panel theme')); ?></label>
                                                                <select id="theme" name="theme" class="form-select">
                                                                    <option value="light-layout" <?php echo e(( $user->theme == 'light-layout' ) ? 'selected' : ''); ?>>Light theme</option>
                                                                    <option value="dark-layout" <?php echo e(( $user->theme == 'dark-layout' ) ? 'selected' : ''); ?>>Dark theme</option>
                                                                </select>
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="rtl"><?php echo e(__('Text direction')); ?></label>
                                                                <select name="rtl" class="form-select">
                                                                    <option value="0" <?php echo e(!$user->rtl ? 'selected' : ''); ?>>Left to Right (LTR)</option>
                                                                    <option value="1" <?php echo e($user->rtl ? 'selected' : ''); ?>>Right to Left (RTL)</option>
                                                                </select>
                                                            </div>
                                                            <?php if(Auth::user()->role === 'admin' && $user->id > 2): ?>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="role"><?php echo e(__('User role')); ?></label>
                                                                <select id="role" name="role" class="form-select">
                                                                    <option value="admin" <?php echo e(( $user->role === 'admin' ) ? 'selected' : ''); ?>>Admin</option>
                                                                    <option value="user" <?php echo e(( $user->role === 'user' ) ? 'selected' : ''); ?>>User</option>
                                                                </select>
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="banned"><?php echo e(__('Ban')); ?>/<?php echo e(__('Unban User Account')); ?></label>
                                                                <select name="banned" class="form-select">
                                                                    <option value="0" <?php echo e(!$user->banned ? 'selected' : ''); ?>><?php echo e(__('User Unbanned')); ?></option>
                                                                    <option value="1" <?php echo e($user->banned ? 'selected' : ''); ?>><?php echo e(__('User Banned')); ?></option>
                                                                </select>
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="billing_end"><?php echo e(__('Billing end')); ?></label>
                                                                <input type="datetime-local" name="billing_end" class="form-control" value="<?php echo e($user->billing_end); ?>">
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="verified_at"><?php echo e(__('Verified at')); ?></label>
                                                                <input type="datetime-local" name="verified_at" class="form-control" value="<?php echo e($user->email_verified_at); ?>">
                                                            </div>
                                                            <div class="col-12 col-md-6" id="package" <?php echo e(\App\Helpers\Helpers::isEx()?'':'hidden'); ?>>
                                                                <label class="form-label" for="package_name"><?php echo e(__('Package name')); ?></label>
                                                                <select name="package_id" class="form-select">
                                                                    <option value="<?php echo e($user->package?->id); ?>" selected><?php echo e($user->package?->name . '-' . $user->package?->rate_monthly . '/' . __('Month')); ?></option>
                                                                    <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($package->id); ?>"><?php echo e($package->name . '-' . $package->rate_monthly . '/' . __('Month')); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="col-12 text-center mt-2 pt-50">
                                                            <button type="submit" class="btn btn-primary me-1"><?php echo e(__('Submit')); ?></button>
                                                            <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close"><?php echo e(__('Cancel')); ?></button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php echo e($users->links()); ?>

                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Modal to add new user starts-->
                    <div class="modal modal-slide-in new-user-modal fade" id="addNew">
                        <div class="modal-dialog">
                            <form action="<?php echo e(route('user.store')); ?>" method="POST" class="add-new-user modal-content pt-0">
                            <?php echo csrf_field(); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
                                <div class="modal-header mb-1">
                                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Add new user')); ?></h5>
                                </div>
                                <div class="modal-body flex-grow-1">
                                    <div class="mb-1">
                                        <label class="form-label" for="name"><?php echo e(__('Username')); ?></label>
                                        <input type="text" name="name" class="form-control" placeholder="<?php echo e(__('Username')); ?>" required />
                                    </div>
                                    <div class="mb-1">
                                        <label class="form-label" for="password"><?php echo e(__('Password')); ?></label>
                                        <input type="password" name="password" class="form-control" placeholder="<?php echo e(__('Password')); ?>" required />
                                    </div>
                                    <div class="mb-1">
                                        <label class="form-label" for="password_confirmation"><?php echo e(__('Confirm Password')); ?></label>
                                        <input type="password" name="password_confirmation" class="form-control" placeholder="<?php echo e(__('Confirm Password')); ?>" required />
                                    </div>
                                    <div class="mb-1">
                                        <label class="form-label" for="email"><?php echo e(__('Email')); ?></label>
                                        <input type="email" name="email" class="form-control" placeholder="<?php echo e(__('Email')); ?>" required />
                                    </div>
                                    <div class="mb-1">
                                        <label class="form-label" for="phone"><?php echo e(__('Phone')); ?></label>
                                        <input type="tel" name="phone" class="form-control" placeholder="14083243658" required />
                                    </div>
                                    <div class="mb-1">
                                        <label class="form-label" for="role"><?php echo e(__('Role')); ?></label>
                                        <select class="form-select" id="role" name="role">
                                            <option value="admin">Admin</option>
                                            <option value="user" selected>User</option>
                                        </select>
                                    </div>
                                    <?php if(\App\Helpers\Helpers::isEx()): ?>
                                    <div class="mb-1">
                                        <label class="form-label" for="package_id"><?php echo e(__('Package')); ?></label>
                                        <select class="form-select" id="package_id" name="package_id">
                                            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($package->id); ?>" <?php echo e(( $package->id === 2 ) ? 'selected' : ''); ?>><?php echo e($package->name); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="mb-1">
                                        <label class="form-label" for="billing_interval"><?php echo e(__('Interval')); ?></label>
                                        <select name="billing_interval" class="form-select">
                                            <?php $__currentLoopData = $intervals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $interval): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($interval); ?>"><?php echo e($interval); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <?php else: ?>
                                        <input type="hidden"  name="package_id" value="2" />
                                        <input type="hidden"  name="billing_interval" value="monthly" />
                                    <?php endif; ?>
                                    <button type="submit" class="btn btn-primary me-1 data-submit"><?php echo e(__('Submit')); ?></button>
                                    <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <!-- Modal to add new user Ends-->
                </div>
                <!-- list and filter end -->
            </section>
            <!-- users list ends -->
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/vendors.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
function search() {
    var url = '<?php echo e(url()->current()); ?>' + '?search=' + $('#search').val();
    location.href= url;
}
$('#searchbtn').click(function (e) {
    search();
})
$('#search').keydown(function (e) {
    if (e.which == 13) {
        search();
    }
})
</script>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views//user-list.blade.php ENDPATH**/ ?>