<!DOCTYPE html>
<html class="loading" lang="en" data-textdirection="ltr">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width,initial-scale=1.0,user-scalable=0,minimal-ui">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title><?php echo e(__('Forgot Password')); ?> - <?php echo e(config('app.name')); ?></title>
    <link rel="icon" type="image/x-icon" href="<?php echo e(url('/')); ?>/app-assets/images/ico/favicon.ico" />
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@300;400;500;600&display=swap" rel="stylesheet">
    
    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/vendors/css/vendors.min.css">
    <!-- END: Vendor CSS-->

    <!-- BEGIN: Theme CSS-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/css/bootstrap.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/css/bootstrap-extended.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/css/colors.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/css/components.css">
    <!-- END: Theme CSS-->

    <!-- BEGIN: Page CSS-->
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/css/core/menu/menu-types/vertical-menu.css">
    <link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/css/pages/authentication.css">
    <!-- END: Page CSS-->

    <style>
        .auth-wrapper.auth-basic {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .auth-card {
            background: #fff;
            border-radius: 1rem;
            box-shadow: 0 4px 25px 0 rgba(0, 0, 0, 0.1);
            padding: 2.5rem;
        }
        .brand-logo {
            text-align: center;
            margin-bottom: 2rem;
        }
        .brand-logo img {
            max-height: 60px;
            margin-bottom: 1rem;
        }
        .auth-title {
            font-size: 1.5rem;
            font-weight: 600;
            color: #5e5873;
            margin-bottom: 0.5rem;
        }
        .auth-subtitle {
            color: #6e6b7b;
            margin-bottom: 2rem;
        }
        .form-label {
            font-weight: 500;
            color: #5e5873;
            margin-bottom: 0.5rem;
        }
        .form-control {
            border-radius: 0.5rem;
            padding: 0.75rem 1rem;
            border: 1px solid #d8d6de;
        }
        .form-control:focus {
            border-color: #fd810e;
            box-shadow: 0 3px 10px 0 rgba(253, 129, 14, 0.1);
        }
        .btn-reset {
            background: linear-gradient(135deg, #fd810e 0%, #ff6b35 100%);
            border: none;
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            color: #fff;
            font-weight: 500;
            width: 100%;
            transition: all 0.3s ease;
        }
        .btn-reset:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px 0 rgba(253, 129, 14, 0.4);
            color: #fff;
        }
        .btn-whatsapp {
            background: linear-gradient(135deg, #25D366 0%, #128C7E 100%);
            border: none;
            border-radius: 0.5rem;
            padding: 0.75rem 1.5rem;
            color: #fff;
            font-weight: 500;
            width: 100%;
            transition: all 0.3s ease;
        }
        .btn-whatsapp:hover {
            transform: translateY(-2px);
            box-shadow: 0 5px 20px 0 rgba(37, 211, 102, 0.4);
            color: #fff;
        }
        .auth-link {
            color: #fd810e;
            text-decoration: none;
            font-weight: 500;
        }
        .auth-link:hover {
            color: #ff6b35;
            text-decoration: underline;
        }
        .alert-status {
            border-radius: 0.5rem;
            border-left: 3px solid #28c76f;
        }
        .alert-errors {
            border-radius: 0.5rem;
            border-left: 3px solid #ea5455;
        }
        .divider {
            display: flex;
            align-items: center;
            text-align: center;
            margin: 1.5rem 0;
        }
        .divider::before,
        .divider::after {
            content: '';
            flex: 1;
            border-bottom: 1px solid #d8d6de;
        }
        .divider span {
            padding: 0 1rem;
            color: #6e6b7b;
            font-size: 0.857rem;
        }
        .info-box {
            background: #f8f8f8;
            border-radius: 0.5rem;
            padding: 1rem;
            margin-bottom: 1.5rem;
            border-left: 3px solid #00cfe8;
        }
        .info-box p {
            margin: 0;
            color: #6e6b7b;
            font-size: 0.9rem;
        }
    </style>
</head>

<body class="vertical-layout vertical-menu-modern blank-page navbar-floating footer-static" data-open="click" data-menu="vertical-menu-modern" data-col="blank-page">
    <!-- BEGIN: Content-->
    <div class="app-content content">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row"></div>
            <div class="content-body">
                <div class="auth-wrapper auth-basic px-2">
                    <div class="auth-inner my-2">
                        <div class="auth-card">
                            <!-- Logo -->
                            <div class="brand-logo">
                                <?php if(\App\Helpers\Helpers::setting('logoUrl')): ?>
                                    <img src="<?php echo e(\App\Helpers\Helpers::setting('logoUrl')); ?>" alt="<?php echo e(config('app.name')); ?>">
                                <?php else: ?>
                                    <h2 class="brand-text text-primary mb-0"><?php echo e(config('app.name')); ?></h2>
                                <?php endif; ?>
                            </div>

                            <!-- Title -->
                            <h2 class="auth-title text-center"><?php echo e(__('Forgot Password?')); ?> 🔒</h2>
                            <p class="auth-subtitle text-center"><?php echo e(__("Enter your email and we'll send you instructions to reset your password")); ?></p>

                            <!-- Session Status -->
                            <?php if(session('status')): ?>
                                <div class="alert alert-success alert-status" role="alert">
                                    <div class="alert-body">
                                        <i data-feather="check-circle" class="me-50"></i>
                                        <?php echo e(session('status')); ?>

                                    </div>
                                </div>
                            <?php endif; ?>

                            <!-- Validation Errors -->
                            <?php if($errors->any()): ?>
                                <div class="alert alert-danger alert-errors" role="alert">
                                    <div class="alert-body">
                                        <i data-feather="alert-circle" class="me-50"></i>
                                        <strong><?php echo e(__('Whoops!')); ?></strong> <?php echo e(__('There were some problems with your input.')); ?>

                                        <ul class="mb-0 mt-1">
                                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <li><?php echo e($error); ?></li>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </ul>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <!-- Email Reset Form -->
                            <form class="auth-forgot-password-form mt-2" method="POST" action="<?php echo e(route('password.email')); ?>">
                                <?php echo csrf_field(); ?>

                                <div class="mb-1">
                                    <label for="email" class="form-label"><?php echo e(__('Email')); ?></label>
                                    <input type="email" class="form-control" id="email" name="email" 
                                           placeholder="john@example.com" value="<?php echo e(old('email')); ?>" required autofocus />
                                </div>

                                <button type="submit" class="btn btn-reset">
                                    <i data-feather="mail" class="me-50"></i>
                                    <?php echo e(__('Send Reset Link')); ?>

                                </button>
                            </form>

                            <?php if(filter_var(\App\Helpers\Helpers::setting('waResetPassword'), FILTER_VALIDATE_BOOLEAN)): ?>
                                <div class="divider">
                                    <span><?php echo e(__('or')); ?></span>
                                </div>

                                <!-- WhatsApp Reset Form -->
                                <div class="info-box">
                                    <p>
                                        <i data-feather="info" class="me-25"></i>
                                        <?php echo e(__('You can also receive a password reset link via WhatsApp')); ?>

                                    </p>
                                </div>

                                <form class="auth-forgot-password-whatsapp-form" method="POST" action="<?php echo e(route('password.wa')); ?>">
                                    <?php echo csrf_field(); ?>

                                    <input type="hidden" id="adminSender" name="adminSender" value="<?php echo e($adminSender); ?>" />

                                    <div class="mb-1">
                                        <label for="phone" class="form-label"><?php echo e(__('Phone Number')); ?></label>
                                        <input type="tel" class="form-control" id="phone" name="phone" 
                                               placeholder="+1234567890" value="<?php echo e(old('phone')); ?>" required />
                                    </div>

                                    <button type="submit" class="btn btn-whatsapp">
                                        <i data-feather="message-circle" class="me-50"></i>
                                        <?php echo e(__('Send via WhatsApp')); ?>

                                    </button>
                                </form>
                            <?php endif; ?>

                            <!-- Back to Login -->
                            <p class="text-center mt-2">
                                <a href="<?php echo e(route('login')); ?>" class="auth-link">
                                    <i data-feather="chevron-left" class="me-25"></i>
                                    <?php echo e(__('Back to login')); ?>

                                </a>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- END: Content-->

    <!-- BEGIN: Vendor JS-->
    <script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/vendors.min.js"></script>
    <!-- END: Vendor JS-->

    <!-- BEGIN: Theme JS-->
    <script src="<?php echo e(url('/')); ?>/app-assets/js/core/app-menu.js"></script>
    <script src="<?php echo e(url('/')); ?>/app-assets/js/core/app.js"></script>
    <!-- END: Theme JS-->

    <script>
        $(window).on('load', function() {
            if (feather) {
                feather.replace({
                    width: 14,
                    height: 14
                });
            }
        });
    </script>
</body>
</html>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views/auth/forgot-password.blade.php ENDPATH**/ ?>