<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php
App::setLocale(Auth::user()->lang);
?>

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <!-- Statistics -->
        <div class="row">
            <div class="col-lg-4 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($statistics['total']); ?></h3>
                            <span><?php echo e(__('Total Agents')); ?></span>
                        </div>
                        <div class="avatar bg-light-primary p-50">
                            <span class="avatar-content">
                                <i data-feather="users" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($statistics['online']); ?></h3>
                            <span><?php echo e(__('Online Now')); ?></span>
                        </div>
                        <div class="avatar bg-light-success p-50">
                            <span class="avatar-content">
                                <i data-feather="user-check" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-4 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($statistics['available']); ?></h3>
                            <span><?php echo e(__('Available')); ?></span>
                        </div>
                        <div class="avatar bg-light-info p-50">
                            <span class="avatar-content">
                                <i data-feather="headphones" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-body">
            <section class="app-agent-list">
                <div class="card">
                    <div class="card-header border-bottom">
                        <h4 class="card-title"><?php echo e(__('Support Agents')); ?></h4>
                        <a href="<?php echo e(route('support.agents.create')); ?>" class="btn btn-primary">
                            <i data-feather="plus" class="me-25"></i>
                            <span><?php echo e(__('Add Agent')); ?></span>
                        </a>
                    </div>
                    <div class="card-body">
                        <!-- Filters -->
                        <form method="GET" action="<?php echo e(route('support.agents.index')); ?>" class="mb-2">
                            <div class="row">
                                <div class="col-md-4 mb-1">
                                    <select name="status" class="form-select" onchange="this.form.submit()">
                                        <option value="all"><?php echo e(__('All Status')); ?></option>
                                        <option value="online" <?php echo e(request('status') == 'online' ? 'selected' : ''); ?>><?php echo e(__('Online')); ?></option>
                                        <option value="offline" <?php echo e(request('status') == 'offline' ? 'selected' : ''); ?>><?php echo e(__('Offline')); ?></option>
                                        <option value="busy" <?php echo e(request('status') == 'busy' ? 'selected' : ''); ?>><?php echo e(__('Busy')); ?></option>
                                        <option value="away" <?php echo e(request('status') == 'away' ? 'selected' : ''); ?>><?php echo e(__('Away')); ?></option>
                                    </select>
                                </div>
                                <div class="col-md-4 mb-1">
                                    <select name="role" class="form-select" onchange="this.form.submit()">
                                        <option value="all"><?php echo e(__('All Roles')); ?></option>
                                        <option value="agent" <?php echo e(request('role') == 'agent' ? 'selected' : ''); ?>><?php echo e(__('Agent')); ?></option>
                                        <option value="supervisor" <?php echo e(request('role') == 'supervisor' ? 'selected' : ''); ?>><?php echo e(__('Supervisor')); ?></option>
                                        <option value="admin" <?php echo e(request('role') == 'admin' ? 'selected' : ''); ?>><?php echo e(__('Admin')); ?></option>
                                    </select>
                                </div>
                            </div>
                        </form>

                        <!-- Agents Table -->
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Agent')); ?></th>
                                        <th><?php echo e(__('Role')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th><?php echo e(__('Active Tickets')); ?></th>
                                        <th><?php echo e(__('Max Tickets')); ?></th>
                                        <th><?php echo e(__('Auto Assign')); ?></th>
                                        <th><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $agents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $agent): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="avatar me-1 <?php echo e($agent->status == 'online' ? 'bg-light-success' : 'bg-light-secondary'); ?>">
                                                    <span class="avatar-content"><?php echo e(substr($agent->user->name, 0, 2)); ?></span>
                                                </div>
                                                <div>
                                                    <div class="fw-bold"><?php echo e($agent->user->name); ?></div>
                                                    <small class="text-muted"><?php echo e($agent->user->email); ?></small>
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <?php
                                                $roleColors = [
                                                    'agent' => 'info',
                                                    'supervisor' => 'warning',
                                                    'admin' => 'danger'
                                                ];
                                            ?>
                                            <span class="badge bg-<?php echo e($roleColors[$agent->role] ?? 'secondary'); ?>"><?php echo e(ucfirst($agent->role)); ?></span>
                                        </td>
                                        <td>
                                            <?php
                                                $statusColors = [
                                                    'online' => 'success',
                                                    'offline' => 'secondary',
                                                    'busy' => 'danger',
                                                    'away' => 'warning'
                                                ];
                                            ?>
                                            <span class="badge bg-<?php echo e($statusColors[$agent->status] ?? 'secondary'); ?>"><?php echo e(ucfirst($agent->status)); ?></span>
                                        </td>
                                        <td>
                                            <span class="badge bg-primary"><?php echo e($agent->current_tickets); ?></span>
                                        </td>
                                        <td><?php echo e($agent->max_tickets); ?></td>
                                        <td>
                                            <?php if($agent->auto_assign): ?>
                                                <i data-feather="check-circle" class="text-success"></i>
                                            <?php else: ?>
                                                <i data-feather="x-circle" class="text-muted"></i>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="dropdown">
                                                <button type="button" class="btn btn-sm btn-icon" data-bs-toggle="dropdown">
                                                    <i data-feather="more-vertical"></i>
                                                </button>
                                                <div class="dropdown-menu">
                                                    <a class="dropdown-item" href="<?php echo e(route('support.agents.show', $agent->id)); ?>">
                                                        <i data-feather="eye" class="me-50"></i>
                                                        <span><?php echo e(__('View')); ?></span>
                                                    </a>
                                                    <a class="dropdown-item" href="<?php echo e(route('support.agents.edit', $agent->id)); ?>">
                                                        <i data-feather="edit" class="me-50"></i>
                                                        <span><?php echo e(__('Edit')); ?></span>
                                                    </a>
                                                    <div class="dropdown-divider"></div>
                                                    <form action="<?php echo e(route('support.agents.updateStatus', $agent->id)); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <input type="hidden" name="status" value="<?php echo e($agent->status == 'online' ? 'offline' : 'online'); ?>">
                                                        <button type="submit" class="dropdown-item">
                                                            <i data-feather="power" class="me-50"></i>
                                                            <span><?php echo e($agent->status == 'online' ? __('Go Offline') : __('Go Online')); ?></span>
                                                        </button>
                                                    </form>
                                                    <div class="dropdown-divider"></div>
                                                    <a class="dropdown-item text-danger" href="<?php echo e(route('support.agents.destroy', $agent->id)); ?>" 
                                                       onclick="return confirm('<?php echo e(__('Are you sure?')); ?>')">
                                                        <i data-feather="trash" class="me-50"></i>
                                                        <span><?php echo e(__('Delete')); ?></span>
                                                    </a>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="text-center py-3">
                                            <p class="mb-0"><?php echo e(__('No agents found')); ?></p>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center">
                            <?php echo e($agents->links()); ?>

                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views/support/agents/index.blade.php ENDPATH**/ ?>