<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- BEGIN: Content-->
    <div class="app-content content ">
        <div class="content-overlay"></div>
        <div class="header-navbar-shadow"></div>
        <div class="content-wrapper">
            <div class="content-header row">
                <h4><?php echo e(__('Send message')); ?></h4>
            </div>
            <div class="content-body">
                <div class="card col-12">
                    <div class="card-body">
                        <form action="<?php echo e(route('sendmsg.store')); ?>" method="POST" enctype="multipart/form-data">
                        <?php echo csrf_field(); ?>
                            <div class="row">
                                <input type="hidden" name="user_id" value="<?php echo e(Auth::user()->id); ?>">
                                <input type="hidden" name="job_id" value="<?php echo e(\Carbon\Carbon::now()->timestamp); ?>">
                                <div class="col-12">
                                    <label> <?php echo e(__('Device')); ?> </label> 
                                    <button id="select_all" name="select_all" class="btn btn-sm rounded-pill btn-outline-secondary"> <?php echo e(__('Select ALL')); ?> </button>
                                    <select class="form-select" id="sender" name="sender[]" multiple required>
                                        <?php $__currentLoopData = $devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($device === $devices[0]): ?>
                                        <option value="<?php echo e($device->sender); ?>" selected><?php echo e($device->user_id . '-' . $device->name . ' (' . $device->sender . ')'); ?></option>
                                        <?php continue; ?>
                                        <?php endif; ?>
                                        <option value="<?php echo e($device->sender); ?>"><?php echo e($device->user_id . '-' . $device->name . ' (' . $device->sender . ')'); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($globals): ?>
                                        <option disabled>─</option>
                                        <?php $__currentLoopData = $globals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $global): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($global['sender']); ?>"><?php echo e($global['user_id'] . '-' . $global['name'] . ' (' . $global['sender'] . ')'); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </select>
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> <?php echo e(__('Single receiver')); ?> </label> <label class="form-label text-warning"> (Ex. 55918912341234, 5515934563456, 553078907890) </label>
                                    <input type="tel" name="single_receiver" placeholder="<?php echo e(__('Phone with country code')); ?>" class="form-control" value="<?php echo e($broadcastPhones); ?>">
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> <?php echo e(__('Multi receivers')); ?> </label> <label class="form-label text-warning"> (<?php echo e(__('Optional')); ?>) <?php echo e(__('Start sending on the next cron job')); ?></label>
                                    <select id="phonebook" name="phonebook" class="form-select">
                                        <option value=""><?php echo e(__('Select Phonebook')); ?></option>
                                        <?php $__currentLoopData = $phonebooks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phonebook): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($phonebook->data); ?>"><?php echo e($phonebook->name); ?> (<?php echo e(count(json_decode($phonebook->data))); ?>)</option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php $__currentLoopData = $subscribers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $subscriber): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($subscriber->device()->value('status') !== 'ONLINE'): ?> <?php continue; ?> <?php endif; ?>
                                        <option value="<?php echo e(__('Subscribers')); ?>-<?php echo e($subscriber->sender); ?>"><?php echo e(__('Subscribers')); ?>-<?php echo e($subscriber->sender); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e(__('Subscribers')); ?>-<?php echo e(__('ALL')); ?>"><?php echo e(__('Subscribers')); ?>-<?php echo e(__('ALL')); ?></option>
                                    </select>
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> <?php echo e(__('Message text')); ?> </label>
                                    <select onchange="getTemplate()" id="template" name="template" class="form-select">
                                        <option value=""><?php echo e(__('Select Template')); ?></option>
                                        <?php $__currentLoopData = $templates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $template): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($template); ?>"><?php echo e($template->name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                    <textarea id="msgtext" name="msgtext" class="form-control" rows="5" placeholder="<?php echo e(__('Message text here...')); ?>"></textarea>
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> <?php echo e(__('Emoji')); ?> (<?php echo e(__('Copy and Paste')); ?>)</label>
                                    <textarea name="emoji" class="form-control" rows="7" readonly><?php echo e(file_get_contents(public_path('app-assets/data/emoji.txt'))); ?></textarea>
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> <?php echo e(__('Media file')); ?> </label> <label class="form-label text-warning"> JPEG/PNG/GIF/PDF/DOCX/PPTX/XLSX/CSV/MP3/MP4/ZIP </label>
                                    <input type="file" id="mediafile" name="mediafile" class="form-control">
                                    <input type="text" id="mediaurlInput" name="mediaurlInput" value="" class="form-control" style="display: none;">
                                    <!-- <label class="form-label text-warning"> <?php echo e(__('Button message samples')); ?> <a href="<?php echo e(config('app.URL_DOCS_BUTTONS')); ?>" target="_blank"><?php echo e(__('Click HERE')); ?>!</a></label> -->
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> <?php echo e(__('Button type')); ?> </label> <label class="form-label text-warning"> (<?php echo e(__('Optional')); ?>) </label>
                                    <select onchange="showButtonType()" id="buttontype" name="buttontype" class="form-select">
                                        <option value="none"><?php echo e(__('No Buttons')); ?></option>
                                        <option value="reply"><?php echo e(__('Reply buttons')); ?></option>
                                        <option value="template"><?php echo e(__('Template buttons (URL/Call)')); ?></option>
                                        <option value="list"><?php echo e(__('List buttons')); ?></option>
                                    </select>
                                    <label id="buttontypeLabel" style="display: none;" class="text-warning"> 
                                        <?php echo e(__('Reply buttons = Quick reply options')); ?><br>
                                        <?php echo e(__('Template buttons = URL/Phone buttons')); ?><br>
                                        <?php echo e(__('List buttons = Dropdown menu')); ?>

                                    </label>
                                    <br>
                                </div>
                                <div class="col-12 col-md-6" style="display: none;" id="areaFooterText">
                                    <label> <?php echo e(__('Button footer text')); ?> </label> <label class="form-label text-warning"> (<?php echo e(__('Optional')); ?>) </label>
                                    <input type="text" id="footerText" name="footerText" placeholder="<?php echo e(__('Text on the footer')); ?>" value="" class="form-control">
                                    <br>
                                </div>
                                <div class="col-12 col-md-6" style="display: none;" id="areaMainTitle">
                                    <label> <?php echo e(__('Main title')); ?> </label> <label class="form-label text-warning"> (<?php echo e(__('Required for List buttons')); ?>) </label>
                                    <input type="text" id="mainTitle" name="mainTitle" placeholder="<?php echo e(__('Main title')); ?>" value="Main title" class="form-control">
                                    <br>
                                </div>
                                <div class="col-12 col-md-6" style="display: none;" id="areaButtonText">
                                    <label> <?php echo e(__('Text on the button')); ?> </label> <label class="form-label text-warning"> (<?php echo e(__('Required for List buttons')); ?>) </label>
                                    <input type="text" id="buttonText" name="buttonText" placeholder="<?php echo e(__('Text on the button')); ?>" value="Choose an option" class="form-control">
                                    <br>
                                </div>
                                <?php for($i=1; $i<=$numOfButtons; $i++): ?>
                                <div class="col-12 col-md-6" style="display: none;" id="areaReply<?php echo e($i); ?>">
                                    <label> <?php echo e(__('Button') . ' ' . $i); ?> </label> <label class="form-label text-warning"> (<?php echo e(__('Optional')); ?>) </label>
                                    <input type="text" id="displayText<?php echo e($i); ?>" name="displayText<?php echo e($i); ?>" placeholder="<?php echo e(__('Text on the button')); ?>" value="" class="form-control">
                                    <input type="text" id="responseText<?php echo e($i); ?>" name="responseText<?php echo e($i); ?>" placeholder="<?php echo e(__('Response ID (or URL like https://... or phone like +234...)')); ?>" value="" class="form-control">
                                    <br>
                                </div>
                                <?php endfor; ?>
                                <?php for($i=1; $i<=$numOfLists; $i++): ?>
                                <div class="col-12 col-md-6" style="display: none;" id="areaList<?php echo e($i); ?>">
                                    <label> <?php echo e(__('Row') . ' ' . $i); ?> </label> <label class="form-label text-warning"> (<?php echo e(__('Optional')); ?>) </label>
                                    <input type="text" id="sectionTitle<?php echo e($i); ?>" name="sectionTitle<?php echo e($i); ?>" placeholder="<?php echo e(__('Section title')); ?>" value="" class="form-control">
                                    <input type="text" id="rowTitle<?php echo e($i); ?>" name="rowTitle<?php echo e($i); ?>" placeholder="<?php echo e(__('Row title')); ?>" value="" class="form-control">
                                    <input type="text" id="description<?php echo e($i); ?>" name="description<?php echo e($i); ?>" placeholder="<?php echo e(__('Description')); ?>" value="" class="form-control">
                                    <input type="text" id="rowId<?php echo e($i); ?>" name="rowId<?php echo e($i); ?>" placeholder="<?php echo e(__('Response ID/keyword')); ?>" value="" class="form-control">
                                    <br>
                                </div>
                                <?php endfor; ?>
                                <div class="col-12 col-md-6">
                                    <label> <?php echo e(__('Schedule time')); ?> </label> <label class="form-label text-warning"> (<?php echo e(__('Optional')); ?>) </label>
                                    <input type="datetime-local" id="schedule" name="schedule" class="form-control">
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> <?php echo e(__('Recurring every')); ?> </label> <label class="form-label text-warning"> (<?php echo e(__('Optional')); ?>) <?php echo e(__('Must input schedule time')); ?></label>
                                    <div class="row">
                                        <div class="col-3">
                                            <div class="row">
                                                <div class="col-12">
                                                    <input type="number" min="0" name="years" placeholder="<?php echo e(__('Years')); ?>" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-3">
                                            <div class="row">
                                                <div class="col-12">
                                                    <input type="number" min="0" name="months" placeholder="<?php echo e(__('Months')); ?>" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-3">
                                            <div class="row">
                                                <div class="col-12">
                                                    <input type="number" min="0" name="weeks" placeholder="<?php echo e(__('Weeks')); ?>" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-3">
                                            <div class="row">
                                                <div class="col-12">
                                                    <input type="number" min="0" name="days" placeholder="<?php echo e(__('Days')); ?>" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> <?php echo e(__('Message delay (seconds)')); ?> </label> <label class="form-label text-warning"> (<?php echo e(__('Optional')); ?>) </label>
                                    <div class="row">
                                        <div class="col-4">
                                            <div class="row">
                                                <div class="col-4">
                                                    <label> <?php echo e(__('Min')); ?> </label>
                                                </div>
                                                <div class="col-8">
                                                    <input type="number" min="1" max="120" name="min" placeholder="<?php echo e(__('Min')); ?>" value="3" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-4">
                                            <div class="row">
                                                <div class="col-4">
                                                    <label> <?php echo e(__('Max')); ?> </label>
                                                </div>
                                                <div class="col-8">
                                                    <input type="number" min="1" max="120" name="max" placeholder="<?php echo e(__('Max')); ?>" value="8" class="form-control">
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> <?php echo e(__('Insert random string')); ?> </label>
                                    <select name="randomString" class="form-select">
                                        <option value="NO"><?php echo e(__('NO')); ?></option>
                                        <option value="uuid"><?php echo e(__('Random code')); ?></option>
                                        <option value="inspiring"><?php echo e(__('Inspiring quote')); ?></option>
                                    </select>
                                    <br>
                                </div>
                                <div class="col-12 col-md-6">
                                    <label> <?php echo e(__('Insert Footer Text')); ?> </label>
                                        <input type="text" id="footer" name="footer" placeholder="<?php echo e(__('Text on the footer')); ?>" class="form-control">
                                    <br>
                                </div>
                                <div>
                                    <button class="btn btn-primary" type="submit" id="sendmsg" onclick="sendMsg(this, '<?php echo e($alertMsg); ?>')" name="send"><?php echo e(__('Send')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

				<!-- BEGIN: Button message sending mechanism -->
                
                <!-- END: Button message sending mechanism -->

                <div class="card col-12">
                    <div class="card-body">
                        <div class="card-header"><a href="<?php echo e(route('phonebook.list')); ?>"><h4><?php echo e(__('Phonebook')); ?></h4></a></div>
                        <div class="card-body">
                            <div class="areapb" id="areapb"></div><br>
                            <table class="table table-striped table-bordered datatable">
                                <thead>
                                    <tr>
                                        <th> <?php echo e(__('Phonebook')); ?> </th>
                                        <th> <?php echo e(__('Name & Receiver number')); ?> </th>
                                        <th> <?php echo e(__('Total')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $phonebooks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phonebook): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                        <?php echo e($phonebook['name']); ?>

                                        </td>
                                        <td>
                                        <?php echo e(str_replace(['"','[',']','name:','receiver:'], [''], substr($phonebook->data, 0, 100)) . '...'); ?>

                                        </td>
                                        <td><?php echo e(count(json_decode($phonebook->data))); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- END: Content-->

    <!-- BEGIN: Vendor JS-->
    <script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/vendors.min.js"></script>
    <!-- BEGIN Vendor JS-->

<script>
    function showButtonType() {
        var buttonType = document.getElementById("buttontype").value;
        
        // Hide all areas first
        document.getElementById("buttontypeLabel").style.display = 'none';
        document.getElementById("areaFooterText").style.display = 'none';
        document.getElementById("areaMainTitle").style.display = 'none';
        document.getElementById("areaButtonText").style.display = 'none';
        
        for (i=1; i<=<?php echo e($numOfButtons); ?>; i++) {
            document.getElementById("areaReply" + i).style.display = 'none';
        }
        for (i=1; i<=<?php echo e($numOfLists); ?>; i++) {
            document.getElementById("areaList" + i).style.display = 'none';
        }
        
        // Show relevant areas based on button type
        if (buttonType === 'reply' || buttonType === 'template') {
            document.getElementById("buttontypeLabel").innerHTML = "<?php echo e(__('Reply buttons = Quick reply options')); ?><br><?php echo e(__('Template buttons = URL/Phone buttons')); ?>";
            document.getElementById("buttontypeLabel").style.display = 'block';
            document.getElementById("areaFooterText").style.display = 'block';
            
            for (i=1; i<=<?php echo e($numOfButtons); ?>; i++) {
                document.getElementById("areaReply" + i).style.display = 'block';
            }
        } else if (buttonType === 'list') {
            document.getElementById("buttontypeLabel").innerHTML = "<?php echo e(__('List buttons = Dropdown menu with sections')); ?>";
            document.getElementById("buttontypeLabel").style.display = 'block';
            document.getElementById("areaFooterText").style.display = 'block';
            document.getElementById("areaMainTitle").style.display = 'block';
            document.getElementById("areaButtonText").style.display = 'block';
            
            for (i=1; i<=<?php echo e($numOfLists); ?>; i++) {
                document.getElementById("areaList" + i).style.display = 'block';
            }
        }
    }

    function clearTemplate() {
        document.getElementById("msgtext").innerHTML = '';
        document.getElementById("mediaurlInput").value = '';
        document.getElementById("mediaurlInput").style.display = 'none';
        document.getElementById("mediafile").style.display = 'block';

        // document.getElementById("buttontype").value = 'none';
        // document.getElementById("buttontype").style.display = 'block';
        // document.getElementById("buttontypeLabel").innerHTML = '';
        // document.getElementById("buttontypeLabel").style.display = 'none';
        // document.getElementById("areaFooterText").style.display = 'none';
        // document.getElementById("areaMainTitle").style.display = 'none';
        // document.getElementById("areaButtonText").style.display = 'none';
        // for (i=1; i<=<?php echo e($numOfButtons); ?>; i++) {
        //     document.getElementById("areaReply" + i).style.display = 'none';
        // }
        // for (i=1; i<=<?php echo e($numOfLists); ?>; i++) {
        //     document.getElementById("areaList" + i).style.display = 'none';
        // }
    }

    function getTemplate() {
        if (document.getElementById("template").value) {
            clearTemplate();
            var template = JSON.parse(document.getElementById("template").value);
            // var buttons = JSON.parse(template.data);
            document.getElementById("msgtext").innerHTML = template.msgtext;
            document.getElementById("mediaurlInput").value = template.mediaurl;
            if (document.getElementById("mediaurlInput").value) {
                document.getElementById("mediaurlInput").style.display = 'block';
                document.getElementById("mediafile").style.display = 'none';
            } else {
                document.getElementById("mediaurlInput").style.display = 'none';
                document.getElementById("mediafile").style.display = 'block';
            }

            // if (buttons && buttons.listButtons) {
            //     document.getElementById("buttontype").value = 'list';
            //     document.getElementById("buttontype").style.display = 'none';
            //     document.getElementById("buttontypeLabel").innerHTML = "<?php echo e(__('List buttons')); ?>";
            //     document.getElementById("buttontypeLabel").style.display = 'block';
            //     document.getElementById("footerText").value = buttons.footerText
            //     document.getElementById("areaFooterText").style.display = 'block';
            //     document.getElementById("mainTitle").value = buttons.mainTitle
            //     document.getElementById("areaMainTitle").style.display = 'block';
            //     document.getElementById("buttonText").value = buttons.buttonText
            //     document.getElementById("areaButtonText").style.display = 'block';

            //     const btns = buttons.listButtons;
            //     var i = 1;
            //     btns.forEach((btn) => {
            //         const rows = btn.rows;
            //         rows.forEach((row) => {
            //             document.getElementById("areaReply" + i).style.display = 'none';
            //             document.getElementById("sectionTitle" + i).value = btn.title;
            //             document.getElementById("rowTitle" + i).value = row.title;
            //             document.getElementById("description" + i).value = row.description;
            //             document.getElementById("rowId" + i).value = row.rowId;
            //             document.getElementById("areaList" + i).style.display = 'block';
            //             i++;
            //         })
            //     })
            // }
            // if (buttons && buttons.replyButtons) {
            //     const btn = buttons.replyButtons;
            //     document.getElementById("buttontype").value = 'reply';
            //     document.getElementById("buttontype").style.display = 'none';
            //     document.getElementById("buttontypeLabel").innerHTML = "<?php echo e(__('Reply buttons = NO URL/phone link')); ?>";
            //     document.getElementById("buttontypeLabel").style.display = 'block';
            //     document.getElementById("footerText").value = buttons.footerText
            //     document.getElementById("areaFooterText").style.display = 'block';
            //     document.getElementById("areaMainTitle").style.display = 'none';
            //     document.getElementById("areaButtonText").style.display = 'none';
            //     for (i=1; i<=btn.length; i++) {
            //         document.getElementById("displayText" + i).value = btn[i-1].buttonText.displayText;
            //         document.getElementById("responseText" + i).value = btn[i-1].buttonId;
            //         document.getElementById("areaReply" + i).style.display = 'block';
            //         document.getElementById("areaList" + i).style.display = 'none';
            //     }
            // } else if (buttons && buttons.templateButtons) {
            //     const btn = buttons.templateButtons;
            //     document.getElementById("buttontype").value = 'template';
            //     document.getElementById("buttontype").style.display = 'none';
            //     document.getElementById("buttontypeLabel").innerHTML = "<?php echo e(__('Template buttons = YES URL/phone link')); ?>";
            //     document.getElementById("buttontypeLabel").style.display = 'block';
            //     document.getElementById("footerText").value = buttons.footerText
            //     document.getElementById("areaFooterText").style.display = 'block';
            //     document.getElementById("areaMainTitle").style.display = 'none';
            //     document.getElementById("areaButtonText").style.display = 'none';
            //     for (i=1; i<=btn.length; i++) {
            //         document.getElementById("displayText" + i).value = btn[i-1].quickReplyButton ? btn[i-1].quickReplyButton.displayText : btn[i-1].callButton ? btn[i-1].callButton.displayText : btn[i-1].urlButton ? btn[i-1].urlButton.displayText : '';
            //         document.getElementById("responseText" + i).value = btn[i-1].quickReplyButton ? btn[i-1].quickReplyButton.id : btn[i-1].callButton ? btn[i-1].callButton.phoneNumber : btn[i-1].urlButton ? btn[i-1].urlButton.url : '';
            //         document.getElementById("areaReply" + i).style.display = 'block';
            //         document.getElementById("areaList" + i).style.display = 'none';
            //     }
            // } else if (buttons && buttons.listButtons) {
            //     document.getElementById("buttontype").value = 'list';
            //     document.getElementById("buttontype").style.display = 'none';
            //     document.getElementById("buttontypeLabel").innerHTML = "<?php echo e(__('List buttons')); ?>";
            //     document.getElementById("buttontypeLabel").style.display = 'block';
            //     document.getElementById("footerText").value = buttons.footerText
            //     document.getElementById("areaFooterText").style.display = 'block';
            //     document.getElementById("mainTitle").value = buttons.mainTitle
            //     document.getElementById("areaMainTitle").style.display = 'block';
            //     document.getElementById("buttonText").value = buttons.buttonText
            //     document.getElementById("areaButtonText").style.display = 'block';

            //     const btns = buttons.listButtons;
            //     var i = 1;
            //     btns.forEach((btn) => {
            //         const rows = btn.rows;
            //         rows.forEach((row) => {
            //             document.getElementById("areaReply" + i).style.display = 'none';
            //             document.getElementById("sectionTitle" + i).value = btn.title;
            //             document.getElementById("rowTitle" + i).value = row.title;
            //             document.getElementById("description" + i).value = row.description;
            //             document.getElementById("rowId" + i).value = row.rowId;
            //             document.getElementById("areaList" + i).style.display = 'block';
            //             i++;
            //         })
            //     })
            // } else if (buttons) {
            //     document.getElementById("buttontype").value = 'none';
            //     document.getElementById("buttontype").style.display = 'block';
            //     document.getElementById("buttontypeLabel").innerHTML = '';
            //     document.getElementById("buttontypeLabel").style.display = 'none';
            //     document.getElementById("areaFooterText").style.display = 'none';
            //     document.getElementById("areaMainTitle").style.display = 'none';
            //     document.getElementById("areaButtonText").style.display = 'none';
            //     for (i=1; i<=<?php echo e($numOfButtons); ?>; i++) {
            //         document.getElementById("areaReply" + i).style.display = 'none';
            //     }
            //     for (i=1; i<=<?php echo e($numOfLists); ?>; i++) {
            //         document.getElementById("areaList" + i).style.display = 'none';
            //     }
            // }
        } else {
            clearTemplate();
        }
    }

    $('#select_all').click(function(e) {
        e.preventDefault();
        $('#sender option').prop('selected', true);
    });

    $('#phonebook').change(function() {
        var pbdatas = $("#phonebook").val().replace(/"|:|\[|\]|name|receiver/g, "");
        $("#areapb").html(pbdatas);
    });

    var select = document.getElementById('sender');
    select.size = select.length > 20 ? 20 : select.length;

    function sendMsg(sendButton, alertMsg) {
        sendButton.disabled=true;
        sendButton.innerHTML = "<?php echo e(__('DO NOT CLOSE / BACK / REFRESH !!!')); ?>";
        sendButton.form.submit();
        setTimeout(function () {
            window.location.reload();
            alert(alertMsg);
        }, 30_000);
    }
</script>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views//sendmsg.blade.php ENDPATH**/ ?>