<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="card-body">
            <button type="button" class="btn btn-primary float-end" data-bs-toggle="modal" data-bs-target="#addNew"><?php echo e(__('Add new autoreply')); ?></button>
            <a class="btn btn-warning float-end" href="<?php echo e(route('autoreply.samples', Auth::user()->id)); ?>"><?php echo e(__('Autoreply samples')); ?></a>
        </div>
        <div class="content-header row">
            <h4><?php echo e(__('Autoreply list')); ?><span class="badge rounded-pill badge-light-secondary"><?php echo e(DB::table('autoreplies')->where('user_id',Auth::user()->id)->count()); ?></span></h4>
        </div>
        <div class="content-body">
            <!-- autoreply list start -->
            <section class="app-autoreply-list">
                <!-- list and filter start -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive table-responsive">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th><?php echo e(__('Device')); ?> <?php echo e(__('Sender')); ?></th>
                                        <th><?php echo e(__('Keyword')); ?></th>
                                        <th><?php echo e(__('Match %')); ?></th>
                                        <th><?php echo e(__('Response')); ?></th>
                                        <th><?php echo e(__('Media file')); ?></th>
                                        <th><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $autoreplies; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $autoreply): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($autoreply->id); ?>" data-bs-toggle="modal">
                                        <?php echo e(empty($autoreply->device->name) ? '' : $autoreply->device->name); ?> (<?php echo e(strtoupper($autoreply->sender)); ?>)</a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($autoreply->id); ?>" data-bs-toggle="modal">
                                        <?php echo e($autoreply->keyword); ?></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($autoreply->id); ?>" data-bs-toggle="modal">
                                        <?php echo e($autoreply->match_percent); ?></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($autoreply->id); ?>" data-bs-toggle="modal">
                                        <?php echo e(substr($autoreply->response, 0, 150) . '...'); ?></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($autoreply->id); ?>" data-bs-toggle="modal">
                                        <?php ($arrMediaurl=explode('/', $autoreply->mediaurl)); ?>
                                        <?php echo e(end($arrMediaurl)); ?></a>
                                        </td>
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton-<?php echo e($autoreply->id); ?>" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton-<?php echo e($autoreply->id); ?>">
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit-<?php echo e($autoreply->id); ?>"><i data-feather="edit" class="me-0"></i> <?php echo e(__('Edit')); ?></a>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#copy-<?php echo e($autoreply->id); ?>"><i data-feather="copy" class="me-0"></i> <?php echo e(__('Copy')); ?></a>
                                                <?php if(strpos($autoreply->data,'"replyButtons":[{"') > -1 || strpos($autoreply->data,'"templateButtons":[{"') > -1 || strpos($autoreply->data,'"listButtons":[{"')): ?>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#removeButtons-<?php echo e($autoreply->id); ?>"><i data-feather="trash" class="me-0"></i> <?php echo e(__('Remove button')); ?></a>
                                                <?php endif; ?>
                                                <?php if($autoreply->mediaurl): ?>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#removeMedia-<?php echo e($autoreply->id); ?>"><i data-feather="trash" class="me-0"></i> <?php echo e(__('Remove media')); ?></a>
                                                <?php endif; ?>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-<?php echo e($autoreply->id); ?>"><i data-feather="trash" class="me-0"></i> <?php echo e(__('Delete')); ?></a>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-<?php echo e($autoreply->id); ?>" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Delete confirmation')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <?php echo e(__('Are you sure you want to delete?')); ?> <br><br>
                                                    <span class="text text-danger"> <b><?php echo e($autoreply->keyword); ?></b> </span><br><br>
                                                    <?php echo e(__('This process is irreversible')); ?> <br>
                                                    <?php echo e(__('The record(s) will be deleted from the database permanently')); ?>

                                                </div>
                                                <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="<?php echo e(route('autoreply.destroy', ['autoreply_id' => $autoreply->id])); ?>"><?php echo e(__('Delete')); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Remove button Modal -->
                                    <div class="modal fade modal-danger text-start" id="removeButtons-<?php echo e($autoreply->id); ?>" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Delete confirmation')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <?php echo e(__('Are you sure you want to delete?')); ?> <br><br>
                                                    <span class="text text-danger"> <b><?php echo e(__('Button')); ?></b> </span><br><br>
                                                    <?php echo e(__('This process is irreversible')); ?> <br>
                                                    <?php echo e(__('The record(s) will be deleted from the database permanently')); ?>

                                                </div>
                                                <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="<?php echo e(route('autoreply.remove', ['autoreply_id' => $autoreply->id, 'action' => 'button'])); ?>"><?php echo e(__('Delete')); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Remove media Modal -->
                                    <div class="modal fade modal-danger text-start" id="removeMedia-<?php echo e($autoreply->id); ?>" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Delete confirmation')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <?php echo e(__('Are you sure you want to delete?')); ?> <br><br>
                                                    <span class="text text-danger"> <b><?php echo e(end($arrMediaurl)); ?></b> </span><br><br>
                                                    <?php echo e(__('This process is irreversible')); ?> <br>
                                                    <?php echo e(__('The record(s) will be deleted from the database permanently')); ?>

                                                </div>
                                                <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="<?php echo e(route('autoreply.remove', ['autoreply_id' => $autoreply->id, 'action' => 'media'])); ?>"><?php echo e(__('Delete')); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Edit Autoreply Modal -->
                                    <div class="modal fade" id="edit-<?php echo e($autoreply->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-autoreply">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1"><?php echo e(__('Edit autoreply')); ?></h1>
                                                    </div>
                                                    <form action="<?php echo e(route('autoreply.update')); ?>" method="POST" id="editAutoreplyForm" class="row gy-1 pt-75" enctype="multipart/form-data">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="row">
                                                            <div class="col-12">
                                                                <input type="hidden" name="autoreply_id" value="<?php echo e($autoreply->id); ?>" />
                                                                <input type="hidden" name="prev_mediafile" value="<?php echo e(end($arrMediaurl)); ?>" />
                                                                <input type="hidden" name="prev_mediaurl" value="<?php echo e($autoreply->mediaurl); ?>" />
                                                                <input type="hidden" name="prev_keyword" value="<?php echo e($autoreply->keyword); ?>" />
                                                                <label class="form-label" for="sender"><?php echo e(__('Autoreply sender')); ?></label>
                                                                <select class="form-control" name="sender">
                                                                    <option value="all" <?php echo e(($autoreply->sender == "all" ? "selected" : "")); ?>><?php echo e(__('ALL')); ?></option>
                                                                    <option value="off" <?php echo e(($autoreply->sender == "off" ? "selected" : "")); ?>><?php echo e(__('OFF')); ?></option>
                                                                    <?php $__currentLoopData = $devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <option value="<?php echo e($device->sender); ?>" <?php echo e(($autoreply->sender == $device->sender ? "selected" : "")); ?>><?php echo e($device->name . ' (' . $device->sender . ')'); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="keyword"><?php echo e(__('Autoreply keyword')); ?></label> <label class="form-label text-warning"> (<?php echo e(__('Hello, Olá, Hallo')); ?>) </label>
                                                                <input type="text" name="keyword" class="form-control" value="<?php echo e($autoreply->keyword); ?>" placeholder="<?php echo e(__('Autoreply keyword')); ?>" required />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="match_percent"><?php echo e(__('Autoreply match percentage')); ?></label>
                                                                <input type="text" name="match_percent" class="form-control" value="<?php echo e($autoreply->match_percent); ?>" placeholder="1 - 100" required />
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="response"><?php echo e(__('Autoreply response')); ?></label> <label class="form-label text-warning"> {name} <?php echo e(__('will display the receivers name')); ?> </label>
                                                                <textarea name="response" class="form-control" rows="6" placeholder="Response text" required><?php echo e($autoreply->response); ?></textarea>
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label> <?php echo e(__('Emoji')); ?> (<?php echo e(__('Copy and Paste')); ?>)</label>
                                                                <textarea name="emoji" class="form-control" rows="7" readonly><?php echo e(file_get_contents(public_path('app-assets/data/emoji.txt'))); ?></textarea><br>
                                                            </div>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="mediafile"><?php echo e(__('Autoreply mediafile')); ?></label> <label class="form-label text-warning"> (<?php echo e(__('Optional')); ?>) </label> <label class="form-label text-warning"> JPEG/PNG/GIF/PDF/DOCX/PPTX/XLSX/CSV/MP3 </label>
                                                                <input type="file" name="mediafile" class="form-control" /><?php echo e(end($arrMediaurl)); ?><br>
                                                            </div><hr>
                                                            <div class="col-12 text-center mt-2 pt-50">
                                                                <button type="submit" class="btn btn-primary me-1"><?php echo e(__('Submit')); ?></button>
                                                                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close"><?php echo e(__('Cancel')); ?></button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Edit Autoreply Modal -->
                                    <!--/ Copy Autoreply Modal -->
                                    <div class="modal fade" id="copy-<?php echo e($autoreply->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-lg modal-dialog-centered modal-edit-user">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1"><?php echo e(__('Copy autoreply')); ?></h1>
                                                    </div>
                                                    <form action="<?php echo e(route('autoreply.copy')); ?>" method="GET" id="copyAutoreplyForm" class="row gy-1 pt-75" enctype="multipart/form-data">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="row">
                                                            <div class="col-12 col-md-6">
                                                                <input type="hidden" name="autoreply_id" value="<?php echo e($autoreply->id); ?>" />
                                                                <label class="form-label" for="autoreply_keyword"><?php echo e(__('Autoreply keyword')); ?></label>
                                                                <input type="text" name="autoreply_keyword" class="form-control" value="<?php echo e($autoreply->keyword); ?>" required readonly />
                                                            </div>
                                                            <?php if(Auth::user()->role === 'admin'): ?>
                                                            <div class="col-12 col-md-6">
                                                                <label class="form-label" for="to_user"><?php echo e(__('To User')); ?></label>
                                                                <select class="select2 form-select" id="to_userid-<?php echo e($autoreply->id); ?>" onchange="changeDevice(this, <?php echo e(Auth::user()->id); ?>, <?php echo e($autoreply->id); ?>)" name="to_userid">
                                                                    <option value=""><?php echo e(__('Select User')); ?></option>
                                                                    <optgroup label="Admins">
                                                                    <?php $__currentLoopData = $adminUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $adminUser): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php if($adminUser->id == 2): ?> <?php continue; ?> <?php endif; ?>
                                                                        <option value="<?php echo e($adminUser->id); ?>" <?php echo e($adminUser->id === $autoreply->user->id ? 'selected' : ''); ?>><?php echo e($adminUser->name); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </optgroup>
                                                                    <optgroup label="Users">
                                                                    <?php $__currentLoopData = $userUsers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $userUser): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($userUser->id); ?>" <?php echo e($userUser->id === $autoreply->user->id ? 'selected' : ''); ?>><?php echo e($userUser->name); ?></option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    </optgroup>
                                                                </select>
                                                            </div>
                                                            <?php else: ?>
                                                            <input type="hidden" name="to_userid" value="<?php echo e($autoreply->user_id); ?>" />
                                                            <?php endif; ?>
                                                            <div class="col-12 col-md-6" id="selectDevice-<?php echo e($autoreply->id); ?>">
                                                                <label class="form-label" for="label_to_sender"><?php echo e(__('To Device')); ?></label>
                                                                <select class="select2 form-select" id="to_sender-<?php echo e($autoreply->id); ?>" name="to_sender">
                                                                    <option value=""><?php echo e(__('Select Device')); ?></option>
                                                                    <?php $__currentLoopData = $devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                        <option value="<?php echo e($device->sender); ?>"><?php echo e($device->name); ?> (<?php echo e($device->sender); ?>)</option>
                                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                </select>
                                                            </div>
                                                            <div class="col-12 text-center mt-2 pt-50">
                                                                <button type="submit" class="btn btn-primary me-1"><?php echo e(__('Submit')); ?></button>
                                                                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close"><?php echo e(__('Cancel')); ?></button>
                                                            </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Copy Autoreply Modal -->
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                        <!-- Modal to add new autoreply starts-->
                        <div class="modal modal-slide-in new-autoreply-modal fade" id="addNew">
                            <div class="modal-dialog">
                                <form action="<?php echo e(route('autoreply.store')); ?>" method="POST" class="modal-content pt-0" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
                                    <div class="modal-header mb-1">
                                        <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Add new autoreply')); ?></h5>
                                    </div>
                                    <div class="modal-body flex-grow-1">
                                        <div class="mb-1">
                                            <label class="form-label" for="sender"><?php echo e(__('Autoreply sender')); ?></label>
                                            <select class="form-control" name="sender">
                                                <option value="all"><?php echo e(__('ALL')); ?></option>
                                                <option value="off"><?php echo e(__('OFF')); ?></option>
                                                <?php $__currentLoopData = $devices; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $device): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($device->sender); ?>"><?php echo e($device->name . ' (' . $device->sender . ')'); ?></option>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="keyword"><?php echo e(__('Autoreply keyword')); ?></label> <label class="form-label text-warning"> (<?php echo e(__('Hello, Olá, Hallo')); ?>) </label>
                                            <input type="text" name="keyword" class="form-control" placeholder="<?php echo e(__('Autoreply keyword')); ?>" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="match_percent"><?php echo e(__('Autoreply match percentage')); ?></label>
                                            <input type="number" name="match_percent" class="form-control dt-dname" placeholder="1 - 100" value="100" required />
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="response"><?php echo e(__('Autoreply response')); ?></label>
                                            <textarea name="response" class="form-control" rows="6" placeholder="{name} <?php echo e(__('will display the receivers name')); ?>" required></textarea>
                                        </div>
                                        <div class="mb-1">
                                            <label> <?php echo e(__('Emoji')); ?> (<?php echo e(__('Copy and Paste')); ?>)</label>
                                            <textarea name="emoji" class="form-control" rows="7" readonly><?php echo e(file_get_contents(public_path('app-assets/data/emoji.txt'))); ?></textarea><br>
                                        </div>
                                        <div class="mb-1">
                                            <label class="form-label" for="mediafile"><?php echo e(__('Autoreply mediafile')); ?></label> <label class="form-label text-warning"> (<?php echo e(__('Optional')); ?>) </label> <label class="form-label text-warning"> JPEG/PNG/GIF/PDF/DOCX/PPTX/XLSX/CSV/MP3 </label>
                                            <input type="file" name="mediafile" class="form-control" placeholder="<?php echo e(__('Autoreply mediafile')); ?>" /><br>
                                        </div>
                                        <button type="submit" class="btn btn-primary me-1 data-submit"><?php echo e(__('Submit')); ?></button>
                                        <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                                    </div>
                                </form>
                            </div>
                        </div>
                        <!-- Modal to add new autoreply Ends-->
                    </div>
                </div>
                <!-- list and filter end -->
            </section>
            <!-- autoreply list ends -->
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/vendors.min.js"></script>
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
    $(document).ready(function () {
        $('#tbl-bootstr').DataTable();
    });        
</script>
<script>
    function changeDevice(name_drop, authId, autoreplyId) {
        var selectId = name_drop.value;
        if (authId == selectId) {
            document.getElementById("selectDevice-" + autoreplyId).style.display = 'block';
        } else {
            document.getElementById("selectDevice-" + autoreplyId).style.display = 'none';
            document.getElementById("to_sender-" + autoreplyId).value = '';
        }
    }
</script>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views//autoreply-list.blade.php ENDPATH**/ ?>