<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="content-header row">
            <h4><?php echo e(__('Settings')); ?></h4>
        </div>
        <div class="content-body">
            <!-- License activation UI removed -->
        </div>

        <div class="card-body">
            <button type="button" class="btn btn-sm btn-primary float-end" data-bs-toggle="modal" data-bs-target="#addNew"><?php echo e(__('Add new setting')); ?></button>
            <a href="<?php echo e(route('setting.clearCache')); ?>" class="btn btn-sm btn-danger float-end" ><?php echo e(__('Clear app cache')); ?></a>
        </div>

        <div class="content-header row">
            <h4><?php echo e(__('Settings list')); ?><span class="badge rounded-pill badge-light-secondary"><?php echo e(DB::table('settings')->count()); ?></span></h4>
        </div>
        <div class="content-body">
            <!-- settings list start -->
            <section class="app-setting-list">
                <!-- list and filter start -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive table-responsive">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th><?php echo e(__('Setting key')); ?></th>
                                        <th><?php echo e(__('Setting value')); ?></th>
                                        <th><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $settings; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $setting): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($setting->id); ?>" data-bs-toggle="modal">
                                        <?php echo e($setting->key); ?></a>
                                        </td>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($setting->id); ?>" data-bs-toggle="modal">
                                        <?php echo e($setting->value); ?></a>
                                        </td>
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton-<?php echo e($setting->id); ?>" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton-<?php echo e($setting->id); ?>">
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit-<?php echo e($setting->id); ?>"><i data-feather="edit" class="me-0"></i> <?php echo e(__('Edit')); ?></a>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-<?php echo e($setting->id); ?>"><i data-feather="trash" class="me-0"></i> <?php echo e(__('Delete')); ?></a>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-<?php echo e($setting->id); ?>" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Delete confirmation')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <?php echo e(__('Are you sure you want to delete?')); ?> <br><br>
                                                    <span class="text text-danger"> <b><?php echo e($setting->key); ?></b> </span><br><br>
                                                    <?php echo e(__('This process is irreversible')); ?> <br>
                                                    <?php echo e(__('The record(s) will be deleted from the database permanently')); ?>

                                                </div>
                                                <div class="modal-footer">
                                                    <a class="btn btn-sm btn-danger" href="<?php echo e(route('setting.destroy', ['setting_id' => $setting->id])); ?>"><?php echo e(__('Delete')); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Edit Setting Modal -->
                                    <div class="modal fade" id="edit-<?php echo e($setting->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-setting">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1"><?php echo e(__('Edit setting')); ?></h1>
                                                    </div>
                                                    <form action="<?php echo e(route('setting.update')); ?>" method="POST" class="row gy-1 pt-75">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="row">
                                                        <div class="col-12 col-md-6">
                                                            <input type="hidden"  name="setting_id" value="<?php echo e($setting->id); ?>" />
                                                            <label class="form-label" for="key"><?php echo e(__('Setting key')); ?></label>
                                                            <input type="text" name="key" class="form-control" value="<?php echo e($setting->key); ?>" />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="value"><?php echo e(__('Setting value')); ?></label>
                                                            <input type="text" name="value" class="form-control" value="<?php echo e($setting->value); ?>" />
                                                        </div>
                                                        <div class="col-12 text-center mt-2 pt-50">
                                                            <button type="submit" class="btn btn-primary me-1"><?php echo e(__('Submit')); ?></button>
                                                            <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close"><?php echo e(__('Cancel')); ?></button>
                                                        </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Edit Setting Modal -->
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- Modal to add new setting starts-->
                    <div class="modal modal-slide-in new-setting-modal fade" id="addNew">
                        <div class="modal-dialog">
                            <form action="<?php echo e(route('setting.store')); ?>" method="POST" class="add-new-setting modal-content pt-0">
                            <?php echo csrf_field(); ?>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
                                <div class="modal-header mb-1">
                                    <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Add new setting')); ?></h5>
                                </div>
                                <div class="modal-body flex-grow-1">
                                    <div class="mb-1">
                                        <label class="form-label" for="key"><?php echo e(__('Setting key')); ?></label>
                                        <input type="text" name="key" class="form-control" required />
                                    </div>
                                    <div class="mb-1">
                                        <label class="form-label" for="value"><?php echo e(__('Setting value')); ?></label>
                                        <input type="text" name="value" class="form-control" required />
                                    </div>
                                    <button type="submit" class="btn btn-primary me-1 data-submit"><?php echo e(__('Submit')); ?></button>
                                    <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                    <!-- Modal to add new setting Ends-->
                </div>
                <!-- list and filter end -->
            </section>
            <!-- settings list ends -->
            <!-- <div class="row">
                <div class="col-md-12">
                    
                </div>
            </div> -->
        </div>

        <div class="content-header row">
            <h4><?php echo e(__('Payment Gateway Configurations')); ?></h4>
        </div>
        <div class="content-body">
            <section class="app-gateway-list">
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive">
                            <table class="table table-hover">
                                                                <thead class="table-light">
                                    <tr>
                                        <th><?php echo e(__('Gateway Name')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th><?php echo e(__('Configuration')); ?></th>
                                        <th><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td>
                                            <strong><?php echo e($gateway->display_name); ?></strong><br>
                                            <small class="text-muted"><?php echo e($gateway->name); ?></small>
                                        </td>
                                        <td>
                                            <?php if($gateway->is_active): ?>
                                                <span class="badge bg-success"><?php echo e(__('Active')); ?></span>
                                            <?php else: ?>
                                                <span class="badge bg-danger"><?php echo e(__('Inactive')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($gateway->name === 'offline'): ?>
                                                <?php $settings = $gateway->settings ?? []; ?>
                                                <small>
                                                    <strong>Bank:</strong> <?php echo e($settings['bank_name'] ?? 'Not set'); ?><br>
                                                    <strong>Account:</strong> <?php echo e($settings['account_number'] ?? 'Not set'); ?>

                                                </small>
                                            <?php else: ?>
                                                <small>
                                                    <strong>Public Key:</strong> <?php echo e($gateway->public_key ? substr($gateway->public_key, 0, 20) . '...' : 'Not set'); ?><br>
                                                    <strong>Secret Key:</strong> <?php echo e($gateway->secret_key ? '********' : 'Not set'); ?>

                                                </small>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <button class="btn btn-warning btn-sm" data-bs-toggle="modal" data-bs-target="#editGateway-<?php echo e($gateway->id); ?>"><?php echo e(__('Edit')); ?></button>
                                        </td>
                                    </tr>
                                    <!-- Edit Gateway Modal -->
                                    <div class="modal fade" id="editGateway-<?php echo e($gateway->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1"><?php echo e(__('Edit Payment Gateway')); ?>: <?php echo e($gateway->display_name); ?></h1>
                                                    </div>
                                                    <form action="<?php echo e(route('gateway.update', ['gateway_id' => $gateway->id])); ?>" method="POST" class="row gy-1 pt-75">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="row">
                                                            <?php if($gateway->name === 'offline'): ?>
                                                                <!-- Offline Payment Specific Fields -->
                                                                <div class="col-12">
                                                                    <div class="alert alert-info">
                                                                        <strong><?php echo e(__('Offline Payment Configuration')); ?></strong>
                                                                        <p class="mb-0"><?php echo e(__('Configure bank details that will be shown to users during payment.')); ?></p>
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="bank_name"><?php echo e(__('Bank Name')); ?></label>
                                                                    <input type="text" name="bank_name" class="form-control" value="<?php echo e($gateway->settings['bank_name'] ?? ''); ?>" placeholder="e.g., Bank Central Asia" />
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="account_number"><?php echo e(__('Account Number')); ?></label>
                                                                    <input type="text" name="account_number" class="form-control" value="<?php echo e($gateway->settings['account_number'] ?? ''); ?>" placeholder="e.g., 1234567890" />
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="account_name"><?php echo e(__('Account Name')); ?></label>
                                                                    <input type="text" name="account_name" class="form-control" value="<?php echo e($gateway->settings['account_name'] ?? ''); ?>" placeholder="e.g., Company Name" />
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="require_proof"><?php echo e(__('Require Proof of Payment')); ?></label>
                                                                    <select name="require_proof" class="form-control">
                                                                        <option value="1" <?php if(($gateway->settings['require_proof'] ?? 1) == 1): ?> selected <?php endif; ?>><?php echo e(__('Yes')); ?></option>
                                                                        <option value="0" <?php if(($gateway->settings['require_proof'] ?? 1) == 0): ?> selected <?php endif; ?>><?php echo e(__('No')); ?></option>
                                                                    </select>
                                                                </div>
                                                                <div class="col-12">
                                                                    <label class="form-label" for="instructions"><?php echo e(__('Payment Instructions')); ?></label>
                                                                    <textarea name="instructions" class="form-control" rows="3" placeholder="<?php echo e(__('Instructions shown to users...')); ?>"><?php echo e($gateway->settings['instructions'] ?? ''); ?></textarea>
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="is_active"><?php echo e(__('Status')); ?></label>
                                                                    <select name="is_active" class="form-control">
                                                                        <option value="1" <?php if($gateway->is_active): ?> selected <?php endif; ?>><?php echo e(__('Active')); ?></option>
                                                                        <option value="0" <?php if(!$gateway->is_active): ?> selected <?php endif; ?>><?php echo e(__('Inactive')); ?></option>
                                                                    </select>
                                                                </div>
                                                            <?php elseif($gateway->name === 'paypal'): ?>
                                                                <!-- PayPal Specific Fields -->
                                                                <div class="col-12">
                                                                    <div class="alert alert-info">
                                                                        <strong><?php echo e(__('PayPal Configuration')); ?></strong>
                                                                        <p class="mb-0"><?php echo e(__('Get your credentials from')); ?> <a href="https://developer.paypal.com/dashboard/" target="_blank">PayPal Developer Dashboard</a></p>
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="mode"><?php echo e(__('Mode')); ?></label>
                                                                    <select name="mode" class="form-control">
                                                                        <option value="sandbox" <?php if(($gateway->settings['mode'] ?? 'sandbox') === 'sandbox'): ?> selected <?php endif; ?>><?php echo e(__('Sandbox (Testing)')); ?></option>
                                                                        <option value="live" <?php if(($gateway->settings['mode'] ?? 'sandbox') === 'live'): ?> selected <?php endif; ?>><?php echo e(__('Live (Production)')); ?></option>
                                                                    </select>
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="client_id"><?php echo e(__('Client ID')); ?></label>
                                                                    <input type="text" name="client_id" class="form-control" value="<?php echo e($gateway->settings['client_id'] ?? ''); ?>" placeholder="PayPal Client ID" />
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="client_secret"><?php echo e(__('Client Secret')); ?></label>
                                                                    <input type="password" name="client_secret" class="form-control" value="<?php echo e($gateway->settings['client_secret'] ?? ''); ?>" placeholder="PayPal Client Secret" />
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="webhook_url"><?php echo e(__('Webhook URL')); ?></label>
                                                                    <input type="text" name="webhook_url" class="form-control" value="<?php echo e($gateway->webhook_url); ?>" readonly />
                                                                    <small class="text-muted"><?php echo e(__('Copy this URL to your PayPal webhook settings')); ?></small>
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="is_active"><?php echo e(__('Status')); ?></label>
                                                                    <select name="is_active" class="form-control">
                                                                        <option value="1" <?php if($gateway->is_active): ?> selected <?php endif; ?>><?php echo e(__('Active')); ?></option>
                                                                        <option value="0" <?php if(!$gateway->is_active): ?> selected <?php endif; ?>><?php echo e(__('Inactive')); ?></option>
                                                                    </select>
                                                                </div>
                                                            <?php elseif($gateway->name === 'stripe'): ?>
                                                                <!-- Stripe Specific Fields -->
                                                                <div class="col-12">
                                                                    <div class="alert alert-info">
                                                                        <strong><?php echo e(__('Stripe Configuration')); ?></strong>
                                                                        <p class="mb-0"><?php echo e(__('Get your credentials from')); ?> <a href="https://dashboard.stripe.com/apikeys" target="_blank">Stripe Dashboard</a></p>
                                                                    </div>
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="test_mode"><?php echo e(__('Test Mode')); ?></label>
                                                                    <select name="test_mode" class="form-control">
                                                                        <option value="1" <?php if(($gateway->settings['test_mode'] ?? 1) == 1): ?> selected <?php endif; ?>><?php echo e(__('Enabled (Testing)')); ?></option>
                                                                        <option value="0" <?php if(($gateway->settings['test_mode'] ?? 1) == 0): ?> selected <?php endif; ?>><?php echo e(__('Disabled (Production)')); ?></option>
                                                                    </select>
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="publishable_key"><?php echo e(__('Publishable Key')); ?></label>
                                                                    <input type="text" name="publishable_key" class="form-control" value="<?php echo e($gateway->settings['publishable_key'] ?? ''); ?>" placeholder="pk_test_... or pk_live_..." />
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="stripe_secret_key"><?php echo e(__('Secret Key')); ?></label>
                                                                    <input type="password" name="stripe_secret_key" class="form-control" value="<?php echo e($gateway->settings['secret_key'] ?? ''); ?>" placeholder="sk_test_... or sk_live_..." />
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="webhook_secret"><?php echo e(__('Webhook Signing Secret')); ?></label>
                                                                    <input type="password" name="webhook_secret" class="form-control" value="<?php echo e($gateway->settings['webhook_secret'] ?? ''); ?>" placeholder="whsec_..." />
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="webhook_url"><?php echo e(__('Webhook URL')); ?></label>
                                                                    <input type="text" name="webhook_url" class="form-control" value="<?php echo e($gateway->webhook_url); ?>" readonly />
                                                                    <small class="text-muted"><?php echo e(__('Copy this URL to your Stripe webhook settings')); ?></small>
                                                                </div>
                                                                <div class="col-12 col-md-6">
                                                                    <label class="form-label" for="is_active"><?php echo e(__('Status')); ?></label>
                                                                    <select name="is_active" class="form-control">
                                                                        <option value="1" <?php if($gateway->is_active): ?> selected <?php endif; ?>><?php echo e(__('Active')); ?></option>
                                                                        <option value="0" <?php if(!$gateway->is_active): ?> selected <?php endif; ?>><?php echo e(__('Inactive')); ?></option>
                                                                    </select>
                                                                </div>
                                                            <?php else: ?>
                                                                <!-- Standard Gateway Fields (Paystack, Flutterwave, etc.) -->
                                                                <div class="col-12 col-md-4">
                                                                    <label class="form-label" for="public_key"><?php echo e(__('Public Key')); ?></label>
                                                                    <input type="text" name="public_key" class="form-control" value="<?php echo e($gateway->public_key); ?>" />
                                                                </div>
                                                                <div class="col-12 col-md-4">
                                                                    <label class="form-label" for="secret_key"><?php echo e(__('Secret Key')); ?></label>
                                                                    <input type="password" name="secret_key" class="form-control" value="<?php echo e($gateway->secret_key); ?>" />
                                                                </div>
                                                                <div class="col-12 col-md-4">
                                                                    <label class="form-label" for="webhook_url"><?php echo e(__('Webhook URL')); ?></label>
                                                                    <input type="text" name="webhook_url" class="form-control" value="<?php echo e($gateway->webhook_url); ?>" />
                                                                </div>
                                                                <div class="col-12 col-md-4">
                                                                    <label class="form-label" for="is_active"><?php echo e(__('Status')); ?></label>
                                                                    <select name="is_active" class="form-control">
                                                                        <option value="1" <?php if($gateway->is_active): ?> selected <?php endif; ?>><?php echo e(__('Active')); ?></option>
                                                                        <option value="0" <?php if(!$gateway->is_active): ?> selected <?php endif; ?>><?php echo e(__('Inactive')); ?></option>
                                                                    </select>
                                                                </div>
                                                            <?php endif; ?>
                                                        </div>
                                                        <div class="col-12 text-center mt-2 pt-50">
                                                            <button type="submit" class="btn btn-primary me-1"><?php echo e(__('Save')); ?></button>
                                                            <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close"><?php echo e(__('Cancel')); ?></button>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Edit Gateway Modal -->
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/vendors.min.js"></script>
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
    $(document).ready(function () {
        $('#tbl-bootstr').DataTable();
    });        
</script>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views//setting-list.blade.php ENDPATH**/ ?>