<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<?php
App::setLocale(Auth::user()->lang);
?>

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <!-- Statistics -->
        <div class="row">
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($statistics['total']); ?></h3>
                            <span><?php echo e(__('Total Leads')); ?></span>
                        </div>
                        <div class="avatar bg-light-primary p-50">
                            <span class="avatar-content">
                                <i data-feather="target" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($statistics['new']); ?></h3>
                            <span><?php echo e(__('New Leads')); ?></span>
                        </div>
                        <div class="avatar bg-light-info p-50">
                            <span class="avatar-content">
                                <i data-feather="user-plus" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($statistics['qualified']); ?></h3>
                            <span><?php echo e(__('Qualified')); ?></span>
                        </div>
                        <div class="avatar bg-light-warning p-50">
                            <span class="avatar-content">
                                <i data-feather="award" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-3 col-sm-6">
                <div class="card">
                    <div class="card-body d-flex align-items-center justify-content-between">
                        <div>
                            <h3 class="fw-bolder mb-75"><?php echo e($statistics['converted']); ?></h3>
                            <span><?php echo e(__('Converted')); ?></span>
                        </div>
                        <div class="avatar bg-light-success p-50">
                            <span class="avatar-content">
                                <i data-feather="check-circle" class="font-medium-4"></i>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="content-body">
            <section class="app-lead-list">
                <div class="card">
                    <div class="card-header border-bottom">
                        <h4 class="card-title"><?php echo e(__('Leads')); ?></h4>
                        <a href="<?php echo e(route('support.leads.create')); ?>" class="btn btn-primary">
                            <i data-feather="plus" class="me-25"></i>
                            <span><?php echo e(__('Add Lead')); ?></span>
                        </a>
                    </div>
                    <div class="card-body">
                        <!-- Filters -->
                        <form method="GET" action="<?php echo e(route('support.leads.index')); ?>" class="mb-2">
                            <div class="row">
                                <div class="col-md-3 mb-1">
                                    <select name="status" class="form-select" onchange="this.form.submit()">
                                        <option value="all"><?php echo e(__('All Status')); ?></option>
                                        <option value="new" <?php echo e(request('status') == 'new' ? 'selected' : ''); ?>><?php echo e(__('New')); ?></option>
                                        <option value="contacted" <?php echo e(request('status') == 'contacted' ? 'selected' : ''); ?>><?php echo e(__('Contacted')); ?></option>
                                        <option value="qualified" <?php echo e(request('status') == 'qualified' ? 'selected' : ''); ?>><?php echo e(__('Qualified')); ?></option>
                                        <option value="proposal" <?php echo e(request('status') == 'proposal' ? 'selected' : ''); ?>><?php echo e(__('Proposal')); ?></option>
                                        <option value="negotiation" <?php echo e(request('status') == 'negotiation' ? 'selected' : ''); ?>><?php echo e(__('Negotiation')); ?></option>
                                        <option value="converted" <?php echo e(request('status') == 'converted' ? 'selected' : ''); ?>><?php echo e(__('Converted')); ?></option>
                                        <option value="lost" <?php echo e(request('status') == 'lost' ? 'selected' : ''); ?>><?php echo e(__('Lost')); ?></option>
                                    </select>
                                </div>
                                <div class="col-md-3 mb-1">
                                    <select name="assigned_to" class="form-select" onchange="this.form.submit()">
                                        <option value="all"><?php echo e(__('All Leads')); ?></option>
                                        <option value="unassigned" <?php echo e(request('assigned_to') == 'unassigned' ? 'selected' : ''); ?>><?php echo e(__('Unassigned')); ?></option>
                                    </select>
                                </div>
                                <div class="col-md-3 mb-1">
                                    <select name="min_score" class="form-select" onchange="this.form.submit()">
                                        <option value=""><?php echo e(__('All Scores')); ?></option>
                                        <option value="70" <?php echo e(request('min_score') == '70' ? 'selected' : ''); ?>><?php echo e(__('High Score (70+)')); ?></option>
                                        <option value="50" <?php echo e(request('min_score') == '50' ? 'selected' : ''); ?>><?php echo e(__('Medium Score (50+)')); ?></option>
                                    </select>
                                </div>
                                <div class="col-md-3 mb-1">
                                    <input type="text" name="search" class="form-control" placeholder="<?php echo e(__('Search...')); ?>" value="<?php echo e(request('search')); ?>">
                                </div>
                            </div>
                        </form>

                        <!-- Leads Table -->
                        <div class="table-responsive">
                            <table class="table">
                                <thead>
                                    <tr>
                                        <th><?php echo e(__('Customer')); ?></th>
                                        <th><?php echo e(__('Source')); ?></th>
                                        <th><?php echo e(__('Status')); ?></th>
                                        <th><?php echo e(__('Score')); ?></th>
                                        <th><?php echo e(__('Assigned To')); ?></th>
                                        <th><?php echo e(__('Last Contact')); ?></th>
                                        <th><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $leads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td>
                                            <div><?php echo e($lead->customer_name ?? __('Unknown')); ?></div>
                                            <small class="text-muted"><?php echo e($lead->customer_phone); ?></small>
                                        </td>
                                        <td><?php echo e(ucfirst($lead->source)); ?></td>
                                        <td>
                                            <?php
                                                $statusColors = [
                                                    'new' => 'info',
                                                    'contacted' => 'primary',
                                                    'qualified' => 'warning',
                                                    'proposal' => 'secondary',
                                                    'negotiation' => 'dark',
                                                    'converted' => 'success',
                                                    'lost' => 'danger'
                                                ];
                                            ?>
                                            <span class="badge bg-<?php echo e($statusColors[$lead->status] ?? 'secondary'); ?>"><?php echo e(ucfirst($lead->status)); ?></span>
                                        </td>
                                        <td>
                                            <div class="d-flex align-items-center">
                                                <div class="progress flex-grow-1 me-1" style="height: 6px; width: 50px;">
                                                    <?php
                                                        $scoreColor = $lead->lead_score >= 70 ? 'success' : ($lead->lead_score >= 50 ? 'warning' : 'danger');
                                                    ?>
                                                    <div class="progress-bar bg-<?php echo e($scoreColor); ?>" style="width: <?php echo e($lead->lead_score); ?>%"></div>
                                                </div>
                                                <span class="text-muted"><?php echo e($lead->lead_score); ?></span>
                                            </div>
                                        </td>
                                        <td>
                                            <?php if($lead->assignedAgent): ?>
                                                <?php echo e($lead->assignedAgent->name); ?>

                                            <?php else: ?>
                                                <span class="text-muted"><?php echo e(__('Unassigned')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <?php if($lead->last_contact_at): ?>
                                                <small><?php echo e($lead->last_contact_at->diffForHumans()); ?></small>
                                            <?php else: ?>
                                                <span class="text-muted"><?php echo e(__('Never')); ?></span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="dropdown">
                                                <button type="button" class="btn btn-sm btn-icon" data-bs-toggle="dropdown">
                                                    <i data-feather="more-vertical"></i>
                                                </button>
                                                <div class="dropdown-menu">
                                                    <a class="dropdown-item" href="<?php echo e(route('support.leads.show', $lead->id)); ?>">
                                                        <i data-feather="eye" class="me-50"></i>
                                                        <span><?php echo e(__('View')); ?></span>
                                                    </a>
                                                    <?php if($lead->status == 'new'): ?>
                                                    <form action="<?php echo e(route('support.leads.qualify', $lead->id)); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <button type="submit" class="dropdown-item">
                                                            <i data-feather="check" class="me-50"></i>
                                                            <span><?php echo e(__('Qualify')); ?></span>
                                                        </button>
                                                    </form>
                                                    <?php endif; ?>
                                                    <?php if($lead->isActive()): ?>
                                                    <form action="<?php echo e(route('support.leads.convert', $lead->id)); ?>" method="POST">
                                                        <?php echo csrf_field(); ?>
                                                        <button type="submit" class="dropdown-item text-success">
                                                            <i data-feather="check-circle" class="me-50"></i>
                                                            <span><?php echo e(__('Convert')); ?></span>
                                                        </button>
                                                    </form>
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="7" class="text-center py-3">
                                            <p class="mb-0"><?php echo e(__('No leads found')); ?></p>
                                        </td>
                                    </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                        <!-- Pagination -->
                        <div class="d-flex justify-content-center">
                            <?php echo e($leads->links()); ?>

                        </div>
                    </div>
                </div>
            </section>
        </div>
    </div>
</div>
<!-- END: Content-->

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views/support/leads/index.blade.php ENDPATH**/ ?>