<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<link rel="stylesheet" href="https://cdn.ckeditor.com/ckeditor5/43.3.0/ckeditor5.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
  <div class="content-overlay"></div>
  <div class="header-navbar-shadow"></div>
  <div class="content-wrapper">
    <div class="content-body">

      <h4 class="fw-bold mb-4" id="top-of-page">
        <span class="text-muted fw-light"><?php echo e(__('Documentation')); ?> /</span> <?php echo e(config('app.name')); ?>

        <?php if(auth()?->user()?->role === 'admin'): ?>
        <button type="button" class="btn btn-sm btn-primary float-end" data-bs-toggle="modal" data-bs-target="#addNew"><i data-feather="plus-square" class="me-0"></i> <?php echo e(strtoupper(__('Add new'))); ?></button>
        <?php endif; ?>
      </h4>

      <div class="row">
        <!-- Menus -->
        <div class="col-xxl-1 col-xl-2 col-lg-3 col-md-3 mb-lg-0 mb-4">
          <!-- Search Jumbotron -->
          <!-- <div class="card-body search-bg text-center" id="kb-search">
              <form class="kb-search-input">
                  <div class="input-group input-group-merge">
                      <i data-feather="search" class="me-0"></i></span>
                      <input type="text" class="form-control" id="searchbar" placeholder="<?php echo e(__('Search')); ?>..." />
                  </div>
              </form>
          </div>
          <br> -->
          <!--/ Search Jumbotron -->
          <?php $__currentLoopData = $menus; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $menu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <span class="fw-bold"><?php echo e($menu->topic); ?></span>
          <div class="nav-align-left">
            <ul class="nav nav-pills border-0 w-100 gap-1">
              <?php $__currentLoopData = $documentations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $documentation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <?php if($documentation->topic === $menu->topic): ?>
              <li class="nav-item">
                <a id="menu-<?php echo e($documentation->title); ?>" class="nav-link" href="#<?php echo e($documentation->title); ?>"><?php echo e($documentation->title); ?>

                  <?php if(!empty($documentation->highlight)): ?>
                  <span class="badge badge-light-success"><?php echo e($documentation->highlight); ?>!</span>
                  <?php endif; ?>
                </a>
              </li>
              <?php endif; ?>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <!-- /Menus -->

        <!-- Body -->
        <div class="col-xl-10 col-lg-9 col-md-9">
          <?php $__currentLoopData = $documentations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $documentation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <div id="<?php echo e($documentation->title); ?>" class="card overflow-hidden mb-3">
            <div class="card-body">
              <h4 class="d-flex align-items-center mt-2 mb-4">
                <span class="badge badge-light-secondary p-2 rounded me-3">
                  <i data-feather="life-buoy" class="me-0"></i>
                </span>
                <?php echo e($documentation->title); ?>

              </h4>
              <?php echo $documentation->content; ?>

              <hr class="container-m-nx my-4">
              <div class="d-flex justify-content-between flex-wrap gap-3 mb-3">
                <div class="article-info">
                  <p class="card-text"><?php echo e(__('Updated at')); ?>: <?php echo e(Carbon\Carbon::parse($documentation->updated_at)->tz(auth()?->user()?->timezone ?? config('app.timezone'))->format('d M Y')); ?></p>
                </div>
                <?php if(Auth::user() && Auth::user()->role === 'admin'): ?>
                <a class="badge badge-light-secondary p-2 rounded me-3" href="<?php echo e(route('documentation.edit', $documentation->id)); ?>"><?php echo e(__('Edit')); ?> <?php echo e($documentation->title); ?> <i data-feather="edit" class="me-0"></i></a>
                <?php endif; ?>
                <a class="badge badge-light-secondary p-2 rounded me-3" href="#top-of-page"><?php echo e(__('Go to top')); ?><i data-feather="arrow-up" class="me-0"></i></a>
              </div>
            </div>
          </div>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
        <!-- /Body -->
      </div>

    </div>
  </div>
</div>
<!-- Add new Modal -->
<div class="modal fade" id="addNew" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-xl modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-transparent">
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <div class="modal-body pb-5 px-sm-5 pt-50">
                <div class="text-center mb-2">
                    <h3 class="mb-1"><?php echo e(__('Add new')); ?></h3>
                </div>
                <form action="<?php echo e(route('documentation.store')); ?>" method="POST" class="row gy-1 pt-75" enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                    <div class="row">
                        <div class="col-12 col-md-6 mb-2">
                            <label class="form-label" for="role"><?php echo e(__('Role')); ?></label>
                            <select class="form-control" name="role">
                                <option value="user">user</option>
                                <option value="admin">admin</option>
                            </select>
                        </div>
                        
                        <div class="col-12 col-md-6 mb-2">
                            <label class="form-label" for="highlight"><?php echo e(__('Highlight')); ?></label> <label class="form-label text-warning"> (<?php echo e(__('Optional')); ?>) </label>
                            <input type="text" name="highlight" class="form-control" value="NEW" />
                        </div>
                        <div class="col-12 col-md-6 mb-2">
                            <label class="form-label" for="topic"><?php echo e(__('Topic')); ?></label>
                            <input type="text" name="topic" class="form-control" value="Features" required />
                        </div>
                        <div class="col-12 col-md-6 mb-2">
                            <label class="form-label" for="title"><?php echo e(__('Title')); ?></label>
                            <input type="text" name="title" class="form-control" required />
                        </div>
                        <div class="col-12 mb-2">
                            <label class="form-label" for="edit-content"><?php echo e(__('Content')); ?></label>
                            <textarea class="form-control" row="20" id="content" name="content"></textarea>
                        </div>
                        <div class="col-12 text-center mt-4 pt-50">
                            <button type="submit" class="btn btn-primary me-1"><?php echo e(__('Save')); ?></button>
                            <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close"><?php echo e(__('Cancel')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<!-- Add new Modal -->

<!-- BEGIN: Vendor JS-->
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/vendors.min.js"></script>
<!-- BEGIN Vendor JS-->

<script src="https://cdn.ckeditor.com/ckeditor5/43.3.0/ckeditor5.js"></script>
<!-- <script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/editors/ckeditor5/ckeditor.js"></script> -->
<script>
    ClassicEditor
        .create( document.querySelector( '#content' ) )
        .catch( error => {
            console.error( error );
        } );
</script>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views//documentation-list.blade.php ENDPATH**/ ?>