<?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<link rel="stylesheet" type="text/css" href="<?php echo e(url('/')); ?>/app-assets/vendors/css/tables/datatable/dataTables.bootstrap5.min.css">

<!-- BEGIN: Content-->
<div class="app-content content ">
    <div class="content-overlay"></div>
    <div class="header-navbar-shadow"></div>
    <div class="content-wrapper">
        <div class="card-body">
            <button type="button" class="btn btn-sm btn-warning float-end" data-bs-toggle="modal" data-bs-target="#scrapeGoogleMap"><i data-feather="map"></i> <?php echo e(strtoupper(__('Scrape G-Maps Business'))); ?></button>
            <a class="btn btn-sm btn-success float-end" href="<?php echo e(route('phonebook.export', ['listAll' => $listAll])); ?>"><i data-feather="external-link"></i> <?php echo e(strtoupper(__('Export'))); ?></a>
            <?php if(!$listAll): ?>
            <button type="button" class="btn btn-sm btn-primary float-end" data-bs-toggle="modal" data-bs-target="#addNew"><i data-feather="plus-square"></i> <?php echo e(strtoupper(__('Add new'))); ?></button>
            <?php endif; ?>
        </div>
        <div class="content-header row">
            <h4><?php echo e(__('Phonebooks list')); ?><span class="badge rounded-pill badge-light-secondary"><?php echo e(DB::table('phonebooks')->where('user_id',Auth::user()->id)->count()); ?></span></h4>
        </div>
        <div class="content-body">
            <!-- phonebooks list start -->
            <section class="app-phonebook-list">
                <!-- list and filter start -->
                <div class="card">
                    <div class="card-body">
                        <div class="table-responsive table-responsive">
                            <table id="tbl-bootstr" class="table table-hover">
                                <thead class="table-light">
                                    <tr>
                                        <th hidden></th>
                                        <?php if($listAll): ?><th><?php echo e(__('Username')); ?></th><?php endif; ?>
                                        <th><?php echo e(__('Phonebook name')); ?></th>
                                        <th><?php echo e(__('Phonebook data')); ?></th>
                                        <th><?php echo e(__('Total')); ?></th>
                                        <th><?php echo e(__('Actions')); ?></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $phonebooks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $phonebook): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td hidden><?php echo e($phonebook->id); ?></td>
                                        <?php if($listAll): ?><td><?php echo e($phonebook->user->name); ?></td><?php endif; ?>
                                        <td><a href="javascript:;" data-bs-target="#edit-<?php echo e($phonebook->id); ?>" data-bs-toggle="modal">
                                        <?php echo e($phonebook->name); ?></a>
                                        </td>
                                        <td><a href="<?php echo e(route('phonebook.show', ['phonebook_id' => $phonebook->id])); ?>">
                                        <span hidden><?php echo e($phonebook->data); ?></span>
                                        <?php echo e(str_replace(['"','[',']','id:','name:','phone:'], [''], substr($phonebook->data, 0, 100)) . '...'); ?>

                                        </a>
                                        </td>
                                        <td><?php echo e(count(json_decode($phonebook->data))); ?></td>
                                        <td>
                                            <button class="btn btn-warning dropdown-toggle" type="button" id="actionButton" data-bs-toggle="dropdown" aria-expanded="false">
                                                <i data-feather="command" class="me-0"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="actionButton">
                                                <a class="dropdown-item" href="<?php echo e(route('phonebook.show', ['phonebook_id' => $phonebook->id])); ?>"><i data-feather="eye" class="me-0"></i> <?php echo e(__('View')); ?></a>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#edit-<?php echo e($phonebook->id); ?>"><i data-feather="edit" class="me-0"></i> <?php echo e(__('Edit')); ?></a>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#check-<?php echo e($phonebook->id); ?>"><i data-feather="check-square" class="me-0"></i> <?php echo e(__('Check')); ?></a>
                                                <div class="dropdown-divider"></div>
                                                <a class="dropdown-item" data-bs-toggle="modal" data-bs-target="#destroy-<?php echo e($phonebook->id); ?>"><i data-feather="trash" class="me-0"></i> <?php echo e(__('Delete')); ?></a>
                                            </div>
                                        </td>
                                    </tr>
                                    <!-- Check Modal -->
                                    <div class="modal fade modal-primary text-start" id="check-<?php echo e($phonebook->id); ?>" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Check confirmation')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <?php echo e(__('Are you sure you want to check?')); ?> <br><br>
                                                    <span class="text text-primary"> <b><?php echo e($phonebook->name); ?></b> </span><br><br>
                                                    <?php echo e(__('This process will check if the contact number is on Whatsapp or not')); ?> <br>
                                                    <?php echo e(__('If contact number is not registered with whatsapp, it will be deleted automatically')); ?> <br><br>
                                                    <?php echo e(__('If you have a lot of contacts in this phonebook')); ?> <br>
                                                    <?php echo e(__('This process will take a long time to complete')); ?>

                                                </div>
                                                <div class="modal-footer">
                                                    <a href="<?php echo e(route('phonebook.check', ['phonebook_id' => $phonebook->id, 'user_id' => $phonebook->user_id])); ?>" onclick="this.disabled=true; this.innerHTML='Please wait... This window will refresh in 20 seconds. It will be running on the background afterward.'; setTimeout(()=>{window.location.reload();}, 20_000)" class="btn btn-sm btn-primary"><?php echo e(__('Check')); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Delete Modal -->
                                    <div class="modal fade modal-danger text-start" id="destroy-<?php echo e($phonebook->id); ?>" tabindex="-1" aria-labelledby="myModalLabel120" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="modal-title" id="myModalLabel120"><?php echo e(__('Delete confirmation')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body">
                                                    <?php echo e(__('Are you sure you want to delete?')); ?> <br><br>
                                                    <span class="text text-danger"> <b><?php echo e($phonebook->name); ?></b> </span><br><br>
                                                    <?php echo e(__('This process is irreversible')); ?> <br>
                                                    <?php echo e(__('The record(s) will be deleted from the database permanently')); ?>

                                                </div>
                                                <div class="modal-footer">
                                                <a class="btn btn-sm btn-danger" href="<?php echo e(route('phonebook.destroy', ['phonebook_id' => $phonebook->id])); ?>"><?php echo e(__('Delete')); ?></a>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Edit Phonebook Modal -->
                                    <div class="modal fade" id="edit-<?php echo e($phonebook->id); ?>" tabindex="-1" aria-hidden="true">
                                        <div class="modal-dialog modal-xl modal-dialog-centered modal-edit-phonebook">
                                            <div class="modal-content">
                                                <div class="modal-header bg-transparent">
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <div class="modal-body pb-5 px-sm-5 pt-50">
                                                    <div class="text-center mb-2">
                                                        <h1 class="mb-1"><?php echo e(__('Edit phonebook')); ?></h1>
                                                    </div>
                                                    <form action="<?php echo e(route('phonebook.update')); ?>" method="POST" id="editPhonebookForm" class="row gy-1 pt-75" enctype="multipart/form-data">
                                                        <?php echo csrf_field(); ?>
                                                        <div class="row">
                                                        <div class="col-12 col-md-6">
                                                            <input type="hidden"  name="phonebook_id" value="<?php echo e($phonebook->id); ?>" />
                                                            <label class="form-label" for="name"><?php echo e(__('Phonebook name')); ?></label>
                                                            <input type="text" name="name" class="form-control" value="<?php echo e($phonebook->name); ?>" placeholder="<?php echo e(__('Phonebook name')); ?>" required />
                                                        </div>
                                                        <div class="col-12 col-md-6">
                                                            <label class="form-label" for="filename"><?php echo e(__('Phonebook filename')); ?></label>
                                                            <a href="<?php echo e(url('/')); ?>/app-assets/data/sample_phonebook.xlsx">download sample XLSX here
                                                                <img src="<?php echo e(url('/')); ?>/app-assets/images/icons/xls.png" alt="png" height="32">
                                                            </a>
                                                            <input type="file" name="filename" class="form-control" placeholder="<?php echo e(__('Upload XLSX file')); ?>" />
                                                        </div>
                                                        <div class="col-12 text-center mt-2 pt-50">
                                                            <button type="submit" class="btn btn-primary me-1"><?php echo e(__('Submit')); ?></button>
                                                            <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal" aria-label="Close"><?php echo e(__('Cancel')); ?></button>
                                                        </div>
                                                        </div>
                                                    </form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <!--/ Edit Phonebook Modal -->
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
                <!-- list and filter end -->
            </section>
            <!-- phonebooks list ends -->
        </div>
    </div>
</div>

<!-- Modal to add new phonebook starts-->
<div class="modal modal-slide-in new-phonebook-modal fade" id="addNew">
    <div class="modal-dialog">
        <form action="<?php echo e(route('phonebook.store')); ?>" method="POST" class="add-new-phonebook modal-content pt-0" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
            <div class="modal-header mb-1">
                <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Add new phonebook')); ?></h5>
            </div>
            <div class="modal-body flex-grow-1">
                <div class="mb-1">
                    <label class="form-label" for="name"><?php echo e(__('Phonebook name')); ?></label>
                    <input type="text" name="name" class="form-control" placeholder="<?php echo e(__('Phonebook name')); ?>" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="filename"><?php echo e(__('Phonebook filename')); ?></label>
                    <a href="<?php echo e(url('/')); ?>/app-assets/data/sample_phonebook.xlsx"><?php echo e(__('Download sample XLSX here')); ?>

                        <img src="<?php echo e(url('/')); ?>/app-assets/images/icons/xls.png" alt="png" height="32">
                    </a>
                    <input type="file" name="filename" class="form-control" placeholder="<?php echo e(__('Upload XLSX file')); ?>" required />
                </div>
                <button type="submit" class="btn btn-primary me-1 data-submit"><?php echo e(__('Submit')); ?></button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
            </div>
        </form>
    </div>
</div>
<!-- Modal to add new phonebook Ends-->

<!-- Modal to scrape Google Maps Business starts-->
<div class="modal modal-slide-in new-phonebook-modal fade" id="scrapeGoogleMap">
    <div class="modal-dialog">
        <form action="<?php echo e(route('phonebook.scrapeGMaps')); ?>" method="POST" class="add-new-phonebook modal-content pt-0">
        <?php echo csrf_field(); ?>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close">×</button>
            <div class="modal-header mb-1">
                <h5 class="modal-title" id="exampleModalLabel"><?php echo e(__('Scrape Google Maps Business')); ?></h5>
            </div>
            <div class="modal-body flex-grow-1">
                <div class="mb-1">
                    <label class="form-label" for="key"><?php echo e(__('Google Maps API KEY')); ?></label>
                    <input type="text" name="key" class="form-control" placeholder="AIzaSyDu9hoFE6IZ055Blbl927z1Zf2fCKECPP0" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="location"><?php echo e(__('Location')); ?> (Longitude,Latitude)</label>
                    <input type="text" name="location" class="form-control" placeholder="-6.137433,106.788849" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="radius"><?php echo e(__('Radius')); ?> (in meters)</label>
                    <input type="text" name="radius" class="form-control" placeholder="1000" required />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="keyword"><?php echo e(__('Keyword')); ?> (Separated by comma | Optional)</label>
                    <input type="text" name="keyword" class="form-control" placeholder="<?php echo e(__('Insert Keyword ...')); ?>" />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="maxprice"><?php echo e(__('Max Price')); ?> (Optional)</label>
                    <input type="number" name="maxprice" class="form-control" />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="minprice"><?php echo e(__('Min Price')); ?> (Optional)</label>
                    <input type="number" name="minprice" class="form-control" />
                </div>
                <div class="mb-1">
                    <label class="form-label" for="rankby"><?php echo e(__('Rank By')); ?> (Optional)</label>
                    <select name="rankby" class="form-select">
                        <option value="prominence">prominence</option>
                        <option value="distance">distance</option>
                    </select>
                </div>
                <div class="mb-1">
                    <label class="form-label" for="type"><?php echo e(__('Type')); ?> (hospital, restaurant, pharmacy, doctor, etc (choose only one) | Optional)</label>
                    <input type="text" name="type" class="form-control" />
                </div>
                <button type="submit" class="btn btn-primary me-1 data-submit"><?php echo e(__('Submit')); ?></button>
                <button type="reset" class="btn btn-outline-secondary" data-bs-dismiss="modal"><?php echo e(__('Cancel')); ?></button>
            </div>
        </form>
    </div>
</div>
<!-- Modal to scrape Google Maps Business Ends-->
<!-- END: Content-->

<!-- BEGIN: Vendor JS-->
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/vendors.min.js"></script>
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/tables/datatable/jquery.dataTables.min.js"></script>
<script src="<?php echo e(url('/')); ?>/app-assets/vendors/js/tables/datatable/dataTables.bootstrap5.min.js"></script>
<!-- BEGIN Vendor JS-->
<script>
    $(document).ready(function () {
        $('#tbl-bootstr').DataTable();
    });        
</script>

<?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php /**PATH /home/procharmate/public_html/whatsapp.procharmate.com/resources/views//phonebook-list.blade.php ENDPATH**/ ?>